/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.customer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.AdmindivisionUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;

public class CustomerAddressApi
extends MdrApi {
    public ApiResult query(Map<String, Object> data) {
        QFilter f = new QFilter("1", "=", (Object)"1");
        String fields = "id,customer.id,email,fixedtel,customer.name,contactname,telephone,address,address2,isdefault";
        Object defaultOwnerID = UserUtil.getDefaultOwnerID();
        f.and("customer.id", "=", defaultOwnerID);
        int page = 1;
        int pageSize = 10;
        if (data != null) {
            if (data.get("page") != null && (Integer)data.get("page") > 1) {
                page = (Integer)data.get("page");
            }
            if (data.get("pageSize") != null && (Integer)data.get("pageSize") > 1) {
                pageSize = (Integer)data.get("pageSize");
            }
        }
        DynamicObjectCollection adressList = ORMUtil.query((String)"mdr_customer_address", (String)fields, (QFilter[])f.toArray(), null, (int)((page - 1) * pageSize), (int)pageSize);
        ArrayList list = new ArrayList();
        for (DynamicObject adress : adressList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", String.valueOf(adress.get("id")));
            map.put("customerId", String.valueOf(adress.get("customer.id")));
            map.put("customer", adress.get("customer.name"));
            map.put("contactName", adress.get("contactname"));
            map.put("telephone", adress.get("telephone"));
            Object addressId = adress.get("address");
            map.put("addressName", AdmindivisionUtil.getAreaFullNameById((Object)addressId));
            map.put("address", AdmindivisionUtil.getNumberListById((Object)addressId));
            map.put("email", (String)adress.get("email"));
            map.put("fixedTel", (String)adress.get("fixedtel"));
            map.put("address2", (String)adress.get("address2"));
            map.put("isDefault", adress.get("isdefault"));
            list.add(map);
        }
        HashMap<String, Serializable> returnMap = new HashMap<String, Serializable>();
        returnMap.put("list", list);
        int count = QueryUtil.querycount((String)"mdr_customer_address", (QFilter[])f.toArray());
        returnMap.put("count", Integer.valueOf(count));
        return ApiResult.success(returnMap);
    }

    public ApiResult save(Map<String, Object> data) {
        if (data == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5165\u53c2\u4e0d\u5f97\u4e3a\u7a7a", (String)"CustomerAddressApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        String customerId = UserUtil.getDefaultOwnerID().toString();
        String contactname = (String)data.get("contactName");
        String telephone = (String)data.get("telephone");
        List addressList = (List)data.get("address");
        String detailAddress = (String)data.get("address2");
        String email = (String)data.get("email");
        String fixedtel = (String)data.get("fixedTel");
        Boolean isdefault = (Boolean)data.get("isDefault");
        if (StringUtils.isEmpty((String)customerId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e20\u9053id\u4e0d\u5f97\u4e3a\u7a7a", (String)"CustomerAddressApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)contactname)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u8d27\u4eba\u59d3\u540d\u4e0d\u5f97\u4e3a\u7a7a", (String)"CustomerAddressApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)telephone)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u8d27\u4eba\u7535\u8bdd\u4e0d\u5f97\u4e3a\u7a7a", (String)"CustomerAddressApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)detailAddress)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be6\u7ec6\u5730\u5740\u4e0d\u5f97\u4e3a\u7a7a", (String)"CustomerAddressApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (addressList == null || addressList.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5730\u5740\u4e0d\u5f97\u4e3a\u7a7a", (String)"CustomerAddressApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (isdefault == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u662f\u5426\u8bbe\u4e3a\u9ed8\u8ba4\u4e0d\u5f97\u4e3a\u7a7a", (String)"CustomerAddressApi_6", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (isdefault.booleanValue()) {
            DynamicObject[] addressArray;
            for (DynamicObject addressInfo : addressArray = BusinessDataServiceHelper.load((String)"mdr_customer_address", (String)"isdefault", (QFilter[])new QFilter("1", "=", (Object)"1").toArray())) {
                addressInfo.set("isdefault", (Object)(isdefault == false ? 1 : 0));
            }
            SaveServiceHelper.save((DynamicObject[])addressArray);
        }
        DynamicObject addressEntry = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer_address");
        Object address = AdmindivisionUtil.getIdByNumber((String)((String)addressList.get(addressList.size() - 1)));
        addressEntry.set("address", address);
        if (!StringUtils.isNotEmpty((String)customerId) || !QueryServiceHelper.exists((String)"mdr_customer", (Object)customerId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e20\u9053\u4fe1\u606f\u9519\u8bef", (String)"CustomerAddressApi_7", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject customerInfo = BusinessDataServiceHelper.loadSingle((Object)customerId, (String)"mdr_customer");
        addressEntry.set("customer", (Object)customerInfo);
        if (StringUtils.isNotEmpty((String)email)) {
            addressEntry.set("email", (Object)email);
        }
        if (StringUtils.isNotEmpty((String)fixedtel)) {
            addressEntry.set("fixedtel", (Object)fixedtel);
        }
        addressEntry.set("contactname", (Object)contactname);
        addressEntry.set("telephone", (Object)telephone);
        addressEntry.set("address2", (Object)detailAddress);
        addressEntry.set("isdefault", (Object)isdefault);
        addressEntry.set("createtime", (Object)new Date());
        OperationUtil.invokeOperation((DynamicObject)addressEntry, (String)"save");
        return ApiResult.success(null);
    }

    public ApiResult delete(Map<String, Object> data) {
        if (data != null) {
            Object id = data.get("id");
            DynamicObject single = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mdr_customer_address");
            OperationUtil.invokeOperation((DynamicObject)single, (String)"delete");
            return ApiResult.success(null);
        }
        return ApiResult.fail(null);
    }

    public ApiResult update(Map<String, Object> data) {
        if (data == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53c2\u6570", (String)"CustomerAddressApi_8", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        Object id = data.get("id");
        if (StringUtils.isEmpty((Object)id) || !QueryServiceHelper.exists((String)"mdr_customer_address", (Object)id)) {
            throw new KDBizException(ResManager.loadKDString((String)"id\u9519\u8bef\u6216\u8005\u4e3a\u7a7a", (String)"CustomerAddressApi_9", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject address = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mdr_customer_address");
        String contactname = (String)data.get("contactName");
        String telephone = (String)data.get("telephone");
        List addressList = (List)data.get("address");
        String detailAddress = (String)data.get("address2");
        String email = (String)data.get("email");
        String fixedtel = (String)data.get("fixedTel");
        Boolean isdefault = (Boolean)data.get("isDefault");
        if (StringUtils.isNotEmpty((String)contactname)) {
            address.set("contactname", (Object)contactname);
        }
        if (StringUtils.isNotEmpty((String)telephone)) {
            address.set("telephone", (Object)telephone);
        }
        if (addressList != null && addressList.size() > 0) {
            address.set("address", addressList.get(addressList.size() - 1));
        }
        if (StringUtils.isNotEmpty((String)detailAddress)) {
            address.set("address2", (Object)detailAddress);
        }
        if (StringUtils.isNotEmpty((String)email)) {
            address.set("email", (Object)email);
        }
        if (StringUtils.isNotEmpty((String)fixedtel)) {
            address.set("fixedtel", (Object)fixedtel);
        }
        if (StringUtils.isNotEmpty((Object)isdefault)) {
            if (isdefault.booleanValue()) {
                DynamicObject[] addressArray;
                for (DynamicObject addressInfo : addressArray = BusinessDataServiceHelper.load((String)"mdr_customer_address", (String)"isdefault", (QFilter[])new QFilter("1", "=", (Object)"1").toArray())) {
                    addressInfo.set("isdefault", (Object)(isdefault == false ? 1 : 0));
                }
                SaveServiceHelper.save((DynamicObject[])addressArray);
            }
            address.set("isdefault", (Object)isdefault);
        }
        OperationUtil.invokeOperation((DynamicObject)address, (String)"save");
        return ApiResult.success(null);
    }
}

