/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.customer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.drp.mdr.api.ApiTransaction;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.enums.ControlStrategy;
import kd.drp.mdr.common.enums.Status;
import kd.drp.mdr.common.enums.customer.CustomerProperty;
import kd.drp.mdr.common.enums.customer.InventoryControlMode;
import kd.drp.mdr.common.enums.customer.SaleControlMode;
import kd.drp.mdr.common.enums.customer.SystemPresetCustomerFuction;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.handler.CustomerRelationHandler;
import kd.drp.mdr.common.util.AdmindivisionUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;

public class CustomerApi
extends MdrApi {
    public ApiResult query(Map<String, Object> data) {
        QFilter f = new QFilter("1", "=", (Object)"1");
        int from = 0;
        int length = -1;
        int pageSize = 20;
        int page = 1;
        if (data != null) {
            String name = (String)data.get("name");
            String number = (String)data.get("number");
            String author = (String)data.get("author");
            String isinnerorg = (String)data.get("isinnerorg");
            String area = (String)data.get("area");
            if (data.get("page") != null) {
                page = (Integer)data.get("page");
            }
            if (data.get("pageSize") != null) {
                pageSize = (Integer)data.get("pageSize");
            }
            if (StringUtils.isNotEmpty((String)name)) {
                f = f.and("name", "like", (Object)("%" + name + "%"));
            }
            if (StringUtils.isNotEmpty((String)number)) {
                f = f.and("number", "like", (Object)("%" + number + "%"));
            }
            if (StringUtils.isNotEmpty((String)author)) {
                Object authorId = CustomerUtil.getIdByNumber((String)author);
                Set authSubsIds = CustomerUtil.getAuthSubsIds((Object)authorId);
                f = f.and("id", "in", (Object)authSubsIds);
            }
            if (StringUtils.isNotEmpty((String)isinnerorg) && "1".equals(isinnerorg)) {
                f = f.and("isinnerorg", "=", (Object)"1");
            }
            if (StringUtils.isNotEmpty((String)area)) {
                f = f.and("area", "in", (Object)AdmindivisionUtil.getAllSubByNumber((String)area));
            }
            data.clear();
        } else {
            data = new HashMap<String, Object>();
        }
        from = (page - 1) * pageSize;
        length = pageSize;
        DynamicObjectCollection customers = ORMUtil.query((String)"mdr_customer", (String)"id,number,name", (QFilter[])f.toArray(), null, (int)from, (int)length);
        ArrayList customerList = new ArrayList();
        for (DynamicObject customer : customers) {
            HashMap<String, String> customerMap = new HashMap<String, String>();
            customerMap.put("id", customer.getString("id"));
            customerMap.put("name", customer.getString("name"));
            customerMap.put("number", customer.getString("number"));
            customerList.add(customerMap);
        }
        data.put("count", QueryUtil.querycount((String)"mdr_customer", (QFilter[])f.toArray()));
        data.put("list", customerList);
        return ApiResult.success(data);
    }

    public ApiResult queryCustomerGroup(Map<String, Object> data) {
        QFilter f = new QFilter("1", "=", (Object)"1");
        int from = 0;
        int length = -1;
        int pageSize = 20;
        int page = 1;
        if (data != null) {
            if (data.get("page") != null) {
                page = (Integer)data.get("page");
            }
            if (data.get("pageSize") != null) {
                pageSize = (Integer)data.get("pageSize");
            }
            if (StringUtils.isNotEmpty((Object)data.get("level"))) {
                f.and("level", "=", data.get("level"));
            }
            data.clear();
        } else {
            data = new HashMap<String, Object>();
        }
        from = (page - 1) * pageSize;
        length = pageSize;
        DynamicObjectCollection customerGroupCollection = ORMUtil.query((String)"mdr_customer_group", (String)"level,parent,id,number,name,description", (QFilter[])f.toArray(), null, (int)from, (int)length);
        ArrayList customerGroupList = new ArrayList();
        HashMap<String, Object> customerGroupMap = null;
        for (DynamicObject customerGroup : customerGroupCollection) {
            customerGroupMap = new HashMap<String, Object>();
            customerGroupMap.put("id", customerGroup.get("id"));
            customerGroupMap.put("name", customerGroup.get("name"));
            customerGroupMap.put("number", customerGroup.get("number"));
            customerGroupMap.put("level", customerGroup.get("level"));
            customerGroupMap.put("parent", customerGroup.get("parent"));
            customerGroupMap.put("description", customerGroup.get("description"));
            customerGroupList.add(customerGroupMap);
        }
        data.put("count", QueryUtil.querycount((String)"mdr_customer_group", (QFilter[])f.toArray()));
        data.put("customerGroupList", customerGroupList);
        return ApiResult.success(data);
    }

    public ApiResult queryCustomerInfo(Map<String, Object> data) {
        Object id = data.get("id");
        DynamicObject customerInfo = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String picture = "";
        if (StringUtils.isEmpty((Object)id) || !QueryServiceHelper.exists((String)"mdr_customer", (Object)id)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165id", (String)"CustomerApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        customerInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mdr_customer");
        map.put("number", customerInfo.get("number"));
        map.put("name", customerInfo.get("name.zh_CN"));
        map.put("grade", customerInfo.get("grade.name.zh_CN"));
        map.put("fax", customerInfo.get("fax"));
        map.put("phone", customerInfo.get("phone"));
        map.put("address", customerInfo.get("address.zh_CN"));
        map.put("isInnerorg", customerInfo.get("isinnerorg"));
        map.put("useImg", picture);
        map.put("id", customerInfo.get("id"));
        Object areaId = customerInfo.get("area");
        if (StringUtils.isNotEmpty((Object)areaId)) {
            String area = AdmindivisionUtil.getAreaFullNameById((Object)areaId);
            map.put("area", area);
        } else {
            map.put("area", "");
        }
        return ApiResult.success(map);
    }

    @ApiTransaction
    public ApiResult syncCustomer(Map<String, Object> data) {
        String easnumber = (String)data.get("easnumber");
        String eascustomerid = (String)data.get("eascustomerid");
        if (StringUtils.isEmpty((String)eascustomerid) || StringUtils.isEmpty((String)easnumber)) {
            ApiResult.fail((String)ResManager.loadKDString((String)"\u8c03\u7528\u67e5\u8be2\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u539f\u56e0:\u5ba2\u6237eas id\u6216eas\u7f16\u7801\u4e3a\u7a7a\uff01", (String)"CustomerApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject customerInfo = null;
        QFilter qFilter = new QFilter("easnumber", "=", (Object)easnumber);
        boolean isExists = QueryServiceHelper.exists((String)"mdr_customer", (QFilter[])qFilter.toArray());
        if (!isExists) {
            customerInfo = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer");
        } else {
            DynamicObject id = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"id", (QFilter[])qFilter.toArray());
            customerInfo = BusinessDataServiceHelper.loadSingle((Object)id.get("id"), (String)"mdr_customer");
        }
        customerInfo.set("number", (Object)easnumber);
        customerInfo.set("easnumber", (Object)easnumber);
        customerInfo.set("name", data.get("name"));
        customerInfo.set("eascustomerid", (Object)eascustomerid);
        customerInfo.set("enable", (Object)1);
        DynamicObject area = this.getAreaInfo((String)data.get("county"), (String)data.get("province"), (String)data.get("city"), (String)data.get("region"));
        customerInfo.set("area", area == null ? null : area.getPkValue());
        customerInfo.set("address", data.get("address"));
        customerInfo.set("isinnerorg", (Object)0);
        customerInfo.set("enable", (Object)1);
        DynamicObjectUtils.setF7Value((DynamicObject)customerInfo, (String)"createorg", (String)"bos_org", (Object)100000L, null);
        customerInfo.set("longnumber", (Object)easnumber);
        DynamicObjectUtils.setF7Value((DynamicObject)customerInfo, (String)"customertype", (String)"mdr_customer_type", (Object)1L, null);
        customerInfo.set("customerproperty", (Object)CustomerProperty.DIRECT_CUSTOMER.toString());
        DynamicObjectUtils.setF7Value((DynamicObject)customerInfo, (String)"bizgroup", (String)"bos_org", (Object)100000L, null);
        DynamicObjectUtils.setMultiF7Value((DynamicObject)customerInfo, (String)"customerfunctions", (String)"mdr_customer_function", (Object[])CustomerUtil.getCustomerFunctionIds((SystemPresetCustomerFuction[])SystemPresetCustomerFuction.values()));
        DynamicObjectUtils.setF7Value((DynamicObject)customerInfo, (String)"currency", (String)"bd_currency", (Object)1L, null);
        customerInfo.set("ordercustomer", null);
        customerInfo.set("salecontrolmode", (Object)SaleControlMode.BUGUANXIAOLIANG.toString());
        customerInfo.set("isnegativeinventory", (Object)false);
        customerInfo.set("invcontrolmode", (Object)InventoryControlMode.INVENTORY_REPORT_MODE.toString());
        customerInfo.set("ctrlstrategy", (Object)ControlStrategy.SHARE_IN_GLOBAL.toString());
        customerInfo.set("status", (Object)Status.AUDITED.toString());
        DynamicObjectUtils.setF7Value((DynamicObject)customerInfo, (String)"org", (String)"bos_org", (Object)100000L, null);
        customerInfo.set("group", null);
        String customergroupnumber = (String)data.get("customergroupnumber");
        List cGroups = (List)data.get("customergroups");
        String isUseLeafCGroup = data.get("IsUseLeafCGroup") == null || data.get("IsUseLeafCGroup").equals("-1") ? "1" : (String)data.get("IsUseLeafCGroup");
        DynamicObject customGroup = null;
        if ("1".equals(isUseLeafCGroup)) {
            this.saveCustomerGroup(cGroups);
            customGroup = this.getDynamicObjectByEASNumber(customergroupnumber, "mdr_customer_group", "id,name,number,easnumber");
            customerInfo.set("group", (Object)customGroup);
        } else {
            ArrayList<Map<String, Object>> toSaveCGroups = new ArrayList<Map<String, Object>>();
            String cParentGroupNumber = "";
            for (Map groupInfo : cGroups) {
                boolean isLeaf = (Boolean)groupInfo.get("isleaf");
                if (isLeaf) {
                    cParentGroupNumber = (String)groupInfo.get("parentNumber");
                    continue;
                }
                toSaveCGroups.add(groupInfo);
            }
            this.saveCustomerGroup(toSaveCGroups);
            boolean ismgroupexist = QueryServiceHelper.exists((String)"mdr_customer_group", (QFilter[])new QFilter("easnumber", "=", (Object)customergroupnumber).toArray());
            if (!ismgroupexist) {
                customergroupnumber = cParentGroupNumber;
            }
            customGroup = this.getDynamicObjectByEASNumber(customergroupnumber, "mdr_customer_group", "id,name,number,easnumber");
            customerInfo.set("group", (Object)customGroup);
        }
        DynamicObjectCollection customerClassEntries = customerInfo.getDynamicObjectCollection("custclassentity");
        boolean isUpdateGroup = false;
        for (DynamicObject classentry : customerClassEntries) {
            DynamicObject standardgroup = classentry.getDynamicObject("classstandardid");
            if (!standardgroup.get("id").equals(836014120472951808L)) continue;
            classentry.set("customergroupid", (Object)customGroup);
            isUpdateGroup = true;
            break;
        }
        if (!isUpdateGroup) {
            DynamicObject cusClassEntry = new DynamicObject(customerClassEntries.getDynamicObjectType());
            DynamicObjectUtils.setF7Value((DynamicObject)cusClassEntry, (String)"classstandardid", (String)"mdr_cust_classstandard", (Object)836014120472951808L, null);
            cusClassEntry.set("customergroupid", (Object)customGroup);
            customerClassEntries.add((Object)cusClassEntry);
        }
        customerInfo.set("creator", (Object)UserUtil.getUserInfo());
        customerInfo.set("createtime", (Object)new Date());
        this.beforeCustomerSave(customerInfo, data);
        OperationUtil.invokeOperation((DynamicObject)customerInfo, (String)"save");
        this.clearCtrlCache();
        return ApiResult.success(null);
    }

    protected void beforeCustomerSave(DynamicObject customerInfo, Map<String, Object> data) {
    }

    private void clearCtrlCache() {
        String entityID = "mdr_customer";
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        BaseDataCtrlCacheMrg.clearCacheWithPrefix((String)type, (String)entityID);
        BaseDataCtrlCache.clearWithPrefixBaseDataUseRange((String)entityID);
    }

    @ApiTransaction
    public ApiResult enableCustomer(Map<String, Object> data) {
        String easnumber = (String)data.get("easnumber");
        DynamicObject customerInfo = this.getCustomerByEasnumber(easnumber);
        if (customerInfo == null || customerInfo.getPkValue().equals(0L)) {
            return ApiResult.success((Object)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728eas\u7f16\u7801\u4e3a%s\u7684\u6e20\u9053", (String)"CustomerApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]), easnumber));
        }
        OperationUtil.invokeOperation((DynamicObject)customerInfo, (String)"enable");
        return ApiResult.success(null);
    }

    @ApiTransaction
    public ApiResult disableCustomer(Map<String, Object> data) {
        String easnumber = (String)data.get("easnumber");
        DynamicObject customerInfo = this.getCustomerByEasnumber(easnumber);
        if (customerInfo == null || customerInfo.getPkValue().equals(0L)) {
            return ApiResult.success((Object)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728eas\u7f16\u7801\u4e3a%s\u7684\u6e20\u9053", (String)"CustomerApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]), easnumber));
        }
        OperationUtil.invokeOperation((DynamicObject)customerInfo, (String)"disable");
        return ApiResult.success(null);
    }

    private DynamicObject getCustomerByEasnumber(String easnumber) {
        DynamicObject customerInfo = null;
        QFilter qFilter = new QFilter("easnumber", "=", (Object)easnumber);
        boolean isExists = QueryServiceHelper.exists((String)"mdr_customer", (QFilter[])qFilter.toArray());
        if (!isExists) {
            customerInfo = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer");
        } else {
            DynamicObject id = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"id", (QFilter[])qFilter.toArray());
            customerInfo = BusinessDataServiceHelper.loadSingle((Object)id.get("id"), (String)"mdr_customer");
        }
        return customerInfo;
    }

    private DynamicObject getAreaInfo(String county, String province, String city, String region) {
        DynamicObject areainfo = null;
        QFilter filter = null;
        if (StringUtils.isNotEmpty((String)region) && (areainfo = BusinessDataServiceHelper.loadSingle((String)"bd_admindivision", (String)"id,name,parent.name", (QFilter[])(filter = new QFilter("name", "=", (Object)region)).toArray())) == null && StringUtils.isNotEmpty((String)city) && (areainfo = BusinessDataServiceHelper.loadSingle((String)"bd_admindivision", (String)"id,name,parent.name", (QFilter[])(filter = new QFilter("name", "=", (Object)city)).toArray())) == null && StringUtils.isNotEmpty((String)province) && (areainfo = BusinessDataServiceHelper.loadSingle((String)"bd_admindivision", (String)"id,name,parent.name", (QFilter[])(filter = new QFilter("name", "=", (Object)province)).toArray())) == null && StringUtils.isNotEmpty((String)county)) {
            filter = new QFilter("name", "=", (Object)county);
            areainfo = BusinessDataServiceHelper.loadSingle((String)"bd_admindivision", (String)"id,name,parent.name", (QFilter[])filter.toArray());
        }
        return areainfo;
    }

    private void saveCustomerGroup(List<Map<String, Object>> grouplist) {
        for (Map<String, Object> groupmap : grouplist) {
            Object parentnumber = groupmap.get("parentNumber");
            boolean ismgroupexist = QueryServiceHelper.exists((String)"mdr_customer_group", (QFilter[])new QFilter("easnumber", "=", groupmap.get("number")).toArray());
            if (ismgroupexist) continue;
            DynamicObject group = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer_group");
            String number = groupmap.get("number").toString();
            if (number == null || "".equals(number)) {
                number = CodeRuleServiceHelper.getNumber((String)"mdr_customer_group", (DynamicObject)group, null);
            }
            if (number == null || "".equals(number)) {
                throw new KDBizException("\u8bf7\u8bbe\u7f6e\u6e20\u9053\u5206\u7ec4\u7f16\u7801\u89c4\u5219");
            }
            group.set("number", (Object)number);
            group.set("name", groupmap.get("name"));
            group.set("easnumber", groupmap.get("number"));
            group.set("fullname", groupmap.get("name"));
            group.set("isleaf", groupmap.get("isleaf"));
            group.set("level", groupmap.get("level"));
            group.set("enable", (Object)1);
            group.set("status", (Object)Character.valueOf('C'));
            if (parentnumber != null) {
                DynamicObject parent = this.getDynamicObjectByEASNumber(groupmap.get("parentNumber").toString(), "mdr_customer_group", "id,longnumber,level,fullname");
                group.set("parent", (Object)parent);
                group.set("longnumber", (Object)(parent.getString("longnumber") + "." + number));
            }
            DynamicObjectUtils.setF7Value((DynamicObject)group, (String)"classstandard", (String)"mdr_cust_classstandard", (Object)836014120472951808L, null);
            OperationUtil.invokeOperation((DynamicObject)group, (String)"save");
        }
    }

    public ApiResult buildCustomerOfUserRelation(Map<String, Object> data) {
        String easCustomerId = (String)data.get("easCustomerId");
        String easCustomerNumber = (String)data.get("easCustomerNumber");
        String phone = (String)data.get("phone");
        if (StringUtils.isEmpty((String)easCustomerId) || StringUtils.isEmpty((String)easCustomerNumber)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684EAS\u5ba2\u6237id\u6216\u5ba2\u6237number\u4e3a\u7a7a\uff01", (String)"CustomerApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (phone == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165EAS\u7684phone\u4e3a\u7a7a\uff01", (String)"CustomerApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        QFilter qfEas = new QFilter("1", "=", (Object)"1");
        qfEas.and("eascustomerid", "=", (Object)easCustomerId);
        qfEas.and("easnumber", "=", (Object)easCustomerNumber);
        DynamicObject customer = null;
        DynamicObject user = null;
        customer = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"id", (QFilter[])qfEas.toArray());
        if (customer == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684EAS\u5ba2\u6237number\u5728\u4e2d\u53f0\u6ca1\u6709\u5bf9\u5e94\u7684\u6e20\u9053\uff0c\u8bf7\u5148\u4e3a\u8be5\u5ba2\u6237\u521b\u5efa\u6e20\u9053\uff01", (String)"CustomerApi_6", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        customer = BusinessDataServiceHelper.loadSingle((Object)customer.get("id"), (String)"mdr_customer");
        QFilter qFilter = new QFilter("1", "=", (Object)"1");
        qFilter.and("phone", "=", (Object)phone);
        user = QueryServiceHelper.queryOne((String)"bos_user", (String)"id", (QFilter[])qFilter.toArray());
        if (user == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165EAS\u7684phone\u5728\u4e2d\u53f0\u6ca1\u6709\u5bf9\u5e94\u7684\u4eba\u5458\uff0c\u8be5\u90e8\u5206\u5f85\u786e\u5b9a\uff01", (String)"CustomerApi_7", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        user = BusinessDataServiceHelper.loadSingle((Object)user.get("id"), (String)"bos_user");
        try {
            CustomerRelationHandler.buildCustomerOfUserRelation((DynamicObject)customer, (DynamicObject)user);
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
        return ApiResult.success(null);
    }

    public ApiResult severCustomerOfUserRelation(Map<String, Object> data) {
        String easCustomerId = (String)data.get("easCustomerId");
        String easCustomerNumber = (String)data.get("easCustomerNumber");
        String phone = (String)data.get("phone");
        if (StringUtils.isEmpty((String)easCustomerId) || StringUtils.isEmpty((String)easCustomerNumber)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684EAS\u5ba2\u6237id\u6216\u5ba2\u6237number\u4e3a\u7a7a\uff01", (String)"CustomerApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (phone == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165EAS\u7684phone\u4e3a\u7a7a\uff01", (String)"CustomerApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        QFilter qfEas = new QFilter("1", "=", (Object)"1");
        qfEas.and("eascustomerid", "=", (Object)easCustomerId);
        qfEas.and("easnumber", "=", (Object)easCustomerNumber);
        DynamicObject customer = null;
        DynamicObject user = null;
        customer = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"id", (QFilter[])qfEas.toArray());
        if (customer == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8be5EAS\u5ba2\u6237\u5728\u4e2d\u53f0\u6ca1\u6709\u5bf9\u5e94\u7684\u6e20\u9053\uff01", (String)"CustomerApi_8", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("1", "=", (Object)"1");
        qFilter.and("phone", "=", (Object)phone);
        user = QueryServiceHelper.queryOne((String)"bos_user", (String)"id", (QFilter[])qFilter.toArray());
        if (user == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165EAS\u7684phone\u5728\u4e2d\u53f0\u6ca1\u6709\u5bf9\u5e94\u7684\u4eba\u5458\uff01", (String)"CustomerApi_9", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        try {
            CustomerRelationHandler.severCustomerOfUserRelation((DynamicObject)customer, (DynamicObject)user);
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
        return ApiResult.success(null);
    }

    public ApiResult changePassword(Map<String, Object> data) {
        if (data == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u8981\u4fee\u6539\u7684\u5bc6\u7801", (String)"CustomerApi_10", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        Object password = data.get("password");
        long userId = UserServiceHelper.getCurrentUserId();
        Map changePsw = UserServiceHelper.changePsw((long)userId, (String)((String)password));
        boolean success = (Boolean)changePsw.get("success");
        if (success) {
            return ApiResult.success(null);
        }
        return ApiResult.fail((String)changePsw.get("msg").toString());
    }

    public ApiResult queryCustomerByIds(Map<String, Object> data) {
        String fileds;
        DynamicObject[] customerInfos;
        QFilter f = new QFilter("1", "=", (Object)"1");
        List ids = (List)data.get("ids");
        String picture = "";
        if (StringUtils.isNotEmpty((Object)ids) && StringUtils.isNotEmpty((Object)ids)) {
            f = f.and(new QFilter("id", "in", (Object)ids));
        }
        int size = (customerInfos = BusinessDataServiceHelper.load((String)"mdr_customer", (String)(fileds = "id,name,useImg"), (QFilter[])f.toArray())) != null && customerInfos.length > 0 ? customerInfos.length : 0;
        ArrayList list = new ArrayList(size);
        if (size > 0) {
            for (DynamicObject customerInfo : customerInfos) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", customerInfo.get("name.zh_CN"));
                map.put("useImg", picture);
                map.put("id", customerInfo.get("id"));
                list.add(map);
            }
        }
        return ApiResult.success(list);
    }

    public ApiResult queryAuthCustomer(Map<String, Object> data) {
        Object customerid = data.get("customerId");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isEmpty((Object)customerid)) {
            customerid = UserUtil.getDefaultOwnerID();
        }
        QFilter fs = new QFilter("customer", "=", customerid);
        fs.and(F7Utils.getEnableFilter());
        List auths = QueryUtil.queryColumnsList((String)"mdr_customer_authorize", (String[])new String[]{"authowner.id", "authowner.name", "authowner.number"}, (QFilter[])fs.toArray());
        for (int i = 0; i < auths.size(); ++i) {
            Map auth = (Map)auths.get(i);
            auth.put("id", auth.get("authowner.id"));
            auth.put("name", auth.get("authowner.name"));
            auth.put("number", auth.get("authowner.number"));
            auth.remove("authowner.id");
            auth.remove("authowner.name");
            auth.remove("authowner.number");
        }
        map.put("list", auths);
        map.put("count", auths.size());
        return ApiResult.success(map);
    }
}

