/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.customer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.api.ApiTransaction;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.AdmindivisionUtil;
import kd.drp.mdr.common.util.AssistantdataUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.UserUtil;

public class CustomerReqApi
extends MdrApi {
    private static final String DELETE = "delete";
    private static final String UNSUBMIT = "unsubmit";

    public ApiResult query(Map<String, Object> data) {
        String userId = UserUtil.getUserID() + "";
        String cType = (String)data.get("customerType");
        String cName = (String)data.get("custName");
        String phone = (String)data.get("phone");
        String idCard = (String)data.get("idCard");
        if (StringUtils.isEmpty((Object)userId)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8c03\u7528\u67e5\u8be2\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u539f\u56e0:\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01", (String)"CustomerReqApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("requser.id", "=", (Object)userId);
        if (!StringUtils.isEmpty((String)cType)) {
            qFilter.and("customertype", "=", (Object)cType);
        }
        if (!StringUtils.isEmpty((String)cName)) {
            qFilter.and("customername", "=", (Object)cName);
        }
        if (!StringUtils.isEmpty((String)phone)) {
            qFilter.and("phone", "=", (Object)phone);
        }
        if (!StringUtils.isEmpty((String)idCard)) {
            qFilter.and("idcard", "=", (Object)idCard);
        }
        DynamicObjectCollection dObjColl = QueryServiceHelper.query((String)"mdr_customer_request", (String)"", (QFilter[])qFilter.toArray());
        ArrayList resultList = new ArrayList(dObjColl.size());
        for (DynamicObject dObj : dObjColl) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(20);
            resultMap.put("id", dObj.getString("id"));
            resultMap.put("reqDate", dObj.getString("reqdate"));
            resultMap.put("customerType", dObj.getString("customertype"));
            resultMap.put("custName", dObj.getString("customername"));
            String areaNumber = AdmindivisionUtil.getAreaFullNameById((Object)dObj.getString("area"));
            resultMap.put("areaNumber", areaNumber);
            resultMap.put("address", dObj.getString("address"));
            resultMap.put("phone", dObj.getString("phone"));
            resultMap.put("blNumber", dObj.getString("blnumber"));
            resultMap.put("comTradeId", dObj.get("comtrade.id"));
            resultMap.put("comTradeNumber", dObj.get("comscale.number"));
            resultMap.put("comTradeName", dObj.get("comtrade.name"));
            resultMap.put("comScaleId", dObj.get("comscale.id"));
            resultMap.put("comScaleNumber", dObj.get("comtrade.number"));
            resultMap.put("comScaleName", dObj.get("comscale.name"));
            resultMap.put("idCard", dObj.getString("idcard"));
            resultMap.put("customerId", dObj.getString("customer.id"));
            resultMap.put("customerName", dObj.getString("customer.name"));
            resultMap.put("billStatus", dObj.getString("billstatus"));
            resultMap.put("genCust", dObj.getString("gencust"));
            resultMap.put("reqUserId", dObj.getString("requser.id"));
            resultList.add(resultMap);
        }
        return ApiResult.success(resultList);
    }

    public ApiResult progressQuery(Map<String, Object> data) {
        String id = UserUtil.getUserID() + "";
        if (StringUtils.isEmpty((Object)id)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8c03\u7528\u67e5\u8be2\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u539f\u56e0:\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01", (String)"CustomerReqApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObjectCollection dynObjs = QueryServiceHelper.query((String)"mdr_customer_request", (String)"id,billstatus,reqdate,gencust,backtime", (QFilter[])new QFilter("requser.id", "=", (Object)id).toArray());
        ArrayList resultList = new ArrayList();
        if (dynObjs.size() > 0) {
            for (DynamicObject dynObj : dynObjs) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                if ("C".equals(dynObj.getString("billstatus")) && dynObj.getBoolean("gencust")) {
                    resultMap.put("auditState", "SUCCESS");
                } else if ("D".equals(dynObj.getString("billstatus"))) {
                    resultMap.put("auditState", "FAIL");
                } else if ("B".equals(dynObj.getString("billstatus")) || "C".equals(dynObj.getString("billstatus")) && !dynObj.getBoolean("gencust")) {
                    resultMap.put("auditState", "WAIT");
                }
                resultMap.put("subDate", dynObj.getString("reqdate"));
                Date auditDate = null;
                if (dynObj.getBoolean("gencust")) {
                    DynamicObject customerInfo = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"id,createtime", (QFilter[])new QFilter("sourcebillid", "=", (Object)dynObj.getString("id")).toArray());
                    auditDate = (Date)customerInfo.get("createtime");
                }
                resultMap.put("auditDate", auditDate);
                resultMap.put("failDate", dynObj.getString("backtime"));
                resultList.add(resultMap);
            }
        }
        return ApiResult.success(resultList);
    }

    @ApiTransaction(propagation=Propagation.REQUIRED)
    public ApiResult save(Map<String, Object> data) {
        String comScaleId;
        String number;
        DynamicObject dynObj = null;
        String id = (String)data.get("id");
        if (StringUtils.isEmpty((String)id)) {
            dynObj = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer_request");
            long genLongId = DB.genLongId((String)"mdr_customer_request");
            dynObj.set("id", (Object)genLongId);
        } else {
            dynObj = QueryServiceHelper.queryOne((String)"mdr_customer_request", (String)"id,billstatus", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
            if (dynObj == null) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u8c03\u7528\u4fdd\u5b58\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u539f\u56e0:\u60a8\u8981\u4fee\u6539\u4fdd\u5b58\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff01", (String)"CustomerReqApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            dynObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mdr_customer_request");
            if ("B".equals(dynObj.get("billstatus"))) {
                OperationUtil.invokeOperation((DynamicObject)dynObj, (String)UNSUBMIT);
            }
        }
        dynObj.set("reqdate", (Object)new Date());
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)dynObj.getDataEntityType().getName(), (DynamicObject)dynObj, null);
        if (codeRuleInfo != null && !StringUtils.isEmpty((String)(number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)dynObj)))) {
            dynObj.set("billno", (Object)number);
        }
        if (StringUtils.isEmpty((Object)dynObj.get("billno"))) {
            dynObj.set("billno", (Object)UUID.randomUUID().toString());
        }
        dynObj.set("customertype", (Object)((String)data.get("customerType")));
        dynObj.set("customername", data.get("custName"));
        dynObj.set("password", data.get("password"));
        dynObj.set("area", data.get("area"));
        dynObj.set("address", data.get("address"));
        dynObj.set("phone", data.get("phone"));
        dynObj.set("blnumber", data.get("blNumber"));
        String comTradeId = (String)data.get("comTradeId");
        if (StringUtils.isNotEmpty((String)comTradeId)) {
            dynObj.set("comtrade", (Object)AssistantdataUtil.getAssistantdataInfo((String)comTradeId));
        }
        if (StringUtils.isNotEmpty((String)(comScaleId = (String)data.get("comScaleId")))) {
            dynObj.set("comscale", (Object)AssistantdataUtil.getAssistantdataInfo((String)comScaleId));
        }
        dynObj.set("idcard", data.get("idCard"));
        String custId = (String)data.get("customerId");
        DynamicObject custInfo = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"id", (QFilter[])new QFilter("id", "=", (Object)custId).toArray());
        if (custInfo == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8c03\u7528\u4fdd\u5b58\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u539f\u56e0:\u4f20\u5165\u7684\u5b57\u6bb5\u6570\u636e[\u7533\u8bf7\u52a0\u5165\u6e20\u9053]\u4e3a\u7a7a\u6216\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01", (String)"CustomerReqApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        custInfo = BusinessDataServiceHelper.loadSingle((Object)custId, (String)"mdr_customer");
        dynObj.set("customer", (Object)custInfo);
        dynObj.set("billstatus", (Object)"B");
        dynObj.set("gencust", (Object)"0");
        if (!data.containsKey("pictureObverse") || !data.containsKey("pictureReverse")) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8c03\u7528\u4fdd\u5b58\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u539f\u56e0:\u8eab\u4efd\u8bc1\u8bc1\u53cd\u9762\u5fc5\u987b\u4e0a\u4f20\uff01", (String)"CustomerReqApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        try {
            Map blMap;
            ArrayList<Map<String, Object>> srcAttachmentMaps = new ArrayList<Map<String, Object>>();
            Map obMap = (Map)data.get("pictureObverse");
            Map reMap = (Map)data.get("pictureReverse");
            srcAttachmentMaps.add(obMap);
            srcAttachmentMaps.add(reMap);
            dynObj.set("picture_ob", obMap.get("url"));
            dynObj.set("picture_re", reMap.get("url"));
            if (data.containsKey("pictureBLicence") && (blMap = (Map)data.get("pictureBLicence")) != null) {
                srcAttachmentMaps.add(blMap);
                dynObj.set("picture_bl", blMap.get("url"));
            }
            this.addAttachmentArray(dynObj, "mdr_customer_request", srcAttachmentMaps);
        }
        catch (Exception e) {
            new KDBizException(e.getMessage());
        }
        OperationUtil.invokeOperation((DynamicObject)dynObj, (String)"save");
        return ApiResult.success(null);
    }

    @ApiTransaction(propagation=Propagation.REQUIRED)
    public ApiResult delete(Map<String, Object> data) {
        String id = (String)data.get("id");
        DynamicObject dynObj = null;
        dynObj = QueryServiceHelper.queryOne((String)"mdr_customer_request", (String)"id", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        if (dynObj == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8c03\u7528\u5220\u9664\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u539f\u56e0:\u60a8\u8981\u5220\u9664\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728,\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff01", (String)"CustomerReqApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        dynObj = BusinessDataServiceHelper.loadSingle((String)"mdr_customer_request", (String)"id,billno,billstatus", (QFilter[])new QFilter("id", "in", (Object)id).toArray());
        if ("B".equals(dynObj.get("billstatus"))) {
            OperationUtil.invokeOperation((DynamicObject)dynObj, (String)UNSUBMIT);
        }
        OperationUtil.invokeOperation((DynamicObject)dynObj, (String)DELETE);
        return ApiResult.success(null);
    }

    private void addAttachmentArray(DynamicObject dynObj, String entrysName, List<Map<String, Object>> srcAttachmentMaps) {
        String dynObjId = dynObj.getString("id");
        ArrayList attachmentList = new ArrayList();
        HashMap<String, Object> uploadMap = new HashMap<String, Object>();
        try (TXHandle h = TX.requiresNew();){
            try {
                for (Map<String, Object> attachmentMap : srcAttachmentMaps) {
                    uploadMap.put("uid", "ydfx-upload-" + dynObjId + "-" + attachmentMap.keySet().toString().substring(7, 9).toLowerCase());
                    int size = StringUtils.isEmpty((Object)attachmentMap.get("size")) ? 0 : (Integer)attachmentMap.get("size");
                    uploadMap.put("size", size);
                    uploadMap.put("name", attachmentMap.get("name"));
                    uploadMap.put("url", attachmentMap.get("url"));
                    attachmentList.add(uploadMap);
                }
                AttachmentServiceHelper.upload((String)entrysName, (Object)dynObjId, (String)"attachmentpanel", attachmentList);
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }
}

