/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.customer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.UserUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class CustomerSaleInfoApi
extends MdrApi {
    protected static Log logger = LogFactory.getLog(CustomerSaleInfoApi.class);

    public ApiResult saleInfosync(Map<String, Object> data) {
        try {
            StringBuffer msg = new StringBuffer();
            Map customer = (Map)data.get("customer");
            if (customer == null) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u540c\u6b65\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"CustomerSaleInfoApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter("easnumber", "=", customer.get("number"));
            DynamicObject id = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"id", (QFilter[])qFilter.toArray());
            if (id == null || id.get("id") == null) {
                msg.append(String.format(ResManager.loadKDString((String)"\u5ba2\u6237%s[%s]\u672a\u540c\u6b65\uff0c\u9500\u552e\u5173\u7cfb\u4e0d\u5904\u7406\uff01", (String)"CustomerSaleInfoApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]), customer.get("name"), customer.get("number")));
                logger.error(msg.toString());
                return ApiResult.fail((String)msg.toString());
            }
            DynamicObject customerInfo = BusinessDataServiceHelper.loadSingle((Object)id.get("id"), (String)"mdr_customer");
            String authownerNumber = (String)data.get("authownerNumber");
            if (StringUtils.isEmpty((String)authownerNumber)) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u83b7\u53d6\u9500\u552e\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"CustomerSaleInfoApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            DynamicObject authownerInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_customer", (String)"id,name,number,isinnerorg", (QFilter[])new QFilter("number", "=", (Object)authownerNumber).toArray());
            if (authownerInfo == null) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u9500\u552e\u7ec4\u7ec7\u5bf9\u5e94\u5185\u90e8\u6e20\u9053[%s]\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5EAS\u9500\u552e\u7ec4\u7ec7\u548c\u5185\u90e8\u6e20\u9053\u5173\u7cfb\u4ee5\u53ca\u6e20\u9053\u4e91\u5185\u90e8\u6e20\u9053\u4fe1\u606f\u662f\u5426\u6b63\u786e\uff01", (String)"CustomerSaleInfoApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]), authownerNumber));
            }
            this.addCustomerAuth(customerInfo, authownerInfo);
            this.addSaler(msg, data, authownerInfo, customerInfo);
            this.addAddressess(data, customerInfo);
            if (msg.length() > 0) {
                HashMap<String, StringBuffer> returndata = new HashMap<String, StringBuffer>();
                returndata.put("msg", msg);
                return ApiResult.success(returndata);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return ApiResult.ex((Throwable)e);
        }
        return ApiResult.success(null);
    }

    private void addAddressess(Map<String, Object> data, DynamicObject customerInfo) {
        List addressess = (List)data.get("addressess");
        if (addressess != null && addressess.size() > 0) {
            String userId = RequestContext.get().getUserId();
            Date date = new Date();
            ArrayList<DynamicObject> addressessList = new ArrayList<DynamicObject>();
            for (Map addr : addressess) {
                String address = (String)addr.get("address");
                String contactname = (String)addr.get("contactname");
                String telephone = (String)addr.get("telephone");
                QFilter[] qf = new QFilter("customer", "=", customerInfo.get("id")).and("address2", "=", (Object)address).and("contactname", "=", (Object)contactname).and("telephone", "=", (Object)telephone).toArray();
                DynamicObject customerAddr = QueryServiceHelper.queryOne((String)"mdr_customer_address", (String)"id", (QFilter[])qf);
                if (customerAddr != null) continue;
                customerAddr = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer_address");
                customerAddr.set("customer", (Object)customerInfo);
                customerAddr.set("address2", (Object)address);
                customerAddr.set("detailaddress", (Object)address);
                customerAddr.set("contactname", (Object)contactname);
                customerAddr.set("telephone", (Object)telephone);
                customerAddr.set("creator", (Object)userId);
                customerAddr.set("createtime", (Object)date);
                customerAddr.set("modifier", (Object)userId);
                customerAddr.set("modifytime", (Object)date);
                customerAddr.set("isdefault", (Object)"0");
                customerAddr.set("enable", (Object)"1");
                customerAddr.set("status", (Object)"C");
                addressessList.add(customerAddr);
            }
            if (addressessList.size() > 0) {
                OperationUtil.invokeOperation((DynamicObject[])addressessList.toArray(new DynamicObject[0]), (String)"save");
            }
        }
    }

    private void addSaler(StringBuffer msg, Map<String, Object> data, DynamicObject authownerInfo, DynamicObject customerInfo) {
        List salers = (List)data.get("salers");
        if (salers != null && salers.size() > 0) {
            DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name,number,phone", (QFilter[])new QFilter("phone", "in", (Object)salers).toArray());
            ArrayList<String> notInNextUser = new ArrayList<String>();
            for (String saler : salers) {
                boolean isInNext = false;
                for (DynamicObject user : users) {
                    if (!user.getString("phone").equals(saler)) continue;
                    isInNext = true;
                    break;
                }
                if (isInNext) continue;
                notInNextUser.add(saler);
            }
            if (notInNextUser.size() > 0) {
                msg.append(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7528\u6237\u5728\u82cd\u7a79\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u672a\u65b0\u589e\u4e3a\u5f53\u524d\u6e20\u9053\u4e1a\u52a1\u5458\uff0c\u8bf7\u5728\u82cd\u7a79\u7cfb\u7edf\u4e2d\u65b0\u589e\u7528\u6237\u540e\u91cd\u65b0\u4fdd\u5b58EAS\u5ba2\u6237\u9500\u552e\u8d44\u6599\uff01\n\u7528\u6237\uff1a\u3010", (String)"CustomerSaleInfoApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                for (int i = 0; i < notInNextUser.size(); ++i) {
                    if (i > 0) {
                        msg.append(',');
                    }
                    msg.append((String)notInNextUser.get(i));
                }
                msg.append('\u3011');
            }
            if (users.length > 0) {
                this.addMdrUser(authownerInfo, users);
                this.addMdrSaler(authownerInfo, customerInfo, users);
            }
        }
    }

    private void addMdrSaler(DynamicObject authownerInfo, DynamicObject customerInfo, DynamicObject[] users) {
        ArrayList<DynamicObject> customerSalers = new ArrayList<DynamicObject>();
        for (DynamicObject user : users) {
            String userId = RequestContext.get().getUserId();
            Date date = new Date();
            DynamicObject customerSaler = QueryServiceHelper.queryOne((String)"mdr_cust_saler_relation", (String)"id", (QFilter[])new QFilter("owner", "=", authownerInfo.get("id")).and("customer", "=", customerInfo.get("id")).and("user", "=", user.get("id")).toArray());
            if (customerSaler != null) continue;
            customerSaler = BusinessDataServiceHelper.newDynamicObject((String)"mdr_cust_saler_relation");
            customerSaler.set("owner", (Object)authownerInfo);
            customerSaler.set("customer", (Object)customerInfo);
            customerSaler.set("user", (Object)user);
            customerSaler.set("isdefault", (Object)"0");
            customerSaler.set("creator", (Object)userId);
            customerSaler.set("createtime", (Object)date);
            customerSaler.set("modifier", (Object)userId);
            customerSaler.set("modifytime", (Object)date);
            customerSaler.set("enable", (Object)"1");
            customerSaler.set("name", (Object)"");
            customerSaler.set("number", (Object)"");
            customerSaler.set("status", (Object)"C");
            customerSalers.add(customerSaler);
        }
        if (customerSalers.size() > 0) {
            OperationUtil.invokeOperation((DynamicObject[])customerSalers.toArray(new DynamicObject[0]), (String)"save");
        }
    }

    private void addMdrUser(DynamicObject authowner, DynamicObject[] users) {
        ArrayList<DynamicObject> mdrUsers = new ArrayList<DynamicObject>();
        for (DynamicObject user : users) {
            Object userId;
            Object ownerId = authowner.get("id");
            if (QueryServiceHelper.exists((String)"dbd_drp_user", (QFilter[])new QFilter("owner", "=", ownerId).and("sysuser", "=", userId = user.get("id")).toArray())) continue;
            DynamicObject userInfo = BusinessDataServiceHelper.newDynamicObject((String)"dbd_drp_user");
            userInfo.set("sysuser", (Object)user);
            userInfo.set("owner", (Object)authowner);
            userInfo.set("isdptadmin", (Object)Boolean.FALSE);
            userInfo.set("iscusorderprocessor", (Object)Boolean.FALSE);
            userInfo.set("isdispatcher", (Object)Boolean.FALSE);
            userInfo.set("issaler", (Object)Boolean.TRUE);
            userInfo.set("isbuyer", (Object)Boolean.TRUE);
            userInfo.set("isdefault", (Object)Boolean.FALSE);
            userInfo.set("enable", (Object)"1");
            userInfo.set("creator", UserUtil.getUserID());
            userInfo.set("createtime", (Object)new Date());
            userInfo.set("remark", (Object)ResManager.loadKDString((String)"EAS\u540c\u6b65\u9500\u552e\u5458\u65b0\u589e\u5206\u9500\u7528\u6237\u5173\u7cfb", (String)"CustomerSaleInfoApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            mdrUsers.add(userInfo);
        }
        if (mdrUsers.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isEasSync", "true");
            OperationUtil.invokeOperation((DynamicObject[])mdrUsers.toArray(new DynamicObject[0]), (String)"save", (OperateOption)option);
        }
    }

    private void addCustomerAuth(DynamicObject customer, DynamicObject authowner) {
        QFilter f = new QFilter("customer", "=", customer.get("id")).and("authowner", "=", authowner.get("id"));
        if (QueryServiceHelper.exists((String)"mdr_customer_authorize", (QFilter[])f.toArray())) {
            return;
        }
        String userId = RequestContext.get().getUserId();
        Date date = new Date();
        DynamicObject auth = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer_authorize");
        StringBuilder number = new StringBuilder();
        number.append(authowner.getString("number"));
        number.append('_');
        number.append(customer.getString("number"));
        auth.set("number", (Object)number.toString());
        auth.set("authowner", (Object)authowner);
        auth.set("customer", (Object)customer);
        auth.set("status", (Object)"C");
        auth.set("enable", (Object)"1");
        auth.set("discountrate", (Object)1);
        auth.set("creator", (Object)userId);
        auth.set("createtime", (Object)date);
        auth.set("modifier", (Object)userId);
        auth.set("modifytime", (Object)date);
        auth.set("ctrlstrategy", (Object)"5");
        auth.set("parentinvtype", (Object)"2");
        for (DynamicObject cusclass : customer.getDynamicObjectCollection("custclassentity")) {
            Object classstandardid = cusclass.getDynamicObject("classstandardid").getPkValue();
            if (!classstandardid.equals(836014120472951808L)) continue;
            auth.set("customergroup", cusclass.get("customergroupid"));
            break;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isEasSync", "true");
        OperationUtil.invokeOperation((DynamicObject[])new DynamicObject[]{auth}, (String)"save", (OperateOption)option);
    }
}

