/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.customer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.UserUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SalerSyncApi
implements IBillWebApiPlugin {
    protected static Log logger = LogFactory.getLog(SalerSyncApi.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        try {
            StringBuffer msg = new StringBuffer();
            Map data = (Map)params.get("data");
            Map customer = (Map)data.get("customer");
            if (customer == null) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u540c\u6b65\u6e20\u9053\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01", (String)"SalerSyncApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            DynamicObject company = BusinessDataServiceHelper.loadSingle((String)"mdr_customer", (String)"id,name,number,isinnerorg", (QFilter[])new QFilter("isinnerorg", "=", (Object)"1").toArray());
            DynamicObject customerInfo = this.addCustomer(customer, company);
            this.addSaler(msg, data, company, customerInfo);
            this.addAddressess(data, company, customerInfo);
            if (msg.length() > 0) {
                HashMap<String, StringBuffer> returndata = new HashMap<String, StringBuffer>();
                returndata.put("msg", msg);
                return ApiResult.success(returndata);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return ApiResult.ex((Throwable)e);
        }
        return ApiResult.success(null);
    }

    private void addAddressess(Map<String, Object> data, DynamicObject companyInfo, DynamicObject customerInfo) {
        List addressess = (List)data.get("addressess");
        if (addressess != null) {
            for (Map addr : addressess) {
                String address = (String)addr.get("address");
                String contactname = (String)addr.get("contactname");
                String telephone = (String)addr.get("telephone");
                QFilter[] qf = new QFilter("customer", "=", customerInfo.get("id")).and("address2", "=", (Object)address).and("contactname", "=", (Object)contactname).and("telephone", "=", (Object)telephone).toArray();
                DynamicObject customerAddr = QueryServiceHelper.queryOne((String)"mdr_customer_address", (String)"id", (QFilter[])qf);
                if (customerAddr != null) continue;
                customerAddr = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer_address");
                customerAddr.set("customer", customerInfo.get("id"));
                customerAddr.set("owner", (Object)companyInfo);
                customerAddr.set("address2", (Object)address);
                customerAddr.set("detailaddress", (Object)address);
                customerAddr.set("contactname", (Object)contactname);
                customerAddr.set("telephone", (Object)telephone);
                customerAddr.set("isdefault", (Object)"0");
                customerAddr.set("creator", (Object)RequestContext.get().getUserId());
                customerAddr.set("createtime", (Object)new Date());
                customerAddr.set("isdefault", (Object)"0");
                customerAddr.set("creator", (Object)RequestContext.get().getUserId());
                customerAddr.set("createtime", (Object)new Date());
                customerAddr.set("modifier", (Object)RequestContext.get().getUserId());
                customerAddr.set("modifytime", (Object)new Date());
                customerAddr.set("enable", (Object)"1");
                customerAddr.set("status", (Object)"C");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{customerAddr});
            }
        }
    }

    private List<String> addSaler(StringBuffer msg, Map<String, Object> data, DynamicObject company, DynamicObject customerInfo) {
        List salers = (List)data.get("salers");
        if (salers != null) {
            DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"id,phone", (QFilter[])new QFilter("phone", "in", (Object)salers).toArray());
            ArrayList<String> notInNextUser = new ArrayList<String>();
            for (String saler : salers) {
                boolean isInNext = false;
                for (DynamicObject user : users) {
                    if (!user.getString("phone").equals(saler)) continue;
                    isInNext = true;
                    break;
                }
                if (isInNext) continue;
                notInNextUser.add(saler);
            }
            if (notInNextUser.size() > 0) {
                msg.append(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7528\u6237\u5728\u82cd\u7a79\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u672a\u65b0\u589e\u4e3a\u5f53\u524d\u6e20\u9053\u4e1a\u52a1\u5458\uff0c\u8bf7\u5728\u82cd\u7a79\u7cfb\u7edf\u4e2d\u65b0\u589e\u7528\u6237\u540e\u91cd\u65b0\u4fdd\u5b58EAS\u5ba2\u6237\u9500\u552e\u8d44\u6599\uff01\n\u7528\u6237\uff1a\u3010", (String)"SalerSyncApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                for (int i = 0; i < notInNextUser.size(); ++i) {
                    if (i > 0) {
                        msg.append(',');
                    }
                    msg.append((String)notInNextUser.get(i));
                }
                msg.append('\u3011');
            }
            for (DynamicObject user : users) {
                this.addMdrUser(company, user);
                this.addMdrSaler(company, customerInfo, user);
            }
        }
        return salers;
    }

    private void addMdrSaler(DynamicObject company, DynamicObject customerInfo, DynamicObject user) {
        DynamicObject customerSaler = QueryServiceHelper.queryOne((String)"mdr_cust_saler_relation", (String)"id", (QFilter[])new QFilter("owner", "=", company.get("id")).and("customer", "=", customerInfo.get("id")).and("user", "=", user.get("id")).toArray());
        if (customerSaler == null) {
            customerSaler = BusinessDataServiceHelper.newDynamicObject((String)"mdr_cust_saler_relation");
            customerSaler.set("owner", company.get("id"));
            customerSaler.set("customer", customerInfo.get("id"));
            customerSaler.set("user", user.get("id"));
            customerSaler.set("isdefault", (Object)"0");
            customerSaler.set("creator", (Object)RequestContext.get().getUserId());
            customerSaler.set("createtime", (Object)new Date());
            customerSaler.set("modifier", (Object)RequestContext.get().getUserId());
            customerSaler.set("modifytime", (Object)new Date());
            customerSaler.set("enable", (Object)"1");
            customerSaler.set("name", (Object)"");
            customerSaler.set("number", (Object)"");
            customerSaler.set("status", (Object)"C");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{customerSaler});
        }
    }

    private void addMdrUser(DynamicObject company, DynamicObject user) {
        Object userId;
        Object ownerId = company.get("id");
        if (!QueryServiceHelper.exists((String)"dbd_drp_user", (QFilter[])new QFilter("owner", "=", ownerId).and("sysuser", "=", userId = user.get("id")).toArray())) {
            user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"id,name,phone,number");
            DynamicObject userInfo = BusinessDataServiceHelper.newDynamicObject((String)"dbd_drp_user");
            userInfo.set("sysuser", (Object)user);
            userInfo.set("owner", (Object)company);
            userInfo.set("isdptadmin", (Object)Boolean.FALSE);
            userInfo.set("iscusorderprocessor", (Object)Boolean.FALSE);
            userInfo.set("isdispatcher", (Object)Boolean.FALSE);
            userInfo.set("issaler", (Object)Boolean.TRUE);
            userInfo.set("isbuyer", (Object)Boolean.TRUE);
            userInfo.set("isdefault", (Object)Boolean.FALSE);
            userInfo.set("enable", (Object)"1");
            userInfo.set("creator", UserUtil.getUserID());
            userInfo.set("createtime", (Object)new Date());
            userInfo.set("remark", (Object)ResManager.loadKDString((String)"EAS\u540c\u6b65\u9500\u552e\u5458\u65b0\u589e\u5206\u9500\u7528\u6237\u5173\u7cfb", (String)"SalerSyncApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"dbd_drp_user", (DynamicObject[])new DynamicObject[]{userInfo}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                List infos = result.getAllErrorOrValidateInfo();
                StringBuilder msg = new StringBuilder();
                for (IOperateInfo info : infos) {
                    msg.append(info.getMessage());
                    msg.append("\r\n");
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25:%s", (String)"SalerSyncApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]), msg.toString()));
            }
        }
    }

    private DynamicObject addCustomer(Map<String, Object> customer, DynamicObject company) {
        String number = (String)customer.get("number");
        DynamicObject customerInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_customer", (String)"id,number,name", (QFilter[])new QFilter("easnumber", "=", (Object)number).toArray());
        if (customerInfo == null) {
            String name = (String)customer.get("name");
            String address = (String)customer.get("address");
            customerInfo = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer");
            customerInfo.set("name", (Object)name);
            customerInfo.set("number", (Object)number);
            customerInfo.set("easnumber", (Object)number);
            customerInfo.set("eascustomerid", customer.get("id"));
            customerInfo.set("address", (Object)address);
            customerInfo.set("enable", (Object)"1");
            customerInfo.set("isinnerorg", (Object)"0");
            customerInfo.set("creator", (Object)RequestContext.get().getUserId());
            customerInfo.set("createtime", (Object)new Date());
            customerInfo.set("modifier", (Object)RequestContext.get().getUserId());
            customerInfo.set("modifytime", (Object)new Date());
            OperationUtil.invokeOperation((DynamicObject)customerInfo, (String)"save");
            customerInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_customer", (String)"id,number,name,isinnerorg", (QFilter[])new QFilter("easnumber", "=", (Object)number).toArray());
            this.addCustomerAuth(customerInfo, company);
        }
        return customerInfo;
    }

    private void addCustomerAuth(DynamicObject customer, DynamicObject company) {
        DynamicObject auth = BusinessDataServiceHelper.newDynamicObject((String)"mdr_customer_authorize");
        StringBuilder number = new StringBuilder();
        if (company != null) {
            number.append(company.getString("number"));
        }
        number.append('_');
        if (customer != null) {
            number.append(customer.getString("number"));
        }
        auth.set("number", (Object)number.toString());
        auth.set("authowner", (Object)company);
        auth.set("customer", (Object)customer);
        auth.set("enable", (Object)"1");
        auth.set("discountrate", (Object)1);
        auth.set("creator", (Object)RequestContext.get().getUserId());
        auth.set("createtime", (Object)new Date());
        auth.set("modifier", (Object)RequestContext.get().getUserId());
        auth.set("modifytime", (Object)new Date());
        OperationUtil.invokeOperation((DynamicObject)auth, (String)"save");
    }
}

