/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.deliveryrecord;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.DateUtil;
import kd.drp.mdr.common.util.OperationUtil;

public class DeliveryRecordApi
extends MdrApi {
    public ApiResult createDeliveryRecord(Map<String, Object> data) {
        String driverPhone;
        String driver;
        String vehicleLicense;
        String logisticsname;
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"bbc_delivery_record");
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)record.getDataEntityType().getName(), (DynamicObject)record, null);
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)record);
        record.set("billno", (Object)number);
        record.set("sourcebilltype", data.get("sourcebilltype"));
        record.set("deliverdate", (Object)DateUtil.formatDate((String)((String)data.get("deliverdate")), (String)"yyyy-MM-dd HH:mm:ss"));
        String logisticsbill = (String)data.get("logisticsbill");
        if (!StringUtils.isEmpty((String)logisticsbill)) {
            record.set("logisticsbill", (Object)logisticsbill);
        }
        if (!StringUtils.isEmpty((String)(logisticsname = (String)data.get("logisticsname")))) {
            DynamicObject logistic = BusinessDataServiceHelper.loadSingle((String)"mdr_logistics", (String)"id", (QFilter[])new QFilter("name", "=", (Object)logisticsname).toArray());
            if (logistic == null) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a%s\u7684\u7269\u6d41\u516c\u53f8", (String)"DeliveryRecordApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]), logisticsname));
            }
            record.set("logistics", (Object)logistic);
        }
        if (!StringUtils.isEmpty((String)(vehicleLicense = (String)data.get("vehicleLicense")))) {
            record.set("platenumber", (Object)vehicleLicense);
        }
        if (!StringUtils.isEmpty((String)(driver = (String)data.get("driver")))) {
            record.set("drivername", (Object)driver);
        }
        if (!StringUtils.isEmpty((String)(driverPhone = (String)data.get("driverPhone")))) {
            record.set("drivertelephone", (Object)driverPhone);
        }
        record.set("easissuebillid", data.get("easissuebillid"));
        record.set("easissuebillno", data.get("easissuebillno"));
        record.set("remark", data.get("remark"));
        record.set("isautosigndeliveryrecord", data.get("isAutoSignDeliveryRecord"));
        record.set("billstatus", (Object)"B");
        record.set("signstatus", (Object)0);
        List entrys = (List)data.get("deliverydetail");
        for (Map entry : entrys) {
            DynamicObject recordentry = record.getDynamicObjectCollection("deliverydetail").addNew();
            recordentry.set("deliverqty", (Object)new BigDecimal(entry.get("deliverqty").toString()));
            recordentry.set("srcbillid", data.get("sourcebillId"));
            recordentry.set("mainbillid", data.get("sourcebillId"));
            recordentry.set("srcbillentryid", entry.get("sourcebillentryid"));
            recordentry.set("mainbillentryid", entry.get("sourcebillentryid"));
            recordentry.set("price", entry.get("salePrice"));
            recordentry.set("taxprice", entry.get("taxPrice"));
            recordentry.set("taxrate", entry.get("taxRate"));
            recordentry.set("taxamount", entry.get("tax"));
            recordentry.set("amount", entry.get("nonTaxAmount"));
            recordentry.set("amountandtax", entry.get("amount"));
            Object discounttype = entry.get("discountType");
            if (discounttype == null) continue;
            if (discounttype.equals("1")) {
                recordentry.set("discounttype", (Object)"B");
            } else if (discounttype.equals("0")) {
                recordentry.set("discounttype", (Object)"A");
            } else {
                recordentry.set("discounttype", null);
            }
            recordentry.set("discount", entry.get("discount"));
            recordentry.set("discountamount", entry.get("discountAmount"));
        }
        OperationUtil.invokeOperation((DynamicObject)record, (String)"save");
        return ApiResult.success(null);
    }

    public ApiResult deleteDeliveryRecord(Map<String, Object> data) {
        String easissuebillid = (String)data.get("easissuebillid");
        if (StringUtils.isEmpty((String)easissuebillid)) {
            return ApiResult.success(null);
        }
        DynamicObject[] record = BusinessDataServiceHelper.load((String)"bbc_delivery_record", (String)"id", (QFilter[])new QFilter("easissuebillid", "=", (Object)easissuebillid).toArray());
        if (record == null || record.length == 0) {
            return ApiResult.success(null);
        }
        for (DynamicObject temprc : record) {
            DynamicObject tempRc = BusinessDataServiceHelper.loadSingle((Object)temprc.getPkValue(), (String)"bbc_delivery_record");
            OperationUtil.invokeOperation((DynamicObject)tempRc, (String)"delete");
        }
        return ApiResult.success(null);
    }
}

