/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.driver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.Propagation;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.api.ApiTransaction;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;

public class DriverApi
extends MdrApi {
    public ApiResult queryDriverList(Map<String, Object> data) {
        this.checkRecordField(data, new String[0]);
        QFilter qf = new QFilter("1", "=", (Object)"1");
        int from = 0;
        int length = -1;
        int pageSize = 20;
        int page = 1;
        String name = (String)data.get("name");
        String id = (String)data.get("id");
        String driverid = (String)data.get("driverId");
        String carid = (String)data.get("carId");
        String driverphone = (String)data.get("driverPhone");
        String isEnble = (String)data.get("isEnble");
        String isdefault = (String)data.get("isdefault");
        String status = (String)data.get("status");
        qf.and("customerentry.customer.id", "=", UserUtil.getDefaultOwnerID());
        if (StringUtils.isNotEmpty((String)isdefault)) {
            qf.and("customerentry.isdefault", "=", (Object)isdefault);
        }
        if (StringUtils.isNotEmpty((String)name)) {
            qf.and("name", "=", (Object)name);
        }
        if (StringUtils.isNotEmpty((String)status)) {
            qf.and("status", "=", (Object)status);
        }
        if (StringUtils.isNotEmpty((String)driverid)) {
            qf.and("driverid", "=", (Object)driverid);
        }
        if (StringUtils.isNotEmpty((Object)data.get("page"))) {
            page = (Integer)data.get("page");
        }
        if (StringUtils.isNotEmpty((Object)data.get("pageSize"))) {
            pageSize = (Integer)data.get("pageSize");
        }
        if (StringUtils.isEmpty((String)isEnble)) {
            isEnble = "1";
        }
        qf.and("customerentry.isenble", "=", (Object)isEnble);
        if (StringUtils.isNotEmpty((String)id)) {
            qf.and("id", "=", (Object)id);
        }
        if (StringUtils.isNotEmpty((String)carid)) {
            qf.and("customerentry.carid", "=", (Object)carid);
        }
        if (StringUtils.isNotEmpty((String)driverphone)) {
            qf.and("driverphone", "=", (Object)driverphone);
        }
        from = (page - 1) * pageSize;
        length = pageSize;
        DynamicObjectCollection driverClass = ORMUtil.query((String)"mdr_driver", (String)"id", (QFilter[])qf.toArray(), null, (int)from, (int)length);
        int querycount = QueryUtil.querycount((String)"mdr_driver", (QFilter[])qf.toArray());
        ArrayList driverClassList = new ArrayList();
        for (DynamicObject dyoId : driverClass) {
            String select = "id,name,driverid,driverphone,customerentry,customerentry.carid,customerentry.customer,status,headjpg,frontjpg,contraryjpg,customerentry.cartype";
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)dyoId.getLong("id"), (String)"mdr_driver", (String)select);
            HashMap<String, String> driverClassMap = new HashMap<String, String>();
            if (dyo.get(6) != null && dyo.getBoolean(6)) {
                driverClassMap.put("isDefault", "1");
            } else {
                driverClassMap.put("isDefault", "0");
            }
            driverClassMap.put("name", dyo.getString("name"));
            driverClassMap.put("driverId", dyo.getString("driverid"));
            driverClassMap.put("frontJpg", dyo.getString("frontjpg"));
            driverClassMap.put("driverPhone", dyo.getString("driverphone"));
            driverClassMap.put("contraryJpg", dyo.getString("contraryjpg"));
            driverClassMap.put("id", dyo.getString("id"));
            driverClassMap.put("driverStatus", dyo.getString("status"));
            driverClassMap.put("headJpg", dyo.getString("headjpg"));
            DynamicObjectCollection customerentryCollection = dyo.getDynamicObjectCollection("customerentry");
            for (DynamicObject customerentry : customerentryCollection) {
                if (!UserUtil.getDefaultOwnerID().equals(customerentry.get("customer.id"))) continue;
                driverClassMap.put("carTypeId", customerentry.getString("cartype.id"));
                driverClassMap.put("carTypeName", customerentry.getString("cartype.name"));
                driverClassMap.put("carId", customerentry.getString("carid"));
                driverClassMap.put("customerId", customerentry.getString("customer.id"));
                break;
            }
            driverClassList.add(driverClassMap);
        }
        HashMap<String, Serializable> countMap = new HashMap<String, Serializable>();
        countMap.put("count", Integer.valueOf(querycount));
        countMap.put("list", driverClassList);
        return ApiResult.success(countMap);
    }

    @ApiTransaction(propagation=Propagation.REQUIRED)
    public ApiResult delete(Map<String, Object> data) {
        this.checkRecordField(data, "ids");
        long customerid = (Long)UserUtil.getDefaultOwnerID();
        ArrayList ids = (ArrayList)data.get("ids");
        for (int i = 0; i < ids.size(); ++i) {
            boolean exists = QueryServiceHelper.exists((String)"mdr_driver", ids.get(i));
            if (!exists) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u8be5\u53f8\u673a\u4e0d\u5b58\u5728", (String)"DriverApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            DynamicObject driver = BusinessDataServiceHelper.loadSingle(ids.get(i), (String)"mdr_driver");
            if (driver == null) continue;
            DynamicObjectCollection customerentryCollection = driver.getDynamicObjectCollection("customerentry");
            int n = customerentryCollection.size();
            for (int j = 0; j < n; ++j) {
                DynamicObject customerentry = (DynamicObject)customerentryCollection.get(j);
                if (customerid != customerentry.getLong("customer.id")) continue;
                if ("C".equals(driver.getString("status"))) {
                    customerentry.set("isenble", (Object)Boolean.FALSE);
                    continue;
                }
                if (n <= 1) {
                    driver.set("status", (Object)"A");
                    OperationUtil.invokeOperation((DynamicObject)driver, (String)"delete");
                    continue;
                }
                customerentryCollection.remove((Object)customerentry);
            }
            driver.set("customerentry", (Object)customerentryCollection);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{driver});
        }
        return ApiResult.success(null);
    }

    public ApiResult add(Map<String, Object> data) {
        this.checkRecordField(data, "carTypeId", "frontJpg", "headJpg", "name", "driverId", "carId", "driverPhone");
        QFilter qf = new QFilter("1", "=", (Object)"1");
        String name = (String)data.get("name");
        String driverid = (String)data.get("driverId");
        String carid = (String)data.get("carId");
        String isdefault = (String)data.get("isdefault");
        String driverphone = (String)data.get("driverPhone");
        String frontjpg = (String)data.get("frontJpg");
        String contraryjpg = (String)data.get("contraryJpg");
        String cartypeId = (String)data.get("carTypeId");
        String headJpg = (String)data.get("headJpg");
        long customerid = (Long)UserUtil.getDefaultOwnerID();
        if (StringUtils.isEmpty((String)isdefault)) {
            isdefault = "0";
        }
        qf.and("driverid", "=", (Object)driverid);
        qf.and("driverphone", "=", (Object)driverphone);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mdr_driver", (String)"id", (QFilter[])qf.toArray());
        if (!QueryServiceHelper.exists((String)"mdr_customer", (Object)customerid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u5ba2\u6237\u4e0d\u5b58\u5728\uff01\uff01", (String)"DriverApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject customer = BusinessDataServiceHelper.loadSingle((Object)customerid, (String)"mdr_customer");
        DynamicObject driver = BusinessDataServiceHelper.newDynamicObject((String)"mdr_driver");
        DynamicObjectCollection customerentryCollection = driver.getDynamicObjectCollection("customerentry");
        DynamicObject customerentry = customerentryCollection.addNew();
        customerentry.set("customer", (Object)customer);
        if (isdefault.equals("1")) {
            customerentry.set("isdefault", (Object)Boolean.TRUE);
        } else {
            customerentry.set("isdefault", (Object)Boolean.FALSE);
        }
        if (!QueryServiceHelper.exists((String)"bos_assistantdata_detail", (Object)cartypeId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f66\u8f86\u7c7b\u578bId\u4e0d\u5b58\u5728\uff01\uff01", (String)"DriverApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject cartypeObj = BusinessDataServiceHelper.loadSingle((Object)cartypeId, (String)"bos_assistantdata_detail");
        customerentry.set("isenble", (Object)Boolean.TRUE);
        customerentry.set("carid", (Object)carid);
        customerentry.set("cartype", (Object)cartypeObj);
        driver.set("name", (Object)name);
        driver.set("driverid", (Object)driverid);
        driver.set("driverphone", (Object)driverphone);
        driver.set("enable", (Object)1);
        driver.set("frontjpg", (Object)frontjpg);
        driver.set("contraryjpg", (Object)contraryjpg);
        driver.set("headjpg", (Object)headJpg);
        driver.set("status", (Object)"A");
        driver.set("creator", UserUtil.getUserID());
        driver.set("createtime", (Object)new Date());
        DynamicObject driverExist = null;
        DynamicObject customerentryExist = null;
        int n = 0;
        if (dynamicObjects.length > 0) {
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)dynamicObjects[0].getLong("id"), (String)"mdr_driver");
            DynamicObjectCollection customerentryC = loadSingle.getDynamicObjectCollection("customerentry");
            for (DynamicObject dynamicObject : customerentryC) {
                ++n;
                if (customerid != dynamicObject.getLong("customer.id")) continue;
                customerentryExist = dynamicObject;
            }
            if ("C".equals(loadSingle.getString("status"))) {
                driver.set("status", (Object)"C");
                driver.set("audittime", (Object)new Date());
                driver.set("auditor", UserUtil.getUserID());
            }
            driverExist = loadSingle;
        }
        if (driverExist != null) {
            if (customerentryExist == null) {
                driverExist.getDynamicObjectCollection("customerentry").add((Object)customerentry);
            } else {
                ((DynamicObject)driverExist.getDynamicObjectCollection("customerentry").get(n - 1)).set("carid", (Object)carid);
                ((DynamicObject)driverExist.getDynamicObjectCollection("customerentry").get(n - 1)).set("cartype", (Object)cartypeObj);
            }
            OperationUtil.invokeOperation(driverExist, (String)"save");
        } else {
            driver.set("status", (Object)"B");
            OperationUtil.invokeOperation((DynamicObject)driver, (String)"save");
        }
        return ApiResult.success(null);
    }

    public ApiResult checkDriver(Map<String, Object> data) {
        this.checkRecordField(data, "driverId", "driverPhone");
        QFilter qf = new QFilter("1", "=", (Object)"1");
        String driverid = (String)data.get("driverId");
        String driverphone = (String)data.get("driverPhone");
        if (driverid == null) {
            throw new KDBizException(ResManager.loadKDString((String)"driverid\u4e0d\u80fd\u4e3a\u7a7a", (String)"DriverApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (driverphone == null) {
            throw new KDBizException(ResManager.loadKDString((String)"driverphone\u4e0d\u80fd\u4e3a\u7a7a", (String)"DriverApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        qf.and("driverid", "=", (Object)driverid);
        qf.and("driverphone", "=", (Object)driverphone);
        qf.and("customerentry.customer.id", "=", UserUtil.getDefaultOwnerID());
        String select = "id,name,driverid,driverphone,customerentry,customerentry.carid,status,headjpg,frontjpg,contraryjpg,customerentry.customer,customerentry.cartype";
        DynamicObject[] driverClass = BusinessDataServiceHelper.load((String)"mdr_driver", (String)select, (QFilter[])qf.toArray());
        ArrayList driverClassList = new ArrayList(driverClass.length);
        for (DynamicObject dyo : driverClass) {
            HashMap<String, Object> driverClassMap = new HashMap<String, Object>();
            if (dyo.get(6) != null && dyo.getBoolean(6)) {
                driverClassMap.put("isDefault", "1");
            } else {
                driverClassMap.put("isDefault", "0");
            }
            driverClassMap.put("name", dyo.getString("name"));
            driverClassMap.put("driverId", dyo.getString("driverid"));
            driverClassMap.put("driverPhone", dyo.getString("driverphone"));
            driverClassMap.put("carId", dyo.getString("customerentry.carid"));
            driverClassMap.put("frontJpg", dyo.getString("frontjpg"));
            driverClassMap.put("contraryJpg", dyo.getString("contraryjpg"));
            driverClassMap.put("id", dyo.getString("id"));
            driverClassMap.put("driverStatus", dyo.getString("status"));
            driverClassMap.put("headJpg", dyo.getString("headjpg"));
            DynamicObjectCollection customerentryCollection = dyo.getDynamicObjectCollection("customerentry");
            for (DynamicObject customerentry : customerentryCollection) {
                if (!UserUtil.getDefaultOwnerID().equals(customerentry.get("customer.id"))) continue;
                driverClassMap.put("carId", customerentry.getString("carid"));
                driverClassMap.put("carTypeId", customerentry.getString("cartype.id"));
                driverClassMap.put("carTypeName", customerentry.getString("cartype.name"));
                break;
            }
            driverClassMap.put("customerId", UserUtil.getDefaultOwnerID());
            driverClassList.add(driverClassMap);
        }
        HashMap driverMap = new HashMap();
        driverMap.put("list", driverClassList);
        return ApiResult.success(driverMap);
    }

    public ApiResult queryCarType(Map<String, Object> data) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)1).and("group.number", "=", (Object)"cartype");
        DynamicObject[] cartypeObj = BusinessDataServiceHelper.load((String)"bos_assistantdata_detail", (String)"id,name", (QFilter[])qFilter.toArray());
        ArrayList list = new ArrayList();
        for (DynamicObject cartype : cartypeObj) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("carTypeName", cartype.getString("name"));
            map.put("carTypeId", cartype.getString("id"));
            list.add(map);
        }
        HashMap hashMap = new HashMap();
        hashMap.put("list", list);
        return ApiResult.success(hashMap);
    }
}

