/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.evaluate;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.api.ApiTransaction;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.status.SaleOrderEvaluateStatus;
import kd.drp.mdr.common.util.CodeRuleUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;

public class ItemEvaluateApi
extends MdrApi {
    private static final String PREFIXURL = "/attachment/download.do?path=/";
    private static final String EVALUATE_LEVEL = "EVL-0001";

    public ApiResult query(Map<String, Object> data) {
        this.checkRecordField(data, "itemId");
        int page = 1;
        int pageSize = 10;
        if (data.get("page") != null && (Integer)data.get("page") > 1) {
            page = (Integer)data.get("page");
        }
        if (data.get("pageSize") != null && (Integer)data.get("pageSize") > 1) {
            pageSize = (Integer)data.get("pageSize");
        }
        Object itemId = data.get("itemId");
        List labelId = (List)data.get("labelList");
        Object evaluateType = data.get("evaluateType");
        if (StringUtils.isEmpty((Object)itemId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u5546\u54c1id", (String)"ItemEvaluateApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((Object)evaluateType)) {
            evaluateType = "1";
        }
        QFilter f = this.getTypeFilter(itemId, evaluateType);
        if (labelId != null && labelId.size() > 0) {
            QFilter labelFilter = this.getLabelFilter(labelId);
            f.and(labelFilter);
        }
        String selectedFileds = "id,item,assistattr,unit,qty,price,amount,owner,ordernumber,isanonymity,isaddevaluate,billno,billstatus,evaluateshoworhide,creator,createtime,evaluatetype,evaluategrade,evaluatecontent,evaluatelabels,entryentity,replytxt,modifier,modifytime,picture1,picture2,picture3,picture4,picture5";
        f.and("evaluatetype", "=", (Object)"0");
        DynamicObjectCollection firstIdList = ORMUtil.query((String)"mdr_item_evaluate", (String)"id,orderentryid", (QFilter[])f.toArray(), null, (int)(pageSize * (page - 1)), (int)pageSize);
        int firstCount = QueryUtil.querycount((String)"mdr_item_evaluate", (QFilter[])f.toArray());
        QFilter filter = this.getIdFilterList(firstIdList);
        DynamicObject[] firstEvaluates = BusinessDataServiceHelper.load((String)"mdr_item_evaluate", (String)selectedFileds, (QFilter[])filter.toArray());
        QFilter qf = new QFilter("item", "=", itemId).and("billstatus", "=", (Object)"C").and("evaluatetype", "=", (Object)"1").and("orderentryid", "in", this.getOrderEntryIdList(firstIdList));
        DynamicObject[] addEvaluates = BusinessDataServiceHelper.load((String)"mdr_item_evaluate", (String)selectedFileds, (QFilter[])qf.toArray());
        ArrayList<HashMap<String, Object>> evaluateList = new ArrayList<HashMap<String, Object>>(firstEvaluates.length);
        for (DynamicObject firstEvaluate : firstEvaluates) {
            HashMap<String, Object> firstMap = new HashMap<String, Object>();
            this.setMapValue(firstEvaluate, firstMap);
            DynamicObjectCollection entryIdCollection = firstEvaluate.getDynamicObjectCollection("entryentity");
            firstMap.put("tagList", this.getTagList(entryIdCollection));
            firstMap.put("labelList", this.getLabelList(firstEvaluate));
            ArrayList<HashMap<String, Object>> addList = new ArrayList<HashMap<String, Object>>();
            for (DynamicObject addEvaluate : addEvaluates) {
                String addEvaluateOrder;
                String firstEvaluateOrder = firstEvaluate.get("ordernumber.id").toString();
                if (!firstEvaluateOrder.equals(addEvaluateOrder = addEvaluate.get("ordernumber.id").toString())) continue;
                HashMap<String, Object> addMap = new HashMap<String, Object>();
                this.setMapValue(addEvaluate, addMap);
                addList.add(addMap);
            }
            firstMap.put("addItemEvaluateList", addList);
            evaluateList.add(firstMap);
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("list", evaluateList);
        result.put("count", Integer.valueOf(firstCount));
        return ApiResult.success(result);
    }

    private List<Object> getTagList(DynamicObjectCollection entryIdCollection) {
        List<String> entryIdList = this.getIdList(entryIdCollection);
        String entryField = "entryentity.evaluatetag.id,entryentity.evaluatetag.name,entryentity.evaluatetag.number,entryentity.score";
        DynamicObjectCollection evaluateentrys = QueryServiceHelper.query((String)"mdr_item_evaluate", (String)entryField, (QFilter[])new QFilter("entryentity.id", "in", entryIdList).toArray());
        ArrayList<Object> tagList = new ArrayList<Object>();
        for (DynamicObject evaluateentry : evaluateentrys) {
            HashMap<String, Object> tagMap = new HashMap<String, Object>();
            tagMap.put("id", evaluateentry.get("entryentity.evaluatetag.id"));
            tagMap.put("name", evaluateentry.get("entryentity.evaluatetag.name"));
            tagMap.put("number", evaluateentry.get("entryentity.evaluatetag.number"));
            tagMap.put("score", evaluateentry.get("entryentity.score"));
            tagList.add(tagMap);
        }
        return tagList;
    }

    private QFilter getIdFilterList(DynamicObjectCollection idList) {
        return new QFilter("id", "in", this.getIdList(idList));
    }

    private List<String> getIdList(DynamicObjectCollection idList) {
        ArrayList<String> list = new ArrayList<String>();
        for (DynamicObject dyjId : idList) {
            String id = dyjId.get("id").toString();
            list.add(id);
        }
        return list;
    }

    private List<String> getOrderEntryIdList(DynamicObjectCollection idList) {
        ArrayList<String> list = new ArrayList<String>();
        for (DynamicObject dyjId : idList) {
            String id = dyjId.get("orderentryid").toString();
            list.add(id);
        }
        return list;
    }

    private QFilter getLabelFilter(List<Object> LabelList) {
        return new QFilter("evaluatelabels.fbasedataid", "in", LabelList);
    }

    private QFilter getTypeFilter(Object itemId, Object evaluateType) {
        DynamicObject evaluateLevel;
        QFilter f = new QFilter("billstatus", "=", (Object)"C");
        f.and("item", "=", itemId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isEmpty((Object)evaluateType)) {
            evaluateType = "1";
        }
        if ((evaluateLevel = QueryServiceHelper.queryOne((String)"mdr_evaluate_grade", (String)"id", (QFilter[])new QFilter("number", "=", (Object)EVALUATE_LEVEL).toArray())) == null) {
            map.put("A", "4-6");
            map.put("B", "2-4");
            map.put("C", "0-2");
        } else {
            Object evaluateLevelId = evaluateLevel.get("id");
            evaluateLevel = BusinessDataServiceHelper.loadSingle((Object)evaluateLevelId, (String)"mdr_evaluate_grade");
            DynamicObjectCollection evaluateLevelCollection = evaluateLevel.getDynamicObjectCollection("entryentity");
            for (DynamicObject evaluateLevelEntry : evaluateLevelCollection) {
                String evaluateRank = evaluateLevelEntry.getString("evaluaterank");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(evaluateLevelEntry.get("mingrade"));
                stringBuilder.append('-');
                stringBuilder.append(evaluateLevelEntry.get("maxgrade"));
                map.put(evaluateRank, stringBuilder.toString());
            }
        }
        switch (evaluateType.toString()) {
            case "1": {
                break;
            }
            case "2": {
                f.and("picture1", "!=", (Object)"");
                break;
            }
            case "3": {
                f.and("isadditemevaluate", "=", (Object)"1");
                break;
            }
            case "4": {
                this.getGradeFilter(f, map, "A");
                break;
            }
            case "5": {
                this.getGradeFilter(f, map, "B");
                break;
            }
            case "6": {
                this.getGradeFilter(f, map, "C");
                break;
            }
        }
        return f;
    }

    private void getGradeFilter(QFilter f, HashMap<String, Object> map, String Tag) {
        String grade = (String)map.get(Tag);
        Object[] grades = grade.split("-");
        Arrays.sort(grades);
        f.and("evaluategrade", ">=", grades[0]).and("evaluategrade", "<", grades[1]);
    }

    private List<Map<String, Object>> getLabelList(DynamicObject firstEvaluate) {
        Map loadFromCacheMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_item_evaluate", (String)"id,evaluatelabels", (QFilter[])new QFilter("id", "=", firstEvaluate.get("id")).toArray());
        ArrayList<Map<String, Object>> labelList = new ArrayList<Map<String, Object>>();
        for (DynamicObject evaluate : loadFromCacheMap.values()) {
            DynamicObjectCollection labelCollection = evaluate.getDynamicObjectCollection("evaluatelabels");
            for (DynamicObject label : labelCollection) {
                if (label.getDynamicObject("fbasedataid") == null) continue;
                HashMap<String, Object> labelMap = new HashMap<String, Object>();
                Map nameMap = (Map)label.getDynamicObject("fbasedataid").get("name");
                Object id = label.getDynamicObject("fbasedataid").get("id");
                labelMap.put("name", nameMap.get("zh_CN"));
                labelMap.put("id", id);
                labelList.add(labelMap);
            }
        }
        return labelList;
    }

    private void setMapValue(DynamicObject evaluate, Map<String, Object> map) {
        map.put("billno", evaluate.getString("billno"));
        map.put("evaluateContent", evaluate.getString("evaluatecontent"));
        map.put("evaluateGrade", evaluate.getBigDecimal("evaluategrade").setScale(2, 4));
        map.put("itemName", evaluate.get("item.name.zh_CN"));
        map.put("assistattrId", evaluate.get("assistattr.id"));
        map.put("assistattrName", evaluate.get("assistattr.name"));
        map.put("unitId", evaluate.get("unit.id"));
        map.put("unitName", evaluate.get("unit.name.zh_CN"));
        map.put("qty", evaluate.get("qty"));
        map.put("userId", evaluate.get("creator.id"));
        map.put("userName", evaluate.getString("creator.name.zh_CN"));
        map.put("isAnonymity", evaluate.getString("isanonymity"));
        map.put("usrImg", evaluate.getString("creator.picturefield"));
        map.put("createTime", evaluate.getDate("createtime"));
        map.put("replyTxt", evaluate.getString("replytxt"));
        map.put("orderNumber", evaluate.getString("ordernumber.id"));
        map.put("picList", this.getPic(evaluate));
        map.put("videoList", this.getUrl(evaluate));
    }

    private List<Object> getUrl(DynamicObject evaluate) {
        List attachments = AttachmentServiceHelper.getAttachments((String)"mdr_item_evaluate", (Object)evaluate.get("id"), (String)"attachmentpanel");
        if (attachments == null || attachments.size() <= 0) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> URLList = new ArrayList<Object>(attachments.size());
        for (Map attachment : attachments) {
            String firstItemEvaluateURL = (String)attachment.get("url");
            int indexOf = firstItemEvaluateURL.lastIndexOf(PREFIXURL) + PREFIXURL.length();
            String substring = firstItemEvaluateURL.substring(indexOf, firstItemEvaluateURL.indexOf(38));
            URLList.add(URLDecoder.decode(substring));
        }
        return URLList;
    }

    private List<Object> getPic(DynamicObject evaluate) {
        ArrayList<Object> picList = new ArrayList<Object>();
        int num = 5;
        String pic = "";
        for (int i = 1; i <= num; ++i) {
            pic = "picture" + String.valueOf(i);
            if (!StringUtils.isNotEmpty((String)evaluate.getString(pic))) continue;
            picList.add(evaluate.getString(pic));
        }
        return picList;
    }

    @ApiTransaction(propagation=Propagation.REQUIRED)
    public ApiResult save(Map<String, Object> data) throws Exception {
        this.checkRecordField(data, "orderId", "itemId");
        List attachments = (List)data.get("attachments");
        String orderId = (String)data.get("orderId");
        String entryId = (String)data.get("orderEntryId");
        Object itemId = data.get("itemId");
        Object isAnonymity = data.get("isAnonymity");
        Object assistattrId = data.get("assistattrId");
        Object evaluategrade = data.get("evaluateGrade");
        String evaluatecontent = (String)data.get("evaluateContent");
        String evaluatetype = (String)data.get("evaluateType");
        List pictures = (List)data.get("pictures");
        List evaluateLabelIdList = (List)data.get("evaluateLabel");
        List evalutateEntity = (List)data.get("entryEntity");
        DynamicObject order = null;
        DynamicObject item = null;
        DynamicObject itemEvaluateObj = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_evaluate");
        itemEvaluateObj.set("billno", (Object)CodeRuleUtil.getCodeRule((String)"mdr_item_evaluate"));
        if (!QueryServiceHelper.exists((String)"bbc_saleorder", (Object)orderId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355id\u65e0\u6548", (String)"ItemEvaluateApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        order = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"bbc_saleorder");
        itemEvaluateObj.set("ordernumber", (Object)order);
        if (!QueryServiceHelper.exists((String)"mdr_item_info", (Object)itemId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1id\u65e0\u6548", (String)"ItemEvaluateApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        item = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"mdr_item_info", (String)"itemclass,name,shorttitle");
        itemEvaluateObj.set("item", (Object)item);
        if (!ItemAttrUtil.hasAssistAttr((Object)itemId)) {
            assistattrId = null;
        } else {
            if (assistattrId != null && !ItemAttrUtil.hasAssistAttr((Object)itemId, (Object)assistattrId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u6ca1\u6709\u6b64\u8f85\u52a9\u5c5e\u6027", (String)"ItemEvaluateApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            DynamicObject assistattr = BusinessDataServiceHelper.loadSingle((Object)assistattrId, (String)"mdr_item_attrvalue", (String)"id,name,number");
            itemEvaluateObj.set("assistattr", (Object)assistattr);
        }
        Object orderEvaluateStatus = order.get("evaluatestatus");
        if (StringUtils.isEmpty((Object)orderEvaluateStatus) || orderEvaluateStatus.toString().equals(SaleOrderEvaluateStatus.EMPT.getFlagStr())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u9700\u8981\u4e3a\u5f85\u8bc4\u8bba\u6216\u8005\u5df2\u8bc4\u4ef7\u72b6\u6001\u624d\u53ef\u4ee5\u65b0\u589e\u8bc4\u4ef7\uff01", (String)"ItemEvaluateApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)evaluatetype)) {
            itemEvaluateObj.set("evaluatetype", (Object)evaluatetype);
            if (evaluatetype.equals("0")) {
                evaluatetype = this.checkEvaluate(orderId, itemId, itemEvaluateObj);
            }
        } else {
            evaluatetype = this.checkEvaluate(orderId, itemId, itemEvaluateObj);
        }
        if (evaluatetype.equals("1")) {
            this.setIsAddEVa(order, item);
        }
        DynamicObjectCollection itemEntry = order.getDynamicObjectCollection("itementry");
        for (Object itemInfo : itemEntry) {
            String itemInfoId = itemInfo.getDynamicObject("item").getString("id");
            if (!itemInfoId.equals(item.getString("id"))) continue;
            itemEvaluateObj.set("qty", (Object)itemInfo.getBigDecimal("qty"));
            itemEvaluateObj.set("unit", (Object)itemInfo.getDynamicObject("unit"));
            BigDecimal object = itemInfo.getBigDecimal("orderamount");
            itemEvaluateObj.set("amount", (Object)object);
        }
        if (StringUtils.isEmpty((Object)isAnonymity)) {
            isAnonymity = Boolean.FALSE;
        }
        itemEvaluateObj.set("orderentryid", (Object)entryId);
        itemEvaluateObj.set("isanonymity", isAnonymity);
        itemEvaluateObj.set("evaluateshoworhide", (Object)"1");
        itemEvaluateObj.set("evaluatecontent", (Object)evaluatecontent);
        itemEvaluateObj.set("billstatus", (Object)"B");
        itemEvaluateObj.set("creator", (Object)UserUtil.getUserInfo());
        itemEvaluateObj.set("createtime", (Object)new Date());
        if (StringUtils.isNotEmpty((Object)evaluategrade)) {
            BigDecimal evaluateGrade = new BigDecimal(evaluategrade.toString());
            if (evaluateGrade.compareTo(BigDecimal.ZERO) <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u8bc4\u4ef7\u8bc4\u5206\u4e0d\u5f97\u4e3a0\u6216\u8d1f\u6570", (String)"ItemEvaluateApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            itemEvaluateObj.set("evaluategrade", (Object)evaluateGrade);
        }
        if (evalutateEntity != null) {
            DynamicObjectCollection entrys = (DynamicObjectCollection)itemEvaluateObj.get("entryentity");
            for (Map evalutate : evalutateEntity) {
                if (!StringUtils.isNotEmpty(evalutate.get("evaluateTagId"))) continue;
                DynamicObject evaluateTag = BusinessDataServiceHelper.loadSingle(evalutate.get("evaluateTagId"), (String)"mdr_evaluate_content");
                DynamicObject entryr = entrys.addNew();
                entryr.set("evaluatetag", (Object)evaluateTag);
                entryr.set("score", evalutate.get("evaluateTagGrade"));
            }
        }
        if (pictures != null && pictures.size() > 0) {
            for (int i = 0; i < pictures.size(); ++i) {
                itemEvaluateObj.set("picture" + String.valueOf(i + 1), pictures.get(i));
            }
        }
        DynamicObjectCollection labels = QueryServiceHelper.query((String)"mdr_evaluate_content", (String)"id,name,number", (QFilter[])new QFilter("id", "in", (Object)evaluateLabelIdList).toArray());
        DynamicObjectCollection evaluatelabels = itemEvaluateObj.getDynamicObjectCollection("evaluatelabels");
        for (DynamicObject label : labels) {
            DynamicObject evaluatelabel = evaluatelabels.addNew();
            evaluatelabel.set("fbasedataid", (Object)label);
            evaluatelabel.set("fbasedataid_id", label.get("id"));
        }
        OperationUtil.invokeOperation((DynamicObject)itemEvaluateObj, (String)"submit");
        if (attachments != null && attachments.size() > 0) {
            this.addAttachment(itemEvaluateObj.get("id"), attachments);
        }
        return ApiResult.success(null);
    }

    private void setIsAddEVa(DynamicObject order, DynamicObject item) {
        QFilter qf = new QFilter("ordernumber.id", "=", order.get("id"));
        qf.and("item", "=", item.get("id"));
        qf.and("evaluatetype", "=", (Object)"0");
        DynamicObject itemEvaluateInfoId = QueryServiceHelper.queryOne((String)"mdr_item_evaluate", (String)"id", (QFilter[])qf.toArray());
        if (itemEvaluateInfoId == null || !QueryServiceHelper.exists((String)"mdr_item_evaluate", (Object)itemEvaluateInfoId.get("id"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u521d\u8bc4", (String)"ItemEvaluateApi_6", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject itemEvaluateInfo = BusinessDataServiceHelper.loadSingle((Object)itemEvaluateInfoId.get("id"), (String)"mdr_item_evaluate");
        itemEvaluateInfo.set("isadditemevaluate", (Object)"1");
        DynamicObject[] itemEvaluateInfoArray = new DynamicObject[]{itemEvaluateInfo};
        SaveServiceHelper.save((DynamicObject[])itemEvaluateInfoArray);
    }

    private String checkEvaluate(Object orderId, Object itemId, DynamicObject itemEvaluateObj) {
        String evaluatetype;
        QFilter evaluateFilter = new QFilter("ordernumber", "=", orderId).and("item", "=", itemId);
        int querycount = QueryUtil.querycount((String)"mdr_item_evaluate", (QFilter[])evaluateFilter.toArray());
        if (querycount > 0) {
            evaluatetype = "1";
            itemEvaluateObj.set("evaluatetype", (Object)evaluatetype);
        } else {
            evaluatetype = "0";
            itemEvaluateObj.set("evaluatetype", (Object)"0");
        }
        return evaluatetype;
    }

    private void addAttachment(Object id, List<Map<String, Object>> attachmentList) throws Exception {
        try (TXHandle h = TX.requiresNew();){
            try {
                ArrayList attachments = new ArrayList(attachmentList.size());
                for (Map<String, Object> attachmentMap : attachmentList) {
                    HashMap<String, Object> uploadMap = new HashMap<String, Object>();
                    String format = new SimpleDateFormat("yyyyMMSSHHMMSS").format(new Date());
                    format = "wfx-upload-" + format;
                    uploadMap.put("uid", format);
                    uploadMap.put("size", attachmentMap.get("size"));
                    uploadMap.put("name", attachmentMap.get("name"));
                    uploadMap.put("url", attachmentMap.get("url"));
                    attachments.add(uploadMap);
                }
                AttachmentServiceHelper.upload((String)"mdr_item_evaluate", (Object)id, (String)"attachmentpanel", attachments);
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    public ApiResult delete(Map<String, Object> data) {
        this.checkRecordField(data, "orderNumber");
        String evaluateOrderNumber = (String)data.get("orderNumber");
        DeleteServiceHelper.delete((String)"mdr_item_evaluate", (QFilter[])new QFilter("billno", "=", (Object)evaluateOrderNumber).toArray());
        return ApiResult.success((Object)ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"ItemEvaluateApi_7", (String)"drp-mdr-webapi", (Object[])new Object[0]));
    }

    public ApiResult update(Map<String, Object> data) {
        return null;
    }

    public ApiResult getCmpEvaluate(Map<String, Object> data) {
        this.checkRecordField(data, "itemId");
        QFilter f = new QFilter("billstatus", "=", (Object)"C");
        String itemId = (String)data.get("itemId");
        f = f.and("item", "=", (Object)itemId);
        String selectedFileds = "billno,evaluategrade,item.name,id";
        BigDecimal score = new BigDecimal("0");
        DynamicObject[] itemInfoList = BusinessDataServiceHelper.load((String)"mdr_item_evaluate", (String)selectedFileds, (QFilter[])f.toArray());
        ArrayList list = new ArrayList();
        if (itemInfoList != null && itemInfoList.length > 0) {
            for (DynamicObject subItem : itemInfoList) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)subItem.get("id"), (String)"mdr_item_evaluate", (String)"evaluatelabels");
                DynamicObjectCollection colList = dynamicObject.getDynamicObjectCollection("evaluatelabels");
                if (colList == null || colList.size() == 0) continue;
                for (DynamicObject col : colList) {
                    HashMap<String, Object> map = new HashMap<String, Object>(2);
                    map.put("name", col.get("fbasedataid.name.zh_CN"));
                    map.put("id", col.get("fbasedataid.id"));
                    list.add(map);
                }
                score = new BigDecimal(subItem.getString("evaluategrade")).add(score);
            }
        }
        BigDecimal avg = null;
        avg = itemInfoList == null || itemInfoList.length == 0 ? new BigDecimal(0) : score.divide(BigDecimal.valueOf(itemInfoList.length), 1, 4);
        Map<Object, Long> labelMap = list.stream().collect(Collectors.groupingBy(p -> p.get("id") + "," + p.get("name"), Collectors.counting()));
        ArrayList labelList = new ArrayList(labelMap.size());
        for (Map.Entry entry : labelMap.entrySet()) {
            HashMap<String, String> map = new HashMap<String, String>();
            String[] arr = entry.getKey().toString().split(",");
            map.put("id", arr[0]);
            map.put("name", arr[1]);
            map.put("count", (String)entry.getValue());
            labelList.add(map);
        }
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        resultMap.put("labelList", labelList);
        resultMap.put("avg", avg);
        return ApiResult.success(resultMap);
    }
}

