/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.evaluate;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.api.ApiTransaction;
import kd.drp.mdr.api.evaluate.ItemEvaluateApi;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.status.SaleOrderEvaluateStatus;
import kd.drp.mdr.common.util.CodeRuleUtil;
import kd.drp.mdr.common.util.OperationUtil;
import org.apache.commons.lang.exception.ExceptionUtils;

public class OrderEvaluateApi
extends ItemEvaluateApi {
    @Override
    @ApiTransaction(propagation=Propagation.REQUIRED)
    public ApiResult save(Map<String, Object> data) throws Exception {
        this.checkRecordField(data, "orderId");
        String orderId = (String)data.get("orderId");
        String evaluatecontent = (String)data.get("evaluateContent");
        List orderEvaluateTagList = (List)data.get("entryEntity");
        Map itemEvaluateMap = (Map)data.get("itemEvaluate");
        List pictures = (List)data.get("pictures");
        List attachments = (List)data.get("attachments");
        DynamicObject order = null;
        DynamicObject orderEvaluateObj = BusinessDataServiceHelper.newDynamicObject((String)"mdr_bill_evaluate_manage");
        if (!QueryServiceHelper.exists((String)"dpa_purorder", (Object)orderId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355id\u65e0\u6548", (String)"OrderEvaluateApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        order = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"dpa_purorder");
        orderEvaluateObj.set("billno", (Object)CodeRuleUtil.getCodeRule((String)"mdr_bill_evaluate_manage"));
        if (orderEvaluateTagList != null && orderEvaluateTagList.size() > 0) {
            DynamicObjectCollection entrys = (DynamicObjectCollection)orderEvaluateObj.get("entryentity");
            for (Map orderEvaluateTag : orderEvaluateTagList) {
                if (!StringUtils.isNotEmpty(orderEvaluateTag.get("evaluateTagId")) || !QueryServiceHelper.exists((String)"mdr_evaluate_content", orderEvaluateTag.get("evaluateTagId"))) continue;
                DynamicObject evaluateTag = BusinessDataServiceHelper.loadSingle(orderEvaluateTag.get("evaluateTagId"), (String)"mdr_evaluate_content");
                DynamicObject entryItem = entrys.addNew();
                Object object2 = orderEvaluateTag.get("evaluateTagGrade");
                entryItem.set("evaluategrade", object2);
                entryItem.set("evaluatenumber", (Object)evaluateTag);
            }
        }
        orderEvaluateObj.set("billnumber", (Object)order);
        orderEvaluateObj.set("goodQty", order.get("totalqty"));
        orderEvaluateObj.set("amount", order.get("totalitemamount"));
        orderEvaluateObj.set("billStatus", (Object)"A");
        orderEvaluateObj.set("createTime", (Object)new Date());
        orderEvaluateObj.set("evaluateType", (Object)"0");
        orderEvaluateObj.set("evaluateShoworHide", (Object)"1");
        orderEvaluateObj.set("evaluateContent", (Object)evaluatecontent);
        if (pictures != null && pictures.size() > 0) {
            for (int i = 0; i < pictures.size(); ++i) {
                orderEvaluateObj.set("picture" + String.valueOf(i + 1), pictures.get(i));
            }
        }
        OperationUtil.invokeOperation((DynamicObject)orderEvaluateObj, (String)"submit");
        if (attachments != null && attachments.size() > 0) {
            this.addingAttachment(orderEvaluateObj.get("id"), attachments);
        }
        itemEvaluateMap.put("orderId", orderId);
        try {
            super.save(itemEvaluateMap);
        }
        catch (Exception e) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u5546\u54c1\u8bc4\u4ef7\u65b0\u589e\u5931\u8d25%s", (String)"OrderEvaluateApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]), ExceptionUtils.getStackTrace((Throwable)e)));
        }
        DynamicObject od = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"bbc_saleorder");
        od.set("evaluatestatus", (Object)SaleOrderEvaluateStatus.EVALUATED.getFlagStr());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{od});
        return ApiResult.success(null);
    }

    @Override
    public ApiResult query(Map<String, Object> data) {
        this.checkRecordField(data, "orderId");
        String orderNum = (String)data.get("orderId");
        QFilter qFilter = new QFilter("evaluateshoworhide", "=", (Object)"1");
        qFilter.and("billnumber.id", "=", (Object)orderNum);
        qFilter.and("billstatus", "=", (Object)"C");
        DynamicObject billEvaId = QueryServiceHelper.queryOne((String)"mdr_bill_evaluate_manage", (String)"id", (QFilter[])qFilter.toArray());
        if (billEvaId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u4e0d\u5b58\u5728", (String)"OrderEvaluateApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject billEvaliate = BusinessDataServiceHelper.loadSingle((Object)billEvaId.getLong("id"), (String)"mdr_bill_evaluate_manage");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("creator", billEvaliate.getString("creator.name"));
        map.put("createTime", billEvaliate.getString("createtime"));
        map.put("billNumber", billEvaliate.getString("billnumber.number"));
        map.put("goodQty", billEvaliate.getString("goodqty"));
        map.put("amount", billEvaliate.getString("amount"));
        map.put("chanelName", billEvaliate.getString("billnumber.owner.name"));
        map.put("evalutateGrade", billEvaliate.getString("evalutategrade"));
        map.put("evaluateContent", billEvaliate.getString("evaluatecontent"));
        ArrayList list = new ArrayList();
        DynamicObjectCollection entryentityCollection = billEvaliate.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryentity : entryentityCollection) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("evaluateTagNumber", entryentity.getString("evaluatenumber.number"));
            hashMap.put("evaluateTagName", entryentity.getString("evaluatenumber.name"));
            hashMap.put("evaluateTagGrade", entryentity.getString("evaluategrade"));
            list.add(hashMap);
        }
        map.put("entryList", list);
        ArrayList attachmentlist = new ArrayList();
        List attachments = AttachmentServiceHelper.getAttachments((String)"mdr_bill_evaluate_manage", (Object)billEvaliate.getLong("id"), (String)"attachmentpanel");
        for (Map map2 : attachments) {
            HashMap hashMap = new HashMap();
            hashMap.put("url", map2.get("url"));
            attachmentlist.add(hashMap);
        }
        map.put("attachmentList", attachmentlist);
        return ApiResult.success(map);
    }

    public ApiResult queryShopInfoNum(Map<String, Object> data) {
        this.checkRecordField(data, "ownerId");
        String ownerId = (String)data.get("ownerId");
        if (StringUtils.isEmpty((String)ownerId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a", (String)"OrderEvaluateApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        QFilter evaQf = new QFilter("billnumber.owner.id", "=", (Object)ownerId);
        evaQf.and("billstatus", "=", (Object)"C");
        DynamicObject[] orderEvas = BusinessDataServiceHelper.load((String)"mdr_bill_evaluate_manage", (String)"evalutategrade,entryentity,entryentity.evaluatenumber,entryentity.evaluategrade", (QFilter[])evaQf.toArray());
        HashMap<String, List<BigDecimal>> map = new HashMap<String, List<BigDecimal>>();
        for (DynamicObject orderEva : orderEvas) {
            String string = "evalutateGrade";
            BigDecimal evalutategrade = orderEva.getBigDecimal("evalutategrade");
            this.calculateScores(map, string, evalutategrade);
            DynamicObjectCollection entryentityCollection = orderEva.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryentity : entryentityCollection) {
                String name = entryentity.getString("evaluatenumber.name");
                BigDecimal entryGrade = entryentity.getBigDecimal("evaluategrade");
                this.calculateScores(map, name, entryGrade);
            }
        }
        TreeMap<String, BigDecimal> evaInfo = new TreeMap<String, BigDecimal>();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            List list = (List)entry.getValue();
            if ("evalutateGrade".equals(key)) {
                key = ResManager.loadKDString((String)"\u7efc\u5408\u8bc4\u5206", (String)"OrderEvaluateApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]);
            }
            BigDecimal divide = ((BigDecimal)list.get(0)).divide((BigDecimal)list.get(1), 1, 4);
            evaInfo.put(key, divide);
        }
        ArrayList arrayList = new ArrayList(evaInfo.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<String, BigDecimal>>(){

            @Override
            public int compare(Map.Entry<String, BigDecimal> o1, Map.Entry<String, BigDecimal> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        ArrayList list = new ArrayList();
        for (Map.Entry entry : arrayList) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", entry.getKey());
            hashMap.put("score", entry.getValue());
            list.add(hashMap);
            if (list.size() < 3) continue;
            break;
        }
        return ApiResult.success(list);
    }

    private void calculateScores(Map<String, List<BigDecimal>> map, String evaScoreName, BigDecimal evalutategrade) {
        List<BigDecimal> scoreList = map.get(evaScoreName);
        if (scoreList != null) {
            scoreList.set(0, scoreList.get(0).add(evalutategrade));
            scoreList.set(1, scoreList.get(1).add(new BigDecimal(1)));
        } else {
            ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
            list.add(evalutategrade);
            list.add(new BigDecimal(1));
            map.put(evaScoreName, list);
        }
    }

    @Override
    public ApiResult delete(Map<String, Object> data) {
        return null;
    }

    private void addingAttachment(Object id, List<Map<String, Object>> attachmentList) throws Exception {
        try (TXHandle h = TX.beginNew();){
            try {
                ArrayList attachments = new ArrayList(attachmentList.size());
                for (Map<String, Object> attachmentMap : attachmentList) {
                    HashMap<String, Object> uploadMap = new HashMap<String, Object>();
                    String format = new SimpleDateFormat("yyyyMMSSHHMMSS").format(new Date());
                    format = "wfx-upload-" + format;
                    uploadMap.put("uid", format);
                    uploadMap.put("size", attachmentMap.get("size"));
                    uploadMap.put("name", attachmentMap.get("name"));
                    uploadMap.put("url", attachmentMap.get("url"));
                    attachments.add(uploadMap);
                }
                AttachmentServiceHelper.upload((String)"mdr_bill_evaluate_manage", (Object)id, (String)"attachmentpanel", attachments);
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }
}

