/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.item;

import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.api.ApiTransaction;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.DateUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;

public class ItemInfoApi
extends MdrApi {
    private static final String PREFIXURL = "/attachment/download.do?path=/";
    protected static Log logger = LogFactory.getLog(ItemInfoApi.class);
    private static final Long DEFAULT_ITEM_TYPE_ID = 870945645681225728L;
    private static final String[] FIELDS_SYNCES = new String[]{"number", "modelNum", "material.BaseUnit.Id", "material.BaseUnit.Number", "material.BaseUnit.Name", "id", "status", "creator", "modifier", "createTime", "modifyTime", "updatetime", "easNum", "minPackNum", "searchKey", "serialNumber", "isOnSell", "newSell", "onlyNow", "stopProduce", "nonSingle", "thumbnail", "itemClass.Id", "itemClass.Number", "itemClass.Name", "itemClass.LongNumber", "owner.Id", "owner.Number", "owner.Name", "picture1", "picture2", "picture3", "picture4", "picture5", "sellTime", "remark", "recommend", "isFromEas", "referencePrice", "description", "saleQty", "assistUnit.Id", "assistUnit.Number", "assistUnit.Name", "isAssistOrder", "assistSaleQty", "hasattr", "shortTitle", "name"};
    private static final String[] FIELDS_QUERYDETAILS = new String[]{"number", "modelNum", "material.BaseUnit.Id", "material.BaseUnit.Number", "material.BaseUnit.Name", "id", "status", "creator", "modifier", "createTime", "modifyTime", "easNum", "minPackNum", "searchKey", "serialNumber", "isOnSell", "newSell", "onlyNow", "stopProduce", "nonSingle", "thumbnail", "itemClass.Id", "itemClass.Number", "itemClass.Name", "itemClass.LongNumber", "owner.Id", "owner.Number", "owner.Name", "picture1", "picture2", "picture3", "picture4", "picture5", "sellTime", "remark", "recommend", "isFromEas", "referencePrice", "description", "description_Tag", "saleQty", "assistUnit.Id", "assistUnit.Number", "assistUnit.Name", "isAssistOrder", "assistSaleQty", "name"};

    public ApiResult syncEs(Map<String, Object> data) {
        QFilter f = new QFilter("1", "=", (Object)"1");
        String syncTime = (String)data.get("syncTime");
        if (StringUtils.isNotEmpty((String)syncTime)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeStr = sdf.format(new Date(Long.parseLong(syncTime)));
            QFilter t = new QFilter("createtime", ">=", (Object)timeStr);
            t.or("modifytime", ">=", (Object)timeStr);
            t.or("updatetime", ">=", (Object)timeStr);
            f = f.and(t);
        }
        Date now = new Date();
        f.and("createtime", "<=", (Object)now);
        f.and("modifytime", "<=", (Object)now);
        f.and("updatetime", "<=", (Object)now);
        String orderByStr = "modifytime,createTime";
        List list = QueryUtil.queryCamelColsList((String)"mdr_item_info", (String[])FIELDS_SYNCES, (QFilter[])f.toArray(), (String)orderByStr);
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            ((Map)list.get(i)).put("modifyTime", this.getTimestamp(((Map)list.get(i)).get("modifyTime")));
            ((Map)list.get(i)).put("createTime", this.getTimestamp(((Map)list.get(i)).get("createTime")));
            ((Map)list.get(i)).put("updatetime", this.getTimestamp(((Map)list.get(i)).get("updatetime")));
            ((Map)list.get(i)).put("sellTime", this.getTimestamp(((Map)list.get(i)).get("sellTime")));
            ((Map)list.get(i)).put("number", ((Map)list.get(i)).get("number"));
            ((Map)list.get(i)).put("name", ((Map)list.get(i)).get("name"));
            ((Map)list.get(i)).put("title", ((Map)list.get(i)).get("name"));
            ((Map)list.get(i)).put("modelNum", ((Map)list.get(i)).get("modelNum"));
            ((Map)list.get(i)).put("baseUnitId", ((Map)list.get(i)).get("materialBaseUnitId"));
            ((Map)list.get(i)).put("baseUnitNumber", ((Map)list.get(i)).get("materialBaseUnitNumber"));
            ((Map)list.get(i)).put("baseUnitName", ((Map)list.get(i)).get("materialBaseUnitName"));
            ((Map)list.get(i)).put("itemClassList", ((Map)list.get(i)).get("itemClassLongNumber").toString().split("\\."));
            QFilter qF = new QFilter("materialid", "=", ItemUtil.getMaterialId(((Map)list.get(i)).get("id"))).and("measureunitid", "=", (Object)(((Map)list.get(i)).get("assistUnitId") + ""));
            if (((Boolean)((Map)list.get(i)).get("isAssistOrder")).booleanValue() && QueryServiceHelper.exists((String)"bd_multimeasureunit", (QFilter[])qF.toArray())) {
                ((Map)list.get(i)).put("conversionRate", ItemUtil.queryConversionFactor(((Map)list.get(i)).get("id"), ((Map)list.get(i)).get("assistUnitId")));
            }
            ArrayList<String> assistattrIds = new ArrayList<String>();
            if (ItemAttrUtil.hasAssistAttr(((Map)list.get(i)).get("id"))) {
                List<Map<String, Object>> setAssistAttr = this.setAssistAttr(((Map)list.get(i)).get("id"));
                for (Map<String, Object> assistAttrs : setAssistAttr) {
                    assistattrIds.add(assistAttrs.get("id") + "");
                }
            }
            ((Map)list.get(i)).put("assistAttrIds", assistattrIds);
            ArrayList pictureList = new ArrayList();
            for (int k = 1; k < 6; ++k) {
                String picture = (String)((Map)list.get(i)).get("picture" + String.valueOf(k));
                if (StringUtils.isNotEmpty((String)picture)) {
                    pictureList.add(picture);
                }
                ((Map)list.get(i)).remove("picture" + String.valueOf(k));
            }
            ((Map)list.get(i)).put("pictureList", pictureList);
            idList.add(String.valueOf(((Map)list.get(i)).get("id")));
            ((Map)list.get(i)).remove("materialBaseUnitId");
            ((Map)list.get(i)).remove("materialBaseUnitNumber");
            ((Map)list.get(i)).remove("materialBaseUnitName");
            ((Map)list.get(i)).remove("itemClassLongNumber");
        }
        Map loadFromCacheMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_item_info", (String)"id,itemBrands", (QFilter[])new QFilter("id", "in", idList).toArray());
        ArrayList list2 = new ArrayList(loadFromCacheMap.size());
        ArrayList itembrandlist = new ArrayList();
        for (DynamicObject item : loadFromCacheMap.values()) {
            DynamicObjectCollection itembrandRs = item.getDynamicObjectCollection("itemBrands");
            for (DynamicObject itembrandR : itembrandRs) {
                if (itembrandR.getDynamicObject("fbasedataid") == null) continue;
                Map nameMap = (Map)itembrandR.getDynamicObject("fbasedataid").get("name");
                itembrandlist.add(nameMap.get("zh_CN"));
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("itembrandlist", itembrandlist);
            hashMap.put("id", item.get("id"));
            list2.add(hashMap);
        }
        for (int m = 0; m < list.size(); ++m) {
            Object itemID = ((Map)list.get(m)).get("id");
            for (Map map : list2) {
                Object itembrandID = map.get("id");
                if (!itembrandID.equals(itemID)) continue;
                ((Map)list.get(m)).put("itemBrandList", map.get("itembrandlist"));
            }
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("list", list);
        returnData.put("count", list.size());
        return ApiResult.success(returnData);
    }

    private Long getTimestamp(Object datatime) {
        if (datatime == null) {
            return 0L;
        }
        return DateUtil.getDateTimeFormat((String)datatime.toString()).getTime();
    }

    public ApiResult queryDetails(Map<String, Object> data) {
        QFilter f = new QFilter("1", "=", (Object)"1");
        String id = (String)data.get("id");
        String number = (String)data.get("number");
        if (StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)number)) {
            List itemInfo;
            if (StringUtils.isNotEmpty((String)id)) {
                f = f.and(new QFilter("id", "=", (Object)id));
            }
            if (StringUtils.isNotEmpty((String)number)) {
                f = f.and(new QFilter("number", "=", (Object)number));
            }
            if ((itemInfo = QueryUtil.queryCamelColsList((String)"mdr_item_info", (String[])FIELDS_QUERYDETAILS, (QFilter[])f.toArray())).size() > 0) {
                HashMap<String, Map> returnData = new HashMap<String, Map>();
                Map itemDetails = (Map)itemInfo.get(0);
                String[] itemClassList = itemDetails.get("itemClassLongNumber").toString().split("\\.");
                for (int i = 0; i < itemClassList.length; ++i) {
                    String itemClassId = itemClassList[i];
                    QFilter itemClassFilter = new QFilter("number", "=", (Object)itemClassId);
                    List itemClassName = QueryUtil.querySingleCol((String)"mdr_item_class", (String)"name", (QFilter[])itemClassFilter.toArray(), (String)"name");
                    if (itemClassName.size() <= 0) {
                        itemClassName.add(" ");
                    }
                    itemDetails.put("itemClassName" + (i + 1), itemClassName.get(0));
                }
                itemDetails.put("number", itemDetails.get("number"));
                itemDetails.put("name", itemDetails.get("name"));
                itemDetails.put("title", itemDetails.get("name"));
                itemDetails.put("itemTitle", itemDetails.get("name"));
                itemDetails.put("modelNum", itemDetails.get("modelNum"));
                itemDetails.put("baseUnitId", itemDetails.get("materialBaseUnitId"));
                itemDetails.put("baseUnitNumber", itemDetails.get("materialBaseUnitNumber"));
                itemDetails.put("baseUnitName", itemDetails.get("materialBaseUnitName"));
                itemDetails.put("itemClassList", itemClassList);
                itemDetails.remove("materialBaseUnitId");
                itemDetails.remove("materialBaseUnitNumber");
                itemDetails.remove("materialBaseUnitName");
                itemDetails.remove("itemClassLongNumber");
                QFilter qFilter = new QFilter("item.id", "=", (Object)id);
                qFilter.and("evaluatetype", "=", (Object)"0").and("billstatus", "=", (Object)"C");
                int evaluateNum = QueryUtil.querycount((String)"mdr_item_evaluate", (QFilter[])qFilter.toArray());
                itemDetails.put("evaluateNum", evaluateNum);
                ArrayList attrList = new ArrayList();
                BigDecimal storeCount = BigDecimal.ZERO;
                DynamicObjectCollection attrs = ItemAttrUtil.getAttrList(itemDetails.get("id"));
                if (attrs != null && attrs.size() > 0) {
                    for (DynamicObject attr : attrs) {
                        DynamicObject store = ItemStoreUtil.queryItemStore(itemDetails.get("ownerId"), itemDetails.get("id"), itemDetails.get("baseUnitId"), (Object)attr.get("id"), null);
                        if (store == null) continue;
                        itemDetails.put("storeCount", store.get("qty"));
                        BigDecimal storeQty = store.getBigDecimal("qty");
                        if (storeQty != null) {
                            storeCount = storeCount.add(storeQty);
                        }
                        HashMap<String, Object> attrMap = new HashMap<String, Object>();
                        attrMap.put("name", attr.get("name"));
                        attrMap.put("number", attr.get("number"));
                        attrMap.put("storeQty", storeQty);
                    }
                }
                itemDetails.put("attrList", attrList);
                itemDetails.put("storeCount", storeCount);
                Object itemId = itemDetails.get("id");
                DynamicObjectCollection itemmodelcollection = ORMUtil.query((String)"mdr_item_info", (String)"itemmodelentry.modelkey,itemmodelentry.seq,itemmodelentry.modelvalue", (QFilter[])new QFilter("id", "=", itemId).toArray(), (String)"itemmodelentry.seq", (int)0, (int)100);
                ArrayList itemmodellist = new ArrayList();
                for (DynamicObject itemmodel : itemmodelcollection) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    String key = (String)itemmodel.get("itemmodelentry.modelkey");
                    String value = (String)itemmodel.get("itemmodelentry.modelvalue");
                    map.put("name", key);
                    map.put("value", value);
                    itemmodellist.add(map);
                }
                itemDetails.put("itemModelList", itemmodellist);
                itemDetails.put("videoList", this.getUrl(itemDetails.get("id")));
                Map loadFromCacheMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_item_info", (String)"id,itemBrands", (QFilter[])new QFilter("id", "=", itemId).toArray());
                ArrayList itembrandlist = new ArrayList();
                for (DynamicObject item : loadFromCacheMap.values()) {
                    DynamicObjectCollection itembrandRs = item.getDynamicObjectCollection("itemBrands");
                    for (DynamicObject itembrandR : itembrandRs) {
                        if (itembrandR.getDynamicObject("fbasedataid") == null) continue;
                        Map nameMap = (Map)itembrandR.getDynamicObject("fbasedataid").get("name");
                        itembrandlist.add(nameMap.get("zh_CN"));
                    }
                }
                itemDetails.put("itemBrandList", itembrandlist);
                ArrayList pictureList = new ArrayList();
                for (int i = 1; i < 6; ++i) {
                    Object picture = itemDetails.get("picture" + String.valueOf(i));
                    if (StringUtils.isNotEmpty(picture)) {
                        pictureList.add(picture);
                    }
                    itemDetails.remove("picture" + String.valueOf(i));
                }
                itemDetails.put("pictureList", pictureList);
                boolean hasAssistAttr = ItemAttrUtil.hasAssistAttr(itemDetails.get("id"));
                if (hasAssistAttr) {
                    itemDetails.put("assistAttrArray", this.setAssistAttr(itemDetails.get("id")));
                }
                returnData.put("details", itemDetails);
                return ApiResult.success(returnData);
            }
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u63a5\u53e3\u5931\u8d25\uff1a\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728", (String)"ItemInfoApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u63a5\u53e3\u5931\u8d25\uff1a\u8bf7\u4f20\u8f93\u5546\u54c1id\u53c2\u6570", (String)"ItemInfoApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
    }

    private List<Map<String, Object>> setAssistAttr(Object itemId) {
        Set attrIds = ItemAttrUtil.getAttrIds((Object)itemId);
        IDataEntityType dataEntityType = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_attrvalue").getDataEntityType();
        DynamicObject[] assistAttrArray = (DynamicObject[])BusinessDataServiceHelper.load((Object[])attrIds.toArray(), (IDataEntityType)dataEntityType);
        ArrayList<Map<String, Object>> assistAttrList = new ArrayList<Map<String, Object>>(assistAttrArray.length);
        for (DynamicObject assistAttr : assistAttrArray) {
            HashMap<String, Object> assistAttrMap = new HashMap<String, Object>();
            ArrayList list = new ArrayList();
            assistAttrMap.put("id", assistAttr.get("id"));
            assistAttrMap.put("name", assistAttr.get("name"));
            assistAttrMap.put("number", assistAttr.get("number"));
            DynamicObjectCollection assistAttrCollection = assistAttr.getDynamicObjectCollection("attrentity");
            for (DynamicObject assistAttrEntry : assistAttrCollection) {
                HashMap<String, Object> assistAttrEntryMap = new HashMap<String, Object>();
                assistAttrEntryMap.put("number", assistAttrEntry.get("attrvalue.number"));
                assistAttrEntryMap.put("name", assistAttrEntry.get("attrvalue.name.zh_CN"));
                QFilter attrQFilter = new QFilter("number", "=", assistAttrEntry.get("attrvalue.number"));
                DynamicObject key = QueryServiceHelper.queryOne((String)"mdr_assist_value", (String)"group.name,group.number", (QFilter[])attrQFilter.toArray());
                if (key != null) {
                    assistAttrEntryMap.put("groupName", key.get("group.name"));
                    assistAttrEntryMap.put("groupNumber", key.get("group.number"));
                }
                list.add(assistAttrEntryMap);
            }
            assistAttrMap.put("assistAttrList", list);
            assistAttrList.add(assistAttrMap);
        }
        return assistAttrList;
    }

    private List<Object> getUrl(Object dyjId) {
        List attachments = AttachmentServiceHelper.getAttachments((String)"mdr_item_info", (Object)dyjId, (String)"attachment");
        if (attachments == null || attachments.size() <= 0) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> URLList = new ArrayList<Object>(attachments.size());
        for (Map attachment : attachments) {
            String firstItemEvaluateURL = (String)attachment.get("url");
            int indexOf = firstItemEvaluateURL.lastIndexOf(PREFIXURL) + PREFIXURL.length();
            String substring = firstItemEvaluateURL.substring(indexOf, firstItemEvaluateURL.indexOf(38));
            URLList.add(URLDecoder.decode(substring));
        }
        return URLList;
    }

    public ApiResult filterList(Map<String, Object> data) {
        QFilter f = new QFilter("1", "=", (Object)"1");
        if (data != null) {
            Object itemClassNumber = data.get("itemClassNumber");
            if (StringUtils.isEmpty((Object)itemClassNumber)) {
                f.and("itemclass", "=", (Object)0).and("enable", "=", (Object)"1");
            }
            if (StringUtils.isNotEmpty((Object)itemClassNumber)) {
                DynamicObject itemClassId = QueryServiceHelper.queryOne((String)"mdr_item_class", (String)"id", (QFilter[])new QFilter("number", "=", itemClassNumber).toArray());
                if (StringUtils.isEmpty((Object)itemClassId)) {
                    f.and("itemclass", "=", (Object)0).and("enable", "=", (Object)"1");
                } else {
                    f.and("itemclass", "=", itemClassId.get("id")).and("enable", "=", (Object)"1");
                }
            }
        }
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"mdr_item_filter", (String)"id", (QFilter[])f.toArray());
        ArrayList<Object> list2 = new ArrayList<Object>();
        if (ids.size() > 0) {
            for (Object dynamicObject : ids) {
                list2.add(dynamicObject.get("id"));
            }
        } else {
            DynamicObjectCollection filterIds = QueryServiceHelper.query((String)"mdr_item_filter", (String)"id", (QFilter[])new QFilter("itemclass", "=", (Object)0).and("enable", "=", (Object)"1").toArray());
            for (DynamicObject dynamicObject : filterIds) {
                list2.add(dynamicObject.get("id"));
            }
        }
        IDataEntityType type = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_filter").getDataEntityType();
        DynamicObject[] itemFilterArray = (DynamicObject[])BusinessDataServiceHelper.load((Object[])list2.toArray(), (IDataEntityType)type);
        ArrayList filterList = new ArrayList(itemFilterArray.length);
        for (DynamicObject itemFilter : itemFilterArray) {
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            filterMap.put("name", itemFilter.get("name.zh_CN"));
            filterMap.put("field", itemFilter.get("number"));
            filterMap.put("type", itemFilter.get("combofield"));
            DynamicObjectCollection itemFilterCollection = itemFilter.getDynamicObjectCollection("entryentity");
            ArrayList list = new ArrayList();
            for (DynamicObject itemFilterEntry : itemFilterCollection) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (filterMap.get("type").toString().equals("1")) {
                    map.put("name", itemFilterEntry.get("rangename"));
                    map.put("beginValue", itemFilterEntry.get("from"));
                    map.put("endValue", itemFilterEntry.get("to"));
                    list.add(map);
                    continue;
                }
                if (!filterMap.get("type").toString().equals("0")) continue;
                map.put("name", itemFilterEntry.get("rangename"));
                map.put("equalValue", itemFilterEntry.get("to"));
                list.add(map);
            }
            filterMap.put("range", list);
            filterList.add(filterMap);
        }
        return ApiResult.success(filterList);
    }

    public ApiResult getItemListByCustomer(Map<String, Object> data) {
        if (data == null) {
            return ApiResult.fail(null);
        }
        int page = 1;
        int pageSize = 10;
        if (data.get("page") != null && (Integer)data.get("page") > 1) {
            page = (Integer)data.get("page");
        }
        if (data.get("pageSize") != null && (Integer)data.get("pageSize") > 1) {
            pageSize = (Integer)data.get("pageSize");
        }
        Object customerId = data.get("customerId");
        QFilter filter = new QFilter("owner.id", "=", customerId);
        filter.and("isOnSell", "=", (Object)"1");
        String selectFields = "referencePrice,name,thumbnail,id,shorttitle,material.baseunit.name,material.baseunit.id,assistUnit.Id,assistUnit.Name,isAssistOrder";
        int count = QueryUtil.querycount((String)"mdr_item_info", (QFilter[])filter.toArray());
        Map map = QueryUtil.queryColsList((String)"mdr_item_info", (String[])selectFields.split(","), (QFilter[])filter.toArray(), null, (int)page, (int)pageSize);
        List list = (List)map.get("list");
        for (Map maps : list) {
            maps.replace("id", maps.get("id") + "");
            maps.replace("materialBaseunitId", maps.get("materialBaseunitId") + "");
            QFilter qF = new QFilter("materialid", "=", ItemUtil.getMaterialId(maps.get("id"))).and("measureunitid", "=", (Object)(maps.get("assistUnitId") + ""));
            if (((Boolean)maps.get("isAssistOrder")).booleanValue() && QueryServiceHelper.exists((String)"bd_multimeasureunit", (QFilter[])qF.toArray())) {
                maps.put("conversionRate", ItemUtil.queryConversionFactor(maps.get("id"), maps.get("assistUnitId")));
            }
            if (!((Boolean)maps.get("isAssistOrder")).booleanValue()) continue;
            maps.put("conversionRate", ItemUtil.queryConversionFactor(maps.get("id"), maps.get("materialBaseunitId")));
        }
        map.put("count", count);
        return ApiResult.success((Object)map);
    }

    public ApiResult getItemListByIds(Map<String, Object> data) {
        QFilter f = new QFilter("1", "=", (Object)"1");
        List ids = (List)data.get("ids");
        ArrayList list = new ArrayList();
        if (StringUtils.isNotEmpty((Object)ids)) {
            String fileds;
            DynamicObject[] itemInfos;
            if (StringUtils.isNotEmpty((Object)ids)) {
                f = f.and(new QFilter("id", "in", (Object)ids));
            }
            if ((itemInfos = BusinessDataServiceHelper.load((String)"mdr_item_info", (String)(fileds = "masterid,id,thumbnail,owner.id,owner.name,picture1,picture2,picture3,picture4,picture5,assistunit.id,assistunit.name,isassistorder,name,description"), (QFilter[])f.toArray())) != null && itemInfos.length > 0) {
                for (DynamicObject itemInfo : itemInfos) {
                    boolean hasAssistAttr;
                    HashMap<String, Object> map = new HashMap<String, Object>(32);
                    String unitId = null;
                    String assistAttrId = null;
                    map.put("itemName", itemInfo.get("masterid.name.zh_CN"));
                    map.put("itemId", itemInfo.get("id"));
                    map.put("isAssistOrder", itemInfo.get("isassistorder"));
                    map.put("title", itemInfo.get("name"));
                    map.put("assistUnitName", itemInfo.get("assistunit.name.zh_CN"));
                    map.put("assistUnitId", itemInfo.get("assistunit.id"));
                    map.put("picture5", itemInfo.get("picture5"));
                    map.put("picture4", itemInfo.get("picture4"));
                    map.put("picture3", itemInfo.get("picture3"));
                    map.put("picture2", itemInfo.get("picture2"));
                    map.put("picture1", itemInfo.get("picture1"));
                    map.put("ownerName", itemInfo.get("owner.name.zh_CN"));
                    map.put("ownerid", itemInfo.get("owner.id"));
                    map.put("thumbnail", itemInfo.get("thumbnail"));
                    map.put("descriPtion", itemInfo.get("description"));
                    if (QueryServiceHelper.exists((String)"bd_material", (Object)itemInfo.get("masterid.id"))) {
                        DynamicObject master = BusinessDataServiceHelper.loadSingle((Object)itemInfo.get("masterid.id"), (String)"bd_material", (String)"baseunit.name,baseunit.id");
                        map.put("baseUnitName", master.get("baseunit.name.zh_CN"));
                        map.put("baseUnitId", master.get("baseunit.id"));
                        unitId = master.get("baseunit.id").toString();
                    }
                    if (hasAssistAttr = ItemAttrUtil.hasAssistAttr(map.get("id"))) {
                        List<Map<String, Object>> assistAttr = this.setAssistAttr(map.get("id"));
                        map.put("assistAttrArray", assistAttr);
                        if (!assistAttr.isEmpty()) {
                            assistAttrId = assistAttr.get(assistAttr.size() - 1).get("id").toString();
                        }
                    }
                    if (((Boolean)itemInfo.get("isassistorder")).booleanValue()) {
                        unitId = itemInfo.get("assistunit.id").toString();
                    }
                    BigDecimal itemPrice = PriceUtil.getItemPrice((Object)itemInfo.get("owner.id"), (Object)UserUtil.getDefaultOwnerID(), (Object)itemInfo.get("id"), (Object)unitId, assistAttrId, (BigDecimal)new BigDecimal(1), (Date)new Date());
                    map.put("itemPrice", itemPrice.setScale(2, 4));
                    list.add(map);
                }
            }
        }
        return ApiResult.success(list);
    }

    @ApiTransaction
    public ApiResult syncItem(Map<String, Object> data) {
        DynamicObject material;
        Object number = data.get("number");
        Object name = data.get("name");
        Object model = data.get("model");
        Object customernumber = data.get("customernumber");
        Object itemclassnumber = data.get("itemclassnumber");
        Object baseunitnumber = data.get("baseunitnumber");
        Object saleunitnumber = data.get("saleunitnumber");
        Object assistunitnumber = data.get("assistunitnumber");
        Object height = data.get("height");
        Object width = data.get("width");
        Object length = data.get("length");
        Object grossWeight = data.get("grossWeight");
        Object netWeight = data.get("netWeight");
        Object volume = data.get("volume");
        HashMap volumeUnitMap = (HashMap)data.get("volumeUnitnumber");
        String volumeUnitnumber = null;
        if (volumeUnitMap != null) {
            volumeUnitnumber = volumeUnitMap.get("unitNumber").toString();
        }
        HashMap lengthUnitMap = (HashMap)data.get("lengthUnitnumber");
        String lengthUnitnumber = null;
        if (lengthUnitMap != null) {
            lengthUnitnumber = lengthUnitMap.get("unitNumber").toString();
        }
        HashMap weightUnitMap = (HashMap)data.get("weightUnitnumber");
        String weightUnitnumber = null;
        if (weightUnitMap != null) {
            weightUnitnumber = weightUnitMap.get("unitNumber").toString();
        }
        if ((material = this.getDynamicObjectByNumber(number.toString(), "bd_material")) == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u7269\u6599\uff0c\u9500\u552e\u9875\u7b7e\u4e0d\u540c\u6b65\u672a\u5546\u54c1", (String)"ItemInfoApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]), number);
            logger.info(msg);
            return ApiResult.success((Object)msg);
        }
        DynamicObject customer = BusinessDataServiceHelper.loadSingle((String)"mdr_customer", (String)"id,createorg", (QFilter[])new QFilter("number", "=", (Object)customernumber.toString()).toArray());
        if (customer == null) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u5185\u90e8\u6e20\u9053", (String)"ItemInfoApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]), customernumber));
        }
        QFilter qfilter = new QFilter("easnum", "=", number);
        qfilter.and(new QFilter("owner", "=", customer.getPkValue()));
        DynamicObject item = BusinessDataServiceHelper.loadSingle((String)"mdr_item_info", (String)"id,name,height,width,length,grossWeight,netWeight,volume,itemclass,baseunit,saleunit,volumnunit,lengthunit,weightunit,assistunit", (QFilter[])qfilter.toArray());
        boolean isUpdate = false;
        if (item != null) {
            isUpdate = true;
        } else {
            isUpdate = false;
            item = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_info");
            item.set("id", (Object)DBServiceHelper.genLongIds((String)"t_mdr_item", (int)1)[0]);
            DynamicObjectCollection col = item.getDynamicObjectCollection("mulowner");
            DynamicObjectType type = col.getDynamicObjectType();
            DynamicObject obj = new DynamicObject(type);
            obj.set("fbasedataid", (Object)customer);
            col.add((Object)obj);
            item.getDynamicObjectCollection("attrvalueentry").clear();
            item.getDynamicObjectCollection("attrentry").clear();
            item.set("owner", (Object)customer);
            item.set("material", (Object)material);
            item.set("easnum", number);
            item.set("isfromeas", (Object)1);
            item.set("modelnum", model);
        }
        item.set("name", name);
        item.set("height", height == null ? "" : height);
        item.set("width", width == null ? "" : width);
        item.set("length", length == null ? "" : length);
        item.set("grossWeight", grossWeight == null ? "" : grossWeight);
        item.set("netWeight", netWeight == null ? "" : netWeight);
        item.set("volume", volume == null ? "" : volume);
        DynamicObject itemclass = this.getDynamicObjectByNumber(itemclassnumber.toString(), "mdr_item_class");
        if (itemclass == null) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u5546\u54c1\u5206\u7c7b", (String)"ItemInfoApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]), itemclassnumber));
        }
        item.set("itemclass", (Object)itemclass);
        DynamicObject baseunit = this.getDynamicObjectByNumber(baseunitnumber.toString(), "bd_measureunits");
        if (baseunit == null) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u8ba1\u91cf\u5355\u4f4d", (String)"ItemInfoApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]), baseunitnumber));
        }
        item.set("baseunit", (Object)baseunit);
        DynamicObject saleunit = this.getDynamicObjectByNumber(saleunitnumber.toString(), "bd_measureunits");
        if (saleunit == null) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u8ba1\u91cf\u5355\u4f4d", (String)"ItemInfoApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]), saleunitnumber));
        }
        item.set("saleunit", (Object)saleunit);
        if (volumeUnitnumber != null) {
            DynamicObject volumeunit = this.getDynamicObjectByNumber(volumeUnitnumber, "bd_measureunits");
            if (volumeunit == null) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u8ba1\u91cf\u5355\u4f4d", (String)"ItemInfoApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]), volumeUnitnumber));
            }
            item.set("volumnunit", (Object)volumeunit);
        }
        if (lengthUnitnumber != null) {
            DynamicObject lengthunit = this.getDynamicObjectByNumber(lengthUnitnumber, "bd_measureunits");
            if (lengthunit == null) {
                return ApiResult.fail((String)String.format("\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u8ba1\u91cf\u5355\u4f4d", lengthUnitnumber));
            }
            item.set("lengthunit", (Object)lengthunit);
        }
        if (weightUnitnumber != null) {
            DynamicObject weightunit = this.getDynamicObjectByNumber(weightUnitnumber, "bd_measureunits");
            if (weightunit == null) {
                return ApiResult.fail((String)String.format("\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u8ba1\u91cf\u5355\u4f4d", weightUnitnumber));
            }
            item.set("weightunit", (Object)weightunit);
        }
        if (assistunitnumber != null) {
            DynamicObject assistunit = this.getDynamicObjectByNumber(assistunitnumber.toString(), "bd_measureunits");
            if (assistunit == null) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u8ba1\u91cf\u5355\u4f4d", (String)"ItemInfoApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]), assistunitnumber));
            }
            item.set("assistunit", (Object)assistunit);
        }
        if (isUpdate) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{item});
            return ApiResult.success(null);
        }
        item.set("conversionfor", (Object)"A");
        item.set("isonsell", (Object)0);
        item.set("status", (Object)"C");
        item.set("enable", (Object)0);
        String itemnumber = CodeRuleServiceHelper.getNumber((String)"mdr_item_info", (DynamicObject)item, null);
        if (itemnumber == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5546\u54c1\u7684\u7f16\u7801\u89c4\u5219", (String)"ItemInfoApi_6", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        item.set("number", (Object)itemnumber);
        List attrsdata = (List)data.get("itemattrs");
        if (attrsdata != null) {
            item.set("hasattr", (Object)1);
            this.saveAttr(item, attrsdata);
        }
        item.set("createorg", (Object)BusinessDataServiceHelper.loadSingle((Object)customer.getLong("createorg_id"), (String)"bos_org"));
        item.set("stockunit", (Object)baseunit);
        item.set("orderunit", (Object)saleunit);
        item.set("retailunit", (Object)saleunit);
        this.setItemClassStandard(item, itemclass);
        item.set("itemtypeid", (Object)BusinessDataServiceHelper.loadSingle((Object)DEFAULT_ITEM_TYPE_ID, (String)"bd_itemtype"));
        item.set("goodsbelong", (Object)"0");
        item.set("ctrlstrategy", (Object)"5");
        this.beforeCustomerSave(item, data);
        OperationUtil.invokeOperation((DynamicObject)item, (String)"save");
        this.saveOrUpdateF7(item);
        return ApiResult.success(null);
    }

    protected void beforeCustomerSave(DynamicObject customerInfo, Map<String, Object> data) {
    }

    private void saveOrUpdateF7(DynamicObject itemDynObj) {
        DynamicObject itemcombinationDynObj = null;
        itemcombinationDynObj = QueryServiceHelper.exists((String)"dpm_itemcombination_f7", (Object)itemDynObj.getPkValue()) ? BusinessDataServiceHelper.loadSingle((Object)itemDynObj.getPkValue(), (String)"dpm_itemcombination_f7") : BusinessDataServiceHelper.newDynamicObject((String)"dpm_itemcombination_f7");
        itemcombinationDynObj.set("number", itemDynObj.get("number"));
        itemcombinationDynObj.set("name", itemDynObj.get("name"));
        itemcombinationDynObj.set("baseunit", itemDynObj.get("baseunit"));
        itemcombinationDynObj.set("modelnum", itemDynObj.get("modelnum"));
        itemcombinationDynObj.set("id", itemDynObj.getPkValue());
        itemcombinationDynObj.set("iscombination", (Object)Boolean.FALSE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{itemcombinationDynObj});
    }

    private void setItemClassStandard(DynamicObject item, DynamicObject itemClass) {
        DynamicObjectCollection itemClassEntryColl = item.getDynamicObjectCollection("itemclassentity");
        DynamicObject itemGroupEntry = new DynamicObject(itemClassEntryColl.getDynamicObjectType());
        DynamicObject itemClassDyn = BusinessDataServiceHelper.loadSingle((String)"bd_goodsclassstandard", (String)"masterid,name,number", (QFilter[])new QFilter("id", "=", (Object)1L).toArray());
        itemGroupEntry.set("classstandardid", (Object)itemClassDyn);
        itemGroupEntry.set("goodsclasssid", (Object)itemClass);
        itemClassEntryColl.add((Object)itemGroupEntry);
    }

    protected void saveAttr(DynamicObject item, List<Map<String, Object>> attrs) {
        HashMap<String, DynamicObject> attrcache = new HashMap<String, DynamicObject>();
        LinkedHashMap<String, DynamicObject> attrtypecache = new LinkedHashMap<String, DynamicObject>();
        int seq = 1;
        for (Map<String, Object> itemasst : attrs) {
            String itemasstnumber = itemasst.get("itemasstnumber").toString();
            String itemasstname = itemasst.get("itemasstname").toString();
            QFilter filter = new QFilter("item", "=", item.getPkValue());
            filter.and("easnumber", "=", (Object)itemasstnumber);
            DynamicObject itemasstobj = BusinessDataServiceHelper.loadSingle((String)"mdr_item_attrvalue", (String)"attrentity.attrvalue", (QFilter[])filter.toArray());
            if (itemasstobj != null) continue;
            itemasstobj = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_attrvalue");
            DynamicObject itemattrvalue = item.getDynamicObjectCollection("attrvalueentry").addNew();
            itemattrvalue.set("attrname", (Object)itemasstname);
            itemattrvalue.set("easnumber", (Object)itemasstnumber);
            String number = CodeRuleServiceHelper.getNumber((String)"mdr_item_attrvalue", (DynamicObject)itemasstobj, null);
            if (number == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5546\u54c1\u8f85\u52a9\u5c5e\u6027\u503c\u7f16\u7801\u89c4\u5219", (String)"ItemInfoApi_7", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            itemattrvalue.set("attrnumber", (Object)number);
            itemattrvalue.set("seq", (Object)(++seq));
            List asstdetail = (List)itemasst.get("asstdetail");
            int i = 1;
            for (Map asst : asstdetail) {
                DynamicObject attrvalue;
                String asstnumber = asst.get("asstnumber").toString();
                String asstname = asst.get("asstname").toString();
                String assttypenumber = asst.get("assttypenumber").toString();
                String assttypename = asst.get("assttypename").toString();
                DynamicObject attrtype = (DynamicObject)attrtypecache.get(assttypenumber);
                if (attrtype == null) {
                    attrtype = this.getAttrType(assttypenumber, assttypename);
                    attrtypecache.put(assttypenumber, attrtype);
                }
                if ((attrvalue = (DynamicObject)attrcache.get(assttypenumber + "_" + asstnumber)) == null) {
                    attrvalue = this.getAttrValue(attrtype, asstnumber, asstname);
                    attrcache.put(assttypenumber + "_" + asstnumber, attrvalue);
                }
                itemattrvalue.set("attrvalue" + i, (Object)attrvalue);
                ++i;
            }
        }
        int attrseq = 1;
        for (Map.Entry attrtype : attrtypecache.entrySet()) {
            DynamicObject attrtypeentry = item.getDynamicObjectCollection("attrentry").addNew();
            attrtypeentry.set("attr", attrtype.getValue());
            attrtypeentry.set("seq", (Object)(++attrseq));
        }
    }

    protected DynamicObject getDynamicObjectByEASNum(String easnumber, String entityName) {
        return BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id", (QFilter[])new QFilter("easnumber", "=", (Object)easnumber).toArray());
    }

    protected DynamicObject getDynamicObjectByEASNum(String easnumber, String entityName, String fields) {
        return BusinessDataServiceHelper.loadSingle((String)entityName, (String)fields, (QFilter[])new QFilter("easnumber", "=", (Object)easnumber).toArray());
    }

    protected DynamicObject getAttrType(String easnumber, String name) {
        DynamicObject attrtype = this.getDynamicObjectByEASNum(easnumber, "mdr_assist_attr");
        if (attrtype == null) {
            attrtype = BusinessDataServiceHelper.newDynamicObject((String)"mdr_assist_attr");
            attrtype.set("name", (Object)name);
            attrtype.set("easnumber", (Object)easnumber);
            attrtype.set("status", (Object)"C");
            attrtype.set("enable", (Object)1);
            Long id = DBServiceHelper.genLongIds((String)"mdr_assist_attr", (int)1)[0];
            attrtype.set("masterid", (Object)id);
            attrtype.set("id", (Object)id);
            attrtype.set("level", (Object)1);
            attrtype.set("isleaf", (Object)Boolean.TRUE);
            String typenumber = CodeRuleServiceHelper.getNumber((String)"mdr_assist_attr", (DynamicObject)attrtype, null);
            if (typenumber == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u8f85\u52a9\u5c5e\u6027\u7f16\u7801\u89c4\u5219", (String)"ItemInfoApi_8", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            attrtype.set("longnumber", (Object)typenumber);
            attrtype.set("number", (Object)typenumber);
            attrtype = (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attrtype})[0];
        }
        return attrtype;
    }

    protected DynamicObject getAttrValue(DynamicObject attrtype, String easnumber, String name) {
        QFilter filter = new QFilter("easnumber", "=", (Object)easnumber);
        filter.and(new QFilter("group", "=", attrtype.get("id")));
        DynamicObject attrvalue = BusinessDataServiceHelper.loadSingle((String)"mdr_assist_value", (String)"id,number,name,easnumber,group", (QFilter[])filter.toArray());
        if (attrvalue == null) {
            attrvalue = BusinessDataServiceHelper.newDynamicObject((String)"mdr_assist_value");
            attrvalue.set("name", (Object)name);
            attrvalue.set("easnumber", (Object)easnumber);
            attrvalue.set("group", (Object)attrtype);
            attrvalue.set("status", (Object)"C");
            attrvalue.set("enable", (Object)1);
            String number = CodeRuleServiceHelper.getNumber((String)"mdr_item_attrvalue", (DynamicObject)attrvalue, null);
            if (number == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u8f85\u52a9\u5c5e\u6027\u503c\u7f16\u7801\u89c4\u5219", (String)"ItemInfoApi_9", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            attrvalue.set("number", (Object)number);
            attrvalue = (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attrvalue})[0];
        }
        return attrvalue;
    }

    @ApiTransaction
    public ApiResult disableItem(Map<String, Object> data) {
        String easnumber = (String)data.get("easnumber");
        DynamicObject itemInfo = this.getItemByEasnumber(easnumber);
        if (itemInfo == null) {
            return ApiResult.success((Object)String.format("\u4e0d\u5b58\u5728eas\u7f16\u7801\u4e3a%s\u7684\u5546\u54c1", easnumber));
        }
        if (itemInfo.getString("enable").equals("0")) {
            return ApiResult.success((Object)String.format("eas\u7f16\u7801\u4e3a%s\u7684\u5546\u54c1\u5df2\u7ecf\u4e3a\u7981\u7528\u72b6\u6001", easnumber));
        }
        OperationResult result = OperationUtil.invokeOperation((DynamicObject)itemInfo, (String)"disable");
        if (result.isSuccess()) {
            return ApiResult.success(null);
        }
        return ApiResult.fail((String)result.getMessage());
    }

    public ApiResult enableItem(Map<String, Object> data) {
        String easnumber = (String)data.get("easnumber");
        DynamicObject itemInfo = this.getItemByEasnumber(easnumber);
        if (itemInfo == null) {
            return ApiResult.success((Object)String.format("\u4e0d\u5b58\u5728eas\u7f16\u7801\u4e3a%s\u7684\u5546\u54c1", easnumber));
        }
        if (itemInfo.getString("enable").equals("1")) {
            return ApiResult.success((Object)String.format("eas\u7f16\u7801\u4e3a%s\u7684\u5546\u54c1\u5df2\u7ecf\u4e3a\u542f\u7528\u72b6\u6001", easnumber));
        }
        OperationResult result = OperationUtil.invokeOperation((DynamicObject)itemInfo, (String)"enable");
        if (result.isSuccess()) {
            return ApiResult.success(null);
        }
        return ApiResult.fail((String)result.getMessage());
    }

    private DynamicObject getItemByEasnumber(String easnumber) {
        DynamicObject itemInfo = null;
        QFilter qFilter = new QFilter("easnum", "=", (Object)easnumber);
        boolean isExists = QueryServiceHelper.exists((String)"mdr_item_info", (QFilter[])qFilter.toArray());
        if (isExists) {
            DynamicObject id = QueryServiceHelper.queryOne((String)"mdr_item_info", (String)"id,enable", (QFilter[])qFilter.toArray());
            itemInfo = BusinessDataServiceHelper.loadSingle((Object)id.get("id"), (String)"mdr_item_info");
        }
        return itemInfo;
    }
}

