/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.item;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.UserUtil;

public class ItemPriceApi
extends MdrApi {
    public ApiResult getItemPrice(Map<String, Object> data) throws ParseException {
        if (data == null) {
            throw new KDBizException(ResManager.loadKDString((String)"data\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (String)"ItemPriceApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        Map<String, Object> map = this.getOneItemPrice(data);
        return ApiResult.success(map);
    }

    public ApiResult queryItemPriceList(Map<String, Object> data) throws ParseException {
        if (data == null) {
            throw new KDBizException(ResManager.loadKDString((String)"data\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01", (String)"ItemPriceApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        List itemList = (List)data.get("itemList");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (itemList != null && itemList.size() > 0) {
            for (Map map : itemList) {
                Map<String, Object> price = this.getOneItemPrice(map);
                price.put("itemId", map.get("itemId"));
                list.add(price);
            }
        }
        data.clear();
        data.put("priceList", list);
        return ApiResult.success(data);
    }

    protected Map<String, Object> getOneItemPrice(Map<String, Object> data) throws ParseException {
        Object ownerId = data.get("ownerId");
        Object customerId = data.get("customerId");
        Object itemId = data.get("itemId");
        Object unitId = data.get("unitId");
        Object assistattrId = data.get("assistattrId");
        String qty = String.valueOf(data.get("qty"));
        Object date = data.get("date");
        if (StringUtils.isEmpty((Object)ownerId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053Id\u4e0d\u80fd\u4e3a\u7a7a", (String)"ItemPriceApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (!QueryServiceHelper.exists((String)"mdr_customer", (Object)ownerId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u4e0d\u5b58\u5728", (String)"ItemPriceApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((Object)customerId)) {
            customerId = UserUtil.getDefaultOwnerID();
        } else if (!QueryServiceHelper.exists((String)"mdr_customer", (Object)customerId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba2\u6237\u6e20\u9053\u4e0d\u5b58\u5728", (String)"ItemPriceApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (!CustomerUtil.isAuthRelation((Object)ownerId, (Object)customerId)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("price", BigDecimal.ZERO);
            return map;
        }
        if (StringUtils.isEmpty((Object)itemId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1Id\u4e0d\u80fd\u4e3a\u7a7a", (String)"ItemPriceApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (!QueryServiceHelper.exists((String)"mdr_item_info", (Object)itemId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u5b58\u5728", (String)"ItemPriceApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((Object)unitId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u5355\u4f4dId\u4e0d\u80fd\u4e3a\u7a7a", (String)"ItemPriceApi_6", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (!QueryServiceHelper.exists((String)"bd_measureunits", (Object)unitId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u5355\u4f4d\u4e0d\u5b58\u5728", (String)"ItemPriceApi_7", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((Object)assistattrId)) {
            assistattrId = 0L;
        } else if (!ItemAttrUtil.hasAssistAttr((Object)itemId, (Object)assistattrId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u6ca1\u6709\u6b64\u8f85\u52a9\u5c5e\u6027", (String)"ItemPriceApi_8", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)qty) || "null".equals(qty)) {
            qty = "0";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isEmpty((Object)date)) {
            date = sdf.format(new Date());
        }
        Map<String, Object> map = this.getItemPriceEX(ownerId, customerId, itemId, unitId, assistattrId, qty, date, sdf);
        return map;
    }

    protected Map<String, Object> getItemPriceEX(Object ownerId, Object customerId, Object itemId, Object unitId, Object assistattrId, String qty, Object date, SimpleDateFormat sdf) throws ParseException {
        BigDecimal itemPrice = PriceUtil.getItemPrice((Object)ownerId, (Object)customerId, (Object)itemId, (Object)unitId, (Object)assistattrId, (BigDecimal)new BigDecimal(qty), (Date)sdf.parse(date.toString()));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("price", itemPrice.setScale(2, 4));
        return map;
    }
}

