/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.item;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.CustomerParamsUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.UserUtil;

public class ItemVendibilityApi
extends MdrApi {
    public ApiResult isVendibility(Map<String, Object> data) {
        if (data == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u5165\u53c2", (String)"ItemVendibilityApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        List itemList = (List)data.get("itemList");
        ArrayList resultList = new ArrayList();
        if (itemList == null || itemList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u5546\u54c1", (String)"ItemVendibilityApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        Object defaultOwner = UserUtil.getDefaultOwnerID();
        for (Map item : itemList) {
            Set<String> idSet;
            Object ownerId = item.get("ownerId");
            Object customerId = item.get("customerId");
            HashMap resultMap = new HashMap();
            String itemId = item.get("id").toString();
            if (StringUtils.isEmpty(ownerId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053id\u4e0d\u5f97\u4e3a\u7a7a", (String)"ItemVendibilityApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty(customerId)) {
                customerId = defaultOwner;
            }
            if (!CustomerUtil.isAuthRelation(ownerId, customerId) || !(idSet = this.parseStr(ItemSaleControlUtil.getAllCanSaleItemIdsByDefaultFilter(ownerId, customerId))).contains(itemId)) continue;
            resultMap.put("name", item.get("name"));
            resultMap.put("id", item.get("id"));
            resultList.add(resultMap);
        }
        return ApiResult.success(resultList);
    }

    public ApiResult isBuy(Map<String, Object> data) {
        this.checkRecordField(data, "items");
        List items = (List)data.get("items");
        ArrayList<HashMap<String, Object>> isBuys = new ArrayList<HashMap<String, Object>>(items.size());
        Object defaultOwner = UserUtil.getDefaultOwnerID();
        for (HashMap itemMap : items) {
            BigDecimal itemPrice;
            String itemId = itemMap.get("itemId") + "";
            Object assistAttrId = itemMap.get("assistAttrId");
            Object qtyStr = itemMap.get("qty");
            Map<String, Object> isBuyMap = new HashMap<String, Object>();
            DynamicObject item = null;
            BigDecimal qty = null;
            if (StringUtils.isNotEmpty((String)itemId) && QueryServiceHelper.exists((String)"mdr_item_info", (Object)itemId)) {
                item = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"mdr_item_info", (String)"id,owner.id,material.id");
            }
            if (item == null || !CustomerUtil.isAuthRelation((Object)item.get("owner.id"), (Object)defaultOwner)) continue;
            String ownerId = item.getString("owner.id");
            String baseunitId = null;
            if (StringUtils.isNotEmpty((String)item.getString("material.id")) && QueryServiceHelper.exists((String)"bd_material", (Object)item.getString("material.id"))) {
                DynamicObject material = BusinessDataServiceHelper.loadSingle((Object)item.getString("material.id"), (String)"bd_material", (String)"id,baseunit.id");
                baseunitId = material.getString("baseunit.id");
            }
            if ((itemPrice = PriceUtil.getItemPrice((Object)ownerId, (Object)defaultOwner, (Object)itemId, (Object)baseunitId, assistAttrId, (BigDecimal)(qty = StringUtils.isEmpty(qtyStr) ? new BigDecimal(1) : new BigDecimal(qtyStr + "")), (Date)new Date())) == null || new BigDecimal(0).compareTo(itemPrice) > 0) {
                isBuyMap.put("itemId", itemId);
                isBuyMap.put("isBuy", "0");
            } else {
                isBuyMap.put("itemId", itemId);
                isBuyMap.put("isBuy", "1");
            }
            isBuyMap = this.isQtyOverStore(itemId, assistAttrId, isBuyMap, qty, ownerId, baseunitId);
            isBuys.add((HashMap<String, Object>)isBuyMap);
        }
        data.clear();
        data.put("list", isBuys);
        return ApiResult.success(data);
    }

    protected Map<String, Object> isQtyOverStore(String itemId, Object assistAttrId, Map<String, Object> isBuyMap, BigDecimal qty, String ownerId, String baseunitId) {
        if (CustomerParamsUtil.isAllowOver((Object)ownerId).equals("1")) {
            BigDecimal storeQty = null;
            if (StringUtils.isNotEmpty((String)baseunitId) && (storeQty = ItemStoreUtil.queryItemStoreQty((Object)ownerId, (Object)itemId, (Object)baseunitId, (Object)assistAttrId, null)).compareTo(qty) < 0) {
                isBuyMap.put("itemId", itemId);
                isBuyMap.put("isBuy", "0");
            }
        }
        return isBuyMap;
    }

    private Set<String> parseStr(Set<Object> idSet) {
        HashSet<String> re = new HashSet<String>(idSet.size());
        for (Object id : idSet) {
            re.add(id.toString());
        }
        return re;
    }
}

