/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.itemstore;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.api.ApiTransaction;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.model.ItemStoreModel;
import kd.drp.mdr.common.util.ItemStoreUtil;
import org.apache.log4j.Logger;

public class ItemStoreApi
extends MdrApi {
    private static final Logger log = Logger.getLogger(ItemStoreApi.class);

    @ApiTransaction
    public ApiResult update(Map<String, Object> data) {
        StringBuilder result = new StringBuilder();
        List list = (List)data.get("list");
        if (list == null || list.size() == 0) {
            return ApiResult.success((Object)ResManager.loadKDString((String)"list\u4e2d\u65e0\u5e93\u5b58\u6570\u636e\uff0c\u65e0\u9700\u66f4\u65b0", (String)"ItemStoreApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        HashSet<String> customerEasNumbers = new HashSet<String>(list.size());
        HashSet<String> warehouseNumbers = new HashSet<String>(list.size());
        HashSet<String> itemEasNumbers = new HashSet<String>(list.size());
        HashSet<String> assistAttrNumbers = new HashSet<String>(list.size());
        HashSet<String> measureUnitNumbers = new HashSet<String>(list.size());
        for (Map map : list) {
            if (map.get("customereasnumber") != null) {
                customerEasNumbers.add(map.get("customereasnumber").toString());
            }
            if (map.get("itemeasnumber") != null) {
                itemEasNumbers.add(map.get("itemeasnumber").toString());
            }
            if (map.get("measureunitnumber") != null) {
                measureUnitNumbers.add(map.get("measureunitnumber").toString());
            }
            if (map.get("assistattrnumber") != null) {
                assistAttrNumbers.add(map.get("assistattrnumber").toString());
            }
            if (map.get("warehousenumber") == null) continue;
            warehouseNumbers.add(map.get("warehousenumber").toString());
        }
        Map<Object, DynamicObject> customers = this.batchLoadInfo(customerEasNumbers, "easnumber", "mdr_customer", "id,name,number,easnumber");
        Map<Object, DynamicObject> warehouses = this.batchLoadInfo(warehouseNumbers, "number", "mdr_warehouse", "id,name,number");
        Map<Object, DynamicObject> units = this.batchLoadInfo(measureUnitNumbers, "number", "bd_measureunits", "id,name,number");
        Map<Object, DynamicObject> attrs = this.batchLoadInfo(assistAttrNumbers, "easnumber", "mdr_item_attrvalue", "id,name,number,easnumber");
        Map<Object, DynamicObject> items = this.batchLoadInfo(itemEasNumbers, "easnum", "easnum,owner.id", "mdr_item_info", "id,name,number,hasattr,easnum,owner");
        ArrayList<ItemStoreModel> stores = new ArrayList<ItemStoreModel>();
        for (int i = 0; i < list.size(); ++i) {
            result.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c", (String)"ItemStoreApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]), i + 1));
            Map m = (Map)list.get(i);
            String itemeasnumber = m.get("itemeasnumber") == null ? null : m.get("itemeasnumber").toString();
            String customereasnumber = m.get("customereasnumber") == null ? null : m.get("customereasnumber").toString();
            String measureunitnumber = m.get("measureunitnumber") == null ? null : m.get("measureunitnumber").toString();
            String assistattrnumber = m.get("assistattrnumber") == null ? null : m.get("assistattrnumber").toString();
            String warehousenumber = m.get("warehousenumber") == null ? null : m.get("warehousenumber").toString();
            DynamicObject customer = customers.get(customereasnumber);
            if (customer == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728EAS\u7f16\u7801\u662f\uff1a%s\u7684\u6e20\u9053\n", (String)"ItemStoreApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]), customereasnumber);
                log.error((Object)msg);
                result.append(msg);
                continue;
            }
            DynamicObject warehouse = null;
            if (warehousenumber != null && !warehousenumber.isEmpty() && (warehouse = warehouses.get(warehousenumber)) == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u662f\uff1a%s\u7684\u53d1\u8d27\u5730\u70b9\n", (String)"ItemStoreApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]), warehousenumber);
                log.error((Object)msg);
                result.append(msg);
                continue;
            }
            DynamicObject item = items.get(itemeasnumber + "_" + customer.getString("id"));
            if (item == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728EAS\u7f16\u7801\u4e3a\u3010%s\u3011\u4e14\u9500\u552e\u6e20\u9053EAS\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u5546\u54c1!\n", (String)"ItemStoreApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]), itemeasnumber, customereasnumber);
                log.error((Object)msg);
                result.append(msg);
                continue;
            }
            DynamicObject measureunit = units.get(measureunitnumber);
            if (measureunit == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u662f\uff1a%s\u7684\u8ba1\u91cf\u5355\u4f4d!\n", (String)"ItemStoreApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]), measureunitnumber);
                log.error((Object)msg);
                result.append(msg);
                continue;
            }
            Object assistattrId = 0L;
            if (assistattrnumber != null) {
                DynamicObject assistattr = attrs.get(assistattrnumber);
                if (assistattr == null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u5b58\u5728\u7f16\u7801\u662f\uff1a%s\u7684\u8f85\u52a9\u5c5e\u6027\n", (String)"ItemStoreApi_6", (String)"drp-mdr-webapi", (Object[])new Object[0]), assistattrnumber);
                    log.error((Object)msg);
                    result.append(msg);
                    continue;
                }
                assistattrId = assistattr.get("id");
            } else if (item.getBoolean("hasattr")) {
                String msg = String.format(ResManager.loadKDString((String)"\u5546\u54c1[%s]\u4e0d\u5b58\u5728\u7f16\u7801[%s]\u7684\u8f85\u52a9\u5c5e\u6027\n", (String)"ItemStoreApi_7", (String)"drp-mdr-webapi", (Object[])new Object[0]), item.getString("number"), assistattrnumber);
                log.error((Object)msg);
                result.append(msg);
                continue;
            }
            ItemStoreModel.StoreChangeType type = ItemStoreModel.StoreChangeType.UPDATE;
            if (m.get("isinit") != null && ((Boolean)m.get("isinit")).booleanValue()) {
                type = ItemStoreModel.StoreChangeType.INIT;
            }
            ItemStoreModel model = new ItemStoreModel((Object)customer.getString("id"), (Object)item.getString("id"), (Object)measureunit.getString("id"), assistattrId, (Object)(warehouse == null ? null : warehouse.getString("id")), new BigDecimal(m.get("qty").toString()), BigDecimal.ZERO, type);
            stores.add(model);
            result.append(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\uff01\n", (String)"ItemStoreApi_8", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (stores.size() > 0) {
            ItemStoreUtil.updateItemStore(stores);
        }
        return ApiResult.success((Object)result.toString());
    }

    private Map<Object, DynamicObject> batchLoadInfo(Set<String> values, String entityKey, String entityName, String selectFields) {
        return this.batchLoadInfo(values, entityKey, entityKey, entityName, selectFields);
    }

    private Map<Object, DynamicObject> batchLoadInfo(Set<String> values, String entityKey, String mapKeys, String entityName, String selectFields) {
        Map<Object, DynamicObject> objs = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)selectFields, (QFilter[])new QFilter(entityKey, "in", values).toArray());
        objs = this.mapTranformKey(objs, mapKeys);
        return objs;
    }

    private Map<Object, DynamicObject> mapTranformKey(Map<Object, DynamicObject> objs, String entityKey) {
        String[] entityKeys = entityKey.split(",");
        HashMap<Object, DynamicObject> newObjs = new HashMap<Object, DynamicObject>(objs.size());
        for (DynamicObject obj : objs.values()) {
            StringBuilder mapkey = new StringBuilder();
            for (int i = 0; i < entityKeys.length; ++i) {
                if (i > 0) {
                    mapkey = mapkey.append('_');
                }
                mapkey = mapkey.append(obj.getString(entityKeys[i]));
            }
            newObjs.put(mapkey.toString(), obj);
        }
        return newObjs;
    }
}

