/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.material;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.api.ApiTransaction;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.status.MaterialCtrlStrategyStatus;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.UserUtil;

public class MaterialSyncApi
extends MdrApi {
    private static final String BOS_ORG_ID = "100000";

    @ApiTransaction(propagation=Propagation.REQUIRED)
    public ApiResult materialAdd(Map<String, Object> data) {
        if (data != null) {
            ArrayList<Map> unitList = new ArrayList<Map>();
            DynamicObject material = null;
            Object number = data.get("number");
            Object name = data.get("name");
            Object modelNum = data.get("modelNum");
            Object helpCode = data.get("helpcode");
            Object description = data.get("description");
            Object grossWeight = data.get("grossWeight");
            Object netWeight = data.get("netWeight");
            Object length = data.get("length");
            Object width = data.get("width");
            Object height = data.get("height");
            Object volume = data.get("volume");
            Object materialgroupnumber = data.get("materialGroupNumber");
            Map lengthUnit = (Map)data.get("lengthUnit");
            Map volumnUnit = (Map)data.get("volumeUnit");
            Map weightUnit = (Map)data.get("weightUnit");
            Map baseUnit = (Map)data.get("baseUnit");
            Map auxPtyUnit = (Map)data.get("assistUnit");
            List multiUnits = (List)data.get("multiUnit");
            unitList.addAll(multiUnits);
            if (lengthUnit != null) {
                unitList.add(lengthUnit);
            }
            if (volumnUnit != null) {
                unitList.add(volumnUnit);
            }
            if (weightUnit != null) {
                unitList.add(weightUnit);
            }
            if (auxPtyUnit != null) {
                unitList.add(auxPtyUnit);
            }
            unitList.add(baseUnit);
            for (Map unit : unitList) {
                this.saveUnit(unit);
            }
            QFilter qFilter = new QFilter("number", "=", number);
            boolean exists = QueryServiceHelper.exists((String)"bd_material", (QFilter[])qFilter.toArray());
            if (exists) {
                DynamicObject materialId = QueryServiceHelper.queryOne((String)"bd_material", (String)"id", (QFilter[])qFilter.toArray());
                material = BusinessDataServiceHelper.loadSingle((Object)materialId.get("id"), (String)"bd_material");
                material.set("modifier", (Object)UserUtil.getUserInfo());
                material.set("modifytime", (Object)new Date());
            } else {
                material = BusinessDataServiceHelper.newDynamicObject((String)"bd_material");
                material.set("id", (Object)DBServiceHelper.genLongIds((String)"t_bd_material", (int)1)[0]);
                material.set("creator", (Object)UserUtil.getUserInfo());
                material.set("createtime", (Object)new Date());
            }
            DynamicObject standard = BusinessDataServiceHelper.loadSingle((String)"bd_materialgroupstandard", (String)"masterid,name,number,createorg", (QFilter[])new QFilter("id", "=", (Object)730148448254487552L).toArray());
            if (standard == null) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7269\u6599\u57fa\u672c\u5206\u7c7b\u6807\u51c6", (String)"MaterialSyncApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            List mgroups = (List)data.get("materialGroups");
            this.saveMaterialAndItemGroup(mgroups, standard);
            DynamicObject materialgroup = this.getDynamicObjectByNumber(materialgroupnumber.toString(), "bd_materialgroup");
            if (materialgroup == null) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u7269\u6599\u5206\u7ec4", (String)"MaterialSyncApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]), materialgroupnumber));
            }
            material.set("group", (Object)materialgroup);
            this.buildMaterialgroupstandard(material, materialgroup, standard);
            if (StringUtils.isNotEmpty((Object)name)) {
                material.set("name", name);
            }
            if (StringUtils.isNotEmpty((Object)number)) {
                material.set("number", number);
            }
            if (StringUtils.isNotEmpty((Object)modelNum)) {
                material.set("modelnum", modelNum);
            }
            material.set("status", (Object)"C");
            material.set("enable", (Object)1);
            material.set("helpcode", helpCode);
            material.set("description", description);
            DynamicObject createOrg = BusinessDataServiceHelper.loadSingle((Object)BOS_ORG_ID, (String)"bos_org");
            material.set("createorg", (Object)createOrg);
            material.set("org", (Object)createOrg);
            material.set("ctrlstrategy", (Object)MaterialCtrlStrategyStatus.SHARED_GLOBAL.getFlagStr());
            material.set("grossweight", grossWeight);
            material.set("netweight", netWeight);
            material.set("length", length);
            material.set("width", width);
            material.set("height", height);
            material.set("volume", volume);
            material.set("materialtype", (Object)1);
            if (lengthUnit != null) {
                material.set("lengthunit", (Object)this.getDynamicObjectByNumber(lengthUnit.get("unitNumber").toString(), "bd_measureunits"));
            }
            if (volumnUnit != null) {
                material.set("volumnunit", (Object)this.getDynamicObjectByNumber(volumnUnit.get("unitNumber").toString(), "bd_measureunits"));
            }
            if (weightUnit != null) {
                material.set("weightunit", (Object)this.getDynamicObjectByNumber(weightUnit.get("unitNumber").toString(), "bd_measureunits"));
            }
            if (auxPtyUnit != null) {
                material.set("auxptyunit", (Object)this.getDynamicObjectByNumber(auxPtyUnit.get("unitNumber").toString(), "bd_measureunits"));
            }
            material.set("baseunit", (Object)this.getDynamicObjectByNumber(baseUnit.get("unitNumber").toString(), "bd_measureunits"));
            OperationUtil.invokeOperation((DynamicObject)material, (String)"save");
            for (Map multiUnit : multiUnits) {
                DynamicObject multimeasureunit = null;
                DynamicObject multi = this.getDynamicObjectByNumber(multiUnit.get("unitNumber").toString(), "bd_measureunits");
                if (multi == null) {
                    logger.info("musave_error:" + multiUnit.get("unitNumber").toString());
                    continue;
                }
                QFilter multiQFilter = new QFilter("measureunitid", "=", multi.get("id"));
                multiQFilter.and("materialid", "=", material.get("id"));
                boolean multiExists = QueryServiceHelper.exists((String)"bd_multimeasureunit", (QFilter[])multiQFilter.toArray());
                if (!multiExists) {
                    multimeasureunit = BusinessDataServiceHelper.newDynamicObject((String)"bd_multimeasureunit");
                } else {
                    DynamicObject id = QueryServiceHelper.queryOne((String)"bd_multimeasureunit", (String)"id", (QFilter[])multiQFilter.toArray());
                    multimeasureunit = BusinessDataServiceHelper.loadSingle((Object)id.get("id"), (String)"bd_multimeasureunit");
                }
                Object numerator = multiUnit.get("numerator");
                Object denominator = multiUnit.get("denominator");
                multimeasureunit.set("measureunitid", (Object)multi);
                multimeasureunit.set("materialid", (Object)material);
                multimeasureunit.set("converttype", (Object)1);
                multimeasureunit.set("numerator", numerator);
                multimeasureunit.set("denominator", denominator);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{multimeasureunit});
            }
            return ApiResult.success(null);
        }
        return ApiResult.fail(null);
    }

    private void buildMaterialgroupstandard(DynamicObject material, DynamicObject materialgroup, DynamicObject standard) {
        DynamicObjectCollection col = material.getDynamicObjectCollection("entry_groupstandard");
        DynamicObject entityGroupDetail = new DynamicObject(col.getDynamicObjectType());
        entityGroupDetail.set("standardid", (Object)standard);
        entityGroupDetail.set("groupid", (Object)materialgroup);
        entityGroupDetail.set("materialid", (Object)material);
        col.add((Object)entityGroupDetail);
    }

    public ApiResult stopUsing(Map<String, Object> data) {
        if (data != null) {
            Object number = data.get("number");
            if (StringUtils.isEmpty((Object)number)) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570", (String)"MaterialSyncApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            Object id = this.getIdByNumber(number, "bd_material");
            if (StringUtils.isNotEmpty((Object)id)) {
                DynamicObject material = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_material");
                material.set("enable", (Object)"0");
                OperationUtil.invokeOperation((DynamicObject)material, (String)"save");
                return ApiResult.success(null);
            }
        }
        return ApiResult.fail(null);
    }

    public ApiResult startUsing(Map<String, Object> data) {
        if (data != null) {
            Object number = data.get("number");
            if (StringUtils.isEmpty((Object)number)) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570", (String)"MaterialSyncApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            Object id = this.getIdByNumber(number, "bd_material");
            if (StringUtils.isNotEmpty((Object)id)) {
                DynamicObject material = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_material");
                material.set("enable", (Object)"1");
                OperationUtil.invokeOperation((DynamicObject)material, (String)"save");
                return ApiResult.success(null);
            }
        }
        return ApiResult.fail(null);
    }

    private void saveUnit(Map<String, Object> unit) {
        Object unitNumber = unit.get("unitNumber");
        QFilter qFilter = new QFilter("number", "=", unitNumber);
        boolean existUnitNumber = QueryServiceHelper.exists((String)"bd_measureunits", (QFilter[])qFilter.toArray());
        if (!existUnitNumber) {
            DynamicObject newUnit = BusinessDataServiceHelper.newDynamicObject((String)"bd_measureunits");
            newUnit.set("name", unit.get("unitName"));
            newUnit.set("number", unit.get("unitNumber"));
            if (StringUtils.isEmpty((Object)unit.get("precisionaccount"))) {
                unit.put("precisionaccount", 1);
            }
            newUnit.set("precisionaccount", unit.get("precisionAccount"));
            newUnit.set("precision", unit.get("precision"));
            newUnit.set("enable", (Object)1);
            newUnit.set("status", (Object)Character.valueOf('C'));
            Map unitGroup = (Map)unit.get("unitGroup");
            DynamicObject unitgroup = this.getDynamicObjectByNumber(unitGroup.get("unitGroupNumber").toString(), "bd_measureunitsgroup");
            if (unitgroup == null) {
                DynamicObject newUnitGroup = BusinessDataServiceHelper.newDynamicObject((String)"bd_measureunitsgroup");
                newUnitGroup.set("number", unitGroup.get("unitGroupNumber"));
                newUnitGroup.set("name", unitGroup.get("unitGroupName"));
                newUnitGroup.set("description", unitGroup.get("description"));
                if (StringUtils.isEmpty(unitGroup.get("isPreset"))) {
                    unitGroup.put("ispreset", 1);
                }
                newUnitGroup.set("ispreset", unitGroup.get("isPreset"));
                newUnitGroup.set("enable", (Object)1);
                newUnitGroup.set("status", (Object)Character.valueOf('C'));
                OperationUtil.invokeOperation((DynamicObject)newUnitGroup, (String)"save");
                newUnit.set("group", (Object)newUnitGroup);
            } else {
                newUnit.set("group", (Object)unitgroup);
            }
            OperationUtil.invokeOperation((DynamicObject)newUnit, (String)"save");
        }
    }

    private void saveMaterialAndItemGroup(List<Map<String, Object>> grouplist, DynamicObject standard) {
        for (Map<String, Object> groupmap : grouplist) {
            Object parentnumber = groupmap.get("parentNumber");
            boolean ismgroupexist = QueryServiceHelper.exists((String)"bd_materialgroup", (QFilter[])new QFilter("number", "=", groupmap.get("number")).toArray());
            if (!ismgroupexist) {
                DynamicObject mgroup = BusinessDataServiceHelper.newDynamicObject((String)"bd_materialgroup");
                mgroup.set("number", groupmap.get("number"));
                mgroup.set("name", groupmap.get("name"));
                mgroup.set("fullname", groupmap.get("name"));
                mgroup.set("isleaf", groupmap.get("isleaf"));
                mgroup.set("level", groupmap.get("level"));
                mgroup.set("enable", (Object)1);
                mgroup.set("standard_id", (Object)730148448254487552L);
                mgroup.set("createorg_id", (Object)standard.getLong("createorg_id"));
                mgroup.set("status", (Object)Character.valueOf('C'));
                if (parentnumber != null) {
                    DynamicObject parent = this.getDynamicObjectByNumber(groupmap.get("parentNumber").toString(), "bd_materialgroup", "id,longnumber,level,fullname");
                    mgroup.set("parent", (Object)parent);
                    mgroup.set("longnumber", (Object)(parent.getString("longnumber") + "." + groupmap.get("number")));
                }
                OperationUtil.invokeOperation((DynamicObject)mgroup, (String)"save");
            }
            TXHandle h = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    boolean isiclassexist = QueryServiceHelper.exists((String)"mdr_item_class", (QFilter[])new QFilter("easnumber", "=", groupmap.get("number")).toArray());
                    if (isiclassexist) continue;
                    DynamicObject itemclass = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_class");
                    itemclass.set("number", groupmap.get("number"));
                    itemclass.set("name", groupmap.get("name"));
                    itemclass.set("easnumber", groupmap.get("number"));
                    itemclass.set("isleaf", groupmap.get("isleaf"));
                    itemclass.set("level", groupmap.get("level"));
                    itemclass.set("enable", (Object)1);
                    itemclass.set("status", (Object)Character.valueOf('C'));
                    itemclass.set("standard_id", (Object)1);
                    if (parentnumber != null) {
                        DynamicObject parent = this.getDynamicObjectByNumber(groupmap.get("parentNumber").toString(), "mdr_item_class", "id,longnumber,level,fullname");
                        itemclass.set("parent", (Object)parent);
                    }
                    OperationUtil.invokeOperation((DynamicObject)itemclass, (String)"save");
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
    }
}

