/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.money;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;

public class BalanceApi
extends MdrApi {
    public ApiResult query(Map<String, Object> data) {
        QFilter qf = new QFilter("status", "=", (Object)"C");
        qf.and("enable", "=", (Object)"1");
        Object page = null;
        Object pageSize = null;
        if (data != null) {
            page = data.get("page");
            pageSize = data.get("pageSize");
            Object ownerId = data.get("ownerId");
            if (StringUtils.isNotEmpty((Object)ownerId)) {
                qf.and("customer.id", "=", ownerId);
            }
            qf.and("owner.id", "=", UserUtil.getDefaultOwnerID());
        }
        String fileds = "id,number,creator.id,creator.name,owner.id,owner.name,customer.name,customer.id,balance,occupied,usable,currency.name";
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        BigDecimal bigDecimal = new BigDecimal(0);
        if (StringUtils.isEmpty((Object)page) && StringUtils.isEmpty((Object)pageSize)) {
            DynamicObject[] balances;
            for (DynamicObject balance : balances = BusinessDataServiceHelper.load((String)"mdr_balance", (String)fileds, (QFilter[])qf.toArray())) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                this.getBalanceInfo(balance, map);
                bigDecimal = bigDecimal.add(balance.getBigDecimal("balance"));
                list.add(map);
            }
        } else {
            DynamicObjectCollection balances = ORMUtil.query((String)"mdr_balance", (String)fileds, (QFilter[])qf.toArray(), null, (int)(((Integer)page - 1) * (Integer)pageSize), (int)((Integer)pageSize));
            for (DynamicObject balance : balances) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                this.getBalanceInfo(balance, map);
                bigDecimal = bigDecimal.add(balance.getBigDecimal("balance"));
                list.add(map);
            }
        }
        hashMap.put("totalBalance", bigDecimal.setScale(2, 4));
        hashMap.put("list", list);
        hashMap.put("count", Integer.valueOf(QueryUtil.querycount((String)"mdr_balance", (QFilter[])qf.toArray())));
        return ApiResult.success(hashMap);
    }

    private void getBalanceInfo(DynamicObject balance, Map<String, Object> map) {
        map.put("id", balance.getString("id"));
        map.put("number", balance.getString("number"));
        map.put("creatorId", balance.getString("creator.id"));
        map.put("creatorName", balance.getString("creator.name"));
        map.put("ownerId", balance.getString("owner.id"));
        map.put("ownerName", balance.getString("owner.name"));
        map.put("customerName", balance.getString("customer.name"));
        map.put("customerId", balance.getString("customer.id"));
        map.put("balance", balance.getBigDecimal("balance").setScale(2, 4));
        map.put("occupied", balance.getBigDecimal("occupied").setScale(2, 4));
        map.put("usable", balance.getBigDecimal("usable").setScale(2, 4));
        map.put("currency", balance.getString("currency.name"));
    }
}

