/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.money;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UserUtil;

public class ReceivingBillApi
extends MdrApi {
    public ApiResult queryList(Map<String, Object> data) {
        this.checkRecordField(data, "page", "pageSize");
        int page = (Integer)data.get("page");
        int pageSize = (Integer)data.get("pageSize");
        Object startTime = data.get("startTime");
        Object endTime = data.get("endTime");
        Object ownerId = data.get("ownerId");
        Object receivingType = data.get("receivingType");
        QFilter qf = new QFilter("1", "=", (Object)"1");
        qf.and("status", "=", (Object)"C");
        qf.and("owner.id", "=", UserUtil.getDefaultOwnerID());
        if (StringUtils.isNotEmpty((Object)ownerId)) {
            qf.and("contactscustomer.id", "=", ownerId);
        }
        if (StringUtils.isNotEmpty((Object)startTime)) {
            qf.and("createtime", ">=", startTime);
        }
        if (StringUtils.isNotEmpty((Object)endTime)) {
            qf.and("createtime", "<=", endTime);
        }
        if (receivingType != null) {
            qf.and("receivingtype", "in", (Object)((List)receivingType));
        }
        String fields = "id,owner.id,owner.name,contactscustomer.id,contactscustomer.name,number,contactscustomer,receivingtype,paymenttype,paymentchannel,paymenttime,remark,amount,order";
        DynamicObjectCollection receivingBills = ORMUtil.query((String)"mdr_money_receivingbill", (String)fields, (QFilter[])qf.toArray(), (String)"createtime desc", (int)((page - 1) * pageSize), (int)pageSize);
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        BigDecimal bigDecimal = new BigDecimal(0);
        if (receivingBills != null && receivingBills.size() > 0) {
            for (DynamicObject receivingBill : receivingBills) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                bigDecimal = bigDecimal.add(receivingBill.getBigDecimal("amount"));
                this.getReceivingBillInfo(receivingBill, map);
                list.add(map);
            }
        }
        data.clear();
        data.put("list", list);
        data.put("totalMoney", bigDecimal.setScale(2, 4));
        int count = QueryUtil.querycount((String)"mdr_money_receivingbill", (QFilter[])qf.toArray());
        data.put("count", count);
        return ApiResult.success(data);
    }

    public ApiResult queryDetails(Map<String, Object> data) {
        this.checkRecordField(data, "id");
        Object id = data.get("id");
        String fields = "id,owner.id,owner.name,creatorid.name,createtime,currency.name,contactscustomer.id,contactscustomer.name,number,contactscustomer,receivingtype,paymenttype,paymentchannel,paymenttime,remark,amount,order";
        DynamicObject receivingBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mdr_money_receivingbill", (String)fields);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (receivingBill != null) {
            this.getReceivingBillInfo(receivingBill, map);
            map.put("creatorName", receivingBill.getString("creatorid.name"));
            map.put("createTime", receivingBill.getString("createtime"));
            map.put("currency", receivingBill.getString("currency.name"));
        }
        return ApiResult.success(map);
    }

    private void getReceivingBillInfo(DynamicObject receivingBill, HashMap<String, Object> map) {
        map.put("id", receivingBill.getString("id"));
        map.put("number", receivingBill.getString("number"));
        map.put("orderNumber", receivingBill.getString("order"));
        map.put("ownerName", receivingBill.getString("owner.name"));
        map.put("ownerId", receivingBill.getString("owner.id"));
        map.put("contactsCustomerId", receivingBill.getString("contactscustomer.id"));
        map.put("contactsCustomerName", receivingBill.getString("contactscustomer.name"));
        map.put("receivingType", receivingBill.getString("receivingtype"));
        if ("0".equals(receivingBill.getString("paymenttype"))) {
            map.put("paymentType", ResManager.loadKDString((String)"\u7ebf\u4e0b\u652f\u4ed8", (String)"ReceivingBillApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if ("0".equals(receivingBill.getString("paymentchannel"))) {
            map.put("paymentChannel", ResManager.loadKDString((String)"\u73b0\u91d1", (String)"ReceivingBillApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        } else if ("1".equals(receivingBill.getString("paymentchannel"))) {
            map.put("paymentChannel", ResManager.loadKDString((String)"\u94f6\u884c\u8f6c\u8d26", (String)"ReceivingBillApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        map.put("paymentTime", receivingBill.getString("paymenttime").substring(0, receivingBill.getString("paymenttime").length() - 2));
        map.put("remark", receivingBill.getString("remark"));
        map.put("amount", receivingBill.getBigDecimal("amount").setScale(2, 4));
    }
}

