/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.WFXOrderType;
import kd.drp.mdr.common.apiclient.wens.EASApiInvokeService;
import kd.drp.mdr.common.handler.DispatchOrderHandler;
import kd.drp.mdr.common.matetype.Dto;
import kd.drp.mdr.common.status.DispatchOrderStatus;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.OperationUtil;

public class OrderSyncApi
extends MdrApi {
    public ApiResult invalid(Map<String, Object> map) {
        Map<String, Object> data = this.getData(map);
        String orderId = (String)data.get("orderid");
        String ordertype = (String)data.get("ordertype");
        String reason = (String)data.get("reason");
        String entityName = "";
        if (WFXOrderType.SALE_ORDER.getType().equals(ordertype)) {
            entityName = "bbc_saleorder";
        } else if (WFXOrderType.DISPATCH_ORDER.getType().equals(ordertype)) {
            entityName = "mdr_dispatch_order";
        } else {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u79fb\u52a8\u5206\u9500\u8ba2\u5355\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u4f5c\u5e9f\uff01", (String)"OrderSyncApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)entityName);
        order.set("invalidreason", (Object)String.format(ResManager.loadKDString((String)"EAS\u8ba2\u5355\u4f5c\u5e9f\uff0c\u4f5c\u5e9f\u539f\u56e0\uff1a%s", (String)"OrderSyncApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]), reason));
        DynamicObjectCollection itementry = order.getDynamicObjectCollection("itementry");
        for (DynamicObject entry : itementry) {
            entry.set("qty", (Object)0);
        }
        if (WFXOrderType.SALE_ORDER.getType().equals(ordertype)) {
            order.set("orderstatus", (Object)SaleOrderStatus.CHANGING.getFlagStr());
        } else if (WFXOrderType.DISPATCH_ORDER.getType().equals(ordertype)) {
            DispatchOrderHandler.reHandleOrderQtysAndAmounts((DynamicObject)order);
            order.set("orderstatus", (Object)DispatchOrderStatus.CHANGING.getFlagStr());
        }
        String message = OperationUtil.invokeOperationToStr((DynamicObject)order, (String)"save");
        if (message != null) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u5206\u9500\u4f5c\u5e9f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0:%s", (String)"OrderSyncApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]), message));
        }
        return ApiResult.success(null);
    }

    public ApiResult syncChanging(Map<String, Object> data) {
        if (data != null) {
            Object orderId = data.get("orderId");
            ArrayList entryList = (ArrayList)data.get("entry");
            String delids = (String)data.get("deleteEntryIds");
            String[] ids = null;
            if (delids != null) {
                ids = delids.split(",");
            }
            DynamicObject order = null;
            if (!StringUtils.isNotEmpty((Object)orderId) || !QueryServiceHelper.exists((String)"bbc_saleorder", (Object)orderId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355id\u65e0\u6548,id\u4e3a\u7a7a\u6216\u8ba2\u5355\u4e0d\u5b58\u5728 ", (String)"OrderSyncApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            order = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"bbc_saleorder");
            DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("itementry");
            for (DynamicObject orderEntry : orderEntrys) {
                for (int i = 0; i < entryList.size(); ++i) {
                    String orderEntryId = ((Map)entryList.get(i)).get("id").toString();
                    if (!orderEntryId.equals(orderEntry.getPkValue().toString())) continue;
                    if (StringUtils.isNotEmpty(((Map)entryList.get(i)).get("qty"))) {
                        BigDecimal qty = new BigDecimal(((Map)entryList.get(i)).get("qty").toString());
                        BigDecimal deliveredQty = new BigDecimal(((Map)entryList.get(i)).get("deliveredqty").toString());
                        if (deliveredQty.compareTo(qty) > 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u6570\u91cf\u5c0f\u4e8e\u5df2\u53d1\u8d27\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01", (String)"OrderSyncApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                        }
                        orderEntry.set("qty", ((Map)entryList.get(i)).get("qty"));
                        if (((Map)entryList.get(i)).get("amount") != null) {
                            orderEntry.set("orderamount", ((Map)entryList.get(i)).get("amount"));
                        }
                        if (((Map)entryList.get(i)).get("alreadyreceqty") != null) {
                            orderEntry.set("alreadyreceqty", ((Map)entryList.get(i)).get("alreadyreceqty"));
                        }
                        if (((Map)entryList.get(i)).get("alreadyreceamount") != null) {
                            orderEntry.set("alreadyreceamount", ((Map)entryList.get(i)).get("alreadyreceamount"));
                        }
                    }
                    if (ids == null || ids.length <= 0) continue;
                    for (String id : ids) {
                        if (!id.equals(orderEntry.getPkValue().toString())) continue;
                        orderEntry.set("qty", (Object)0);
                        orderEntry.set("orderamount", (Object)0);
                    }
                }
            }
            order.set("orderstatus", (Object)SaleOrderStatus.CHANGING.getFlagStr());
            order.set("itementry", (Object)orderEntrys);
            String msg = OperationUtil.invokeOperationToStr((DynamicObject)order, (String)"save");
            if (StringUtils.isNotEmpty((String)msg)) {
                return ApiResult.fail((String)msg);
            }
            return ApiResult.success((Object)msg);
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6570\u636e", (String)"OrderSyncApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]));
    }

    public ApiResult orderSync(Map<String, Object> data) {
        Dto dto = EASApiInvokeService.send((String)"orderSync", data);
        return ApiResult.success((Object)dto);
    }

    public ApiResult orderCancelSync(Map<String, Object> data) {
        Dto dto = EASApiInvokeService.send((String)"orderCancelSync", data);
        return ApiResult.success((Object)dto);
    }
}

