/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.purorder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.Propagation;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.api.ApiTransaction;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.handler.ReceivingBillHandler;
import kd.drp.mdr.common.handler.SaleOrderHandler;
import kd.drp.mdr.common.handler.UnitBatchHandler;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.common.model.Result;
import kd.drp.mdr.common.status.DispatchOrderSyncStatus;
import kd.drp.mdr.common.status.SaleOrderConfirmStatus;
import kd.drp.mdr.common.status.SaleOrderEvaluateStatus;
import kd.drp.mdr.common.status.SaleOrderPayStatus;
import kd.drp.mdr.common.status.SaleOrderReceStatus;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.status.SaleOrderSyncStatus;
import kd.drp.mdr.common.util.AdmindivisionUtil;
import kd.drp.mdr.common.util.CodeRuleUtil;
import kd.drp.mdr.common.util.CustomerSalerUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.SynDispatchOrderUtil;
import kd.drp.mdr.common.util.SynSaleOrderUtil;
import kd.drp.mdr.common.util.UnitUtil;
import kd.drp.mdr.common.util.UserUtil;

public class PurOrderApi
extends MdrApi {
    private Object defaultowner = null;
    private UnitBatchHandler unitHandler;

    @ApiTransaction(propagation=Propagation.REQUIRED)
    public ApiResult save(Map<String, Object> data) {
        this.checkRecordField(data, "orderItem");
        CheckResult before = this.before(data);
        if (!before.isSuccess()) {
            throw new KDBizException(before.getMsg());
        }
        List orderList = (List)data.get("orderItem");
        ArrayList<DynamicObject> purOrderList = new ArrayList<DynamicObject>();
        ArrayList<String> shoppingCartList = new ArrayList<String>();
        DynamicObject purOrder = null;
        for (int i = 0; i < orderList.size(); ++i) {
            Map orderMap = (Map)orderList.get(i);
            purOrder = BusinessDataServiceHelper.newDynamicObject((String)"dpa_purorder");
            this.setOrderHeader(purOrder, orderMap, data);
            this.setOrderEntry(shoppingCartList, purOrder, orderMap);
            this.calcNumber(purOrder);
            purOrder = this.setPurOrder(purOrder);
            purOrderList.add(purOrder);
        }
        for (int index = 0; index < purOrderList.size(); ++index) {
            String mark = ((DynamicObject)purOrderList.get(index)).getDynamicObject("owner").getString("name");
            DynamicObject order = purOrderList.get(index);
            String submitMsg = OperationUtil.invokeOperationToStr((DynamicObject)order, (String)"submit");
            if (!StringUtils.isNotEmpty((String)submitMsg)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u4e3a%s %s", (String)"PurOrderApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]), mark, submitMsg));
        }
        Result after = this.after(purOrderList);
        if (!after.isSuccess()) {
            throw new KDBizException(after.getMsg());
        }
        if (shoppingCartList.size() > 0 && shoppingCartList != null) {
            QFilter qf = new QFilter("id", "in", shoppingCartList);
            DeleteServiceHelper.delete((String)"mdr_shopping_cart", (QFilter[])qf.toArray());
        }
        return ApiResult.success(null);
    }

    private Object getDefaultOwnerID() {
        if (this.defaultowner == null) {
            this.defaultowner = UserUtil.getDefaultOwnerID();
        }
        return this.defaultowner;
    }

    protected UnitBatchHandler getUnitBatchHandler() {
        if (this.unitHandler == null) {
            this.unitHandler = new UnitBatchHandler();
        }
        return this.unitHandler;
    }

    private void setOrderHeader(DynamicObject purOrder, Map<String, Object> orderMap, Map<String, Object> data) {
        DynamicObject customer = null;
        String consigneeId = (String)data.get("consigneeId");
        String consigneeAddress = (String)data.get("consigneeAddress");
        String consigneePhone = (String)data.get("consigneePhone");
        String consigneeName = (String)data.get("consigneeName");
        String driverId = (String)data.get("driverId");
        String driverPhone = (String)data.get("driverPhone");
        String driverNub = (String)data.get("driverNub");
        String ownerId = (String)orderMap.get("ownerId");
        String customerId = (String)orderMap.get("customerId");
        String bizType = (String)orderMap.get("bizTypeNumber");
        String orderRemark = (String)orderMap.get("orderRemark");
        String ownerName = "";
        if (!StringUtils.isNotEmpty((String)ownerId) || !QueryServiceHelper.exists((String)"mdr_customer", (Object)ownerId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u6e20\u9053id", (String)"PurOrderApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject owner = BusinessDataServiceHelper.loadSingle((Object)ownerId, (String)"mdr_customer");
        purOrder.set("owner", (Object)owner);
        ownerName = owner.getString("name");
        if (StringUtils.isNotEmpty((String)customerId) && QueryServiceHelper.exists((String)"mdr_customer", (Object)customerId)) {
            customer = BusinessDataServiceHelper.loadSingle((Object)customerId, (String)"mdr_customer");
            purOrder.set("customer", (Object)customer);
        } else {
            customer = BusinessDataServiceHelper.loadSingle((Object)this.getDefaultOwnerID(), (String)"mdr_customer");
            purOrder.set("customer", (Object)customer);
        }
        customerId = customer.getString("id");
        if (!CustomerUtil.isAuthRelation((Object)ownerId, (Object)customerId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0e\u9500\u552e\u6e20\u9053[%s]\u4e0d\u5b58\u5728\u8ba2\u8d27\u5173\u7cfb\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (String)"PurOrderApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]), ownerName));
        }
        purOrder.set("billno", (Object)CodeRuleUtil.getCodeRule((String)"dpa_purorder"));
        purOrder.set("customerordernum", purOrder.get("billno"));
        DynamicObject defaultBizTypeInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_biztype", (String)"number,name,id,easnumber,bizcategory,enable", (QFilter[])new QFilter("number", "=", (Object)"210").toArray());
        if (StringUtils.isEmpty((String)bizType)) {
            purOrder.set("bizType", (Object)defaultBizTypeInfo);
        } else {
            DynamicObject bizTypeInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_biztype", (String)"number,name,id,easnumber,bizcategory,enable", (QFilter[])new QFilter("number", "=", (Object)bizType).toArray());
            if (StringUtils.isEmpty((Object)bizTypeInfo)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u7f16\u7801\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u63d0\u4ea4", (String)"PurOrderApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            purOrder.set("bizType", (Object)bizTypeInfo);
        }
        purOrder.set("orderremark", (Object)orderRemark);
        purOrder.set("isusebalance", (Object)Boolean.FALSE);
        purOrder.set("billstatus", (Object)"B");
        purOrder.set("orderstatus", (Object)SaleOrderStatus.TEMP_SAVE.getFlagStr());
        purOrder.set("confirmstatus", (Object)SaleOrderConfirmStatus.EMPTY.getFlagStr());
        purOrder.set("paystatus", (Object)SaleOrderPayStatus.NOT_PAID.getFlagStr());
        purOrder.set("sync", (Object)SaleOrderSyncStatus.NO_SYNC.getFlagStr());
        purOrder.set("amountstatus", (Object)SaleOrderReceStatus.NO_RECE.getFlagStr());
        purOrder.set("evaluatestatus", (Object)SaleOrderEvaluateStatus.EMPT.getFlagStr());
        purOrder.set("billingtype", (Object)"A");
        purOrder.set("currency", (Object)1);
        purOrder.set("createtime", (Object)new Date());
        purOrder.set("orderdate", (Object)new Date());
        purOrder.set("creator", UserUtil.getDefaultOwnerID());
        DynamicObject currency = BusinessDataServiceHelper.loadSingle((Object)1L, (String)"bd_currency");
        purOrder.set("currency", (Object)currency);
        List salers = CustomerSalerUtil.queryCustomerSalerPK((Object)customerId, (Object)ownerId);
        if (salers.size() > 0) {
            purOrder.set("saler", salers.get(0));
        }
        if (StringUtils.isNotEmpty((String)consigneeId) && QueryServiceHelper.exists((String)"mdr_customer_address", (Object)consigneeId)) {
            DynamicObject consigneeInfo = BusinessDataServiceHelper.loadSingle((Object)consigneeId, (String)"mdr_customer_address");
            purOrder.set("consigneeaddress", (Object)consigneeInfo);
            purOrder.set("address", (Object)(AdmindivisionUtil.queryAreaFullNameByNumber((Object)consigneeInfo.getString("address")) + consigneeInfo.getString("address2")));
            purOrder.set("consigneephone", (Object)consigneeInfo.getString("telephone"));
            purOrder.set("consignee", (Object)consigneeInfo.getString("contactname"));
        } else {
            if (StringUtils.isNotEmpty((String)consigneeName)) {
                purOrder.set("consignee", (Object)consigneeName);
            }
            if (StringUtils.isNotEmpty((String)consigneeName)) {
                purOrder.set("consigneephone", (Object)consigneePhone);
            }
            if (StringUtils.isNotEmpty((String)consigneeName)) {
                purOrder.set("address", (Object)consigneeAddress);
            }
        }
        if (StringUtils.isNotEmpty((String)driverId) && QueryServiceHelper.exists((String)"mdr_driver", (Object)driverId)) {
            DynamicObject driver = BusinessDataServiceHelper.loadSingle((Object)driverId, (String)"mdr_driver");
            purOrder.set("driver", (Object)driver);
        }
        if (StringUtils.isNotEmpty((String)driverPhone)) {
            purOrder.set("drivertel", (Object)driverPhone);
        }
        if (StringUtils.isNotEmpty((String)driverNub)) {
            purOrder.set("carno", (Object)driverNub);
        }
    }

    private BigDecimal setOrderEntry(List<String> shoppingCartList, DynamicObject purOrder, Map<String, Object> orderMap) {
        DynamicObject owner = purOrder.getDynamicObject("owner");
        Object ownerId = owner.get("id");
        String ownerName = owner.getString("name");
        Object customerId = purOrder.getDynamicObject("customer").get("id");
        List entries = (List)orderMap.get("itemEntry");
        if (entries.size() <= 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u4e3a%s\u81f3\u5c11\u9700\u4f20\u4e00\u6761\u5206\u5f55", (String)"PurOrderApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]), ownerName));
        }
        BigDecimal subtotal = BigDecimal.ZERO;
        DynamicObjectCollection itementry = purOrder.getDynamicObjectCollection("itementry");
        for (int j = 0; j < entries.size(); ++j) {
            BigDecimal newAssistQty;
            DynamicObject itemEntry = itementry.addNew();
            String itemId = (String)((Map)entries.get(j)).get("itemId");
            String unitId = null;
            String assistUnitId = null;
            Object priceObj = ((Map)entries.get(j)).get("price");
            if (StringUtils.isEmpty(priceObj)) {
                priceObj = BigDecimal.ZERO;
            }
            BigDecimal price = new BigDecimal(priceObj.toString());
            String shoppingCartId = (String)((Map)entries.get(j)).get("shoppingCartId");
            DynamicObject itemObj = null;
            if (StringUtils.isNotEmpty((String)itemId) && QueryServiceHelper.exists((String)"mdr_item_info", (Object)itemId)) {
                String filed = "number,name,modelnum,hasattr,thumbnail,conversionfor,name,id,isonsell,easnum,referenceprice,remark,assistunit,baseunit";
                itemObj = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"mdr_item_info", (String)filed);
                if ("0".equals(itemObj.get("isonsell"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u5df2\u88ab\u4e0b\u67b6", (String)"PurOrderApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]), itemObj.get("name")));
                }
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u4e3a%s\u7684\u8ba2\u5355\u672a\u67e5\u8be2\u5230\u76f8\u5173\u5546\u54c1\u4fe1\u606f", (String)"PurOrderApi_6", (String)"drp-mdr-webapi", (Object[])new Object[0]), ownerName));
            }
            itemEntry.set("item", (Object)itemObj);
            itemEntry.set("itemtitle", itemObj.get("name"));
            Map qtyAndUnitMap = UnitUtil.setQtyAndUnit((Map)((Map)entries.get(j)), (DynamicObject)itemObj);
            BigDecimal newQty = qtyAndUnitMap.get("newQty") != null ? (BigDecimal)qtyAndUnitMap.get("newQty") : null;
            unitId = qtyAndUnitMap.get("unitId") + "";
            DynamicObject unitInfo = BusinessDataServiceHelper.loadSingle((Object)unitId, (String)"bd_measureunits");
            itemEntry.set("unit", (Object)unitInfo);
            itemEntry.set("qty", (Object)newQty);
            itemEntry.set("alterqty", (Object)newQty);
            Object baseUnitId = this.getUnitBatchHandler().getBaseUnitId((Object)itemId);
            if (baseUnitId != null) {
                itemEntry.set("baseunit", (Object)BusinessDataServiceHelper.loadSingle((Object)baseUnitId, (String)"bd_measureunits", (String)"id,name,number"));
            }
            BigDecimal baseQty = this.getUnitBatchHandler().getBaseQty((Object)itemId, newQty, unitInfo.getPkValue());
            itemEntry.set("baseqty", (Object)baseQty);
            itemEntry.set("alterbaseqty", (Object)baseQty);
            assistUnitId = qtyAndUnitMap.get("assistUnitId") + "";
            BigDecimal bigDecimal = newAssistQty = qtyAndUnitMap.get("newAssistQty") != null ? (BigDecimal)qtyAndUnitMap.get("newAssistQty") : null;
            if (QueryServiceHelper.exists((String)"bd_measureunits", (Object)assistUnitId)) {
                itemEntry.set("assistunit", (Object)BusinessDataServiceHelper.loadSingle((Object)assistUnitId, (String)"bd_measureunits", (String)"id,name,number,precisionaccount,precision,conversiontype"));
            }
            itemEntry.set("alterassistqty", (Object)newAssistQty);
            itemEntry.set("assistqty", (Object)newAssistQty);
            Object assistAttrId = ((Map)entries.get(j)).get("assistAttrId");
            Boolean hasattr = (Boolean)itemObj.get("hasattr");
            if (hasattr.booleanValue()) {
                if (StringUtils.isNotEmpty(assistAttrId)) {
                    DynamicObject assistattr = BusinessDataServiceHelper.loadSingle(assistAttrId, (String)"mdr_item_attrvalue", (String)"id,name,number");
                    itemEntry.set("assistattr", (Object)assistattr);
                    assistAttrId = assistattr.get("id");
                } else {
                    Object defaultAttrId = ItemAttrUtil.getDefaultAttrId((Object)itemId);
                    DynamicObject assistattr = BusinessDataServiceHelper.loadSingle((Object)defaultAttrId, (String)"mdr_item_attrvalue", (String)"id,name,number");
                    itemEntry.set("assistattr", (Object)assistattr);
                    assistAttrId = defaultAttrId;
                }
            } else {
                itemEntry.set("assistattr", null);
                assistAttrId = null;
            }
            BigDecimal itemPrice = null;
            if (StringUtils.isNotEmpty((String)unitId)) {
                itemPrice = this.checkPrice(ownerId, customerId, itemObj.get("id"), unitId, assistAttrId, newQty, new Date(), price);
            }
            if (itemPrice == null || BigDecimal.ZERO.compareTo(itemPrice) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u4ef7\u683c\u5f02\u5e38,\u8bf7\u5237\u65b0\u540e\u52a0\u5165", (String)"PurOrderApi_7", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            ItemStoreUtil.isAllowOverStore((Object)itemId, (Object)ownerId, assistAttrId, (BigDecimal)newQty, (Object)unitId, (Object)assistUnitId);
            itemEntry.set("price", (Object)itemPrice);
            itemEntry.set("itemprice", (Object)itemPrice);
            if (StringUtils.isEmpty((String)itemEntry.getString("isevaluate"))) {
                itemEntry.set("isevaluate", (Object)"0");
            }
            itemEntry.set("orderamount", (Object)price.multiply(itemEntry.getBigDecimal("qty")));
            itemEntry.set("primamount", (Object)price.multiply(itemEntry.getBigDecimal("qty")));
            itemEntry.set("itemamount", (Object)itemPrice.multiply(itemEntry.getBigDecimal("qty")));
            subtotal = subtotal.add(itemEntry.getBigDecimal("itemamount"));
            shoppingCartList.add(shoppingCartId);
        }
        purOrder.set("itemEntry", (Object)itementry);
        return subtotal;
    }

    protected DynamicObject setPurOrder(DynamicObject purOrder) {
        return purOrder;
    }

    protected Result after(ArrayList<DynamicObject> purOrderList) {
        return CheckResult.returnTrue();
    }

    protected CheckResult before(Map<String, Object> data) {
        return CheckResult.returnTrue();
    }

    private void calcNumber(DynamicObject order) {
    }

    public ApiResult delete(Map<String, Object> data) {
        int delete;
        this.checkRecordField(data, "id");
        String id = (String)data.get("id");
        if (QueryServiceHelper.exists((String)"dpa_purorder", (Object)id) && (delete = DeleteServiceHelper.delete((String)"dpa_purorder", (QFilter[])new QFilter("id", "=", (Object)id).toArray())) < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"PurOrderApi_8", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        return ApiResult.success(null);
    }

    protected BigDecimal checkPrice(Object ownerId, Object customerId, Object itemId, Object unitId, Object assistAttrId, BigDecimal qty, Date date, BigDecimal price) {
        BigDecimal itemPrice = PriceUtil.getItemPrice((Object)ownerId, (Object)customerId, (Object)itemId, (Object)unitId, (Object)assistAttrId, (BigDecimal)qty, (Date)date);
        if (itemPrice.compareTo(price) != 0) {
            return null;
        }
        return itemPrice;
    }

    public ApiResult pseDelete(Map<String, Object> data) {
        DynamicObject saleOrder;
        String msg;
        this.checkRecordField(data, "id");
        String id = (String)data.get("id");
        if (QueryServiceHelper.exists((String)"dpa_purorder", (Object)id) && StringUtils.isNotEmpty((String)(msg = OperationUtil.invokeOperationToStr((DynamicObject)(saleOrder = BusinessDataServiceHelper.loadSingle((Object)id, (String)"dpa_purorder")), (String)"psedelete")))) {
            throw new KDBizException(msg);
        }
        return ApiResult.success(null);
    }

    public ApiResult queryByOrderStatus(Map<String, Object> data) {
        this.checkRecordField(data, "status");
        QFilter qFilter = new QFilter("1", "=", (Object)"1");
        int from = 0;
        int length = -1;
        int pageSize = 20;
        int page = 1;
        long customerId = (Long)UserUtil.getDefaultOwnerID();
        qFilter.and("customer.id", "=", (Object)customerId);
        String status = (String)data.get("status");
        String isDelete = (String)data.get("isDelete");
        Object createTime = data.get("createTime");
        Object ownerName = data.get("ownerName");
        if (StringUtils.isNotEmpty((Object)data.get("pageSize"))) {
            pageSize = (Integer)data.get("pageSize");
        }
        if (StringUtils.isNotEmpty((Object)data.get("page"))) {
            page = (Integer)data.get("page");
        }
        if (StringUtils.isNotEmpty((Object)createTime)) {
            qFilter.and("createtime", "=", createTime);
        }
        if (StringUtils.isNotEmpty((Object)ownerName)) {
            qFilter.and("owner.name", "like", (Object)("%" + ownerName + "%"));
        }
        if (StringUtils.isEmpty((String)isDelete)) {
            isDelete = "0";
        }
        qFilter.and("isdelete", "=", (Object)isDelete);
        switch (status) {
            case "O": {
                break;
            }
            case "A": {
                qFilter.and("orderstatus", "=", (Object)"B");
                break;
            }
            case "C": {
                qFilter.and("orderstatus", "=", (Object)"C");
                break;
            }
            case "B": {
                qFilter.and("evaluatestatus", "=", (Object)"B");
                break;
            }
            case "D": {
                qFilter.and("evaluatestatus", "=", (Object)"C");
                break;
            }
            case "E": {
                qFilter.and("orderstatus", "=", (Object)"E");
                break;
            }
            case "H": {
                qFilter.and("orderstatus", "=", (Object)"H");
                break;
            }
            case "I": {
                qFilter.and("orderstatus", "=", (Object)"I");
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"status\u503c\u5f02\u5e38", (String)"PurOrderApi_9", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
        }
        from = (page - 1) * pageSize;
        length = pageSize;
        ArrayList list = new ArrayList();
        DynamicObjectCollection load = ORMUtil.query((String)"bbc_saleorder", (String)"id", (QFilter[])qFilter.toArray(), (String)"createtime desc", (int)from, (int)length);
        if (page > 1 && load == null) {
            page = 1;
            from = 0;
            load = ORMUtil.query((String)"bbc_saleorder", (String)"id", (QFilter[])qFilter.toArray(), (String)"createtime desc", (int)from, (int)length);
        }
        for (DynamicObject dynamicObject : load) {
            DynamicObject pic;
            DynamicObject bizpartner;
            HashMap<String, Object> map = new HashMap<String, Object>(27);
            if (!QueryServiceHelper.exists((String)"bbc_saleorder", (Object)dynamicObject.getLong("id"))) continue;
            DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("id"), (String)"bbc_saleorder");
            map.put("orderId", order.getString("id"));
            map.put("orderNum", order.getString("billno"));
            map.put("createTime", order.getDate("createtime"));
            BigDecimal totalitemamount = (BigDecimal)order.get("totalitemamount");
            map.put("totalItemAmount", totalitemamount.setScale(2, 4).toPlainString());
            map.put("ownerId", order.getString("owner.id"));
            map.put("ownerName", order.getString("owner.name"));
            map.put("customerId", order.getString("customer.id"));
            map.put("customerName", order.getString("customer.name"));
            map.put("arrivalDate", order.getDate("arrivaldate"));
            map.put("confirmArrivalDate", order.getDate("confirmarrivaldate"));
            map.put("totalAlterBaseQty", order.getBigDecimal("totalalterbaseqty").setScale(2, 4));
            map.put("totalBaseQty", order.getBigDecimal("totalbaseqty").setScale(2, 4));
            map.put("totalAlterAssistQty", order.getBigDecimal("totalalterassistqty").setScale(2, 4));
            map.put("totalAssistQty", order.getBigDecimal("totalassistqty").setScale(2, 4));
            map.put("orderRemark", order.getString("orderremark"));
            map.put("evaluateStatus", order.getString("evaluatestatus"));
            Object id = order.get("owner.id");
            String picture = "";
            if (StringUtils.isEmpty((Object)id) || !QueryServiceHelper.exists((String)"mdr_customer", (Object)id)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u5546\u5bb6\u6e20\u9053ID", (String)"PurOrderApi_10", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            DynamicObject drpUser = QueryServiceHelper.queryOne((String)"dbd_drp_user", (String)"sysuser", (QFilter[])new QFilter("owner", "=", id).toArray());
            if (drpUser != null && (bizpartner = QueryServiceHelper.queryOne((String)"bos_bizpartneruser", (String)"bizpartner.id", (QFilter[])new QFilter("user.id", "=", drpUser.get("sysuser")).toArray())) != null && (pic = QueryServiceHelper.queryOne((String)"bd_bizpartner", (String)"picturefield", (QFilter[])new QFilter("id", "=", bizpartner.get("bizpartner.id")).toArray())) != null) {
                picture = (String)pic.get("picturefield");
            }
            map.put("ownerPic", picture);
            map.put("biztypeId", order.getString("biztype.id"));
            map.put("biztypeName", order.getString("biztype.name"));
            map.put("biztypeBizcategory", order.getString("biztype.bizcategory"));
            map.put("biztypeEasNumber", order.getString("biztype.easnumber"));
            boolean orderEvaExists = QueryServiceHelper.exists((String)"mdr_bill_evaluate_manage", (QFilter[])new QFilter("billnumber.id", "=", (Object)order.getString("id")).toArray());
            String evaluateStatus = order.getString("evaluatestatus");
            String orderStatus = order.getString("orderstatus");
            map.put("orderStatus", orderStatus);
            map.put("paysSatus", order.getString("paystatus"));
            if (orderEvaExists && "B".equals(evaluateStatus)) {
                map.put("evaluateStatus", "D");
            } else {
                map.put("evaluateStatus", evaluateStatus);
            }
            if ("A".equals(evaluateStatus)) {
                switch (orderStatus) {
                    case "A": {
                        map.put("statusText", ResManager.loadKDString((String)"\u5546\u5bb6\u62d2\u63a5\u6b64\u5355", (String)"PurOrderApi_11", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                        break;
                    }
                    case "B": {
                        map.put("statusText", ResManager.loadKDString((String)"\u5f85\u786e\u8ba4", (String)"PurOrderApi_12", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                        break;
                    }
                    case "C": {
                        map.put("statusText", ResManager.loadKDString((String)"\u5f85\u53d1\u8d27", (String)"PurOrderApi_13", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                        break;
                    }
                    case "D": {
                        map.put("statusText", ResManager.loadKDString((String)"\u90e8\u5206\u53d1\u8d27", (String)"PurOrderApi_14", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                        break;
                    }
                    case "E": {
                        map.put("statusText", ResManager.loadKDString((String)"\u5f85\u6536\u8d27", (String)"PurOrderApi_15", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                        break;
                    }
                    case "I": {
                        map.put("statusText", ResManager.loadKDString((String)"\u5df2\u4f5c\u5e9f", (String)"PurOrderApi_16", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                        break;
                    }
                    case "J": {
                        map.put("statusText", ResManager.loadKDString((String)"\u5f85\u5206\u8d27", (String)"PurOrderApi_17", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                        break;
                    }
                    case "K": {
                        map.put("statusText", ResManager.loadKDString((String)"\u90e8\u5206\u5206\u8d27", (String)"PurOrderApi_18", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                        break;
                    }
                    case "L": {
                        map.put("statusText", ResManager.loadKDString((String)"\u5df2\u5206\u8d27", (String)"PurOrderApi_19", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                        break;
                    }
                    case "M": {
                        map.put("statusText", ResManager.loadKDString((String)"\u4e34\u65f6", (String)"PurOrderApi_20", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                    }
                }
            } else if ("B".equals(evaluateStatus)) {
                if (QueryServiceHelper.exists((String)"mdr_bill_evaluate_manage", (QFilter[])new QFilter("billnumber.id", "=", (Object)order.getString("id")).toArray())) {
                    map.put("statusText", ResManager.loadKDString((String)"\u8bc4\u8bba\u5ba1\u6838\u4e2d", (String)"PurOrderApi_21", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                } else {
                    map.put("statusText", ResManager.loadKDString((String)"\u5f85\u8bc4\u8bba", (String)"PurOrderApi_22", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                }
            } else if ("C".equals(evaluateStatus) && "H".equals(orderStatus)) {
                map.put("statusText", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"PurOrderApi_23", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            map.put("status", status);
            ArrayList<HashMap<String, Object>> itementryList = new ArrayList<HashMap<String, Object>>();
            DynamicObjectCollection itementryCollection = order.getDynamicObjectCollection("itementry");
            for (DynamicObject itementry : itementryCollection) {
                Map<String, Object> hashMap = new HashMap<String, Object>(18);
                long itemId = itementry.getLong("item.id");
                DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"mdr_item_info", (String)"id,number,name,thumbnail,isassistorder");
                hashMap.put("itemName", item.getString("name"));
                hashMap.put("itemId", item.getString("id"));
                hashMap.put("itemTitle", item.getString("name"));
                hashMap.put("itemNum", item.getString("number"));
                hashMap.put("isEvaluate", itementry.get("isevaluate"));
                hashMap.put("itemPic", item.getString("thumbnail"));
                if (item.getString("thumbnail") == null) {
                    hashMap.put("itemPic", " ");
                }
                hashMap.put("isAssistOrder", item.getBoolean("isassistorder"));
                hashMap.put("itemAssistUnitName", itementry.getString("assistunit.name"));
                hashMap.put("itemAssistUnitId", itementry.getString("assistunit.id"));
                hashMap.put("alterAssistQty", itementry.getBigDecimal("assistqty").setScale(2, 4));
                hashMap.put("itemEntryId", itementry.getString("id"));
                hashMap.put("alterQty", itementry.getBigDecimal("alterqty").setScale(2, 4));
                hashMap.put("itemPrice", itementry.getBigDecimal("price").setScale(2, 4));
                hashMap.put("itemUnitId", itementry.getString("unit.id"));
                hashMap.put("itemUnitName", itementry.getString("unit.name"));
                hashMap.put("assistattrId", itementry.getString("assistattr.id"));
                hashMap.put("assistattrName", itementry.getString("assistattr.name"));
                hashMap = this.setItemEntry(itementry, hashMap);
                itementryList.add((HashMap<String, Object>)hashMap);
            }
            map.put("itemList", itementryList);
            list.add(map);
        }
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>(4);
        resultMap.put("list", list);
        int querycount = QueryUtil.querycount((String)"bbc_saleorder", (QFilter[])qFilter.toArray());
        resultMap.put("count", Integer.valueOf(querycount));
        resultMap.put("page", Integer.valueOf(page));
        resultMap.put("pageSize", Integer.valueOf(pageSize));
        return ApiResult.success(resultMap);
    }

    private Map<String, Object> setItemEntry(DynamicObject itementry, Map<String, Object> hashMap) {
        return hashMap;
    }

    public ApiResult queryCountOrderStatus(Map<String, Object> data) {
        long customerId = (Long)UserUtil.getDefaultOwnerID();
        QFilter qFilter = new QFilter("customer.id", "=", (Object)customerId);
        qFilter.and("isdelete", "=", (Object)"0");
        int allNum = QueryUtil.querycount((String)"bbc_saleorder", (QFilter[])qFilter.toArray());
        qFilter.and("orderstatus", "=", (Object)"B");
        int unconfirmed = QueryUtil.querycount((String)"bbc_saleorder", (QFilter[])qFilter.toArray());
        QFilter qFilter2 = new QFilter("customer.id", "=", (Object)customerId);
        qFilter2.and("isdelete", "=", (Object)"0");
        qFilter2.and("orderstatus", "=", (Object)"C");
        int unshipped = QueryUtil.querycount((String)"bbc_saleorder", (QFilter[])qFilter2.toArray());
        QFilter qFilter3 = new QFilter("customer.id", "=", (Object)customerId);
        qFilter3.and("orderstatus", "=", (Object)"E");
        qFilter3.and("isdelete", "=", (Object)"0");
        int unreceived = QueryUtil.querycount((String)"bbc_saleorder", (QFilter[])qFilter3.toArray());
        QFilter qFilter4 = new QFilter("customer.id", "=", (Object)customerId);
        qFilter4.and("evaluatestatus", "=", (Object)"B");
        qFilter4.and("isdelete", "=", (Object)"0");
        int unevaluated = QueryUtil.querycount((String)"bbc_saleorder", (QFilter[])qFilter4.toArray());
        QFilter qFilter5 = new QFilter("customer.id", "=", (Object)customerId);
        qFilter5.and("paystatus", "=", (Object)"A");
        qFilter5.and("isdelete", "=", (Object)"0");
        int unpay = QueryUtil.querycount((String)"bbc_saleorder", (QFilter[])qFilter5.toArray());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("allNum", allNum);
        map.put("unConfirmed", unconfirmed);
        map.put("unShipped", unshipped);
        map.put("unReceived", unreceived);
        map.put("unEvaluated", unevaluated);
        map.put("unPay", unpay);
        return ApiResult.success(map);
    }

    public ApiResult cancelOrder(Map<String, Object> data) {
        this.checkRecordField(data, "orderId");
        String orderIdData = (String)data.get("orderId");
        QFilter qFilter = new QFilter("id", "=", (Object)orderIdData);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bbc_saleorder", (String)"id", (QFilter[])qFilter.toArray());
        if (queryOne == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728", (String)"PurOrderApi_24", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        long orderId = queryOne.getLong("id");
        DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"bbc_saleorder");
        if (!"B".equals(order.getString("orderstatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba2\u5355\u4e0d\u80fd\u53d6\u6d88\uff01", (String)"PurOrderApi_25", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        order.set("orderstatus", (Object)"A");
        OperationUtil.invokeOperation((DynamicObject)order, (String)"invalid");
        return ApiResult.success(null);
    }

    public ApiResult queryOrderDetail(Map<String, Object> data) {
        DynamicObject pic;
        DynamicObject bizpartner;
        this.checkRecordField(data, "orderId");
        String orderIdData = (String)data.get("orderId");
        if (!QueryServiceHelper.exists((String)"bbc_saleorder", (Object)orderIdData)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728!!", (String)"PurOrderApi_26", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(orderIdData), (String)"bbc_saleorder");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderNum", order.getString("billno"));
        map.put("orderCreateTime", order.getDate("createtime"));
        map.put("orderId", order.getLong("id") + "");
        boolean orderEvaExists = QueryServiceHelper.exists((String)"mdr_bill_evaluate_manage", (QFilter[])new QFilter("billnumber.id", "=", (Object)order.getString("id")).toArray());
        String evaluateStatus = order.getString("evaluatestatus");
        String orderStatus = order.getString("orderstatus");
        map.put("orderStatus", order.getString("orderstatus"));
        map.put("paysSatus", order.getString("paystatus"));
        map.put("evaluateStatus", evaluateStatus);
        if (orderEvaExists && "B".equals(evaluateStatus)) {
            map.put("evaluateStatus", "D");
        } else {
            map.put("evaluateStatus", evaluateStatus);
        }
        if ("A".equals(evaluateStatus)) {
            switch (orderStatus) {
                case "A": {
                    map.put("statusText", ResManager.loadKDString((String)"\u5546\u5bb6\u62d2\u63a5\u6b64\u5355", (String)"PurOrderApi_11", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                    break;
                }
                case "B": {
                    map.put("statusText", ResManager.loadKDString((String)"\u5f85\u786e\u8ba4", (String)"PurOrderApi_12", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                    break;
                }
                case "C": {
                    map.put("statusText", ResManager.loadKDString((String)"\u5f85\u53d1\u8d27", (String)"PurOrderApi_13", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                    break;
                }
                case "D": {
                    map.put("statusText", ResManager.loadKDString((String)"\u90e8\u5206\u53d1\u8d27", (String)"PurOrderApi_14", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                    break;
                }
                case "E": {
                    map.put("statusText", ResManager.loadKDString((String)"\u5f85\u6536\u8d27", (String)"PurOrderApi_15", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                    break;
                }
                case "I": {
                    map.put("statusText", ResManager.loadKDString((String)"\u5df2\u4f5c\u5e9f", (String)"PurOrderApi_16", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                    break;
                }
                case "J": {
                    map.put("statusText", ResManager.loadKDString((String)"\u5f85\u5206\u8d27", (String)"PurOrderApi_17", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                    break;
                }
                case "K": {
                    map.put("statusText", ResManager.loadKDString((String)"\u90e8\u5206\u5206\u8d27", (String)"PurOrderApi_18", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                    break;
                }
                case "L": {
                    map.put("statusText", ResManager.loadKDString((String)"\u5df2\u5206\u8d27", (String)"PurOrderApi_19", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                    break;
                }
                case "M": {
                    map.put("statusText", ResManager.loadKDString((String)"\u4e34\u65f6", (String)"PurOrderApi_20", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                }
            }
        } else if ("B".equals(evaluateStatus)) {
            if (QueryServiceHelper.exists((String)"mdr_bill_evaluate_manage", (QFilter[])new QFilter("billnumber.id", "=", (Object)order.getString("id")).toArray())) {
                map.put("statusText", ResManager.loadKDString((String)"\u8bc4\u8bba\u5ba1\u6838\u4e2d", (String)"PurOrderApi_21", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            } else {
                map.put("statusText", ResManager.loadKDString((String)"\u5f85\u8bc4\u8bba", (String)"PurOrderApi_22", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
        } else if ("C".equals(evaluateStatus) && "H".equals(orderStatus)) {
            map.put("statusText", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"PurOrderApi_23", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        Object id = order.get("owner.id");
        String picture = "";
        if (StringUtils.isEmpty((Object)id) || !QueryServiceHelper.exists((String)"mdr_customer", (Object)id)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u5546\u5bb6\u6e20\u9053ID", (String)"PurOrderApi_10", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject user = QueryServiceHelper.queryOne((String)"dbd_drp_user", (String)"sysuser", (QFilter[])new QFilter("owner", "=", id).toArray());
        if (user != null && (bizpartner = QueryServiceHelper.queryOne((String)"bos_bizpartneruser", (String)"bizpartner.id", (QFilter[])new QFilter("user.id", "=", user.get("sysuser")).toArray())) != null && (pic = QueryServiceHelper.queryOne((String)"bd_bizpartner", (String)"picturefield", (QFilter[])new QFilter("id", "=", bizpartner.get("bizpartner.id")).toArray())) != null) {
            picture = (String)pic.get("picturefield");
        }
        map.put("ownerPic", picture);
        map.put("ownerId", order.getString("owner.id"));
        map.put("ownerName", order.getString("owner.name"));
        map.put("customerId", order.getString("customer.id"));
        map.put("customerName", order.getString("customer.name"));
        HashMap<String, String> driverMap = new HashMap<String, String>();
        driverMap.put("driverID", order.getString("driver.id"));
        driverMap.put("driverName", order.getString("driver.name"));
        driverMap.put("driverTel", order.getString("drivertel"));
        driverMap.put("carno", order.getString("carno"));
        DynamicObject[] drivers = BusinessDataServiceHelper.load((String)"mdr_driver", (String)"customerentry", (QFilter[])new QFilter("id", "=", order.get("driver.id")).toArray());
        if (drivers != null && drivers.length > 1) {
            DynamicObjectCollection customerentryCollection = drivers[0].getDynamicObjectCollection("customerentry");
            for (DynamicObject customerentry : customerentryCollection) {
                if (!UserUtil.getDefaultOwnerID().equals(customerentry.get("customer.id"))) continue;
                driverMap.put("carTypeName", customerentry.getString("cartype.name"));
                driverMap.put("carTypeId", customerentry.getString("cartype.id"));
            }
        } else {
            driverMap.put("carTypeName", null);
            driverMap.put("carTypeId", null);
        }
        map.put("driverMap", driverMap);
        map.put("tranSportTypeName", order.getString("transporttype.name"));
        map.put("consignee", order.getString("consignee"));
        map.put("consigneePhone", order.getString("consigneephone"));
        map.put("address", order.getString("address"));
        map.put("arrivalDate", order.getDate("arrivaldate"));
        map.put("orderRemark", order.getString("orderremark"));
        BigDecimal transportprice = (BigDecimal)order.get("transportprice");
        map.put("transportPrice", transportprice.setScale(2, 4).toPlainString());
        DynamicObjectCollection itementryCollection = order.getDynamicObjectCollection("itementry");
        ArrayList<HashMap<String, Object>> itementryList = new ArrayList<HashMap<String, Object>>();
        for (DynamicObject itementry : itementryCollection) {
            Map<String, Object> hashMap = new HashMap<String, Object>(18);
            hashMap.put("itemEntryId", itementry.getString("id"));
            long itemId = itementry.getLong("item.id");
            DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"mdr_item_info", (String)"id,number,isassistorder,name,thumbnail");
            hashMap.put("itemName", item.getString("name"));
            hashMap.put("itemId", item.getString("id"));
            hashMap.put("itemTitle", item.getString("name"));
            hashMap.put("isAssistOrder", item.getBoolean("isassistorder"));
            hashMap.put("itemNum", item.getString("number"));
            hashMap.put("itemPic", item.getString("thumbnail"));
            hashMap.put("isEvaluate", itementry.get("isevaluate"));
            if (item.getString("thumbnail") == null) {
                hashMap.put("itemPic", " ");
            }
            hashMap.put("alterQty", itementry.getBigDecimal("qty").setScale(2, 4));
            hashMap.put("itemPrice", itementry.getBigDecimal("itemprice").setScale(2, 4));
            hashMap.put("itemUnitId", itementry.getString("unit.id"));
            hashMap.put("itemUnitName", itementry.getString("unit.name"));
            hashMap.put("itemAssistUnitName", itementry.getString("assistunit.name"));
            hashMap.put("itemAssistUnitId", itementry.getString("assistunit.id"));
            hashMap.put("alterAssistQty", itementry.getBigDecimal("assistqty").setScale(2, 4));
            hashMap.put("assistattrId", itementry.getString("assistattr.id"));
            hashMap.put("assistattrName", itementry.getString("assistattr.name"));
            hashMap = this.setItemEntry(itementry, hashMap);
            itementryList.add((HashMap<String, Object>)hashMap);
        }
        map.put("items", itementryList);
        BigDecimal totalqty = (BigDecimal)order.get("totalalterqty");
        BigDecimal totalitemamount = (BigDecimal)order.get("totalitemamount");
        BigDecimal totalorderamount = (BigDecimal)order.get("totalorderamount");
        map.put("totalqty", totalqty.setScale(2, 4).toPlainString());
        map.put("totalItemAmount", totalitemamount.setScale(2, 4).toPlainString());
        map.put("totalOrderAmount", totalorderamount.setScale(2, 4).toPlainString());
        return ApiResult.success(map);
    }

    public ApiResult queryOrderOpTime(Map<String, Object> data) throws ParseException {
        this.checkRecordField(data, "orderId");
        Object orderId = data.get("orderId");
        if (!QueryServiceHelper.exists((String)"bbc_saleorder", (Object)orderId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728", (String)"PurOrderApi_24", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        QFilter qf = new QFilter("orderid", "=", orderId);
        qf.and("ordertype", "=", (Object)"saleorder");
        String selectFields = "operatekey,createdate";
        DynamicObjectCollection orderLogCollection = QueryServiceHelper.query((String)"mdr_order_op_log", (String)selectFields, (QFilter[])qf.toArray());
        HashMap<String, Date> map = new HashMap<String, Date>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (DynamicObject orderLog : orderLogCollection) {
            String operatekey = orderLog.getString("operatekey");
            Date createdate = orderLog.getDate("createdate");
            switch (operatekey) {
                case "\u4fdd\u5b58": {
                    if (map.get("submit") != null) {
                        if (!sdf.parse(map.get("submit").toString()).after(createdate)) break;
                        break;
                    }
                    map.put("submit", createdate);
                    break;
                }
                case "\u53d1\u8d27": {
                    if (map.get("todelivery") != null) {
                        if (!sdf.parse(map.get("todelivery").toString()).after(createdate)) break;
                        break;
                    }
                    map.put("todelivery", createdate);
                    break;
                }
                case "\u6536\u6b3e": {
                    if (map.get("topay") != null) {
                        if (!sdf.parse(map.get("topay").toString()).after(createdate)) break;
                        break;
                    }
                    map.put("topay", createdate);
                    break;
                }
                case "\u786e\u8ba4\u6536\u8d27": {
                    if (map.get("tosign") != null) {
                        if (!sdf.parse(map.get("tosign").toString()).after(createdate)) break;
                        break;
                    }
                    map.put("tosign", createdate);
                }
            }
        }
        return ApiResult.success(map);
    }

    @ApiTransaction(propagation=Propagation.REQUIRED)
    public ApiResult antiSyncSaleOrder(Map<String, Object> data) {
        String orderIdData = (String)data.get("orderid");
        String isAntiSyncUnAuditOrder = (String)data.get("isAntiSyncUnAuditOrder");
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(orderIdData));
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bbc_saleorder", (String)"id,eassaleorderno", (QFilter[])qFilter.toArray());
        if (queryOne == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728", (String)"PurOrderApi_24", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        long orderId = queryOne.getLong("id");
        String easSaleOrderNo = queryOne.getString("eassaleorderno");
        SynSaleOrderUtil.setSynStatus((Object)orderId, (SaleOrderSyncStatus)SaleOrderSyncStatus.NOT_SYNC, (String[])new String[]{" "});
        String resultMsg = "";
        if ("1".equals(isAntiSyncUnAuditOrder)) {
            DynamicObject order = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"bbc_saleorder");
            order.set("orderstatus", (Object)SaleOrderStatus.TEMP_SAVE.getFlagStr());
            order.set("billstatus", (Object)"A");
            Object[] saveResult = SaveServiceHelper.save((IDataEntityType)order.getDataEntityType(), (Object[])new DynamicObject[]{order});
            if (saveResult == null) {
                resultMsg = ResManager.loadKDString((String)"\u8ba2\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (String)"PurOrderApi_27", (String)"drp-mdr-webapi", (Object[])new Object[0]);
                throw new KDBizException(resultMsg);
            }
            SaleOrderUtil.handleStoreReverse((DynamicObject)order);
            if (order.getBoolean("isusebalance")) {
                ReceivingBillHandler.handleRefundsBill((DynamicObject)order, null, (boolean)false);
                ReceivingBillHandler.handleOffsetBill((DynamicObject)order, (boolean)false, null);
            }
            SaleOrderHandler.reHandleOrderPayStatus((DynamicObject)order);
            SaleOrderUtil.handleAfterUnAudit((DynamicObject[])new DynamicObject[]{order});
            SaleOrderUtil.handleRebate4EndUnAudit((DynamicObject[])new DynamicObject[]{order});
        }
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            SynSaleOrderUtil.setSynStatus((Object)orderId, (SaleOrderSyncStatus)SaleOrderSyncStatus.ALREADY_SYNC, (String[])new String[]{easSaleOrderNo});
            return ApiResult.fail((String)resultMsg);
        }
        return ApiResult.success(null);
    }

    @ApiTransaction(propagation=Propagation.REQUIRED)
    public ApiResult antiSyncDispatchOrder(Map<String, Object> data) {
        String orderIdData = (String)data.get("orderid");
        QFilter qFilter = new QFilter("id", "=", (Object)orderIdData);
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"mdr_dispatch_order", (String)"id", (QFilter[])qFilter.toArray());
        if (queryOne == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728", (String)"PurOrderApi_24", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        long orderId = queryOne.getLong("id");
        SynDispatchOrderUtil.setSynStatus((Object)orderId, (DispatchOrderSyncStatus)DispatchOrderSyncStatus.NOT_SYNC);
        return ApiResult.success(null);
    }
}

