/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.returnorder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.api.ApiTransaction;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.AdmindivisionUtil;
import kd.drp.mdr.common.util.CodeRuleUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UnitUtil;
import kd.drp.mdr.common.util.UserUtil;

public class ReturnOrderApi
extends MdrApi {
    public ApiResult returnOrderListQuery(Map<String, Object> data) {
        if (data == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53c2\u6570", (String)"ReturnOrderApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        int page = 1;
        int pageSize = 10;
        if (data.get("page") != null && (Integer)data.get("page") > 1) {
            page = (Integer)data.get("page");
        }
        if (data.get("pageSize") != null && (Integer)data.get("pageSize") > 1) {
            pageSize = (Integer)data.get("pageSize");
        }
        Object orderId = data.get("orderId");
        Object returnOrderNumber = data.get("returnOrderNumber");
        QFilter qFilter = new QFilter("isdelete", "=", (Object)"0");
        if (StringUtils.isNotEmpty((Object)orderId)) {
            qFilter.and("itementry.sourcebillid", "=", orderId);
        }
        if (StringUtils.isNotEmpty((Object)data.get("billStatus"))) {
            qFilter.and("billstatus", "=", data.get("billStatus"));
        }
        if (StringUtils.isNotEmpty((Object)returnOrderNumber)) {
            qFilter.and("billno", "=", returnOrderNumber);
        }
        DynamicObjectCollection returnOrderCol = ORMUtil.query((String)"mdr_returnorder_req", (String)"id", (QFilter[])qFilter.toArray(), null, (int)((page - 1) * pageSize), (int)pageSize);
        int size = 0;
        if (returnOrderCol != null && returnOrderCol.size() > 0) {
            size = returnOrderCol.size();
        }
        ArrayList<Object> returnOrderList = new ArrayList<Object>(size);
        if (size > 0) {
            for (DynamicObject dynamicObject : returnOrderCol) {
                DynamicObject[] object = dynamicObject.get("id");
                returnOrderList.add(object);
            }
        }
        IDataEntityType type = BusinessDataServiceHelper.newDynamicObject((String)"mdr_returnorder_req").getDataEntityType();
        DynamicObject[] returnOrderCollection = (DynamicObject[])BusinessDataServiceHelper.load((Object[])returnOrderList.toArray(), (IDataEntityType)type);
        returnOrderList.clear();
        if (returnOrderCollection != null && returnOrderCollection.length > 0) {
            for (DynamicObject returnOrder : returnOrderCollection) {
                HashMap<String, Object> returnOrderMap = new HashMap<String, Object>(7);
                returnOrderMap.put("id", returnOrder.get("id").toString());
                returnOrderMap.put("number", returnOrder.get("billno"));
                returnOrderMap.put("billStatus", returnOrder.get("billstatus"));
                returnOrderMap.put("createTime", returnOrder.get("createtime"));
                returnOrderMap.put("ownerId", returnOrder.get("owner.id"));
                returnOrderMap.put("ownerName", returnOrder.get("owner.name"));
                DynamicObjectCollection returnOrderEntryCollection = returnOrder.getDynamicObjectCollection("itementry");
                size = 0;
                if (returnOrderEntryCollection != null && returnOrderEntryCollection.size() > 0) {
                    size = returnOrderEntryCollection.size();
                }
                ArrayList arrayList = new ArrayList(size);
                if (size > 0) {
                    for (DynamicObject returnOrderEntry : returnOrderEntryCollection) {
                        HashMap<String, Object> entryMap = new HashMap<String, Object>(11);
                        DynamicObject item = returnOrderEntry.getDynamicObject("item");
                        Object itemId = item.get("id");
                        DynamicObject itemName = QueryServiceHelper.queryOne((String)"mdr_item_info", (String)"isassistorder,name", (QFilter[])new QFilter("id", "=", itemId).toArray());
                        entryMap.put("itemName", itemName.get("name"));
                        entryMap.put("itemPic", item.get("thumbnail"));
                        entryMap.put("isAssistOrder", itemName.getBoolean("isassistorder"));
                        entryMap.put("itemAssistUnitName", returnOrderEntry.getString("assistunit.name"));
                        entryMap.put("itemAssistUnitId", returnOrderEntry.getString("assistunit.id"));
                        entryMap.put("alterAssistQty", returnOrderEntry.getBigDecimal("assistqty").setScale(2, 4));
                        entryMap.put("itemUnitName", returnOrderEntry.getString("unit.name"));
                        entryMap.put("itemUnitId", returnOrderEntry.getString("unit.id"));
                        entryMap.put("qty", returnOrderEntry.getBigDecimal("qty").setScale(2, 4));
                        entryMap.put("orderId", returnOrderEntry.get("sourcebillid"));
                        entryMap.put("orderNumber", returnOrderEntry.get("sourcebillnumber"));
                        arrayList.add(entryMap);
                    }
                }
                returnOrderMap.put("entry", arrayList);
                returnOrderList.add(returnOrderMap);
            }
        }
        int count = QueryUtil.querycount((String)"mdr_returnorder_req", (QFilter[])qFilter.toArray());
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("list", returnOrderList);
        map.put("count", Integer.valueOf(count));
        return ApiResult.success(map);
    }

    public ApiResult queryOne(Map<String, Object> data) {
        QFilter q = new QFilter("isdelete", "=", (Object)"0");
        if (data == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5165\u53c2\u4e0d\u5f97\u4e3a\u7a7a", (String)"ReturnOrderApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        String id = (String)data.get("id");
        q.and("id", "=", (Object)id);
        if (StringUtils.isEmpty((Object)QueryServiceHelper.exists((String)"mdr_returnorder_req", (Object)id))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165id\u65e0\u6548\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u5b58\u5728", (String)"ReturnOrderApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject returnOrderInfo = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(id), (String)"mdr_returnorder_req");
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("ownerId", returnOrderInfo.get("owner.id"));
        returnMap.put("ownerName", returnOrderInfo.get("owner.name"));
        returnMap.put("detailAddress", returnOrderInfo.get("detailaddress"));
        returnMap.put("consigneeName", returnOrderInfo.get("consigneename"));
        returnMap.put("consigneePhone", returnOrderInfo.get("consigneephone"));
        returnMap.put("returnReason", returnOrderInfo.get("returnreason"));
        Object assistantId = returnOrderInfo.getDynamicObject("assistant").get("id");
        DynamicObject assistant = BusinessDataServiceHelper.loadSingle((Object)assistantId, (String)"bos_assistantdata_detail");
        returnMap.put("assistantName", assistant.get("name.zh_CN"));
        returnMap.put("returnType", returnOrderInfo.get("returntype"));
        returnMap.put("createTime", returnOrderInfo.get("createtime"));
        returnMap.put("creator", returnOrderInfo.get("creator.name.zh_CN"));
        Object billStatus = returnOrderInfo.get("billstatus");
        if (billStatus.equals("C")) {
            returnMap.put("auditor", returnOrderInfo.get("auditor.name.zh_CN"));
            returnMap.put("auditDate", returnOrderInfo.get("auditdate"));
        } else if (billStatus.equals("D")) {
            returnMap.put("invalidUser", returnOrderInfo.get("invaliduser.name.zh_CN"));
            returnMap.put("invalidDate", returnOrderInfo.get("invaliddate"));
        }
        returnMap.put("status", returnOrderInfo.get("billstatus"));
        return ApiResult.success(returnMap);
    }

    @ApiTransaction(propagation=Propagation.REQUIRED)
    public ApiResult save(Map<String, Object> data) {
        if (data == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570", (String)"ReturnOrderApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        List itemList = (List)data.get("itemList");
        List pictureList = (List)data.get("pictures");
        String ownerId = (String)data.get("ownerId");
        String submitTypeId = (String)data.get("submitTypeId");
        String returnReason = (String)data.get("returnReason");
        List addressList = (List)data.get("address");
        String detailAddress = (String)data.get("detailAddress");
        String customerName = (String)data.get("customerName");
        String customerPhone = (String)data.get("customerPhone");
        String returnType = (String)data.get("returnType");
        DynamicObject returnOrderReq = BusinessDataServiceHelper.newDynamicObject((String)"mdr_returnorder_req");
        returnOrderReq.set("billno", (Object)CodeRuleUtil.getCodeRule((String)"mdr_returnorder_req"));
        Object customerId = UserUtil.getDefaultOwnerID();
        if (StringUtils.isNotEmpty((Object)customerId) && QueryServiceHelper.exists((String)"mdr_customer", (Object)customerId)) {
            DynamicObject customer = BusinessDataServiceHelper.loadSingle((Object)customerId, (String)"mdr_customer");
            returnOrderReq.set("customer", (Object)customer);
        }
        if (!StringUtils.isNotEmpty((String)ownerId) || !QueryServiceHelper.exists((String)"mdr_customer", (Object)ownerId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f9b\u8d27\u5546\u4e0d\u5b58\u5728", (String)"ReturnOrderApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject owner = BusinessDataServiceHelper.loadSingle((Object)ownerId, (String)"mdr_customer");
        returnOrderReq.set("owner", (Object)owner);
        if (StringUtils.isEmpty((String)returnType)) {
            returnOrderReq.set("returntype", (Object)"1");
        } else {
            returnOrderReq.set("returntype", (Object)returnType);
        }
        returnOrderReq.set("billstatus", (Object)"A");
        if (!StringUtils.isNotEmpty((String)submitTypeId) || !QueryServiceHelper.exists((String)"bos_assistantdata_detail", (Object)submitTypeId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u9000\u8d27\u539f\u56e0id", (String)"ReturnOrderApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject assistant = BusinessDataServiceHelper.loadSingle((Object)submitTypeId, (String)"bos_assistantdata_detail");
        returnOrderReq.set("assistant", (Object)assistant);
        returnOrderReq.set("billdate", (Object)new Date());
        returnOrderReq.set("returnreason", (Object)returnReason);
        Object userID = UserUtil.getUserID();
        DynamicObject creator = BusinessDataServiceHelper.loadSingle((Object)userID, (String)"bos_user");
        returnOrderReq.set("creator", (Object)creator);
        returnOrderReq.set("createtime", (Object)new Date());
        returnOrderReq.set("consigneename", (Object)customerName);
        returnOrderReq.set("consigneephone", (Object)customerPhone);
        String addressStr = (String)addressList.get(addressList.size() - 1);
        String address = AdmindivisionUtil.queryAreaFullNameByNumber((Object)addressStr);
        returnOrderReq.set("detailaddress", (Object)(address + detailAddress));
        if (itemList == null || itemList.size() <= 0) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u4f20\u5165\u4e00\u6761\u5206\u5f55", (String)"ReturnOrderApi_6", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObjectCollection itementry = returnOrderReq.getDynamicObjectCollection("itementry");
        for (int i = 0; i < itemList.size(); ++i) {
            Map item = (Map)itemList.get(i);
            String itemId = (String)item.get("itemId");
            Object remark = item.get("remark");
            Object orderId = item.get("orderId");
            Object orderEntryId = item.get("orderEntryId");
            Object orderType = item.get("orderType");
            Object price = item.get("price");
            Object amount = item.get("amount");
            String unitId = null;
            String assistUnitId = null;
            BigDecimal newQty = null;
            BigDecimal newAssistQty = null;
            DynamicObject entry = itementry.addNew();
            if (StringUtils.isNotEmpty((String)itemId) && QueryServiceHelper.exists((String)"mdr_item_info", (Object)itemId)) {
                DynamicObject itemInfo = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"mdr_item_info");
                entry.set("item", (Object)itemInfo);
                item.put("qty", data.get("qty"));
                item.put("assistQty", data.get("assistQty"));
                Map qtyAndUnitMap = UnitUtil.setQtyAndUnit((Map)item, (DynamicObject)itemInfo);
                newQty = qtyAndUnitMap.get("newQty") != null ? (BigDecimal)qtyAndUnitMap.get("newQty") : null;
                newAssistQty = qtyAndUnitMap.get("newAssistQty") != null ? (BigDecimal)qtyAndUnitMap.get("newAssistQty") : null;
                unitId = (String)qtyAndUnitMap.get("unitId");
                assistUnitId = (String)qtyAndUnitMap.get("assistUnitId");
                unitId = qtyAndUnitMap.get("unitId") + "";
                assistUnitId = qtyAndUnitMap.get("assistUnitId") + "";
            }
            entry.set("unit", (Object)BusinessDataServiceHelper.loadSingle(unitId, (String)"bd_measureunits", (String)"id,name,number,precisionaccount,precision,conversiontype"));
            if (QueryServiceHelper.exists((String)"bd_measureunits", assistUnitId)) {
                entry.set("assistunit", (Object)BusinessDataServiceHelper.loadSingle(assistUnitId, (String)"bd_measureunits", (String)"id,name,number,precisionaccount,precision,conversiontype"));
            }
            entry.set("qty", newQty);
            entry.set("assistqty", newAssistQty);
            if (StringUtils.isEmpty(orderType)) {
                entry.set("sourcebilltype", (Object)"0");
            } else {
                entry.set("sourcebilltype", orderType);
            }
            entry.set("remark", remark);
            if (StringUtils.isNotEmpty(orderId) && QueryServiceHelper.exists((String)"bbc_saleorder", orderId)) {
                DynamicObject order = QueryServiceHelper.queryOne((String)"bbc_saleorder", (String)"billno", (QFilter[])new QFilter("id", "=", orderId).toArray());
                entry.set("sourcebillnumber", order.get("billno"));
            }
            entry.set("sourcebillid", orderId);
            entry.set("sourcebillentryid", orderEntryId);
            entry.set("itemprice", price);
            entry.set("amount", amount);
        }
        returnOrderReq.set("itementry", (Object)itementry);
        OperationUtil.invokeOperation((DynamicObject)returnOrderReq, (String)"submit");
        if (pictureList != null && pictureList.size() > 0) {
            ArrayList<Map<String, Object>> attachmentList = new ArrayList<Map<String, Object>>(pictureList.size());
            for (int i = 0; i < pictureList.size(); ++i) {
                HashMap<String, Object> attachmentMap = new HashMap<String, Object>();
                String url = (String)pictureList.get(i);
                String name = url.substring(url.lastIndexOf(47) + 1);
                attachmentMap.put("size", 0);
                attachmentMap.put("name", name);
                attachmentMap.put("url", url);
                attachmentList.add(attachmentMap);
            }
            try {
                this.addAttachment(returnOrderReq.get("id"), attachmentList);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u5f02\u5e38", (String)"ReturnOrderApi_7", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
        }
        return ApiResult.success(null);
    }

    private void addAttachment(Object id, List<Map<String, Object>> attachmentList) throws Exception {
        try (TXHandle h = TX.beginNew();){
            try {
                ArrayList attachments = new ArrayList(attachmentList.size());
                for (Map<String, Object> attachmentMap : attachmentList) {
                    HashMap<String, Object> uploadMap = new HashMap<String, Object>();
                    String format = new SimpleDateFormat("yyyyMMSSHHMMSS").format(new Date());
                    format = "ydfx-upload-" + format;
                    uploadMap.put("uid", format);
                    uploadMap.put("size", attachmentMap.get("size"));
                    uploadMap.put("name", attachmentMap.get("name"));
                    uploadMap.put("url", attachmentMap.get("url"));
                    attachments.add(uploadMap);
                }
                AttachmentServiceHelper.upload((String)"mdr_purorder", (Object)id, (String)"attachmentpanel", attachments);
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    public ApiResult delete(Map<String, Object> data) {
        if (data == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570", (String)"ReturnOrderApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        Object id = data.get("id");
        if (id != null) {
            DynamicObject returnOrder = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mdr_returnorder_req");
            OperationUtil.invokeOperation((DynamicObject)returnOrder, (String)"psedelete");
        }
        return ApiResult.success(null);
    }

    public ApiResult returnReasonList(Map<String, Object> data) {
        DynamicObjectCollection assistantDataCollection = QueryServiceHelper.query((String)"bos_assistantdata_detail", (String)"id,name", (QFilter[])new QFilter("group.number", "=", (Object)"returnreason").toArray());
        ArrayList list = new ArrayList();
        for (DynamicObject assistantData : assistantDataCollection) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", assistantData.get("id"));
            map.put("name", assistantData.getString("name"));
            list.add(map);
        }
        HashMap map = new HashMap();
        map.put("list", list);
        return ApiResult.success(map);
    }
}

