/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.saleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.status.SaleOrderStatus;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.SaleOrderUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.iAlgorithm.LocalPageCache;
import kd.drp.mdr.iAlgorithm.OrderAlgorithm;
import net.sf.json.JSONObject;

public class SaleOrderApi
extends MdrApi {
    protected static Log logger = LogFactory.getLog(SaleOrderApi.class);

    public ApiResult querySaleOrderStatus(Map<String, Object> data) {
        String id = (String)data.get("id");
        JSONObject json = new JSONObject();
        DynamicObject order = QueryServiceHelper.queryOne((String)"bbc_saleorder", (String)"orderstatus", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(id)).toArray());
        json.put((Object)"orderstatus", (Object)order.getString("orderstatus"));
        return ApiResult.success((Object)json);
    }

    public ApiResult invalidSaleOrder(Map<String, Object> data) {
        return ApiResult.success(null);
    }

    public ApiResult getSaleOrderStatusQty(Map<String, Object> data) {
        Object userID = UserUtil.getUserID();
        logger.info("\u83b7\u53d6\u5230\u7684\u7cfb\u7edf\u7528\u6237ID\u4e3a:" + userID);
        QFilter filter = this.getCustomFilter();
        QFilter fsAwaitDelivery = new QFilter("creator", "=", userID);
        fsAwaitDelivery.and(new QFilter("orderstatus", "=", (Object)"C"));
        QFilter fsAwaitReceive = new QFilter("creator", "=", userID);
        fsAwaitReceive.and(new QFilter("orderstatus", "=", (Object)"E"));
        QFilter fsAlreadyReceive = new QFilter("creator", "=", userID);
        fsAlreadyReceive.and(new QFilter("orderstatus", "=", (Object)"G"));
        String cols = F7Utils.getSelectCols((String[])new String[]{"orderstatus"});
        DynamicObjectCollection queryAwaitDelivery = QueryServiceHelper.query((String)"bbc_saleorder", (String)cols, (QFilter[])filter.and(fsAwaitDelivery).toArray());
        DynamicObjectCollection queryAwaitReceive = QueryServiceHelper.query((String)"bbc_saleorder", (String)cols, (QFilter[])filter.and(fsAwaitReceive).toArray());
        DynamicObjectCollection queryAlreadyReceive = QueryServiceHelper.query((String)"bbc_saleorder", (String)cols, (QFilter[])filter.and(fsAlreadyReceive).toArray());
        ArrayList list = new ArrayList();
        HashMap<String, Integer> mapData = new HashMap<String, Integer>();
        mapData.put("awaitDelivery", queryAwaitDelivery.size());
        mapData.put("awaitReceive", queryAwaitReceive.size());
        mapData.put("alreadyReceive", queryAlreadyReceive.size());
        list.add(mapData);
        data.clear();
        data.put("list", list);
        data.put("cardExpired", Boolean.FALSE);
        return ApiResult.success(data);
    }

    public ApiResult updateSaleOrder(Map<String, Object> data) {
        String saleorderid = (String)data.get("orderid");
        ArrayList entrylist = (ArrayList)data.get("entry");
        String delids = (String)data.get("deleteentryids");
        String[] deletedids = delids.split(",");
        DynamicObject oldOrder = BusinessDataServiceHelper.loadSingle((Object)saleorderid, (String)"bbc_saleorder");
        if (oldOrder == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u7ebf\u4e0a\u8ba2\u5355\u4e0d\u5b58\u5728\uff01", (String)"SaleOrderApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (this.isUsePromotion(saleorderid)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u82cd\u7a79\u8ba2\u5355\u5df2\u4ea7\u751f\u4fc3\u9500\u7ed3\u679c\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"SaleOrderApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObjectCollection entrys = oldOrder.getDynamicObjectCollection("itementry");
        for (DynamicObject entry : entrys) {
            for (int i = 0; i < entrylist.size(); ++i) {
                String entryid = ((Map)entrylist.get(i)).get("orderentryid").toString();
                if (!entryid.equals(entry.getPkValue().toString())) continue;
                if (((Map)entrylist.get(i)).get("qty") != null) {
                    BigDecimal qty = new BigDecimal(((Map)entrylist.get(i)).get("qty").toString());
                    BigDecimal deliveredQty = (BigDecimal)((Map)entrylist.get(i)).get("deliveredqty");
                    if (deliveredQty != null && deliveredQty.compareTo(qty) > 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u6570\u91cf\u5c0f\u4e8e\u5df2\u53d1\u8d27\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01", (String)"SaleOrderApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                    }
                    entry.set("qty", ((Map)entrylist.get(i)).get("qty"));
                }
                if (((Map)entrylist.get(i)).get("amount") != null) {
                    BigDecimal amount = new BigDecimal(((Map)entrylist.get(i)).get("amount").toString());
                    this.setAmountByEAS(entry, amount);
                }
                if (((Map)entrylist.get(i)).get("taxrate") == null) continue;
                BigDecimal taxrate = new BigDecimal(((Map)entrylist.get(i)).get("taxrate").toString());
                entry.set("taxrate", (Object)taxrate);
            }
            for (String id : deletedids) {
                if (!id.equals(entry.getPkValue().toString())) continue;
                entry.set("qty", (Object)0);
                this.setAmountByEAS(entry, BigDecimal.ZERO);
            }
        }
        new OrderAlgorithm(oldOrder, (IPageCache)new LocalPageCache()).reCalWholeOrderByItemAmount();
        oldOrder.set("orderstatus", (Object)SaleOrderStatus.CHANGING.getFlagStr());
        oldOrder.set("operateremark", (Object)ResManager.loadKDString((String)"EAS\u8ba2\u5355\u53d8\u66f4\u540c\u6b65", (String)"SaleOrderApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        OperationUtil.invokeOperation((DynamicObject)oldOrder, (String)"save");
        this.createOrderEvaluation(saleorderid, (String)data.get("evaluation"));
        return ApiResult.success(null);
    }

    private void setAmountByEAS(DynamicObject entry, BigDecimal amount) {
        entry.set("itemamount", (Object)amount);
        entry.set("promotionamount", (Object)amount);
        entry.set("rebateamount", (Object)amount);
        entry.set("taxAmount", (Object)amount);
    }

    private boolean isUsePromotion(Object orderid) {
        return QueryServiceHelper.exists((String)"dpm_execution", (QFilter[])new QFilter("order", "=", (Object)Long.valueOf(orderid.toString())).toArray());
    }

    private void createOrderEvaluation(String orderid, String evaluation) {
        if (StringUtils.isEmpty((String)evaluation)) {
            return;
        }
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"mdr_order_evaluates");
        obj.set("content", (Object)evaluation);
        obj.set("order", (Object)orderid);
        obj.set("isreaded", (Object)"0");
        OperationUtil.invokeOperation((DynamicObject)obj, (String)"save");
    }

    private QFilter getCustomFilter() {
        QFilter f = null;
        List ownerIds = UserUtil.getOwnerIDs();
        for (Object ownerId : ownerIds) {
            if (f == null) {
                f = SaleOrderUtil.getSaleOrderSalerFilter(ownerId);
                continue;
            }
            f.or(SaleOrderUtil.getSaleOrderSalerFilter(ownerId));
        }
        if (f == null) {
            f = new QFilter("1", "=", (Object)"0");
        }
        return f;
    }
}

