/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.shoppingcart;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.Propagation;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.api.ApiTransaction;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.ORMUtil;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.CustomerParamsUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemStoreUtil;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.QueryUtil;
import kd.drp.mdr.common.util.UnitUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.WebUtil;

public class ShoppingCartApi
extends MdrApi {
    public ApiResult query(Map<String, Object> data) {
        this.checkRecordField(data, new String[0]);
        QFilter f = new QFilter("1", "=", (Object)"1");
        int page = 1;
        int pageSize = 20;
        String ischoose = (String)data.get("isChoose");
        String customer = (String)data.get("customer");
        String owner = (String)data.get("owner");
        String isQuickOrder = (String)data.get("isQuickOrder");
        if (StringUtils.isEmpty((String)isQuickOrder)) {
            isQuickOrder = "0";
        }
        if ("1".equals(isQuickOrder)) {
            f.and("isquickorder", "=", (Object)isQuickOrder);
        }
        if (StringUtils.isNotEmpty((String)ischoose)) {
            f = f.and("ischoose", "=", (Object)ischoose);
        }
        f = StringUtils.isNotEmpty((String)customer) ? f.and("owner", "=", (Object)customer) : f.and("owner", "=", UserUtil.getDefaultOwnerID());
        if (StringUtils.isNotEmpty((String)owner)) {
            f = f.and("customer", "=", (Object)owner);
        }
        f.and("ispurchasing", "=", (Object)"0");
        if (data.get("page") != null && (Integer)data.get("page") > 1) {
            page = (Integer)data.get("page");
        }
        if (data.get("pageSize") != null && (Integer)data.get("pageSize") > 1) {
            pageSize = (Integer)data.get("pageSize");
        }
        String fields = "id,owner.id,owner.name,customer.id,customer.name,item.id,item.thumbnail,item.name,item.isassistorder,item.referenceprice,unit.id,unit.name,assistattr.id,assistattr.name,qty,assistunit.id,assistunit.name,assistqty,createdate,user.name,ischoose,item.shorttitle";
        DynamicObjectCollection dc = ORMUtil.query((String)"mdr_shopping_cart", (String)fields, (QFilter[])f.toArray(), (String)"createdate desc", (int)((page - 1) * pageSize), (int)pageSize);
        ArrayList list = new ArrayList();
        if (dc != null && dc.size() > 0) {
            HashMap<String, ArrayList<HashMap<String, Object>>> datas = new HashMap<String, ArrayList<HashMap<String, Object>>>();
            for (DynamicObject o : dc) {
                String customerId = o.getString("customer.id");
                HashMap<String, Object> map = new HashMap<String, Object>();
                this.getShoppingCarInfo(o, map);
                ArrayList<HashMap<String, Object>> dataList = (ArrayList<HashMap<String, Object>>)datas.get(customerId);
                if (dataList == null) {
                    dataList = new ArrayList<HashMap<String, Object>>();
                }
                dataList.add(map);
                datas.put(customerId, dataList);
            }
            for (ArrayList dataList : datas.values()) {
                DynamicObject pic;
                DynamicObject bizpartner;
                HashMap<String, Object> map = new HashMap<String, Object>();
                Object id = ((Map)dataList.get(0)).get("ownerId");
                String picture = "";
                if (StringUtils.isEmpty(id) || !QueryServiceHelper.exists((String)"mdr_customer", id)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u5546\u5bb6\u6e20\u9053ID", (String)"ShoppingCartApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                }
                DynamicObject drpUser = QueryServiceHelper.queryOne((String)"dbd_drp_user", (String)"sysuser", (QFilter[])new QFilter("owner", "=", id).toArray());
                if (drpUser != null && (bizpartner = QueryServiceHelper.queryOne((String)"bos_bizpartneruser", (String)"bizpartner.id", (QFilter[])new QFilter("user.id", "=", drpUser.get("sysuser")).toArray())) != null && (pic = QueryServiceHelper.queryOne((String)"bd_bizpartner", (String)"picturefield", (QFilter[])new QFilter("id", "=", bizpartner.get("bizpartner.id")).toArray())) != null) {
                    picture = (String)pic.get("picturefield");
                }
                map.put("ownerPic", picture);
                map.put("ownerId", ((Map)dataList.get(0)).get("ownerId"));
                map.put("ownerName", ((Map)dataList.get(0)).get("ownerName"));
                map.put("cartList", dataList);
                list.add(map);
            }
        }
        data.clear();
        data.put("list", list);
        int count = QueryUtil.querycount((String)"mdr_shopping_cart", (QFilter[])f.toArray());
        data.put("count", count);
        return ApiResult.success(data);
    }

    private void getShoppingCarInfo(DynamicObject o, HashMap<String, Object> map) {
        map.put("id", o.getString("id"));
        map.put("customerId", o.getString("owner.id"));
        map.put("customerName", o.getString("owner.name"));
        map.put("ownerName", o.getString("customer.name"));
        map.put("ownerId", o.getString("customer.id"));
        map.put("assistattrId", o.getString("assistattr.id"));
        map.put("assistattrName", o.getString("assistattr.name"));
        map.put("itemId", o.getString("item.id"));
        map.put("itemPic", o.getString("item.thumbnail"));
        map.put("itemName", o.getString("item.name"));
        map.put("itemTitle", o.getString("item.name"));
        map.put("unitId", o.getString("unit.id"));
        map.put("unitName", o.getString("unit.name"));
        map.put("qty", o.get("qty"));
        map.put("assistunitId", o.getString("assistunit.id"));
        map.put("assistunitName", o.getString("assistunit.name"));
        map.put("assistQty", o.get("assistqty"));
        map.put("isAssistOrder", o.get("item.isassistorder"));
        if (o.getBoolean("item.isassistorder")) {
            map.put("conversionRate", ItemUtil.queryConversionFactor((Object)o.getString("item.id"), (Object)o.getString("unit.id")).divide(ItemUtil.queryConversionFactor((Object)o.getString("item.id"), (Object)o.getString("assistunit.id")), 6, 4));
        }
        map.put("shortTitle", o.getString("item.shorttitle"));
        map.put("createdate", o.get("createdate"));
        map.put("userName", o.getString("user.name"));
        if (o.getBoolean("ischoose")) {
            map.put("isChoose", "1");
        } else {
            map.put("isChoose", "0");
        }
        map.put("price", PriceUtil.getItemPrice((Object)o.get("customer.id"), (Object)o.get("owner.id"), (Object)o.get("item.id"), (Object)o.get("unit.id"), (Object)o.get("assistattr.id"), (BigDecimal)o.getBigDecimal("qty")).setScale(2, 4));
    }

    @ApiTransaction(propagation=Propagation.REQUIRED)
    public ApiResult save(Map<String, Object> data) throws ParseException {
        this.checkRecordField(data, "list");
        List list = (List)data.get("list");
        String isQuickOrder = (String)data.get("isQuickOrder");
        if (StringUtils.isEmpty((String)isQuickOrder)) {
            isQuickOrder = "0";
        }
        if (list == null || list.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d2d\u7269\u8f66\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ShoppingCartApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if ("1".equals(isQuickOrder)) {
            QFilter qFilter = new QFilter("isquickorder", "=", (Object)"1");
            qFilter.and("ispurchasing", "=", (Object)"0");
            DeleteServiceHelper.delete((String)"mdr_shopping_cart", (QFilter[])qFilter.toArray());
        }
        DynamicObject[] shoppingcartList = new DynamicObject[list.size()];
        Map map = null;
        for (int i = 0; i < list.size(); ++i) {
            map = (Map)list.get(i);
            this.checkRecordField(map, "ownerId", "itemId");
            String id = (String)map.get("id");
            Object itemId = map.get("itemId");
            String ownerId = (String)map.get("ownerId");
            String customerId = (String)map.get("customerId");
            String ischoose = (String)map.get("isChoose");
            String assistattrId = (String)map.get("assistattrId");
            if (StringUtils.isEmpty((String)ischoose)) {
                ischoose = "0";
            }
            if (ItemAttrUtil.hasAssistAttr(itemId)) {
                if (StringUtils.isEmpty((String)assistattrId) && "1".equals(isQuickOrder)) {
                    assistattrId = (String)ItemAttrUtil.getDefaultAttrId(itemId);
                }
                if (!ItemAttrUtil.hasAssistAttr(itemId, (Object)assistattrId)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u8f85\u52a9\u5c5e\u6027\u6709\u8bef\uff01\uff01", (String)"ShoppingCartApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                }
            } else if (StringUtils.isNotEmpty((String)assistattrId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u672a\u5f00\u542f\u8f85\u52a9\u5c5e\u6027", (String)"ShoppingCartApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            if (assistattrId == null) {
                assistattrId = "0";
            }
            if (!QueryServiceHelper.exists((String)"mdr_customer", (Object)ownerId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u4e0d\u5b58\u5728", (String)"ShoppingCartApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)customerId)) {
                customerId = String.valueOf(UserUtil.getDefaultOwnerID());
            }
            if (!QueryServiceHelper.exists((String)"mdr_customer", (Object)customerId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5ba2\u6237\u6e20\u9053\u4e0d\u5b58\u5728", (String)"ShoppingCartApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            if (!CustomerUtil.isAuthRelation((Object)ownerId, (Object)customerId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5ba2\u6237\u6e20\u9053\u4e0e\u4f9b\u8d27\u6e20\u9053\u95f4\u4e0d\u5b58\u5728\u6388\u6743\u5173\u7cfb\uff0c\u8bf7\u786e\u8ba4\uff01", (String)"ShoppingCartApi_6", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            DynamicObject item = BusinessDataServiceHelper.loadSingle(itemId, (String)"mdr_item_info", (String)"id,assistunit,baseunit,conversionfor,name,isassistorder");
            if (item == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u5b58\u5728", (String)"ShoppingCartApi_7", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            Set saleItemSet = ItemSaleControlUtil.getAllCanSaleItemIdsByDefaultFilter((Object)ownerId, (Object)customerId);
            if (!saleItemSet.contains(itemId)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25,%s\u4e0d\u5728\u9500\u552e\u8303\u56f4\u5185", (String)"ShoppingCartApi_8", (String)"drp-mdr-webapi", (Object[])new Object[0]), item.getString("name")));
            }
            Map qtyAndUnitMap = UnitUtil.setQtyAndUnit((Map)map, (DynamicObject)item);
            BigDecimal newQty = qtyAndUnitMap.get("newQty") != null ? (BigDecimal)qtyAndUnitMap.get("newQty") : null;
            BigDecimal newAssistQty = qtyAndUnitMap.get("newAssistQty") != null ? (BigDecimal)qtyAndUnitMap.get("newAssistQty") : null;
            String unitId = qtyAndUnitMap.get("unitId") + "";
            String assistUnitId = qtyAndUnitMap.get("assistUnitId") + "";
            BigDecimal itemPrice = PriceUtil.getItemPrice((Object)ownerId, (Object)customerId, itemId, (Object)unitId, (Object)assistattrId, (BigDecimal)newQty, (Date)new Date());
            if (itemPrice == null || new BigDecimal(0).compareTo(itemPrice) > 0) {
                if ("1".equals(isQuickOrder)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u4ef7\u683c\u5f02\u5e38,\u8bf7\u5237\u65b0\u540e\u52a0\u5165", (String)"ShoppingCartApi_9", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            ItemStoreUtil.isAllowOverStore(itemId, (Object)ownerId, (Object)assistattrId, (BigDecimal)newQty, (Object)unitId, (Object)assistUnitId);
            QFilter qf = new QFilter("1", "=", (Object)"1");
            if (StringUtils.isNotEmpty((String)id)) {
                qf.and("id", "=", (Object)id);
            } else {
                qf.and("item", "=", itemId);
                if (StringUtils.isNotEmpty((String)unitId)) {
                    qf.and("unit.id", "=", (Object)unitId);
                }
                if (StringUtils.isNotEmpty((String)assistUnitId)) {
                    qf.and("assistunit.id", "=", (Object)assistUnitId);
                }
                qf.and("owner", "=", (Object)customerId);
                qf.and("customer", "=", (Object)ownerId);
                qf.and("user", "=", UserUtil.getUserID());
                qf.and("ispurchasing", "=", (Object)"0");
                qf.and("assistattr", "=", (Object)assistattrId);
            }
            DynamicObject shoppingcart = null;
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)"mdr_shopping_cart", (String)"owner,customer,item,unit,qty,assistunit,assistqty,createdate,user,ispurchasing,ischoose,isquickorder", (QFilter[])qf.toArray());
            if (objects.length > 0) {
                shoppingcart = objects[0];
                if ("1".equals(isQuickOrder)) {
                    shoppingcart.set("qty", (Object)newQty);
                    shoppingcart.set("assistqty", (Object)newAssistQty);
                    shoppingcart.set("isquickorder", (Object)Boolean.TRUE);
                } else {
                    try {
                        shoppingcart.set("qty", (Object)shoppingcart.getBigDecimal("qty").add(newQty));
                    }
                    catch (NullPointerException e) {
                        shoppingcart.set("qty", (Object)newQty);
                    }
                    try {
                        shoppingcart.set("assistqty", (Object)shoppingcart.getBigDecimal("assistqty").add(newAssistQty));
                    }
                    catch (NullPointerException e) {
                        shoppingcart.set("assistqty", (Object)newAssistQty);
                    }
                    shoppingcart.set("isquickorder", (Object)Boolean.FALSE);
                }
                shoppingcart.set("ispurchasing", (Object)Boolean.FALSE);
                if ("1".equals(ischoose)) {
                    shoppingcart.set("ischoose", (Object)Boolean.TRUE);
                } else {
                    shoppingcart.set("ischoose", (Object)Boolean.FALSE);
                }
            } else {
                shoppingcart = BusinessDataServiceHelper.newDynamicObject((String)"mdr_shopping_cart");
                shoppingcart.set("owner", (Object)customerId);
                shoppingcart.set("customer", (Object)ownerId);
                shoppingcart.set("item", itemId);
                shoppingcart.set("assistattr", (Object)assistattrId);
                shoppingcart.set("unit", (Object)unitId);
                shoppingcart.set("qty", (Object)newQty);
                shoppingcart.set("assistunit", (Object)assistUnitId);
                shoppingcart.set("assistqty", (Object)newAssistQty);
                shoppingcart.set("createdate", (Object)new Date());
                shoppingcart.set("user", UserUtil.getUserID());
                shoppingcart.set("ispurchasing", (Object)Boolean.FALSE);
                if ("1".equals(ischoose)) {
                    shoppingcart.set("ischoose", (Object)Boolean.TRUE);
                } else {
                    shoppingcart.set("ischoose", (Object)Boolean.FALSE);
                }
                if ("1".equals(isQuickOrder)) {
                    shoppingcart.set("isquickorder", (Object)Boolean.TRUE);
                } else {
                    shoppingcart.set("isquickorder", (Object)Boolean.FALSE);
                }
            }
            shoppingcartList[i] = shoppingcart;
        }
        if (shoppingcartList.length > 0) {
            SaveServiceHelper.save((DynamicObject[])shoppingcartList);
            return ApiResult.success(null);
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u6dfb\u52a0\u5931\u8d25", (String)"ShoppingCartApi_10", (String)"drp-mdr-webapi", (Object[])new Object[0]));
    }

    @ApiTransaction(propagation=Propagation.REQUIRED)
    public ApiResult modify(Map<String, Object> data) {
        this.checkRecordField(data, "list");
        List list = (List)data.get("list");
        if (list == null || list.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d2d\u7269\u8f66\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ShoppingCartApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DynamicObject[] shoppingcartList = new DynamicObject[list.size()];
        Map map = null;
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject owner;
            map = (Map)list.get(i);
            this.checkRecordField(map, "id");
            String id = (String)map.get("id");
            String itemId = (String)map.get("itemId");
            String ownerId = (String)map.get("ownerId");
            String customerId = (String)map.get("customerId");
            String ischoose = (String)map.get("isChoose");
            String assistattrId = (String)map.get("assistattrId");
            BigDecimal newQty = null;
            BigDecimal newAssistQty = null;
            String unitId = null;
            String assistUnitId = null;
            if (StringUtils.isEmpty((String)id)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u8d2d\u7269\u8f66ID", (String)"ShoppingCartApi_11", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            QFilter qf = new QFilter("1", "=", (Object)"1");
            if (StringUtils.isNotEmpty((String)id)) {
                qf.and("id", "=", (Object)id);
            }
            if (!QueryServiceHelper.exists((String)"mdr_shopping_cart", (Object)id)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728\uff01", (String)"ShoppingCartApi_12", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            DynamicObject shoppingcart = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mdr_shopping_cart");
            if (StringUtils.isEmpty((String)itemId)) {
                itemId = shoppingcart.getString("item.id");
            }
            if (ItemAttrUtil.hasAssistAttr((Object)itemId)) {
                if (!ItemAttrUtil.hasAssistAttr((Object)itemId, (Object)assistattrId)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u6ca1\u6709\u6b64\u8f85\u52a9\u5c5e\u6027", (String)"ShoppingCartApi_13", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                }
            } else if (StringUtils.isNotEmpty((String)assistattrId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u672a\u5f00\u542f\u8f85\u52a9\u5c5e\u6027", (String)"ShoppingCartApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            if (StringUtils.isNotEmpty((String)ownerId) && (owner = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"id,name,number", (QFilter[])WebUtil.getIdQFilter((Object)ownerId).toArray())) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u4e0d\u5b58\u5728", (String)"ShoppingCartApi_4", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            DynamicObject item = QueryServiceHelper.queryOne((String)"mdr_item_info", (String)"id,assistunit,baseunit,conversionfor", (QFilter[])WebUtil.getIdQFilter((Object)itemId).toArray());
            if (item == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u5b58\u5728", (String)"ShoppingCartApi_7", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            if (StringUtils.isNotEmpty(map.get("unitId")) && StringUtils.isEmpty(map.get("qty"))) {
                map.put("qty", shoppingcart.getBigDecimal("qty"));
            }
            if (StringUtils.isNotEmpty(map.get("assistUnit")) && StringUtils.isEmpty(map.get("assistQty"))) {
                map.put("assistQty", shoppingcart.get("assistqty"));
            }
            Map qtyAndUnitMap = null;
            if (StringUtils.isNotEmpty(map.get("unitId")) || StringUtils.isNotEmpty(map.get("assistUnit"))) {
                qtyAndUnitMap = UnitUtil.setQtyAndUnit((Map)map, (DynamicObject)item);
                newQty = qtyAndUnitMap.get("newQty") != null ? (BigDecimal)qtyAndUnitMap.get("newQty") : null;
                newAssistQty = qtyAndUnitMap.get("newAssistQty") != null ? (BigDecimal)qtyAndUnitMap.get("newAssistQty") : null;
                unitId = qtyAndUnitMap.get("unitId") + "";
                assistUnitId = qtyAndUnitMap.get("assistUnitId") + "";
            }
            if (qtyAndUnitMap == null) {
                try {
                    if (StringUtils.isNotEmpty(map.get("qty"))) {
                        newQty = new BigDecimal(map.get("qty").toString());
                    }
                    if (StringUtils.isNotEmpty(map.get("assistQty"))) {
                        newAssistQty = new BigDecimal(map.get("assistQty").toString());
                    }
                }
                catch (ClassCastException e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5546\u54c1\u6570\u91cf\u6709\u8bef", (String)"ShoppingCartApi_14", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                }
            }
            DynamicObject customer = null;
            if (StringUtils.isEmpty((String)customerId)) {
                customerId = shoppingcart.getString("owner.id");
            }
            if ((customer = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"id,name,number", (QFilter[])WebUtil.getIdQFilter((Object)customerId).toArray())) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5ba2\u6237\u6e20\u9053\u4e0d\u5b58\u5728", (String)"ShoppingCartApi_5", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)ownerId)) {
                ownerId = shoppingcart.getString("customer.id");
            }
            if (!CustomerUtil.isAuthRelation((Object)ownerId, (Object)customerId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5ba2\u6237\u6e20\u9053\u4e0e\u4f9b\u8d27\u6e20\u9053\u95f4\u4e0d\u5b58\u5728\u6388\u6743\u5173\u7cfb\uff0c\u8bf7\u786e\u8ba4\uff01", (String)"ShoppingCartApi_6", (String)"drp-mdr-webapi", (Object[])new Object[0]));
            }
            this.setShoppingCar(itemId, ownerId, customerId, ischoose, assistattrId, newQty, newAssistQty, unitId, assistUnitId, shoppingcart);
            if (CustomerParamsUtil.isAllowOver((Object)shoppingcart.getString("customer.id")).equals("1")) {
                BigDecimal storeQty = null;
                if (StringUtils.isNotEmpty((String)shoppingcart.getString("unit.id")) ? (storeQty = ItemStoreUtil.queryItemStoreQty((Object)shoppingcart.getString("customer.id"), (Object)itemId, (Object)shoppingcart.getString("unit.id"), (Object)assistattrId, null)).compareTo(shoppingcart.getBigDecimal("qty")) < 0 : (storeQty = ItemStoreUtil.queryItemStoreQty((Object)shoppingcart.getString("customer.id"), (Object)itemId, (Object)shoppingcart.getString("assistunit.id"), (Object)assistattrId, null)).compareTo(shoppingcart.getBigDecimal("assistqty")) < 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3\uff01\uff01\uff01", (String)"ShoppingCartApi_15", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                }
            }
            shoppingcartList[i] = shoppingcart;
        }
        OperationUtil.invokeOperation((DynamicObject[])shoppingcartList, (String)"save");
        return ApiResult.success(null);
    }

    private void setShoppingCar(String itemId, String ownerId, String customerId, String ischoose, String assistattrId, BigDecimal newQty, BigDecimal newAssistQty, String unitId, String assistUnitId, DynamicObject shoppingcart) {
        if (StringUtils.isNotEmpty((String)assistattrId)) {
            shoppingcart.set("assistattr", (Object)assistattrId);
        }
        if (StringUtils.isNotEmpty((String)customerId)) {
            shoppingcart.set("owner", (Object)customerId);
        }
        if (StringUtils.isNotEmpty((String)ownerId)) {
            shoppingcart.set("customer", (Object)ownerId);
        }
        if (StringUtils.isNotEmpty((String)itemId)) {
            shoppingcart.set("item", (Object)itemId);
        }
        if (StringUtils.isNotEmpty((String)unitId)) {
            shoppingcart.set("unit", (Object)unitId);
        }
        if (StringUtils.isNotEmpty((Object)newQty)) {
            shoppingcart.set("qty", (Object)newQty);
        }
        if (StringUtils.isNotEmpty((String)assistUnitId)) {
            shoppingcart.set("assistunit", (Object)assistUnitId);
        }
        if (StringUtils.isNotEmpty((Object)newAssistQty)) {
            shoppingcart.set("assistqty", (Object)newAssistQty);
        }
        if (StringUtils.isNotEmpty((String)ischoose)) {
            if ("1".equals(ischoose)) {
                shoppingcart.set("ischoose", (Object)Boolean.TRUE);
            } else {
                shoppingcart.set("ischoose", (Object)Boolean.FALSE);
            }
        }
    }

    public ApiResult delete(Map<String, Object> data) {
        this.checkRecordField(data, "ids");
        ArrayList ids = (ArrayList)data.get("ids");
        if (ids == null || ids.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u8d2d\u7269\u8f66ids\u4e3a\u7a7a", (String)"ShoppingCartApi_16", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        for (String shoppingCartId : ids) {
            if (QueryServiceHelper.exists((String)"mdr_shopping_cart", (Object)shoppingCartId)) continue;
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u65e0\u6b64\u8d2d\u7269\u8f66\u4fe1\u606f", (String)"ShoppingCartApi_17", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        DeleteServiceHelper.delete((String)"mdr_shopping_cart", (QFilter[])WebUtil.getIdQFilter((Collection)ids).toArray());
        return ApiResult.success(null);
    }

    public ApiResult deleteAll(Map<String, Object> data) {
        this.checkRecordField(data, new String[0]);
        Object customerId = data.get("customerId");
        if (StringUtils.isEmpty((Object)customerId)) {
            customerId = UserUtil.getDefaultOwnerID();
        }
        QFilter f = new QFilter("owner", "=", customerId);
        DeleteServiceHelper.delete((String)"mdr_shopping_cart", (QFilter[])f.toArray());
        return ApiResult.success(null);
    }

    public ApiResult setChoose(Map<String, Object> data) {
        this.checkRecordField(data, "ids", "isChooses");
        ArrayList ids = (ArrayList)data.get("ids");
        ArrayList ischooses = (ArrayList)data.get("isChooses");
        if (ids.size() != ischooses.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684id\u4e2a\u6570\u548cisChooses\u4e0d\u540c", (String)"ShoppingCartApi_18", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        if (ids.size() > 0 && ischooses.size() > 0) {
            for (int i = 0; i < ids.size(); ++i) {
                String id = (String)ids.get(i);
                boolean ischoose = false;
                if ("1".equals(ischooses.get(i))) {
                    ischoose = true;
                }
                DynamicObject shoppingcart = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mdr_shopping_cart");
                shoppingcart.set("ischoose", (Object)ischoose);
                OperationUtil.invokeOperation((DynamicObject)shoppingcart, (String)"save");
            }
        }
        return ApiResult.success(null);
    }
}

