/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.api.user;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.api.ApiTransaction;
import kd.drp.mdr.api.MdrApi;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.util.AssistantdataUtil;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.common.util.UserUtil;

public class UserApi
extends MdrApi {
    public ApiResult query(Map<String, Object> data) {
        String userId = UserUtil.getUserID() + "";
        if (StringUtils.isEmpty((Object)userId)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8c03\u7528\u67e5\u8be2\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u539f\u56e0:\u4f20\u5165\u7684id\u503c\u4e3a\u7a7a\uff01", (String)"UserApi_0", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(36);
        DynamicObject userData = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)this.getSelectFields(), (QFilter[])new QFilter("id", "=", (Object)userId).toArray());
        if (userData != null) {
            DynamicObject customer;
            resultMap.put("id", userId);
            String customerName = "";
            String defaultOwnerID = UserUtil.getDefaultOwnerID() + "";
            if (defaultOwnerID != null && (customer = BusinessDataServiceHelper.loadSingle((Object)defaultOwnerID, (String)"mdr_customer")) != null) {
                customerName = (String)customer.get("name.zh_CN");
            }
            resultMap.put("ownerId", defaultOwnerID);
            resultMap.put("customerName", customerName);
            resultMap.put("avatar", userData.getString("picturefield"));
            resultMap.put("userName", userData.getString("name"));
            resultMap.put("simplePinyin", userData.getString("simplepinyin"));
            resultMap.put("fullPinyin", userData.getString("fullpinyin"));
            resultMap.put("userType", userData.getString("usertype"));
            resultMap.put("number", userData.getString("number"));
            resultMap.put("phone", userData.getString("phone"));
            resultMap.put("email", userData.getString("email"));
            resultMap.put("idCard", userData.getString("idcard"));
            resultMap.put("birthday", userData.get("birthday"));
            resultMap.put("gender", userData.get("gender"));
            resultMap.put("customerType", "");
            resultMap.put("nickname", "");
            resultMap.put("pictureObverse", "");
            resultMap.put("pictureReverse", "");
            DynamicObject extData = BusinessDataServiceHelper.loadSingle((String)"mdr_user_ext", (String)"id,customertype,nickname,picture_ob,picture_re", (QFilter[])new QFilter("user.id", "=", (Object)userId).toArray());
            if (extData != null) {
                DynamicObject bizPartInfo;
                DynamicObject bizUserInfo;
                resultMap.put("customerType", extData.get("customertype"));
                resultMap.put("nickname", extData.get("nickname"));
                resultMap.put("pictureObverse", extData.get("picture_ob"));
                resultMap.put("pictureReverse", extData.get("picture_re"));
                if ("CT02".equals(extData.get("customertype")) && (bizUserInfo = BusinessDataServiceHelper.loadSingle((String)"bos_bizpartneruser", (String)"bizpartner", (QFilter[])new QFilter("user.id", "=", (Object)userId).toArray())) != null && (bizPartInfo = BusinessDataServiceHelper.loadSingle((String)"bd_bizpartner", (String)"id,picturefield,name,type,country_id,address,phone,societycreditcode", (QFilter[])new QFilter("id", "=", bizUserInfo.get("bizpartner.id")).toArray())) != null) {
                    resultMap.put("logo", bizPartInfo.get("picturefield"));
                    resultMap.put("comType", bizPartInfo.get("type"));
                    resultMap.put("country", bizPartInfo.get("country_id"));
                    resultMap.put("comName", bizPartInfo.get("name.zh_CN"));
                    resultMap.put("address", bizPartInfo.get("address.zh_CN"));
                    resultMap.put("phone", bizPartInfo.get("phone"));
                    resultMap.put("societyCreditCode", bizPartInfo.get("societycreditcode"));
                    DynamicObject bizExtInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_bizpartner_ext", (String)"comtrade,comscale,picture_bl", (QFilter[])new QFilter("bizpartner.id", "=", bizPartInfo.get("id")).toArray());
                    if (bizExtInfo != null) {
                        resultMap.put("comTradeId", bizExtInfo.get("comtrade.id"));
                        resultMap.put("comTradeNumber", bizExtInfo.get("comscale.number"));
                        resultMap.put("comTradeName", bizExtInfo.get("comtrade.name.zh_CN"));
                        resultMap.put("comScaleId", bizExtInfo.get("comscale.id"));
                        resultMap.put("comScaleNumber", bizExtInfo.get("comtrade.number"));
                        resultMap.put("comScaleName", bizExtInfo.get("comscale.name.zh_CN"));
                        resultMap.put("pictureBLicence", bizExtInfo.get("picture_bl"));
                    }
                }
            }
        }
        return ApiResult.success(resultMap);
    }

    public ApiResult isExistUser(Map<String, Object> data) {
        if (StringUtils.isEmpty(data)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7\u7801\uff01", (String)"UserApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        String phone = (String)data.get("phone");
        if (phone.length() != 11) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7\u7801\uff01", (String)"UserApi_1", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        DynamicObject userObj = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"id", (QFilter[])new QFilter("phone", "=", (Object)phone).toArray());
        if (StringUtils.isEmpty((Object)userObj)) {
            resultMap.put("isExist", "0");
        } else {
            resultMap.put("isExist", "1");
        }
        return ApiResult.success(resultMap);
    }

    @ApiTransaction
    public ApiResult modify(Map<String, Object> data) {
        DynamicObject userInfo;
        String userId = UserUtil.getUserID() + "";
        if (StringUtils.isEmpty((String)userId)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8c03\u7528\u4fee\u6539\u63a5\u53e3\u5931\u8d25,\u5931\u8d25\u539f\u56e0:\u4f20\u5165\u7684\u7528\u6237id\u503c\u4e3a\u7a7a\uff01", (String)"UserApi_2", (String)"drp-mdr-webapi", (Object[])new Object[0]));
        }
        String newPhone = (String)data.get("phone");
        if (StringUtils.isNotEmpty((String)newPhone) && StringUtils.isNotEmpty((Object)(userInfo = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user")))) {
            userInfo.set("phone", (Object)newPhone);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userInfo});
            return ApiResult.success(null);
        }
        DynamicObject userExtInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_user_ext", (String)"id,customertype,nickname,picture_ob,picture_re", (QFilter[])new QFilter("user.id", "=", (Object)userId).toArray());
        if (StringUtils.isNotEmpty((Object)userExtInfo)) {
            DynamicObject newUserExt = BusinessDataServiceHelper.newDynamicObject((String)"mdr_user_ext");
            newUserExt.set("id", userExtInfo.get("id"));
            newUserExt.set("user", (Object)userId);
            newUserExt.set("customertype", userExtInfo.get("customertype"));
            newUserExt.set("nickname", data.get("nickname"));
            newUserExt.set("picture_ob", data.get("pictureObverse"));
            newUserExt.set("picture_re", data.get("pictureReverse"));
            if ("CT01".equals(userExtInfo.get("customertype"))) {
                DynamicObject userInfo2 = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)this.getSelectFields(), (QFilter[])new QFilter("id", "=", (Object)userId).toArray());
                if (!StringUtils.isEmpty((Object)userInfo2)) {
                    userInfo2.set("picturefield", data.get("avatar"));
                    userInfo2.set("name", data.get("userName"));
                    userInfo2.set("usertype", data.get("userType"));
                    userInfo2.set("number", data.get("number"));
                    userInfo2.set("email", data.get("email"));
                    userInfo2.set("idcard", data.get("idCard"));
                    if (StringUtils.isNotEmpty((Object)data.get("birthday"))) {
                        try {
                            userInfo2.set("birthday", (Object)new SimpleDateFormat("yyyy-MM-dd").parse(data.get("birthday").toString()));
                        }
                        catch (ParseException e) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u751f\u65e5\u671f\u6709\u8bef", (String)"UserApi_3", (String)"drp-mdr-webapi", (Object[])new Object[0]));
                        }
                    }
                    userInfo2.set("gender", data.get("gender"));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userInfo2});
                }
                DeleteServiceHelper.delete((IDataEntityType)userExtInfo.getDataEntityType(), (Object[])new Object[]{userExtInfo.get("id")});
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newUserExt});
            }
            if ("CT02".equals(userExtInfo.get("customertype"))) {
                DynamicObject bizUserInfo = BusinessDataServiceHelper.loadSingle((String)"bos_bizpartneruser", (String)"bizpartner", (QFilter[])new QFilter("user.id", "=", (Object)userId).toArray());
                DynamicObject bizPartInfo = null;
                if (bizUserInfo != null) {
                    String comScaleId;
                    bizPartInfo = BusinessDataServiceHelper.loadSingle((String)"bd_bizpartner", (String)"id,name,type,country_id,address,phone,societycreditcode", (QFilter[])new QFilter("id", "=", bizUserInfo.get("bizpartner.id")).toArray());
                    bizPartInfo.set("name", data.get("comName"));
                    bizPartInfo.set("type", data.get("comType"));
                    bizPartInfo.set("country_id", data.get("countryId"));
                    bizPartInfo.set("address", data.get("address"));
                    bizPartInfo.set("societycreditcode", data.get("societyCreditCode"));
                    DynamicObject bizExtInfo = BusinessDataServiceHelper.loadSingle((String)"mdr_bizpartner_ext", (String)"comtrade,comscale,picture_bl", (QFilter[])new QFilter("bizpartner.id", "=", bizPartInfo.get("id")).toArray());
                    String comTradeId = (String)data.get("comTradeId");
                    if (StringUtils.isNotEmpty((String)comTradeId)) {
                        bizExtInfo.set("comtrade", (Object)AssistantdataUtil.getAssistantdataInfo((String)comTradeId));
                    }
                    if (StringUtils.isNotEmpty((String)(comScaleId = (String)data.get("comScaleId")))) {
                        bizExtInfo.set("comscale", (Object)AssistantdataUtil.getAssistantdataInfo((String)comScaleId));
                    }
                    bizExtInfo.set("picture_bl", data.get("pictureBLicence"));
                    DeleteServiceHelper.delete((IDataEntityType)userExtInfo.getDataEntityType(), (Object[])new Object[]{userExtInfo.get("id")});
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newUserExt});
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizExtInfo});
                    OperationUtil.invokeOperation((DynamicObject)bizPartInfo, (String)"save");
                }
            }
        }
        return ApiResult.success(null);
    }

    private String getSelectFields() {
        return "id,picturefield,name,simplepinyin,fullpinyin,usertype,number,phone,email,idcard,birthday,gender,entryentity,entryentity.dpt,entryentity.position,entryentity.isincharge,entryentity.ispartjob";
    }
}

