/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mdr.business.handle;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.enums.ControlStrategy;
import kd.drp.mdr.common.enums.Status;
import kd.drp.mdr.common.enums.customer.CustomerProperty;
import kd.drp.mdr.common.enums.customer.InventoryControlMode;
import kd.drp.mdr.common.enums.customer.SaleControlMode;
import kd.drp.mdr.common.f7.F7Utils;

public class CustomerUpgradeHandler {
    private DBRoute drpDBRoute;

    private DBRoute getDRPDBRoute() {
        if (this.drpDBRoute == null) {
            this.drpDBRoute = DBRoute.of((String)"drp");
        }
        return this.drpDBRoute;
    }

    public void upgrade() {
        List<Map<Object, Object>> customers = this.getAllCustomer();
        if (!CollectionUtils.isEmpty(customers)) {
            Map<Object, Object> customerId2OrgIdMap = this.getCustomerId2OrgIdMap(customers);
            Map<Object, Object> customerId2OrderCusotmerIdMap = this.getCustomerId2OrderCustomerIdMap();
            this.updateMdrCustomer(customers);
            this.updateMdrCustomerX(customers, customerId2OrgIdMap, customerId2OrderCusotmerIdMap);
            this.updateMdrCustomerFunctions(customers);
            this.updateMdrCustomerClass(customers);
        }
    }

    private void updateMdrCustomerClass(List<Map<Object, Object>> customers) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO T_MDR_CUSTOMER_CLASS(FENTRYID,FCUSTOMERID,FSEQ,FCLASSSTANDARDID,FCUSTOMERGROUPID) VALUES(?,?,?,?,?) ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        ArrayList<Object> dataValueList = null;
        long[] pkIds = DBServiceHelper.genLongIds((String)"T_MDR_CUSTOMER_FUNCTIONS", (int)customers.size());
        long customerGroupId = 0L;
        Object customerId = null;
        int index = 0;
        for (Map<Object, Object> customer : customers) {
            if (customer.get("FCUSTOMERGROUPID") == null || (customerGroupId = Long.parseLong(customer.get("FCUSTOMERGROUPID").toString())) <= 0L) continue;
            customerId = customer.get("FCUSTOMERID");
            dataValueList = new ArrayList<Object>();
            dataValueList.add(pkIds[index++]);
            dataValueList.add(customerId);
            dataValueList.add(1L);
            dataValueList.add(836014120472951808L);
            dataValueList.add(customerGroupId);
            paramsList.add(dataValueList.toArray());
        }
        if (!CollectionUtils.isEmpty(paramsList)) {
            DB.executeBatch((DBRoute)this.getDRPDBRoute(), (String)sql.toString(), paramsList);
        }
    }

    private void updateMdrCustomerFunctions(List<Map<Object, Object>> customers) {
        if (customers == null || customers.size() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO T_MDR_CUSTOMER_FUNCTIONS(FPKID,FCUSTOMERID,FBASEDATAID) VALUES(?,?,?) ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(customers.size());
        ArrayList<Object> dataValueList = null;
        long[] pkIds = DBServiceHelper.genLongIds((String)"T_MDR_CUSTOMER_FUNCTIONS", (int)(customers.size() * 3));
        Object customerId = null;
        int index = 0;
        for (Map<Object, Object> customer : customers) {
            customerId = customer.get("FCUSTOMERID");
            dataValueList = new ArrayList<Object>(3);
            dataValueList.add(pkIds[index++]);
            dataValueList.add(customerId);
            dataValueList.add(768696787199340544L);
            paramsList.add(dataValueList.toArray());
            dataValueList = new ArrayList(3);
            dataValueList.add(pkIds[index++]);
            dataValueList.add(customerId);
            dataValueList.add(769522126980935680L);
            paramsList.add(dataValueList.toArray());
            dataValueList = new ArrayList(3);
            dataValueList.add(pkIds[index++]);
            dataValueList.add(customerId);
            dataValueList.add(769522191178951680L);
            paramsList.add(dataValueList.toArray());
        }
        DB.executeBatch((DBRoute)this.getDRPDBRoute(), (String)sql.toString(), paramsList);
    }

    private void updateMdrCustomer(List<Map<Object, Object>> customers) {
        if (customers == null || customers.size() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE T_MDR_CUSTOMER SET ");
        sql.append("FCREATEORGID = ?,");
        sql.append("FORGID = ?,");
        sql.append("FCTRLSTRATEGY = ?,");
        sql.append("FSTATUS = ?,");
        sql.append("FID = FCUSTOMERID");
        sql.append(" WHERE FCUSTOMERID = ? ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(customers.size());
        ArrayList<Object> dataValueList = null;
        for (Map<Object, Object> customer : customers) {
            dataValueList = new ArrayList<Object>(5);
            dataValueList.add(100000L);
            dataValueList.add(100000L);
            dataValueList.add(ControlStrategy.SHARE_IN_GLOBAL.toString());
            dataValueList.add(Status.AUDITED.toString());
            dataValueList.add(Long.valueOf(customer.get("FCUSTOMERID").toString()));
            paramsList.add(dataValueList.toArray());
        }
        DB.executeBatch((DBRoute)this.getDRPDBRoute(), (String)sql.toString(), paramsList);
    }

    private void updateMdrCustomerX(List<Map<Object, Object>> customers, Map<Object, Object> customerId2OrgIdMap, Map<Object, Object> customerId2OrderCusotmerIdMap) {
        if (customers == null || customers.size() == 0) {
            return;
        }
        StringBuilder sql_x = new StringBuilder();
        sql_x.append("UPDATE T_MDR_CUSTOMER_X SET ");
        sql_x.append("FLONGID = ?,");
        sql_x.append("FLONGNUMBER = ?,");
        sql_x.append("FCUSTOMERTYPEID = ?,");
        sql_x.append("FCUSTOMERPROPERTY = ?,");
        sql_x.append("FSALEORGID = ?,");
        sql_x.append("FLEGALCUSTOMERID = FCUSTOMERID,");
        sql_x.append("FISSTORE = ?,");
        sql_x.append("FCURRENCYID = ?,");
        sql_x.append("FORDERCUSTOMERID = ?,");
        sql_x.append("FBALANCECUSTOMERID = FCUSTOMERID,");
        sql_x.append("FRECEIVECUSTOMERID = FCUSTOMERID,");
        sql_x.append("FPAYCUSTOMERID = FCUSTOMERID,");
        sql_x.append("FSALECONTROLMODE = ?,");
        sql_x.append("FISNEGATIVEINVENTORY = ?,");
        sql_x.append("FINVCONTROLMODE = ?");
        sql_x.append(" WHERE FCUSTOMERID = ? ");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(customers.size());
        ArrayList<Object> dataValueList = null;
        long defaultSaleOrgId = 100000L;
        Object saleOrgId = null;
        for (Map<Object, Object> customer : customers) {
            dataValueList = new ArrayList<Object>(16);
            dataValueList.add(customer.get("FCUSTOMERID").toString());
            dataValueList.add(customer.get("FNUMBER"));
            dataValueList.add("1".equals(customer.get("FISINNERORG")) ? 9L : 1L);
            dataValueList.add("1".equals(customer.get("FISINNERORG")) ? CustomerProperty.INNER_ORG.toString() : CustomerProperty.DIRECT_CUSTOMER.toString());
            saleOrgId = this.getSaleOrderId(customer, customerId2OrgIdMap, customerId2OrderCusotmerIdMap, defaultSaleOrgId);
            if (saleOrgId.equals(0L)) {
                saleOrgId = defaultSaleOrgId;
            }
            dataValueList.add(saleOrgId);
            if (!saleOrgId.equals(defaultSaleOrgId)) {
                defaultSaleOrgId = Long.parseLong(saleOrgId.toString());
            }
            dataValueList.add("0");
            dataValueList.add(1L);
            dataValueList.add(this.getOrderCustomerId(customer.get("FNUMBER"), customerId2OrderCusotmerIdMap));
            dataValueList.add(SaleControlMode.BUGUANXIAOLIANG.toString());
            dataValueList.add("0");
            dataValueList.add(InventoryControlMode.ENTRY_IN_SALE_MODE.toString());
            dataValueList.add(customer.get("FCUSTOMERID"));
            paramsList.add(dataValueList.toArray());
        }
        DB.executeBatch((DBRoute)this.getDRPDBRoute(), (String)sql_x.toString(), paramsList);
    }

    private Object getSaleOrderId(Map<Object, Object> customer, Map<Object, Object> customerId2OrgIdMap, Map<Object, Object> customerId2OrderCusotmerIdMap, Object defaultSaleOrgId) {
        boolean isInnerOrg = "1".equals(customer.get("FISINNERORG"));
        Object customerId = customer.get("FCUSTOMERID");
        if (isInnerOrg) {
            if (customerId2OrgIdMap.containsKey(customerId) && customerId2OrgIdMap.get(customerId) != null) {
                return customerId2OrgIdMap.get(customerId);
            }
        } else {
            Object orderCustomerId = this.getOrderCustomerId(customerId, customerId2OrderCusotmerIdMap);
            if (customerId2OrgIdMap.containsKey(orderCustomerId) && customerId2OrgIdMap.get(orderCustomerId) != null) {
                return customerId2OrgIdMap.get(orderCustomerId);
            }
            return defaultSaleOrgId;
        }
        return 0L;
    }

    private Object getOrderCustomerId(Object customerId, Map<Object, Object> customerId2OrderCusotmerIdMap) {
        if (customerId2OrderCusotmerIdMap.containsKey(customerId) && customerId2OrderCusotmerIdMap.get(customerId) != null) {
            return customerId2OrderCusotmerIdMap.get(customerId);
        }
        return 0L;
    }

    private Map<Object, Object> getCustomerId2OrgIdMap(List<Map<Object, Object>> customers) {
        Map<Object, Object> customerId2PartnerIdMap = this.getCustomerId2PartnerIdMap(customers);
        if (!customerId2PartnerIdMap.isEmpty()) {
            HashSet<Object> partnerIds = new HashSet<Object>();
            partnerIds.addAll(customerId2PartnerIdMap.values());
            if (partnerIds.contains(null)) {
                partnerIds.remove(null);
            }
            Map<Object, Object> partnerId2InternalCompanyIdMap = this.getPartnerId2InternalCompanyIdMap(partnerIds.toArray());
            Object partnerId = null;
            Object orgId = null;
            for (Map.Entry<Object, Object> customerId2PartnerIdEntry : customerId2PartnerIdMap.entrySet()) {
                partnerId = customerId2PartnerIdEntry.getValue();
                if (partnerId == null || !partnerId2InternalCompanyIdMap.containsKey(partnerId) || (orgId = partnerId2InternalCompanyIdMap.get(partnerId)) == null) continue;
                customerId2PartnerIdEntry.setValue(orgId);
            }
        }
        return customerId2PartnerIdMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, Object> getPartnerId2InternalCompanyIdMap(Object[] partnerIds) {
        HashMap<Object, Object> result = new HashMap<Object, Object>(16);
        String algokey = this.getClass().getName();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)algokey, (String)"bd_bizpartner", (String)F7Utils.appendSelectCols((String)"id", (String[])new String[]{"internal_company.id"}), (QFilter[])new QFilter("id", "in", (Object)partnerIds).toArray(), null);){
            for (Row row : ds) {
                result.put(row.get(0), row.get(1));
            }
        }
        return result;
    }

    private Map<Object, Object> getCustomerId2PartnerIdMap(List<Map<Object, Object>> customers) {
        if (customers == null || customers.size() == 0) {
            return new HashMap<Object, Object>(0);
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>(customers.size());
        for (Map<Object, Object> customer : customers) {
            map.put(customer.get("FCUSTOMERID"), customer.get("FPARTNERID"));
        }
        return map;
    }

    private List<Map<Object, Object>> getAllCustomer() {
        return (List)DB.query((DBRoute)this.getDRPDBRoute(), (String)"SELECT FCUSTOMERID,FNUMBER,FPARTNERID,FISINNERORG,FCUSTOMERGROUPID FROM T_MDR_CUSTOMER WHERE FCREATEORGID = 0 ", (ResultSetHandler)new ResultSetHandler<List<Map<Object, Object>>>(){

            public List<Map<Object, Object>> handle(ResultSet rs) throws Exception {
                if (rs == null) {
                    return new ArrayList<Map<Object, Object>>(0);
                }
                ArrayList<Map<Object, Object>> results = new ArrayList<Map<Object, Object>>(rs.getRow());
                HashMap<String, Object> result = null;
                while (rs.next()) {
                    result = new HashMap<String, Object>(5);
                    result.put("FCUSTOMERID", rs.getLong("FCUSTOMERID"));
                    result.put("FNUMBER", rs.getString("FNUMBER"));
                    result.put("FPARTNERID", rs.getLong("FPARTNERID"));
                    result.put("FISINNERORG", rs.getObject("FISINNERORG"));
                    result.put("FCUSTOMERGROUPID", rs.getLong("FCUSTOMERGROUPID"));
                    results.add(result);
                }
                return results;
            }
        });
    }

    private Map<Object, Object> getCustomerId2OrderCustomerIdMap() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT T1.FCUSTOMERID,T1.FAUTHOWNERID ");
        sql.append("FROM T_MDR_CUSTOMER_AUTHORIZE T1 ");
        sql.append("INNER JOIN T_MDR_CUSTOMER T2 ON T1.FAUTHOWNERID = T2.FCUSTOMERID ");
        sql.append("WHERE T2.FISINNERORG = '1' ");
        return (Map)DB.query((DBRoute)this.getDRPDBRoute(), (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<Map<Object, Object>>(){

            public Map<Object, Object> handle(ResultSet rs) throws Exception {
                if (rs == null) {
                    return new HashMap<Object, Object>(0);
                }
                HashMap<Object, Object> result = new HashMap<Object, Object>(rs.getRow());
                while (rs.next()) {
                    result.put(rs.getLong("FCUSTOMERID"), rs.getLong("FAUTHOWNERID"));
                }
                return result;
            }
        });
    }
}

