/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.opplugin.basedata;

import java.lang.reflect.Method;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class MEMBaseBaseOppPlugin
extends AbstractOperationServicePlugIn {
    public static final Log logger = LogFactory.getLog(MEMBaseBaseOppPlugin.class);
    public static final String BEFORE_FLAG = "Before";
    public static final String AFTER_FLAG = "After";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        try {
            String methodName = operationKey + BEFORE_FLAG;
            Method method = this.getMethod(methodName, BeforeOperationArgs.class);
            if (method == null) {
                return;
            }
            ReflectionUtils.makeAccessible((Method)method);
            method.invoke((Object)this, e);
        }
        catch (Exception ex) {
            if (ex.getCause() != null && ex.getCause() instanceof KDBizException) {
                KDBizException bizEx = (KDBizException)ex.getCause();
                throw new KDBizException(bizEx.getMessage());
            }
            throw new RuntimeException(ex);
        }
    }

    private Method getMethod(String methodName, Class typeClass) {
        for (Class<?> clazz = ((Object)((Object)this)).getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] paramTypes = methods[i].getParameterTypes();
                if (paramTypes.length <= 0 || !paramTypes[0].equals(typeClass) || !methods[i].getName().equals(methodName)) continue;
                return methods[i];
            }
        }
        return null;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        try {
            String methodName = operationKey + AFTER_FLAG;
            Method method = this.getMethod(methodName, EndOperationTransactionArgs.class);
            if (method == null) {
                return;
            }
            ReflectionUtils.makeAccessible((Method)method);
            method.invoke((Object)this, e);
        }
        catch (Exception ex) {
            if (ex.getCause() != null && ex.getCause() instanceof KDBizException) {
                KDBizException bizEx = (KDBizException)ex.getCause();
                throw new KDBizException(bizEx.getMessage());
            }
            throw new RuntimeException(ex);
        }
    }

    protected static boolean isAddNew(DynamicObject obj) {
        Object pkValue = obj.getPkValue();
        boolean flag = false;
        if (pkValue == null) {
            flag = true;
        } else if (pkValue instanceof Long) {
            Long longValue = (Long)pkValue;
            if (longValue == 0L) {
                flag = true;
            }
        } else {
            flag = pkValue.toString().trim().length() == 0;
        }
        if (flag) {
            return flag;
        }
        return !QueryServiceHelper.exists((String)obj.getDataEntityType().getName(), (Object)pkValue);
    }

    protected String getPK(DynamicObject info) {
        if (info == null) {
            return this.getPK();
        }
        return info.getDataEntityType().getPrimaryKey().getName();
    }

    protected String getPK() {
        return this.billEntityType.getPrimaryKey().getName();
    }

    protected String getEntityName(DynamicObject info) {
        if (info == null) {
            return this.getEntityName();
        }
        return info.getDataEntityType().getName();
    }

    protected String getEntityName() {
        return this.billEntityType.getName();
    }
}

