/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.opplugin.basedata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mem.common.BizBillStatusEnum;
import kd.drp.mem.opplugin.basedata.MEMBaseOppPlugin;

public class MEMBillOppPlugin
extends MEMBaseOppPlugin {
    @Override
    protected List<String[]> getRequiredFieldList(DynamicObject dataInfo) {
        return Collections.emptyList();
    }

    @Override
    protected List<String[]> getCanNotRepeatFieldList() {
        return Collections.emptyList();
    }

    @Override
    protected void checkSave(DynamicObject dynamicObject) {
        super.checkSave(dynamicObject);
    }

    protected void checkIsExist(DynamicObject dynamic, BizBillStatusEnum[] billstatuses, String oppAlias) {
        ArrayList<String> billstatusList = new ArrayList<String>(billstatuses.length);
        for (int i = 0; i < billstatuses.length; ++i) {
            BizBillStatusEnum billstatus = billstatuses[i];
            billstatusList.add(billstatus.getValue());
        }
        QFilter[] filters = new QFilter[]{new QFilter(this.getPK(dynamic), "=", dynamic.getPkValue()), new QFilter(this.getBillstatusField(), "in", (Object)billstatusList.toArray())};
        boolean exists = QueryServiceHelper.exists((String)dynamic.getDataEntityType().getName(), (QFilter[])filters);
        if (!exists) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < billstatuses.length; ++i) {
                BizBillStatusEnum billstatus = billstatuses[i];
                String statusAlias = billstatus.getAlias();
                if (i == 0) {
                    sb.append(statusAlias);
                    continue;
                }
                if (i == billstatuses.length - 1) {
                    sb.append(ResManager.loadKDString((String)"\u6216", (String)"MEMBillOppPlugin_0", (String)"drp-mem-opplugin", (Object[])new Object[0])).append(statusAlias);
                    continue;
                }
                sb.append('\u3001').append(statusAlias);
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u662f%s\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u6267\u884c%s", (String)"MEMBillOppPlugin_1", (String)"drp-mem-opplugin", (Object[])new Object[0]), sb, oppAlias));
        }
    }

    @Override
    protected void submitBefore(BeforeOperationArgs args) {
        super.submitBefore(args);
        DynamicObject[] infos = args.getDataEntities();
        for (int i = 0; i < infos.length; ++i) {
            infos[i].set(this.getBillstatusField(), (Object)BizBillStatusEnum.SUBMITED.getValue());
        }
    }

    protected void submitListBefore(BeforeOperationArgs args) {
        super.submitBefore(args);
        DynamicObject[] infos = args.getDataEntities();
        for (int i = 0; i < infos.length; ++i) {
            infos[i].set(this.getBillstatusField(), (Object)BizBillStatusEnum.SUBMITED.getValue());
        }
    }

    @Override
    protected StringBuilder getSubmitListSelector(DynamicObject info) {
        StringBuilder selector = super.getSubmitListSelector(info);
        if (selector.length() == 0) {
            selector.append(this.getBillstatusField()).append('\n');
        } else {
            selector.append(',').append(this.getBillstatusField()).append('\n');
        }
        return selector;
    }

    @Override
    protected void auditBefore(BeforeOperationArgs args) {
        super.auditBefore(args);
        DynamicObject[] infos = args.getDataEntities();
        for (int i = 0; i < infos.length; ++i) {
            infos[i].set(this.getBillstatusField(), (Object)BizBillStatusEnum.AUDIDPASS.getValue());
        }
    }

    @Override
    protected void unauditBefore(BeforeOperationArgs args) {
        super.unauditBefore(args);
        DynamicObject[] infos = args.getDataEntities();
        for (int i = 0; i < infos.length; ++i) {
            infos[i].set(this.getBillstatusField(), (Object)BizBillStatusEnum.SAVED.getValue());
        }
    }

    @Override
    protected void checkSubmit(DynamicObject dynamicObject) {
        super.checkSubmit(dynamicObject);
        this.checkBillInWorkFlow(dynamicObject);
    }

    protected void checkBillInWorkFlow(DynamicObject dynamicObject) {
    }

    @Override
    protected void checkAudit(DynamicObject dynamicObject) {
        super.checkAudit(dynamicObject);
        if (MEMBillOppPlugin.isAddNew(dynamicObject)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u63d0\u4ea4\u5355\u636e", (String)"MEMBillOppPlugin_2", (String)"drp-mem-opplugin", (Object[])new Object[0]));
        }
        BizBillStatusEnum[] billstatuses = new BizBillStatusEnum[]{BizBillStatusEnum.SUBMITED, BizBillStatusEnum.AUDITING};
        this.checkIsExist(dynamicObject, billstatuses, ResManager.loadKDString((String)"\u5ba1\u6279", (String)"MEMBillOppPlugin_3", (String)"drp-mem-opplugin", (Object[])new Object[0]));
    }

    @Override
    protected void checkDelete(DynamicObject dynamicObject) {
        super.checkDelete(dynamicObject);
        if (MEMBillOppPlugin.isAddNew(dynamicObject)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e", (String)"MEMBillOppPlugin_4", (String)"drp-mem-opplugin", (Object[])new Object[0]));
        }
        BizBillStatusEnum[] billstatuses = new BizBillStatusEnum[]{BizBillStatusEnum.SAVED, BizBillStatusEnum.SUBMITED};
        this.checkIsExist(dynamicObject, billstatuses, ResManager.loadKDString((String)"\u5220\u9664", (String)"MEMBillOppPlugin_5", (String)"drp-mem-opplugin", (Object[])new Object[0]));
    }

    @Override
    protected void checkUnAudit(DynamicObject dynamicObject) {
        super.checkUnAudit(dynamicObject);
        if (MEMBillOppPlugin.isAddNew(dynamicObject)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e", (String)"MEMBillOppPlugin_4", (String)"drp-mem-opplugin", (Object[])new Object[0]));
        }
        BizBillStatusEnum[] billstatuses = new BizBillStatusEnum[]{BizBillStatusEnum.AUDIDPASS};
        this.checkIsExist(dynamicObject, billstatuses, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"MEMBillOppPlugin_6", (String)"drp-mem-opplugin", (Object[])new Object[0]));
    }

    protected String getBillstatusField() {
        return "billstatus";
    }

    protected void closebillBefore(BeforeOperationArgs args) {
        DynamicObject[] infos = args.getDataEntities();
        for (int i = 0; i < infos.length; ++i) {
            this.checkIsExist(infos[i], new BizBillStatusEnum[]{BizBillStatusEnum.AUDIDPASS, BizBillStatusEnum.PARTREFUND}, ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c", (String)"MEMBillOppPlugin_7", (String)"drp-mem-opplugin", (Object[])new Object[0]));
            infos[i].set(this.getBillstatusField(), (Object)BizBillStatusEnum.CLOSED.getValue());
        }
    }

    protected void closebillAfter(EndOperationTransactionArgs args) {
        Object[] infos = args.getDataEntities();
        if (infos.length > 0) {
            BusinessDataServiceHelper.save((IDataEntityType)infos[0].getDataEntityType(), (Object[])infos);
        }
    }
}

