/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.opplugin.cost;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mem.common.BigDecimalUtil;
import kd.drp.mem.common.BizBillStatusEnum;
import kd.drp.mem.opplugin.cost.SynMarketCostApplyUtil;

public class CostOppUtil {
    public static final Log logger = LogFactory.getLog(CostOppUtil.class);

    private CostOppUtil() {
    }

    public static Map<String, Object> updateApplyBill(DynamicObject dynObj, boolean isAudit) {
        logger.info("\u66f4\u65b0\u62a5\u9500\u7533\u8bf7\u5355:id=" + dynObj.getPkValue() + ";" + dynObj + ";isAudit=" + isAudit);
        dynObj = BusinessDataServiceHelper.loadSingle((Object)dynObj.getPkValue(), (String)dynObj.getDataEntityType().getName());
        DynamicObjectCollection entryColl = dynObj.getDynamicObjectCollection("entrys");
        if (entryColl == null || entryColl.size() == 0) {
            logger.info(dynObj.getString("billno") + " entrys is null");
            return null;
        }
        Object applyBillId = ((DynamicObject)entryColl.get(0)).get("sourceid");
        if (applyBillId == null || "0".equals(applyBillId.toString())) {
            logger.info(dynObj.getString("billno") + " applyBillId is null");
            return null;
        }
        StringBuilder selector = new StringBuilder();
        selector.append("id,");
        selector.append("totalamtapply,");
        selector.append("totalamount,");
        selector.append("totalamtunapproved,");
        selector.append("entrys,");
        selector.append("entrys.id,");
        selector.append("entrys.sourceentryid,");
        selector.append("entrys.amount,");
        selector.append("entrys.amtapproved,");
        selector.append("entrys.amtunapproved");
        QFilter[] filters = new QFilter[]{new QFilter("entrys.sourceid", "=", applyBillId), new QFilter("billstatus", "=", (Object)"E")};
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)dynObj.getDataEntityType().getName(), (String)selector.toString(), (QFilter[])filters);
        HashMap<String, BigDecimal> applyEntryValMap = new HashMap<String, BigDecimal>();
        if (dyns != null && dyns.length != 0) {
            logger.info(dynObj.getString("billno") + " reimbursopp is" + dyns.length);
            for (int i = 0; i < dyns.length; ++i) {
                DynamicObject dynInfo = dyns[i];
                DynamicObjectCollection entrys = (DynamicObjectCollection)dynInfo.get("entrys");
                if (entrys == null) continue;
                for (int j = 0; j < entrys.size(); ++j) {
                    DynamicObject entry = (DynamicObject)entrys.get(j);
                    Object applyentryid = entry.get("sourceentryid");
                    if (applyentryid == null) continue;
                    BigDecimal amount = entry.getBigDecimal("amount") == null ? BigDecimal.ZERO : entry.getBigDecimal("amount");
                    BigDecimal amtapproved = entry.getBigDecimal("amtapproved") == null ? BigDecimal.ZERO : entry.getBigDecimal("amtapproved");
                    BigDecimal amtunapproved = BigDecimalUtil.subtractObject((Object)amount, (Object)amtapproved);
                    String mapKey1 = applyentryid + "refundamount";
                    String mapKey2 = applyentryid + "amtapproved";
                    String mapKey3 = applyentryid + "amtunapproved";
                    if (applyEntryValMap.get(mapKey1) != null) {
                        applyEntryValMap.put(mapKey1, ((BigDecimal)applyEntryValMap.get(mapKey1)).add(amount));
                        applyEntryValMap.put(mapKey2, ((BigDecimal)applyEntryValMap.get(mapKey2)).add(amtapproved));
                        applyEntryValMap.put(mapKey3, ((BigDecimal)applyEntryValMap.get(mapKey3)).add(amtunapproved));
                        continue;
                    }
                    applyEntryValMap.put(mapKey1, amount);
                    applyEntryValMap.put(mapKey2, amtapproved);
                    applyEntryValMap.put(mapKey3, amtunapproved);
                }
            }
        } else {
            logger.info(dynObj.getString("billno") + " reimbursopp is empty");
        }
        DynamicObject applyBill = BusinessDataServiceHelper.loadSingle((Object)applyBillId, (String)"mem_market_cost_apply", (String)"entryentity,entryentity.refundamount,entryentity.amtapproved,entryentity.amtunapproved,totalrefundamount,totalamtapproved,entryentity.amount,totalamount,totalamtunapproved,billstatus,issyn");
        if (applyBill != null) {
            DynamicObjectCollection applyEntrys = (DynamicObjectCollection)applyBill.get("entryentity");
            BigDecimal refundamountSum = BigDecimal.ZERO;
            BigDecimal amtapprovedSum = BigDecimal.ZERO;
            BigDecimal amtunapprovedSum = BigDecimal.ZERO;
            for (int i = 0; i < applyEntrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)applyEntrys.get(i);
                Object entryId = entry.getPkValue();
                String mapKey1 = entryId + "refundamount";
                String mapKey2 = entryId + "amtapproved";
                if (applyEntryValMap.get(mapKey1) != null) {
                    entry.set("refundamount", applyEntryValMap.get(mapKey1));
                    entry.set("amtapproved", applyEntryValMap.get(mapKey2));
                    entry.set("amtunapproved", (Object)BigDecimalUtil.subtractObject((Object)entry.get("amount"), applyEntryValMap.get(mapKey1)));
                } else {
                    entry.set("refundamount", (Object)BigDecimal.ZERO);
                    entry.set("amtapproved", (Object)BigDecimal.ZERO);
                    entry.set("amtunapproved", entry.get("amount"));
                }
                BigDecimal refundamount = entry.getBigDecimal("refundamount") == null ? BigDecimal.ZERO : entry.getBigDecimal("refundamount");
                BigDecimal amtapproved = entry.getBigDecimal("amtapproved") == null ? BigDecimal.ZERO : entry.getBigDecimal("amtapproved");
                BigDecimal amtunapproved = entry.getBigDecimal("amtunapproved") == null ? BigDecimal.ZERO : entry.getBigDecimal("amtunapproved");
                refundamountSum = refundamountSum.add(refundamount);
                amtapprovedSum = amtapprovedSum.add(amtapproved);
                amtunapprovedSum = amtunapprovedSum.add(amtunapproved);
            }
            applyBill.set("totalrefundamount", (Object)refundamountSum);
            applyBill.set("totalamtapproved", (Object)amtapprovedSum);
            amtunapprovedSum = BigDecimalUtil.subtractObject((Object)applyBill.get("totalamount"), (Object)amtapprovedSum);
            applyBill.set("totalamtunapproved", (Object)amtunapprovedSum);
            logger.info(dynObj.getString("billno") + " refundamountSum is" + refundamountSum);
            logger.info(dynObj.getString("billno") + " amtapprovedSum is" + amtapprovedSum);
            logger.info(dynObj.getString("billno") + " amtunapprovedSum is" + amtunapprovedSum);
            if (amtapprovedSum != null && amtapprovedSum.floatValue() > 0.0f) {
                logger.info(dynObj.getString("billno") + " amtapprovedSum is" + amtapprovedSum);
                if (amtunapprovedSum != null && amtunapprovedSum.floatValue() > 0.0f) {
                    applyBill.set("billstatus", (Object)BizBillStatusEnum.PARTREFUND.getValue());
                } else if (isAudit) {
                    applyBill.set("billstatus", (Object)BizBillStatusEnum.CLOSED.getValue());
                }
            } else {
                applyBill.set("billstatus", (Object)BizBillStatusEnum.AUDIDPASS.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{applyBill});
            if (amtapprovedSum != null && amtapprovedSum.floatValue() > 0.0f && (amtunapprovedSum == null || !(amtunapprovedSum.floatValue() > 0.0f)) && isAudit) {
                return SynMarketCostApplyUtil.getMarketCostApplyClose(applyBill);
            }
        }
        return null;
    }
}

