/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.opplugin.cost;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mem.common.BizBillStatusEnum;
import kd.drp.mem.common.DateUtil;
import kd.drp.mem.common.EnableStatusEnum;
import kd.drp.mem.common.ExecStatusEnum;

public class ExecuteStatusTask
extends AbstractTask {
    protected Log logger = LogFactory.getLog(ExecuteStatusTask.class);

    public void execute(RequestContext ctx, Map<String, Object> params) throws KDException {
        this.execute(null);
    }

    public void execute(Object billId) {
        QFilter f = this.getCostTypeFilter();
        if (f == null) {
            this.logger.info("CostTypeFilter is null");
            return;
        }
        QFilter qFilter = this.getQFilterForComExecute(f, billId);
        DynamicObject[] costApplys = BusinessDataServiceHelper.load((String)"mem_market_cost_apply", (String)"billstatus,enddate,execstatus,expensetype", (QFilter[])qFilter.toArray());
        this.logger.info("ExecuteStatusTask:ed qFilter:" + qFilter);
        if (costApplys.length == 0) {
            this.logger.info("ExecuteStatusTask:query 0 executed Data");
        } else {
            this.logger.info("ExecuteStatusTask:query " + costApplys.length + " executed Data.");
            for (DynamicObject info : costApplys) {
                info.set("execstatus", (Object)ExecStatusEnum.ECECUTEED.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])costApplys);
        }
        qFilter = this.getQFilterForComExecuting(f, billId);
        this.logger.info("ExecuteStatusTask:ing qFilter:" + qFilter);
        costApplys = BusinessDataServiceHelper.load((String)"mem_market_cost_apply", (String)"billstatus,begindate,enddate,execstatus,expensetype", (QFilter[])qFilter.toArray());
        if (costApplys.length == 0) {
            this.logger.info("ExecuteStatusTask:query 0 executing Data");
        } else {
            this.logger.info("ExecuteStatusTask:query " + costApplys.length + " executing Data.");
            for (DynamicObject info : costApplys) {
                info.set("execstatus", (Object)ExecStatusEnum.ECECUTEING.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])costApplys);
        }
        qFilter = this.getQFilterForUnComExecute(f, billId);
        this.logger.info("ExecuteStatusTask:unExec qFilter:" + qFilter);
        costApplys = BusinessDataServiceHelper.load((String)"mem_market_cost_apply", (String)"billstatus,begindate,execstatus,expensetype", (QFilter[])qFilter.toArray());
        if (costApplys.length != 0) {
            for (DynamicObject info : costApplys) {
                info.set("execstatus", (Object)ExecStatusEnum.UNECECUTE.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])costApplys);
        }
    }

    protected QFilter getQFilterForUnComExecute(QFilter f, Object billId) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BizBillStatusEnum.AUDIDPASS.getValue());
        QFilter f1 = new QFilter("execstatus", "!=", (Object)ExecStatusEnum.UNECECUTE.getValue());
        Date sysdate = DateUtil.getDayFirst((Date)new Date());
        QFilter f2 = new QFilter("begindate", ">", (Object)sysdate);
        qFilter.and(f);
        qFilter.and(f1);
        qFilter.and(f2);
        if (billId != null) {
            qFilter.and(new QFilter("id", "=", billId));
        }
        return qFilter;
    }

    protected QFilter getQFilterForComExecute(QFilter f, Object billId) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BizBillStatusEnum.AUDIDPASS.getValue());
        qFilter.or(new QFilter("billstatus", "=", (Object)BizBillStatusEnum.PARTREFUND.getValue()));
        Date sysdate = DateUtil.getDayFirst((Date)new Date());
        QFilter f1 = new QFilter("enddate", "<", (Object)sysdate);
        QFilter f2 = new QFilter("execstatus", "!=", (Object)ExecStatusEnum.ECECUTEED.getValue());
        qFilter.and(f);
        qFilter.and(f1);
        qFilter.and(f2);
        if (billId != null) {
            qFilter.and(new QFilter("id", "=", billId));
        }
        return qFilter;
    }

    protected QFilter getQFilterForComExecuting(QFilter f, Object billId) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BizBillStatusEnum.AUDIDPASS.getValue());
        qFilter.or(new QFilter("billstatus", "=", (Object)BizBillStatusEnum.PARTREFUND.getValue()));
        QFilter f1 = new QFilter("execstatus", "!=", (Object)ExecStatusEnum.ECECUTEING.getValue());
        Date sysdate = DateUtil.getDayLast((Date)new Date());
        QFilter f2 = new QFilter("begindate", "<=", (Object)sysdate);
        sysdate = DateUtil.getDayFirst((Date)new Date());
        QFilter f3 = new QFilter("enddate", ">=", (Object)sysdate);
        qFilter.and(f);
        qFilter.and(f1);
        qFilter.and(f2);
        qFilter.and(f3);
        if (billId != null) {
            qFilter.and(new QFilter("id", "=", billId));
        }
        return qFilter;
    }

    public QFilter getCostTypeFilter() {
        QFilter filter = new QFilter("enabled", "=", (Object)EnableStatusEnum.ENABLED.getValue());
        DynamicObjectCollection rs = QueryServiceHelper.query((String)"mem_billconfig", (String)"expensetype,enabled,costexecute", (QFilter[])filter.toArray());
        if (rs == null || rs.size() == 0) {
            return null;
        }
        HashSet<Object> set = new HashSet<Object>();
        for (DynamicObject obj : rs) {
            set.add(obj.get("expensetype"));
        }
        return new QFilter("expensetype", "in", set);
    }
}

