/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.opplugin.cost;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mem.common.BizBillStatusEnum;
import kd.drp.mem.common.DateUtil;
import kd.drp.mem.common.ExecStatusEnum;
import kd.drp.mem.common.FreezeStatusEnum;
import kd.drp.mem.opplugin.cost.ExecuteStatusTask;

public class FreezeStatusTask
extends AbstractTask {
    protected Log logger = LogFactory.getLog(ExecuteStatusTask.class);

    public void execute(RequestContext ctx, Map<String, Object> params) throws KDException {
        QFilter qFilter = null;
        int controlDay = QueryServiceHelper.queryOne((String)"mem_sys_params", (String)"maximumaudittime", null).getInt("maximumaudittime");
        this.logger.info("FreezeStatusTask: controlDay=" + controlDay);
        Date currentDate = new Date();
        if (controlDay > 0) {
            QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)BizBillStatusEnum.AUDIDPASS.getValue());
            billStatusFilter.or("billstatus", "=", (Object)BizBillStatusEnum.PARTREFUND.getValue());
            QFilter freezeStatusFilter = new QFilter("freezestatus", "=", (Object)"");
            freezeStatusFilter.or("freezestatus", "=", null);
            qFilter = billStatusFilter.and(freezeStatusFilter);
            QFilter excuteStatusFilter = new QFilter("execstatus", "=", (Object)ExecStatusEnum.ECECUTEED.getValue());
            qFilter.and(excuteStatusFilter);
            this.logger.info("FreezeStatusTask: freezes status filter=" + qFilter);
            DynamicObject[] costApplys = BusinessDataServiceHelper.load((String)"mem_market_cost_apply", (String)"billno,freezestatus,freezedate,enddate,execstatus", (QFilter[])qFilter.toArray());
            if (costApplys.length == 0) {
                return;
            }
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            for (DynamicObject info : costApplys) {
                Date endDate = info.getDate("enddate");
                if (endDate == null) continue;
                this.logger.info("FreezeStatusTask: billno=" + info.getString("billno") + ";endDate=" + endDate);
                endDate = DateUtil.getDayLast((Date)endDate);
                int dif = (int)(currentDate.getTime() - endDate.getTime()) / 86400000;
                this.logger.info("FreezeStatusTask: billno=" + info.getString("billno") + ";dif=" + dif);
                if (dif <= controlDay) continue;
                info.set("freezestatus", (Object)FreezeStatusEnum.FREEZED.getValue());
                info.set("freezedate", (Object)new Date());
                list.add(info);
            }
            if (list.size() > 0) {
                this.logger.info("FreezeStatusTask: list=" + list.size());
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
            }
        }
    }
}

