/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.opplugin.cost;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mem.common.BizBillStatusEnum;
import kd.drp.mem.opplugin.basedata.MEMBillOppPlugin;
import kd.drp.mem.opplugin.cost.SynMarketCostApplyUtil;

public class MarketCostApplyAuditNotPassPlugin
extends MEMBillOppPlugin {
    private String AUDIT_NOT_PASS = "auditnotpass";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
    }

    @Override
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        if (this.AUDIT_NOT_PASS.equals(operationKey)) {
            DynamicObject[] infos = e.getDataEntities();
            for (int i = 0; i < infos.length; ++i) {
                if (!BizBillStatusEnum.SUBMITED.getValue().equals(infos[i].get("billstatus")) && !BizBillStatusEnum.AUDITING.getValue().equals(infos[i].get("billstatus"))) {
                    throw new KDBizException((StringUtils.isEmpty((String)infos[i].getString("billno")) ? "" : String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s\u7684\u6570\u636e", (String)"MarketCostApplyAuditNotPassPlugin_0", (String)"drp-mem-opplugin", (Object[])new Object[0]), infos[i].getString("billno"))) + ResManager.loadKDString((String)"\u975e\u63d0\u4ea4\u3001\u5ba1\u6279\u4e2d\u72b6\u6001\u4e0d\u80fd\u5ba1\u6279", (String)"MarketCostApplyAuditNotPassPlugin_1", (String)"drp-mem-opplugin", (Object[])new Object[0]));
                }
                infos[i].set(this.getBillstatusField(), (Object)BizBillStatusEnum.AUDITNOPASS.getValue());
            }
        }
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if (this.AUDIT_NOT_PASS.equals(operationKey)) {
            DynamicObject[] infos = e.getDataEntities();
            SaveServiceHelper.save((DynamicObject[])infos);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (this.AUDIT_NOT_PASS.equals(e.getOperationKey())) {
            DynamicObject[] datas = e.getDataEntities();
            if (SysParamsUtil.isOpenEasSync()) {
                for (int i = 0; i < datas.length; ++i) {
                    SynMarketCostApplyUtil.synMarketCostApplyAuditNotPass(datas[i]);
                }
            }
        }
    }
}

