/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.opplugin.cost;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mem.common.BigDecimalUtil;
import kd.drp.mem.common.BizBillStatusEnum;
import kd.drp.mem.common.ExecStatusEnum;
import kd.drp.mem.opplugin.basedata.MEMBillOppPlugin;
import kd.drp.mem.opplugin.cost.SynMarketCostApplyUtil;

public class MarketCostApplyCloseOppPlugin
extends MEMBillOppPlugin {
    protected Log logger = LogFactory.getLog(MarketCostApplyCloseOppPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("execstatus");
        e.getFieldKeys().add("issyn");
    }

    @Override
    protected void closebillBefore(BeforeOperationArgs e) {
        super.closebillBefore(e);
        DynamicObject[] datas = e.getDataEntities();
        HashSet<Object> set = new HashSet<Object>(datas.length);
        for (int i = 0; i < datas.length; ++i) {
            set.add(datas[i].getPkValue());
            datas[i].set("execstatus", (Object)ExecStatusEnum.ECECUTEED.getValue());
        }
        QFilter filter = new QFilter("billstatus", "!=", (Object)BizBillStatusEnum.AUDIDPASS.getValue());
        filter.and("billstatus", "!=", (Object)BizBillStatusEnum.AUDITNOPASS.getValue());
        filter.and("billstatus", "!=", (Object)BizBillStatusEnum.CLOSED.getValue());
        filter.and("billstatus", "!=", (Object)BizBillStatusEnum.PARTREFUND.getValue());
        filter.and("entrys.sourceid", "in", set.stream().map(id -> id.toString()).collect(Collectors.toList()));
        if (QueryServiceHelper.exists((String)"mem_market_cost_reimburse", (QFilter[])filter.toArray())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u5c1a\u672a\u5ba1\u6279\u7684\u5e02\u573a\u8d39\u7528\u62a5\u9500\u5355.", (String)"MarketCostApplyCloseOppPlugin_0", (String)"drp-mem-opplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected void closebillAfter(EndOperationTransactionArgs e) {
        super.closebillAfter(e);
        if (SysParamsUtil.isOpenEasSync()) {
            DynamicObject[] datas = e.getDataEntities();
            for (int i = 0; i < datas.length; ++i) {
                if (!datas[i].getDynamicObjectType().getProperties().containsKey((Object)"issyn") && datas[i].getBoolean("issyn")) {
                    this.logger.info("MarketCostApplyCloseOppPlugin pk\u4e3a:" + datas[i].getPkValue() + "\u4e0d\u9700\u8981\u540c\u6b65.");
                    continue;
                }
                DynamicObject costApply = BusinessDataServiceHelper.loadSingle((Object)datas[i].getPkValue(), (String)"mem_market_cost_apply", (String)"id,totalamount,totalamtapproved");
                BigDecimal dif = BigDecimalUtil.subtractObject((Object)costApply.getBigDecimal("totalamount"), (Object)costApply.getBigDecimal("totalamtapproved"));
                if (dif != null && dif.floatValue() > 0.0f) {
                    SynMarketCostApplyUtil.synMarketCostApplyUpdateAndClose(costApply);
                    continue;
                }
                SynMarketCostApplyUtil.synMarketCostApplyClose(costApply);
            }
        }
    }
}

