/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.opplugin.cost;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mem.common.CostBillServiceHelper;
import kd.drp.mem.common.DateUtil;
import kd.drp.mem.opplugin.basedata.MEMBillOppPlugin;
import kd.drp.mem.opplugin.basedata.MEMOppUtil;
import kd.drp.mem.opplugin.cost.SynMarketCostApplyUtil;

public class MarketCostApplyOppPlugin
extends MEMBillOppPlugin {
    protected static final String ENTRYENDDATE = "entryenddate";
    protected static final String ENTRYBEGINDATE = "entrybegindate";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        MEMOppUtil.onPreparePropertys(e, "entryentity", "bill", "mem_market_costapplyentry");
    }

    @Override
    protected void saveBefore(BeforeOperationArgs args) {
        super.saveBefore(args);
        this.checkEmpty(args);
    }

    @Override
    protected void submitBefore(BeforeOperationArgs args) {
        super.submitBefore(args);
        this.checkEmpty(args);
    }

    protected void checkEmpty(BeforeOperationArgs args) {
        DynamicObject[] infos = args.getDataEntities();
        for (int i = 0; i < infos.length; ++i) {
            StringBuilder msg = new StringBuilder();
            DynamicObject expensetype = CostBillServiceHelper.getBillConfigExpenseType((Object)infos[i].getDynamicObject("expensetype").getPkValue());
            if (expensetype != null) {
                DynamicObjectCollection entrys;
                boolean bool = infos[i].getDataEntityType().getProperties().containsKey((Object)"entryentity");
                DynamicObjectCollection billconfigentrys = expensetype.getDynamicObjectCollection("mem_billconfigentrys");
                if (!bool) {
                    StringBuilder sql = new StringBuilder("entryentity,entryentity.id");
                    for (DynamicObject billconfigentry : billconfigentrys) {
                        sql.append(",entryentity.").append(billconfigentry.getDynamicObject("fieldname").getString("number"));
                    }
                    DynamicObject e = BusinessDataServiceHelper.loadSingle((Object)infos[i].getPkValue(), (String)infos[i].getDataEntityType().getName(), (String)sql.toString());
                    entrys = e.getDynamicObjectCollection("entryentity");
                } else {
                    entrys = infos[i].getDynamicObjectCollection("entryentity");
                }
                if (entrys == null || entrys.size() < 1) {
                    msg.append(ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a.\n", (String)"MarketCostApplyOppPlugin_0", (String)"drp-mem-opplugin", (Object[])new Object[0]));
                } else {
                    for (DynamicObject billconfigentry : billconfigentrys) {
                        DynamicObject fieldName = billconfigentry.getDynamicObject("fieldname");
                        if (!billconfigentry.getBoolean("isrequired")) continue;
                        for (int j = 0; j < entrys.size(); ++j) {
                            DynamicObject entry = (DynamicObject)entrys.get(j);
                            if (entry.get(fieldName.getString("number")) != null && !StringUtils.isEmpty((String)entry.get(fieldName.getString("number")).toString())) continue;
                            msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c%s\u4e0d\u80fd\u4e3a\u7a7a.\n", (String)"MarketCostApplyOppPlugin_1", (String)"drp-mem-opplugin", (Object[])new Object[0]), j + 1, fieldName.getString("name")));
                        }
                    }
                    Date currentDate = DateUtil.getDayFirst((Date)new Date());
                    for (int j = 0; j < entrys.size(); ++j) {
                        Date beginDate = ((DynamicObject)entrys.get(j)).getDate(ENTRYBEGINDATE);
                        if (beginDate == null) {
                            msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a.\n", (String)"MarketCostApplyOppPlugin_2", (String)"drp-mem-opplugin", (Object[])new Object[0]), j + 1));
                        } else if ((beginDate = DateUtil.getDayFirst((Date)beginDate)).getTime() < currentDate.getTime()) {
                            msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f.\n", (String)"MarketCostApplyOppPlugin_3", (String)"drp-mem-opplugin", (Object[])new Object[0]), j + 1));
                        }
                        Date endDate = ((DynamicObject)entrys.get(j)).getDate(ENTRYENDDATE);
                        if (endDate == null) {
                            msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a.\n", (String)"MarketCostApplyOppPlugin_4", (String)"drp-mem-opplugin", (Object[])new Object[0]), j + 1));
                        } else {
                            endDate = DateUtil.getDayLast((Date)endDate);
                        }
                        if (beginDate == null || endDate == null || beginDate.getTime() <= endDate.getTime()) continue;
                        msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f.\n", (String)"MarketCostApplyOppPlugin_5", (String)"drp-mem-opplugin", (Object[])new Object[0]), j + 1));
                    }
                }
            }
            if (msg.length() <= 0) continue;
            throw new KDBizException(msg.toString());
        }
    }

    @Override
    protected void submitAfter(EndOperationTransactionArgs e) {
        super.submitAfter(e);
        if (SysParamsUtil.isOpenEasSync()) {
            DynamicObject[] datas = e.getDataEntities();
            for (int i = 0; i < datas.length; ++i) {
                SynMarketCostApplyUtil.synMarketCostApplyData(datas[i]);
            }
        }
    }

    protected void unsubmitAfter(EndOperationTransactionArgs e) {
        if (SysParamsUtil.isOpenEasSync()) {
            DynamicObject[] datas = e.getDataEntities();
            for (int i = 0; i < datas.length; ++i) {
                SynMarketCostApplyUtil.synMarketCostApplyDelete(datas[i]);
            }
        }
    }

    @Override
    protected List<String[]> getRequiredFieldList(DynamicObject dataInfo) {
        ArrayList<String[]> listField = new ArrayList<String[]>();
        listField.add(new String[]{"billno", ResManager.loadKDString((String)"\u7f16\u7801", (String)"MarketCostApplyOppPlugin_6", (String)"drp-mem-opplugin", (Object[])new Object[0])});
        return listField;
    }

    @Override
    protected List<String[]> getCanNotRepeatFieldList() {
        ArrayList<String[]> listField = new ArrayList<String[]>();
        listField.add(new String[]{"billno", ResManager.loadKDString((String)"\u7f16\u7801", (String)"MarketCostApplyOppPlugin_6", (String)"drp-mem-opplugin", (Object[])new Object[0])});
        return listField;
    }
}

