/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.opplugin.cost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mem.common.BigDecimalUtil;
import kd.drp.mem.common.BizBillStatusEnum;
import kd.drp.mem.opplugin.basedata.MEMBillOppPlugin;
import kd.drp.mem.opplugin.cost.SynMarketCostReimburseUtil;

public class MarketCostReimburseOppPlugin
extends MEMBillOppPlugin {
    protected Log logger = LogFactory.getLog(MarketCostReimburseOppPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entrys.sourceid");
        e.getFieldKeys().add("entrys.sourceentryid");
        e.getFieldKeys().add("entrys.amtapproved");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("receivable");
        e.getFieldKeys().add("receivable.receivableamt");
        e.getFieldKeys().add("totalamount");
    }

    @Override
    protected List<String[]> getRequiredFieldList(DynamicObject dataInfo) {
        ArrayList<String[]> listField = new ArrayList<String[]>();
        listField.add(new String[]{"billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"MarketCostReimburseOppPlugin_0", (String)"drp-mem-opplugin", (Object[])new Object[0])});
        return listField;
    }

    protected void unsubmitAfter(EndOperationTransactionArgs e) {
        if (SysParamsUtil.isOpenEasSync()) {
            DynamicObject[] datas = e.getDataEntities();
            for (int i = 0; i < datas.length; ++i) {
                SynMarketCostReimburseUtil.synMarketCostReimburseDelete(datas[i]);
            }
        }
    }

    @Override
    protected List<String[]> getCanNotRepeatFieldList() {
        ArrayList<String[]> listField = new ArrayList<String[]>();
        listField.add(new String[]{"billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"MarketCostReimburseOppPlugin_0", (String)"drp-mem-opplugin", (Object[])new Object[0])});
        return listField;
    }

    @Override
    protected void checkSave(DynamicObject dynamicObject) {
        super.checkSave(dynamicObject);
        this.checkBill(dynamicObject);
    }

    @Override
    protected void checkSubmit(DynamicObject dynamicObject) {
        super.checkSubmit(dynamicObject);
        this.checkBill(dynamicObject);
    }

    @Override
    protected void checkAudit(DynamicObject dynamicObject) {
        super.checkAudit(dynamicObject);
    }

    protected void checkBill(DynamicObject dynamicObject) {
        DynamicObject dynObj;
        StringBuilder msg = new StringBuilder();
        DynamicObjectCollection entrys2 = dynamicObject.getDynamicObjectCollection("entrys");
        for (int i = 0; i < entrys2.size(); ++i) {
            DynamicObject eInfo = (DynamicObject)entrys2.get(i);
            if (eInfo.getBigDecimal("amount") == null || eInfo.getBigDecimal("amount").abs().floatValue() < 0.01f) {
                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u4e3a0\n", (String)"MarketCostReimburseOppPlugin_1", (String)"drp-mem-opplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            BigDecimal dif = BigDecimalUtil.subtractObject((Object)eInfo.getBigDecimal("amtapply"), (Object)eInfo.getBigDecimal("amount"));
            if (dif == null || !(dif.floatValue() <= -0.01f)) continue;
            msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u62a5\u9500\u91d1\u989d(%s)\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d(%s)\uff01\n", (String)"MarketCostReimburseOppPlugin_2", (String)"drp-mem-opplugin", (Object[])new Object[0]), i + 1, BigDecimalUtil.setScale((Object)eInfo.getBigDecimal("amount"), (int)2), BigDecimalUtil.setScale((Object)eInfo.getBigDecimal("amtapply"), (int)2)));
        }
        BigDecimal borrowSum = BigDecimal.ZERO;
        if (dynamicObject.getDataEntityType().getProperties().containsKey((Object)"offsetborrow")) {
            DynamicObjectCollection offsetEntrys = dynamicObject.getDynamicObjectCollection("offsetborrow");
            for (int i = 0; i < offsetEntrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)offsetEntrys.get(i);
                if (entry.getBigDecimal("offsetamt").compareTo(entry.getBigDecimal("brwamt")) <= 0) continue;
                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u51b2\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u501f\u6b3e\u91d1\u989d\uff01\n", (String)"MarketCostReimburseOppPlugin_3", (String)"drp-mem-opplugin", (Object[])new Object[0]), i + 1));
                borrowSum = BigDecimalUtil.addObject((Object)borrowSum, (Object)entry.getBigDecimal("offsetamt"));
            }
        }
        DynamicObjectCollection dynReceivables = (DynamicObjectCollection)dynamicObject.get("receivable");
        BigDecimal receiveSum = BigDecimal.ZERO;
        if (dynReceivables != null && dynReceivables.size() != 0) {
            BigDecimal totalamount;
            int rowCount = dynReceivables.size();
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject dyn = (DynamicObject)dynReceivables.get(i);
                BigDecimal val = dyn.getBigDecimal("receivableamt");
                receiveSum = receiveSum.add(val == null ? BigDecimal.ZERO : val);
            }
            BigDecimal sum = receiveSum.add(borrowSum);
            BigDecimal bigDecimal = totalamount = dynamicObject.getBigDecimal("totalamtapproved") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("totalamtapproved");
            if (totalamount.compareTo(sum) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0e\u51b2\u9500\u91d1\u989d\u5408\u8ba1\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e\u6838\u51c6\u91d1\u989d\u5408\u8ba1\uff01", (String)"MarketCostReimburseOppPlugin_4", (String)"drp-mem-opplugin", (Object[])new Object[0]));
            }
        }
        if ((dynObj = dynamicObject).getDynamicObjectCollection("entrys") == null && dynObj.getDynamicObjectCollection("entrys").size() == 0) {
            this.logger.info(dynObj.getString("billno") + " entrys is null.");
            return;
        }
        DynamicObjectCollection entryColl = dynObj.getDynamicObjectCollection("entrys");
        if (entryColl == null || entryColl.size() < 1) {
            this.logger.info(dynObj.getString("billno") + " entrys is empty.");
            return;
        }
        Object applyBillId = ((DynamicObject)entryColl.get(0)).get("sourceid");
        if (applyBillId == null || StringUtils.isEmpty((String)applyBillId.toString()) || "0".equals(applyBillId.toString())) {
            this.logger.info(dynObj.getString("billno") + " applyBillId is null.");
            return;
        }
        StringBuilder selector = new StringBuilder();
        selector.append("id,");
        selector.append("totalamtapply,");
        selector.append("totalamount,");
        selector.append("totalamtunapproved,");
        selector.append("entrys,");
        selector.append("entrys.id,");
        selector.append("entrys.sourceentryid,");
        selector.append("entrys.sourceid,");
        selector.append("entrys.amount,");
        selector.append("entrys.amtapproved,");
        selector.append("entrys.amtunapproved");
        QFilter filters = new QFilter("entrys.sourceid", "=", applyBillId);
        filters.and("billstatus", "!=", (Object)BizBillStatusEnum.AUDITNOPASS.getValue());
        if (dynObj.getPkValue() != null) {
            filters.and("id", "!=", dynObj.getPkValue());
        }
        DynamicObject[] reimburseDyns = BusinessDataServiceHelper.load((String)dynObj.getDataEntityType().getName(), (String)selector.toString(), (QFilter[])filters.toArray());
        HashMap<String, BigDecimal> applyEntryValMap = new HashMap<String, BigDecimal>();
        if (reimburseDyns != null && reimburseDyns.length != 0) {
            this.logger.info(dynObj.getString("billno") + " reimbursopp is" + reimburseDyns.length);
            for (int t = 0; t < reimburseDyns.length; ++t) {
                DynamicObject dynInfo = reimburseDyns[t];
                this.addEnryToMap(applyEntryValMap, dynInfo);
            }
        } else {
            this.logger.info(dynObj.getString("billno") + " reimbursopp is empty");
        }
        this.addEnryToMap(applyEntryValMap, dynObj);
        DynamicObject applyBill = BusinessDataServiceHelper.loadSingle((Object)applyBillId, (String)"mem_market_cost_apply");
        if (applyBill != null) {
            DynamicObjectCollection applyEntrys = (DynamicObjectCollection)applyBill.get("entryentity");
            for (int t = 0; t < applyEntrys.size(); ++t) {
                BigDecimal applyEntryVal;
                DynamicObject entry = (DynamicObject)applyEntrys.get(t);
                Object entryId = entry.getPkValue();
                BigDecimal amount = entry.getBigDecimal("amount");
                BigDecimal dif = BigDecimalUtil.subtractObject((Object)amount, (Object)(applyEntryVal = (BigDecimal)applyEntryValMap.get(entryId.toString())));
                if (dif == null || !(dif.floatValue() <= -0.01f)) continue;
                msg.append(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u540e\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\uff1a%s\u7684\u7b2c%s\u884c\u7684\u7d2f\u8ba1\u751f\u6210\u751f\u6210\u7684\u5e02\u573a\u8d39\u7528\u62a5\u9500\u5355\u91d1\u989d%s\u5927\u4e8e\u5e02\u573a\u8d39\u7528\u7533\u8bf7\u5355\u91d1\u989d%s", (String)"MarketCostReimburseOppPlugin_5", (String)"drp-mem-opplugin", (Object[])new Object[0]), applyBill.getString("billno"), t + 1, BigDecimalUtil.setScale((Object)applyEntryVal), BigDecimalUtil.setScale((Object)amount)));
            }
        }
        if (msg.length() > 0) {
            throw new KDBizException(msg.toString());
        }
    }

    protected void addEnryToMap(Map<String, BigDecimal> applyEntryValMap, DynamicObject dynInfo) {
        DynamicObjectCollection entrys = (DynamicObjectCollection)dynInfo.get("entrys");
        if (entrys != null) {
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicObject entry = (DynamicObject)entrys.get(j);
                Object applyentryid = entry.get("sourceentryid");
                if (applyentryid == null) continue;
                BigDecimal amtapproved = entry.getBigDecimal("amtapproved") == null ? BigDecimal.ZERO : entry.getBigDecimal("amtapproved");
                String mapKey2 = applyentryid.toString();
                if (applyEntryValMap.get(mapKey2) != null) {
                    applyEntryValMap.put(mapKey2, BigDecimalUtil.addObject((Object)applyEntryValMap.get(mapKey2), (Object)amtapproved));
                    continue;
                }
                applyEntryValMap.put(mapKey2, amtapproved);
            }
        }
    }

    @Override
    protected StringBuilder getSubmitListSelector(DynamicObject info) {
        StringBuilder selector = super.getSubmitListSelector(info);
        if (selector.length() == 0) {
            selector.append("totalamount").append('\n');
        } else {
            selector.append(',').append("totalamount").append('\n');
        }
        selector.append(',').append("receivable").append('\n');
        selector.append(",entrys.amtapply,entrys.amount\n");
        selector.append(',').append("receivable.receivableamt").append('\n');
        return selector;
    }

    @Override
    protected void submitBefore(BeforeOperationArgs args) {
        super.submitBefore(args);
    }

    @Override
    protected void submitAfter(EndOperationTransactionArgs args) {
        super.submitAfter(args);
        if (SysParamsUtil.isOpenEasSync()) {
            DynamicObject[] infos = args.getDataEntities();
            for (int i = 0; i < infos.length; ++i) {
                SynMarketCostReimburseUtil.synMarketCostReimburse(infos[i]);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("audit".equals(operationKey)) {
            this.updateBorrowBill(e);
        }
    }

    private void updateBorrowBill(AfterOperationArgs args) {
        DynamicObject[] infos = args.getDataEntities();
        HashSet<Object> set = new HashSet<Object>(infos.length);
        if (infos.length == 0) {
            return;
        }
        for (int i = 0; i < infos.length; ++i) {
            set.add(infos[i].getPkValue());
        }
        DynamicObject[] dynObjs = (DynamicObject[])BusinessDataServiceHelper.load((Object[])set.toArray(), (IDataEntityType)infos[0].getDataEntityType());
        for (int i = 0; i < dynObjs.length; ++i) {
            DynamicObjectCollection entryColl;
            DynamicObject obj = dynObjs[i];
            if (!obj.getDynamicObjectType().getProperties().containsKey((Object)"offsetborrow") || (entryColl = obj.getDynamicObjectCollection("offsetborrow")).size() == 0) continue;
            DynamicObject[] saveObj = new DynamicObject[entryColl.size()];
            for (int j = 0; j < entryColl.size(); ++j) {
                DynamicObject entry = (DynamicObject)entryColl.get(j);
                DynamicObject borrow = BusinessDataServiceHelper.loadSingle((Object)entry.getDynamicObject("borrow").getPkValue(), (String)"er_dailyloanbill");
                borrow.set("usedamount", (Object)BigDecimalUtil.addObject((Object)borrow.get("usedamount"), (Object)entry.get("brwamt")));
                if (borrow.getBigDecimal("usedamount").compareTo(borrow.getBigDecimal("approveamount")) == 0) {
                    borrow.set("billstatus", (Object)"I");
                } else if (borrow.getBigDecimal("usedamount").compareTo(borrow.getBigDecimal("approveamount")) > 0) {
                    // empty if block
                }
                saveObj[j] = borrow;
            }
            SaveServiceHelper.save((DynamicObject[])saveObj);
        }
    }

    @Override
    protected void closebillAfter(EndOperationTransactionArgs e) {
        super.closebillAfter(e);
        if (SysParamsUtil.isOpenEasSync()) {
            DynamicObject[] datas = e.getDataEntities();
            for (int i = 0; i < datas.length; ++i) {
                SynMarketCostReimburseUtil.synMarketCostReimburseClose(datas[i]);
            }
        }
    }
}

