/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.opplugin.cost.apply;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.drp.mem.common.BigDecimalUtil;
import kd.drp.mem.opplugin.basedata.MEMBillOppPlugin;

public class DpaMarketCostApplySaveAmountOppPlugin
extends MEMBillOppPlugin {
    protected static final String TOTALREFUNDAMOUNT = "totalrefundamount";
    protected static final String TOTALAMTAPPROVED = "totalamtapproved";
    protected static final String TOTALAMTUNAPPROVED = "totalamtunapproved";
    protected static final String TOTALAMOUNT = "totalamount";
    protected static final String ENTRYENTITY = "entryentity";
    protected static final String REFUNDAMOUNT = "refundamount";
    protected static final String AMTAPPROVED = "amtapproved";
    protected static final String AMTUNAPPROVED = "amtunapproved";
    protected static final String AMOUNT = "amount";

    @Override
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        if ("save".equals(e.getOperationKey())) {
            DynamicObject[] objects = e.getDataEntities();
            this.calcBillTotalAmountFiled(objects, TOTALREFUNDAMOUNT, REFUNDAMOUNT);
            this.calcBillTotalAmountFiled(objects, TOTALAMTAPPROVED, AMTAPPROVED);
            this.calcBillTotalAmountFiled(objects, TOTALAMTUNAPPROVED, AMTUNAPPROVED);
            this.calcBillTotalAmountFiled(objects, TOTALAMOUNT, AMOUNT);
        }
    }

    private void calcBillTotalAmountFiled(DynamicObject[] objects, String billControlKey, String entryControlKey) {
        if (TOTALAMOUNT.equals(billControlKey)) {
            for (int i = 0; i < objects.length; ++i) {
                Object totalamount = objects[i].get(billControlKey);
                if (totalamount != null) continue;
                DynamicObjectCollection entrys = objects[i].getDynamicObjectCollection(ENTRYENTITY);
                BigDecimal total = BigDecimal.ZERO;
                for (DynamicObject entry : entrys) {
                    total = BigDecimalUtil.addObject((Object)total, (Object)entry.getBigDecimal(entryControlKey));
                }
                objects[i].set(billControlKey, (Object)total);
            }
        } else {
            for (int i = 0; i < objects.length; ++i) {
                DynamicObjectCollection entrys = objects[i].getDynamicObjectCollection(ENTRYENTITY);
                BigDecimal total = BigDecimal.ZERO;
                for (DynamicObject entry : entrys) {
                    total = BigDecimalUtil.addObject((Object)total, (Object)entry.getBigDecimal(entryControlKey));
                }
                objects[i].set(billControlKey, (Object)total);
            }
        }
    }
}

