/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.opplugin.cost.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mem.common.CostBillServiceHelper;
import kd.drp.mem.common.DateUtil;
import kd.drp.mem.common.MarketCostApplyConstants;
import kd.drp.mem.opplugin.basedata.MEMBillOppPlugin;
import kd.drp.mem.opplugin.basedata.MEMOppUtil;
import kd.drp.mem.opplugin.cost.SynMarketCostApplyUtil;

public class DpaMarketCostApplySubmitOppPlugin
extends MEMBillOppPlugin
implements MarketCostApplyConstants {
    private static final String[] key_words = new String[]{"shopnumber", "storename", "storetype", "shoptype", "shoparea", "shopregion", "address", "citytype", "shopphone", "iteminfonum", "iteminfomodel", "itembrands", "itemclass"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
        MEMOppUtil.onPreparePropertys(e, "entryentity", "bill", "mem_market_costapplyentry");
    }

    @Override
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.checkEmpty(e);
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        this.submitAfter(e);
    }

    @Override
    protected void submitAfter(EndOperationTransactionArgs e) {
        super.submitAfter(e);
        if (SysParamsUtil.isOpenEasSync()) {
            DynamicObject[] datas = e.getDataEntities();
            for (int i = 0; i < datas.length; ++i) {
                SynMarketCostApplyUtil.synMarketCostApplyData(datas[i]);
            }
        }
    }

    @Override
    protected List<String[]> getRequiredFieldList(DynamicObject dataInfo) {
        ArrayList<String[]> listField = new ArrayList<String[]>();
        listField.add(new String[]{"billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"MarketCostApplySubmitOppPlugin_0", (String)"drp-mem-opplugin", (Object[])new Object[0])});
        return listField;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkEmpty(BeforeOperationArgs args) {
        DynamicObject[] infos = args.getDataEntities();
        List<String> fields = Arrays.asList(key_words);
        Date currentDate = DateUtil.getDayFirst((Date)new Date());
        for (int i = 0; i < infos.length; ++i) {
            StringBuilder msg = new StringBuilder();
            DynamicObject info = infos[i];
            DynamicObject expensetype = CostBillServiceHelper.getBillConfigExpenseType((Object)info.getDynamicObject("expensetype").getPkValue());
            if (expensetype != null) {
                DynamicObjectCollection entrys;
                boolean bool = info.getDataEntityType().getProperties().containsKey((Object)"entryentity");
                DynamicObjectCollection billconfigentrys = expensetype.getDynamicObjectCollection("mem_billconfigentrys");
                if (!bool) {
                    StringBuilder sql = new StringBuilder("entryentity,entryentity.id");
                    for (DynamicObject billconfigentry : billconfigentrys) {
                        sql.append(",entryentity.").append(billconfigentry.getDynamicObject("fieldname").getString("number"));
                    }
                    Iterator e = BusinessDataServiceHelper.loadSingle((Object)info.getPkValue(), (String)info.getDataEntityType().getName(), (String)sql.toString());
                    entrys = e.getDynamicObjectCollection("entryentity");
                } else {
                    entrys = info.getDynamicObjectCollection("entryentity");
                }
                if (entrys == null || entrys.size() < 1) {
                    msg.append(ResManager.loadKDString((String)"\u5206\u5f55\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a.\n", (String)"MarketCostApplySubmitOppPlugin_1", (String)"drp-mem-opplugin", (Object[])new Object[0]));
                } else {
                    ArrayList<Object> requiredFields = new ArrayList<Object>();
                    for (DynamicObject billconfigentry : billconfigentrys) {
                        DynamicObject fieldName = billconfigentry.getDynamicObject("fieldname");
                        if (fields.contains(fieldName.getString("number"))) continue;
                        if (billconfigentry.getBoolean("isrequired")) {
                            requiredFields.add(fieldName);
                            continue;
                        }
                        if (!billconfigentry.getBoolean("isdisplay") || !"amount".equalsIgnoreCase(fieldName.getString("number"))) continue;
                        requiredFields.add(fieldName);
                    }
                    for (int j = 0; j < entrys.size(); ++j) {
                        void var16_17;
                        DynamicObject entry = (DynamicObject)entrys.get(j);
                        for (DynamicObject dynamicObject : requiredFields) {
                            Object fieldObj = entry.get(dynamicObject.getString("number"));
                            if (null != fieldObj) {
                                if (fieldObj instanceof BigDecimal) {
                                    if (BigDecimal.ZERO.compareTo((BigDecimal)fieldObj) < 0) continue;
                                    msg.append(String.format("\u7b2c[%s]\u884c[%s]\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0. \n", j + 1, dynamicObject.getString("name")));
                                    continue;
                                }
                                if (!StringUtils.isEmpty((String)fieldObj.toString())) continue;
                                msg.append(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c[%s]\u4e0d\u80fd\u4e3a\u7a7a.\n", (String)"MarketCostApplySubmitOppPlugin_2", (String)"drp-mem-opplugin", (Object[])new Object[0]), j + 1, dynamicObject.getString("name")));
                                continue;
                            }
                            msg.append(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c[%s]\u4e0d\u80fd\u4e3a\u7a7a.\n", (String)"MarketCostApplySubmitOppPlugin_2", (String)"drp-mem-opplugin", (Object[])new Object[0]), j + 1, dynamicObject.getString("name")));
                        }
                        Date beginDate = entry.getDate("entrybegindate");
                        if (beginDate == null) {
                            msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a.\n", (String)"MarketCostApplySubmitOppPlugin_3", (String)"drp-mem-opplugin", (Object[])new Object[0]), j + 1));
                        } else if ((beginDate = DateUtil.getDayFirst((Date)beginDate)).getTime() < currentDate.getTime()) {
                            msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f.\n", (String)"MarketCostApplySubmitOppPlugin_4", (String)"drp-mem-opplugin", (Object[])new Object[0]), j + 1));
                        }
                        Date date = entry.getDate("entryenddate");
                        if (date == null) {
                            msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a.\n", (String)"MarketCostApplySubmitOppPlugin_5", (String)"drp-mem-opplugin", (Object[])new Object[0]), j + 1));
                        } else {
                            Date date2 = DateUtil.getDayLast((Date)date);
                        }
                        if (beginDate == null || var16_17 == null || beginDate.getTime() <= var16_17.getTime()) continue;
                        msg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f.\n", (String)"MarketCostApplySubmitOppPlugin_6", (String)"drp-mem-opplugin", (Object[])new Object[0]), j + 1));
                    }
                }
            }
            if (msg.length() <= 0) continue;
            throw new KDBizException(msg.toString());
        }
    }
}

