/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.opplugin.cost.reimburse;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mem.common.BigDecimalUtil;
import kd.drp.mem.opplugin.basedata.MEMBillOppPlugin;
import kd.drp.mem.opplugin.cost.CostOppUtil;
import kd.drp.mem.opplugin.cost.SynMarketCostReimburseUtil;

public class MarketCostReimburseAuditOppPlugin
extends MEMBillOppPlugin {
    protected Log logger = LogFactory.getLog(MarketCostReimburseAuditOppPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("entrys.amount");
        e.getFieldKeys().add("entrys.amtapproved");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billstatus");
    }

    @Override
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.auditBefore(e);
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        this.auditAfter(e);
    }

    @Override
    protected void auditAfter(EndOperationTransactionArgs args) {
        super.auditAfter(args);
        List<Map<String, Object>> list = this.updateApplyBill(args);
        if (SysParamsUtil.isOpenEasSync()) {
            DynamicObject[] infos = args.getDataEntities();
            for (int i = 0; i < infos.length; ++i) {
                if (list.get(i) == null) {
                    DynamicObjectCollection entrys = infos[i].getDynamicObjectCollection("entrys");
                    boolean isDif = false;
                    for (int j = 0; j < entrys.size(); ++j) {
                        DynamicObject dynamicObject = (DynamicObject)entrys.get(j);
                        BigDecimal dif = BigDecimalUtil.subtractObject((Object)dynamicObject.getBigDecimal("amount"), (Object)dynamicObject.getBigDecimal("amtapproved"));
                        if (dif == null || !((double)dif.floatValue() > 0.01)) continue;
                        isDif = true;
                        break;
                    }
                    if (isDif) {
                        SynMarketCostReimburseUtil.synMarketCostReimburseUpdateAndAudit(infos[i]);
                        continue;
                    }
                    SynMarketCostReimburseUtil.synMarketCostReimburseAudit(infos[i]);
                    continue;
                }
                SynMarketCostReimburseUtil.synMarketCostReimburseAuditAndCloseApply(infos[i], list.get(i));
            }
        }
    }

    protected List<Map<String, Object>> updateApplyBill(EndOperationTransactionArgs args) {
        DynamicObject[] infos = args.getDataEntities();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(infos.length);
        for (int i = 0; i < infos.length; ++i) {
            list.add(CostOppUtil.updateApplyBill(infos[i], true));
        }
        return list;
    }
}

