/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.drp.mem.common.MEMFilterUtil;

public class CostBillServiceHelper {
    private static Log logger = LogFactory.getLog(CostBillServiceHelper.class);

    public static DynamicObject getBillConfigExpenseType(Object expensetypePk) {
        String selectFields = "id,name,number,mem_billconfigentrys.fieldname,isdisplay,isrequired";
        QFilter[] qFilters = MEMFilterUtil.getQFilter("expensetype", expensetypePk);
        DynamicObject[] expensetypes = BusinessDataServiceHelper.load((String)"mem_billconfig", (String)selectFields, (QFilter[])qFilters);
        if (expensetypes.length > 0) {
            return expensetypes[0];
        }
        return null;
    }

    public static void initObjByMap(Object billObj, Map<String, Object> billMap) {
        block4: {
            block3: {
                if (billObj == null || billMap == null) {
                    return;
                }
                Set<String> keySet = billMap.keySet();
                Set<Map.Entry<String, Object>> entrySet = billMap.entrySet();
                if (!(billObj instanceof DynamicObject)) break block3;
                DynamicObject dynamicObject = (DynamicObject)billObj;
                for (Map.Entry<String, Object> entry : entrySet) {
                    dynamicObject.set(entry.getKey(), entry.getValue());
                }
                break block4;
            }
            if (!(billObj instanceof IDataModel)) break block4;
            IDataModel billModel = (IDataModel)billObj;
            String mapKey = "";
            for (Map.Entry<String, Object> entry : billMap.entrySet()) {
                mapKey = entry.getKey();
                if (billModel.getProperty(mapKey) == null) continue;
                billModel.setValue(mapKey, entry.getValue());
            }
        }
    }

    public static Map<String, Object> createNewData(Long applierId) {
        HashMap<String, Object> billMap = new HashMap<String, Object>();
        if (applierId == null) {
            return billMap;
        }
        Map<String, Object> userMap = CostBillServiceHelper.getUserMap(applierId);
        if (CollectionUtils.isEmpty(userMap)) {
            return billMap;
        }
        DynamicObject dept = (DynamicObject)userMap.get("dept");
        if (dept != null) {
            logger.info("=================\u90e8\u95e8id:" + dept.getPkValue());
        } else {
            logger.info("====================\u90e8\u95e8id is null");
        }
        billMap.put("dept", dept);
        billMap.put("costdept", dept);
        Long deptId = null;
        if (dept != null) {
            deptId = (Long)dept.getPkValue();
            Long companyId = CostBillServiceHelper.initCompanyByDept(deptId);
            billMap.put("company", companyId);
            billMap.put("costcompany", companyId);
            logger.info("===============\u8d22\u52a1\u7ec4\u7ec7id:" + companyId);
        }
        billMap.put("applierpositionstr", userMap.get("applierpositionstr"));
        Map<String, Object> retMap = CostBillServiceHelper.getCurrencySet(deptId);
        billMap.put("currencysetting", retMap.get("currencysetting"));
        billMap.put("currency", retMap.get("currency"));
        return billMap;
    }

    public static void changeExpenseTypeFullNameToName(DynamicObject expenseType) {
        QFilter[] qFilters;
        DynamicObject[] expenseTypes;
        if (expenseType != null && (expenseTypes = BusinessDataServiceHelper.load((String)"mem_expensetype", (String)"id,fullname", (QFilter[])(qFilters = MEMFilterUtil.getPKQFilter(expenseType.getPkValue())))).length > 0) {
            expenseType.set("name", expenseTypes[0].get("fullname"));
        }
    }

    public static void changeDeptFullNameToName(DynamicObject dept) {
        QFilter[] qFilters;
        DynamicObject[] adminOrgs;
        if (dept != null && (adminOrgs = BusinessDataServiceHelper.load((String)"bos_adminorg_structure", (String)"id,fullname", (QFilter[])(qFilters = MEMFilterUtil.getQFilter("org", dept.getPkValue())))).length > 0) {
            dept.set("name", adminOrgs[0].get("fullname"));
        }
    }

    public static Map<String, Object> getCurrencySet(Long orgId) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        if (orgId == null) {
            RequestContext requestContext = RequestContext.get();
            orgId = requestContext.getOrgId();
        }
        ORM orm = ORM.create();
        Map accountinfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
        if (accountinfo != null && accountinfo.size() > 0) {
            QFilter qFilter = new QFilter("id", "=", accountinfo.get("baseCurrencyID"));
            DynamicObjectCollection dynamicObjects = orm.query("bd_currency", "id,name,number,amtprecision,priceprecision,sign,isshowsign", new QFilter[]{qFilter});
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                retMap.put("currency", dynamicObjects.get(0));
            }
            retMap.put("currencysetting", accountinfo.get("exchangeRateTableID"));
        }
        return retMap;
    }

    @Deprecated
    public static DynamicObject getCurrencySetting(Long orgId) {
        DynamicObject currencySetting = null;
        DynamicObject currency = null;
        if (orgId == null) {
            RequestContext requestContext = RequestContext.get();
            orgId = requestContext.getOrgId();
        }
        ORM orm = ORM.create();
        Long companyId = CostBillServiceHelper.initCompanyByDept(orgId);
        if (companyId == null) {
            return currencySetting;
        }
        while (currency == null) {
            List superiorOrgs;
            QFilter qFilter = new QFilter("org.id", "=", (Object)companyId);
            DynamicObjectCollection dynamicObjects = orm.query("er_currencyinfo", "id,currency.id,currency.name,currency.number,currency.amtprecision,currency.priceprecision,currency.sign,exratetable.id,currency.isshowsign", new QFilter[]{qFilter});
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                currencySetting = (DynamicObject)dynamicObjects.get(0);
                currency = currencySetting.getDynamicObject("currency");
                if (currency != null) continue;
                superiorOrgs = OrgServiceHelper.getSuperiorOrgs((long)companyId);
                if (superiorOrgs.size() > 0) {
                    companyId = (Long)superiorOrgs.get(0);
                    continue;
                }
                return null;
            }
            superiorOrgs = OrgServiceHelper.getSuperiorOrgs((long)companyId);
            if (superiorOrgs.size() > 0) {
                companyId = (Long)superiorOrgs.get(0);
                continue;
            }
            return null;
        }
        return currencySetting;
    }

    public static Long initCompanyByDept(Long deptId) {
        logger.info("---------------deptId:" + deptId);
        Long companyId = 0L;
        try {
            companyId = OrgServiceHelper.getToOrg((String)"01", (String)"10", (Long)deptId, (Long)0L);
        }
        catch (Exception e) {
            logger.error("========================get companyId error ", (Throwable)e);
        }
        if (companyId == 0L) {
            logger.info("\u6ca1\u6709\u59d4\u6258\u5173\u7cfb\uff0c\u53d6\u8d22\u52a1\u7ec4\u7ec7:");
            Map company = OrgServiceHelper.getCompanyfromOrg((Object)deptId);
            if (company != null) {
                companyId = (Long)company.get("id");
            }
        }
        logger.info("================================companyId:" + companyId);
        return companyId;
    }

    public static Map<String, Object> getUserMap(Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String selectFields = "id,name,number,phone,entryentity.id,entryentity.position,entryentity.dpt.*,entryentity.dpt,entryentity.ispartjob";
        QFilter[] qFilters = MEMFilterUtil.getQFilter("id", userId);
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)selectFields, (QFilter[])qFilters);
        if (users.length > 0) {
            DynamicObject user = users[0];
            DynamicObjectCollection userEntrys = user.getDynamicObjectCollection("entryentity");
            for (DynamicObject userEntry : userEntrys) {
                boolean isPartjob = userEntry.getBoolean("ispartjob");
                resultMap.put("applierpositionstr", userEntry.getString("position"));
                DynamicObject dept = userEntry.getDynamicObject("dpt");
                resultMap.put("dept", dept);
                if (isPartjob) continue;
                break;
            }
        }
        return resultMap;
    }
}

