/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.common;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang.StringUtils;

public class DistanceAndLocationUtil {
    public static double getDistance(double longitude1, double latitude1, double longitude2, double latitude2) {
        double lat1 = Math.PI / 180 * latitude1;
        double lat2 = Math.PI / 180 * latitude2;
        double lon1 = Math.PI / 180 * longitude1;
        double lon2 = Math.PI / 180 * longitude2;
        double R = 6371.0;
        double d = Math.acos(Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1)) * R;
        return d;
    }

    public static String getDistance(String longitude1, String latitude1, String longitude2, String latitude2) {
        Log logger = LogFactory.getLog(DistanceAndLocationUtil.class);
        if (StringUtils.isBlank((String)longitude1) && StringUtils.isBlank((String)latitude1)) {
            return "";
        }
        if (StringUtils.isBlank((String)longitude2) && StringUtils.isBlank((String)latitude2)) {
            return "";
        }
        Double lo1 = Double.valueOf(longitude1);
        Double la1 = Double.valueOf(latitude1);
        Double lo2 = Double.valueOf(longitude2);
        Double la2 = Double.valueOf(latitude2);
        double d = DistanceAndLocationUtil.getDistance(lo1, la1, lo2, la2);
        logger.info("getDistance :lo1=" + lo1 + ",la1=" + la1 + ",lo2=" + lo2 + ",la2=" + la2);
        if (lo1 == 0.0 || la1 == 0.0 || lo2 == 0.0 || la2 == 0.0) {
            return "";
        }
        if (BigDecimal.ZERO.compareTo(BigDecimal.valueOf(d)) != 0) {
            DecimalFormat f = new DecimalFormat("0.00");
            return f.format(d) + "km";
        }
        return "0km";
    }
}

