/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mem.common.MEMQueryUtil;

public class MEMUtil {
    public static final Log logger = LogFactory.getLog(MEMUtil.class);

    public static Object getUserID() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    public static boolean isSaler(Object myOwnerId) {
        return UserUtil.isSaler((Object)myOwnerId);
    }

    public static boolean isDispatcher(Object myOwnerId) {
        return UserUtil.isDispatcher((Object)myOwnerId);
    }

    public static boolean isDispatcher(Set<Object> myOwnerIds) {
        DynamicObjectCollection bizCollection = MEMUtil.queryBizCollection(myOwnerIds);
        for (int i = 0; i < bizCollection.size(); ++i) {
            DynamicObject info = (DynamicObject)bizCollection.get(i);
            if (!info.getBoolean("isdispatcher")) continue;
            return info.getBoolean("isdispatcher");
        }
        return false;
    }

    public static DynamicObject queryBizInfoAndCheckExist(Object myOwnerId) {
        DynamicObject info = MEMUtil.queryBizInfo(myOwnerId);
        if (info == null) {
            QFilter f = new QFilter("id", "=", myOwnerId);
            String name = "";
            DynamicObject customer = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"name", (QFilter[])f.toArray());
            if (customer != null) {
                name = customer.getString("name");
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5c5e\u4e8e \u6e20\u9053\u3010%s\u3011id=%s", (String)"MEMUtil_0", (String)"drp-mem-common", (Object[])new Object[0]), name, myOwnerId));
        }
        return info;
    }

    public static DynamicObject queryBizInfo(Object myOwnerId) {
        QFilter f = new QFilter("sysuser", "=", MEMUtil.getUserID());
        f.and("owner", "=", myOwnerId);
        f.and("enable", "=", (Object)"1");
        String cols = F7Utils.getSelectCols((String[])new String[]{"issaler", "isbuyer", "isdefault", "isdispatcher"});
        return QueryServiceHelper.queryOne((String)"dbd_drp_user", (String)cols, (QFilter[])f.toArray());
    }

    public static DynamicObjectCollection queryBizCollection(Set<Object> myOwnerIds) {
        QFilter f = new QFilter("sysuser", "=", MEMUtil.getUserID());
        f.and("owner", "in", myOwnerIds);
        String cols = F7Utils.getSelectCols((String[])new String[]{"issaler", "isbuyer", "isdefault", "isdispatcher"});
        return QueryServiceHelper.query((String)"dbd_drp_user", (String)cols, (QFilter[])f.toArray());
    }

    public static Map<String, List<Object>> getCustomerIds() {
        return MEMUtil.getCustomerIds(MEMUtil.getUserID());
    }

    public static Map<String, List<Object>> getCustomerIds(Object id) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put("SUPPLIER", MEMUtil.getSupplierIDs());
        map.put("OWNER", MEMUtil.getOwnerIDs());
        logger.info("supplierIDs:" + map.get("SUPPLIER"));
        logger.info("ownerIDs:" + map.get("OWNER"));
        return map;
    }

    public static List<Object> getSupplierIDs() {
        QFilter f = new QFilter("sysuser", "=", MEMUtil.getUserID());
        f.and("owner.isinnerorg", "=", (Object)Character.valueOf('0'));
        return MEMUtil.querySingleCol("dbd_drp_user", "owner", f.toArray(), "isdefault desc");
    }

    public static List<Object> getEnableSupplierIDs() {
        QFilter f = new QFilter("sysuser", "=", MEMUtil.getUserID());
        f.and("owner.isinnerorg", "=", (Object)Character.valueOf('0'));
        f.and("enable", "=", (Object)Character.valueOf('1'));
        return MEMUtil.querySingleCol("dbd_drp_user", "owner", f.toArray(), "isdefault desc");
    }

    public static List<Object> getOwnerIDs() {
        QFilter f = new QFilter("sysuser", "=", MEMUtil.getUserID());
        f.and("owner.isinnerorg", "=", (Object)Character.valueOf('1'));
        return MEMUtil.querySingleCol("dbd_drp_user", "owner", f.toArray(), "isdefault desc");
    }

    public static List<Object> getCustomerIdsByCurrentUserIsSaleFunctions() {
        QFilter f = MEMUtil.getCustomerFilters();
        return MEMUtil.querySingleCol("dbd_drp_user", "owner", f.toArray(), "isdefault desc");
    }

    private static QFilter getCustomerFilters() {
        QFilter f = new QFilter("sysuser", "=", MEMUtil.getUserID());
        QFilter f3 = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        f.and(f3);
        return f;
    }

    private static QFilter getOutCustomerFilters() {
        QFilter f = new QFilter("sysuser", "=", MEMUtil.getUserID());
        f.and("enable", "=", (Object)Character.valueOf('1'));
        f.and("owner.isinnerorg", "=", (Object)Character.valueOf('0'));
        return f;
    }

    public static List<Object> getDefaultCustomerId() {
        QFilter f = MEMUtil.getOutCustomerFilters();
        f.and("isdefault", "=", (Object)Character.valueOf('1'));
        List<Object> customerIds = MEMUtil.querySingleCol("dbd_drp_user", "owner", f.toArray(), "createtime desc");
        if (!CollectionUtils.isEmpty(customerIds)) {
            DynamicObjectCollection validCustomers = QueryServiceHelper.query((String)"mdr_customer", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", customerIds), new QFilter("enable", "=", (Object)Character.valueOf('1')), new QFilter("status", "=", (Object)Character.valueOf('C')), new QFilter("isinnerorg", "=", (Object)Character.valueOf('0'))});
            List<Object> validIds = validCustomers.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            return validIds;
        }
        return new ArrayList<Object>(0);
    }

    public static long getDrpCustomerUserBelongsOrgId(Long customerId) {
        DynamicObject drpCustomerUser;
        DynamicObject customer = QueryServiceHelper.queryOne((String)"mdr_customer", (String)"partner", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)customerId)});
        if (null != customer && (drpCustomerUser = QueryServiceHelper.queryOne((String)"drp_customer_user", (String)"org", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)UserServiceHelper.getCurrentUserId()), new QFilter("bizpartner", "=", (Object)customer.getLong("partner"))})) instanceof DynamicObject) {
            return drpCustomerUser.getLong("org");
        }
        return 0L;
    }

    public static List<Object> querySingleCol(String entityName, String colName, QFilter[] filters, String orderByStr) {
        DynamicObjectCollection result = QueryServiceHelper.query((String)entityName, (String)colName, (QFilter[])filters, (String)orderByStr);
        return MEMUtil.toList(result, colName);
    }

    public static List<Object> toList(DynamicObjectCollection result, String keyName) {
        ArrayList<Object> values = new ArrayList<Object>(result.size());
        int len = result.size();
        for (int i = 0; i < len; ++i) {
            values.add(((DynamicObject)result.get(i)).get(keyName));
        }
        return values;
    }

    public static Object queryBaseUnitId(Object itemPK) {
        if (itemPK == null) {
            return null;
        }
        DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)itemPK, (String)"mdr_item_info", (String)"baseunit,baseunit.id,baseunit.number,baseunit.name");
        if (item == null || item.get("baseunit") == null) {
            return null;
        }
        return item.get("baseunit");
    }

    public static Object queryMasteridBaseUnitId(Object itemPK) {
        if (itemPK == null) {
            return null;
        }
        return MEMUtil.queryBaseUnitId(itemPK);
    }

    public static Object queryMasteridAssistUnitId(Object itemPK) {
        QFilter f = new QFilter("id", "=", itemPK);
        DynamicObject item = QueryServiceHelper.queryOne((String)"mdr_item_info", (String)"assistunit", (QFilter[])f.toArray());
        if (item == null) {
            return null;
        }
        return item.get("assistunit");
    }

    public static Object queryAssistUnitId(Object itemPK) {
        if (itemPK == null) {
            return null;
        }
        DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)itemPK, (String)"mdr_item_info", (String)"assistunit,assistunit.id");
        if (item == null || item.get("assistunit") == null) {
            return null;
        }
        return item.get("assistunit");
    }

    public static void setSeqValue(DynamicObject entityTemplate, int value) {
        IDataEntityProperty dpSeq = MEMUtil.ensureSeqField(entityTemplate);
        dpSeq.setValueFast((Object)entityTemplate, (Object)value);
    }

    public static IDataEntityProperty ensureSeqField(DynamicObject entityTemplate) {
        DynamicProperty prop = entityTemplate.getDynamicObjectType().getProperty("seq");
        if (prop == null) {
            throw new KDException(new ErrorCode("####", ResManager.loadKDString((String)"seq \u5217\u4e0d\u5b58\u5728", (String)"MEMUtil_1", (String)"drp-mem-common", (Object[])new Object[0])), new Object[0]);
        }
        return prop;
    }

    public static boolean pkIsNull(Object pkValue) {
        if (pkValue == null) {
            return true;
        }
        boolean flag = false;
        String valueStr = pkValue.toString().trim();
        if (pkValue instanceof Long) {
            if (Long.parseLong(valueStr) == 0L) {
                flag = true;
            }
        } else if (valueStr.length() == 0) {
            flag = true;
        }
        return flag;
    }

    public static boolean isUseMarketExpenseType() {
        return true;
    }

    public static boolean isSplitMDEApp() {
        return false;
    }

    public static Set<Object> queryUserRegionsWithAllSubs(Object myOwnerId) {
        QFilter f = new QFilter("user", "=", MEMUtil.getUserID());
        f.and("owner", "=", myOwnerId);
        Set<Object> ids = MEMQueryUtil.querySingleCol("mdr_region_user_relation", "region.id", f.toArray());
        if (!ids.isEmpty()) {
            ids.addAll(MEMUtil.queryAllSubNodeIds(ids));
        }
        return ids;
    }

    private static QFilter createFilter(Object regionId) {
        if (regionId instanceof Collection) {
            return new QFilter("parent", "in", regionId);
        }
        return new QFilter("parent", "=", regionId);
    }

    public static Set<Object> queryAllSubNodeIds(Object regionIdOrIds) {
        QFilter f = MEMUtil.createFilter(regionIdOrIds);
        Set<Object> subIds = MEMQueryUtil.querySingleCol("mdr_region", "id", f.toArray());
        if (subIds.isEmpty()) {
            return subIds;
        }
        subIds.addAll(MEMUtil.queryAllSubNodeIds(subIds));
        return subIds;
    }
}

