/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.common;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.orm.query.dataentity.SingleORM;

public class ParameterHelper {
    private static final String FORGID = ":FORGID";
    private static final String FACCTBOOKID = ":FACCTBOOKID";
    private static final String FSUBSYSTEM = ":FSUBSYSTEM";
    private static final String PUBLIC_PARAM_APPID = "public/common";

    public static DynamicObject getParameters(long orgId, long acctBookId, String subSystem) {
        String sql = " SELECT FDATA FROM T_BAS_SYSPARAMETER WHERE FORGID=? AND FACCTBOOKID=? AND FSUBSYSTEM=? ";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(FORGID, -5, (Object)orgId));
        params.add(new SqlParameter(FACCTBOOKID, -5, (Object)acctBookId));
        params.add(new SqlParameter(FSUBSYSTEM, 12, (Object)ParameterHelper.getParamAppId(subSystem)));
        DynamicObjectCollection existData = SingleORM.query(null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        String para = ParameterHelper.getParameterFormId(subSystem);
        if (StringUtils.isBlank((CharSequence)para)) {
            return null;
        }
        return ParameterHelper.serializeToDataEntity(existData, para);
    }

    private static String getParamAppId(String paramAppId) {
        return StringUtils.isBlank((CharSequence)paramAppId) ? PUBLIC_PARAM_APPID : paramAppId;
    }

    public static String getParameterFormId(String subSystem) {
        DynamicObjectCollection collection = SingleORM.query(null, (String)" SELECT FFORMID FROM T_BAS_SYSPARACONSOLE WHERE FSUBSYSTEM = ? AND FENABLED = '1' ", (Object[])new SqlParameter[]{new SqlParameter(FSUBSYSTEM, 12, (Object)ParameterHelper.getParamAppId(subSystem))});
        return collection != null && !collection.isEmpty() ? ((DynamicObject)collection.get(0)).getString(0) : null;
    }

    public static DynamicObject createDefaultEntity(MainEntityType mainEntityType, DynamicObject dataEntity) {
        DataEntityPropertyCollection propertyCollection = mainEntityType.getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            if (property instanceof FieldProp) {
                dataEntity.set(property, ((FieldProp)property).getDefValue());
                continue;
            }
            if (!(property instanceof BasedataProp)) continue;
            dataEntity.set(property, (Object)((BasedataProp)property).getDefValue());
        }
        return dataEntity;
    }

    private static DynamicObject serializeToDataEntity(DynamicObjectCollection existData, String formId) {
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            String jsonStr;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
            DynamicObject dataEntity = (DynamicObject)entityType.createInstance();
            ParameterHelper.createDefaultEntity(entityType, dataEntity);
            String string = jsonStr = existData != null && !existData.isEmpty() ? ((DynamicObject)existData.get(0)).getString(0) : null;
            if (StringUtils.isNotBlank(jsonStr)) {
                Map map = (Map)SerializationUtils.fromJsonString(jsonStr, Map.class);
                if (!map.get("_Type_").equals(formId)) {
                    return dataEntity;
                }
                DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)entityType);
                DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
                dataEntity = (DynamicObject)jser.deserializeFromString(jsonStr, (Object)dataEntity);
            }
            return dataEntity;
        }
        return null;
    }
}

