/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.common;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.drp.mem.common.BizBillStatusEnum;
import kd.drp.mem.common.DateUtil;
import kd.drp.mem.common.EnableStatusEnum;
import kd.drp.mem.common.MEMUtil;

public class ToExecFilterUtil {
    private static Log logger = LogFactory.getLog(ToExecFilterUtil.class);

    public static QFilter getOrgFilter() {
        Long userId = UserServiceHelper.getCurrentUserId();
        Long mainOrgId = UserServiceHelper.getUserMainOrgId((long)userId);
        QFilter filter = new QFilter("dept", "=", (Object)mainOrgId);
        return filter;
    }

    public static QFilter getCostTypeFilter() {
        QFilter f = new QFilter("expensetype", "in", ToExecFilterUtil.getCostTypeSet());
        return f;
    }

    public static Set<Object> getCostTypeSet() {
        QFilter filter = new QFilter("costexecute", "=", (Object)"1");
        filter.and("enabled", "=", (Object)EnableStatusEnum.ENABLED.getValue());
        DynamicObjectCollection rs = QueryServiceHelper.query((String)"mem_billconfig", (String)"expensetype,enabled,costexecute", (QFilter[])filter.toArray());
        HashSet<Object> set = new HashSet<Object>();
        for (DynamicObject obj : rs) {
            set.add(obj.get("expensetype"));
        }
        return set;
    }

    public static QFilter getDateFilter() {
        Date date = new Date();
        date = DateUtil.getDayFirst(date);
        QFilter filter = new QFilter("begindate", "<=", (Object)date);
        filter.and("enddate", ">=", (Object)date);
        return filter;
    }

    public static QFilter getBillStatusFilter() {
        QFilter filter = new QFilter("billstatus", "=", (Object)BizBillStatusEnum.AUDIDPASS.getValue());
        filter.or(new QFilter("billstatus", "=", (Object)BizBillStatusEnum.PARTREFUND.getValue()));
        return filter;
    }

    public static QFilter getMobSetFilter() {
        List<Object> ownerIDs;
        Map<String, List<Object>> map = MEMUtil.getCustomerIds();
        List<Object> supplierIDs = map == null ? null : map.get("SUPPLIER");
        List<Object> list = ownerIDs = map == null ? null : map.get("OWNER");
        if (supplierIDs != null && supplierIDs.size() > 0 && (ownerIDs == null || ownerIDs.size() < 1)) {
            return new QFilter("customer", "in", new HashSet<Object>(supplierIDs));
        }
        if (ownerIDs != null && ownerIDs.size() > 0 && (supplierIDs == null || supplierIDs.size() < 1)) {
            logger.info(RequestContext.get() + "\u662f\u5185\u90e8\u5ba2\u6237\uff0c\u91c7\u7528\u6807\u51c6\u8fc7\u6ee4");
            logger.info(RequestContext.get() + "\u662f\u5185\u90e8\u5ba2\u6237");
            if (MEMUtil.isDispatcher(ownerIDs)) {
                logger.info(RequestContext.get() + "\u662f\u7763\u5bfc\u7528\u6237");
                return null;
            }
            logger.info(RequestContext.get() + "\u662f\u975e\u7763\u5bfc\u7528\u6237");
            Long userId = UserServiceHelper.getCurrentUserId();
            Long mainOrgId = UserServiceHelper.getUserMainOrgId((long)userId);
            QFilter filter = new QFilter("org", "=", (Object)mainOrgId);
            DynamicObject mainOrg = BusinessDataServiceHelper.loadSingle((String)"bos_adminorg_structure", (String)"id,longnumber", (QFilter[])filter.toArray());
            filter = QFilter.like((String)"masterid.longnumber", (String)mainOrg.getString("longnumber"));
            HashSet<Object> set = new HashSet<Object>();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOrg", (String)"bos_adminorg_structure", (String)"id,org,longnumber", (QFilter[])filter.toArray(), (String)"");){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    if (!row.getString("longnumber").startsWith(mainOrg.getString("longnumber") + "!")) continue;
                    set.add(row.get("id"));
                    set.add(row.get("org"));
                }
                set.add(mainOrgId);
            }
            return new QFilter("dept", "in", set);
        }
        if (supplierIDs != null && supplierIDs.size() > 0 && ownerIDs != null && ownerIDs.size() > 0) {
            logger.info("\u7528\u6237\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u5f53\u524d\u7528\u6237\u65e2\u662f\u5185\u90e8\u7528\u6237\uff0c\u53c8\u662f\u5916\u90e8\u7528\u6237\u3002");
        } else {
            logger.info("\u7528\u6237\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u5f53\u524d\u7528\u6237\u5c1a\u672a\u8bbe\u7f6e\u6240\u5c5e\u6e20\u9053.");
        }
        return new QFilter("customer", "<", (Object)"0");
    }

    public static QFilter getDefaultFilter() {
        return ToExecFilterUtil.getCostTypeFilter().and(ToExecFilterUtil.getDateFilter()).and(ToExecFilterUtil.getBillStatusFilter()).and(ToExecFilterUtil.getMobSetFilter());
    }

    public static QFilter getFilterNoDate() {
        return ToExecFilterUtil.getCostTypeFilter().and(ToExecFilterUtil.getBillStatusFilter()).and(ToExecFilterUtil.getMobSetFilter());
    }
}

