/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.syn;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.util.StringUtils;
import kd.drp.mem.common.CollectionUtil;
import kd.drp.mem.syn.ITranProcess;

public class Config {
    private Map<String, String> selectorMap = new HashMap<String, String>();
    private Map<String, Map<String, String>> entrySelectorMap = new HashMap<String, Map<String, String>>();
    private Map<String, String> entryMap = new HashMap<String, String>();
    private Map<String, String> entryKeyMap = new HashMap<String, String>();
    private ITranProcess tranProcess;
    private Set<String> querySelecotrs = new HashSet<String>();

    public String getSynEntryProperty(String key, String p) {
        Map<String, String> map = this.entrySelectorMap.get(key);
        if (map != null) {
            String string = map.get(p);
            return StringUtils.isEmpty((String)string) ? p : string;
        }
        return null;
    }

    public String getSynProperty(String p) {
        String value = this.getMapKeyValue(this.selectorMap, p);
        if (value != null) {
            return StringUtils.isEmpty((String)value) ? p : value;
        }
        value = this.getMapKeyValue(this.entryMap, p);
        if (value != null) {
            return StringUtils.isEmpty((String)value) ? p : value;
        }
        return null;
    }

    private String getMapKeyValue(Map<String, String> map, String key) {
        String value = map.get(key);
        value = value == null ? (map.containsKey(key) ? "" : null) : value;
        return value;
    }

    public void setEntrySynKey(String key, String synProperty) {
        if (key.equals(synProperty)) {
            this.entryKeyMap.remove(key);
        } else {
            this.entryKeyMap.put(key, synProperty);
        }
    }

    public String getEntrySynKey(String key) {
        if (this.entrySelectorMap.containsKey(key)) {
            String string = this.entryKeyMap.get(key);
            return StringUtils.isEmpty((String)string) ? key : string;
        }
        return null;
    }

    public Set<String> getEntryKeys() {
        return this.entrySelectorMap.keySet();
    }

    public Set<String> getHeadSelecters() {
        Set<String> headSet = this.selectorMap.keySet();
        return headSet;
    }

    public Set<String> getEntrySelecters() {
        Set<String> entrySet = this.entryMap.keySet();
        return entrySet;
    }

    public Map<String, String> getEntryMap(String key) {
        return this.entrySelectorMap.get(key);
    }

    public Set<String> getSelecters() {
        HashSet<String> set = new HashSet<String>();
        Set<String> headSet = this.selectorMap.keySet();
        Set<String> entrySet = this.entryMap.keySet();
        set.addAll(headSet);
        set.addAll(entrySet);
        return set;
    }

    public void addEntrySelectors(String entryKey, String propertys) {
        List<String> list = Arrays.asList(propertys.split(","));
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            this.addEntrySelector(entryKey, string, null);
        }
    }

    public void addEntrySelectors2(String entryKey, String propertys) {
        List<String> list = Arrays.asList(propertys.split(","));
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            this.addEntrySelector(entryKey, string.substring(entryKey.length() + 1), null);
        }
    }

    public void addEntrySelector(String entryKey, String string, String synProperty) {
        Map<String, String> map = this.entrySelectorMap.get(entryKey);
        if (map == null) {
            map = new HashMap<String, String>();
            this.entrySelectorMap.put(entryKey, map);
        }
        map.put(string, synProperty);
        this.entryMap.put(entryKey + "." + string, synProperty);
    }

    public void addSelectors(String propertys) {
        List<String> list = Arrays.asList(propertys.split(","));
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            this.selectorMap.put(string, null);
        }
    }

    public void addSelector(String property) {
        this.selectorMap.put(property, null);
    }

    public void addSelector(String property, String synProperty) {
        this.selectorMap.put(property, synProperty);
    }

    public String getSelectorForOql() {
        Set<String> set = this.getSelecters();
        set.addAll(this.querySelecotrs);
        return CollectionUtil.tranSet2String2(set);
    }

    public String getHeadSelectorForOql() {
        return CollectionUtil.tranSet2String2(this.selectorMap.keySet());
    }

    public String getEntrySelectorForOql() {
        return CollectionUtil.tranSet2String2(this.entryMap.keySet());
    }

    public void addQuerySelector(String selecotr) {
        this.querySelecotrs.add(selecotr);
    }

    public void addQuerySelectors(String propertys) {
        List<String> list = Arrays.asList(propertys.split(","));
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            this.addQuerySelector(string);
        }
    }

    public ITranProcess getTranProcess() {
        return this.tranProcess;
    }

    public void setTranProcess(ITranProcess tranProcess) {
        this.tranProcess = tranProcess;
    }
}

