/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.syn;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.message.send.MessageSendService;
import kd.drp.mdr.common.message.send.model.MessageResponse;
import kd.drp.mdr.common.message.send.model.MsgTypeEnum;
import kd.drp.mdr.common.model.SynResult;
import kd.drp.mem.syn.Config;
import kd.drp.mem.syn.ITranProcess;

public class SynUtil {
    public static SynResult synDOToEAS(DynamicObject object, Config config, MsgTypeEnum msgType) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String json = SynUtil.tranDO2String(object, config);
        data.put("data", json);
        return SynUtil.sendMessage(data, msgType);
    }

    public static String tranDO2String(DynamicObject entityTemplate, Config config) {
        Map<String, Object> map = SynUtil.tranDO2Map(entityTemplate, config);
        return SynUtil.tranMap2String(map);
    }

    public static SynResult sendMessage(Map<String, Object> data, MsgTypeEnum msgType) {
        SynResult synresult = new SynResult();
        Boolean issyn = Boolean.TRUE;
        if (data.size() > 0) {
            MessageResponse result = MessageSendService.sendMessageAndWaitComplete((MsgTypeEnum)msgType, data, null, (RequestContext)RequestContext.get());
            if (result != null && !result.isSuccess()) {
                String errorMessage = result.getErrorMessage();
                if (result.getErrorCode().equals("402") || result.getErrorCode().equals("400")) {
                    errorMessage = ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u548cEAS\u5e94\u7528\u670d\u52a1\u5668\u662f\u5426\u6b63\u5e38\uff0c\u7136\u540e\u5c1d\u8bd5\u91cd\u65b0\u786e\u8ba4", (String)"SynUtil_0", (String)"drp-mem-common", (Object[])new Object[0]);
                }
                issyn = Boolean.FALSE;
                synresult.setMsg(errorMessage);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5931\u8d25%s", (String)"SynUtil_1", (String)"drp-mem-common", (Object[])new Object[0]), synresult.getMsg()));
            }
            synresult.setSuccess(issyn.booleanValue());
        }
        return synresult;
    }

    public static String tranMap2String(Map<String, Object> map) {
        return new JSONObject(map).toJSONString();
    }

    public static Map<String, Object> tranDO2Map(DynamicObject entityTemplate, Config config) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)entityTemplate.getPkValue(), (String)entityTemplate.getDataEntityType().getName(), (String)config.getSelectorForOql());
        HashMap<String, Object> map = new HashMap<String, Object>(config.getHeadSelecters().size());
        map.put("PK_ID", bill.getPkValue());
        if (config.getTranProcess() != null) {
            ITranProcess tranProcess = config.getTranProcess();
            tranProcess.beforeTran(config, bill, map);
        }
        for (String key : config.getHeadSelecters()) {
            String synProperty = config.getSynProperty(key);
            map.put(synProperty, bill.get(key));
        }
        for (String key : config.getEntryKeys()) {
            Map<String, String> entryMap = config.getEntryMap(key);
            DynamicObjectCollection doc = bill.getDynamicObjectCollection(key);
            ArrayList list = new ArrayList(entryMap.size());
            for (int i = 0; i < doc.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)doc.get(i);
                HashMap<String, Object> emap = new HashMap<String, Object>(entryMap.size());
                emap.put("PK_ID", dynamicObject.getPkValue());
                for (String ek : entryMap.keySet()) {
                    String synProperty = config.getSynEntryProperty(key, ek);
                    emap.put(synProperty, dynamicObject.get(ek));
                }
                list.add(emap);
            }
            map.put(config.getEntrySynKey(key), list);
        }
        if (config.getTranProcess() != null) {
            ITranProcess tranProcess = config.getTranProcess();
            tranProcess.process(config, bill, map);
        }
        return map;
    }
}

