/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.yzj.config;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.drp.mem.common.ParameterHelper;
import kd.drp.mem.yzj.TokenType;
import kd.drp.mem.yzj.config.SSLClient;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class YzjConfigServiceHelper {
    private static Log logger = LogFactory.getLog(YzjConfigServiceHelper.class);
    public static final long ROOT_ORG_ID = 100000L;
    public static final String SUBSYSTEM_APPLICATION = "application/SYS/BASE";
    public static final String PARAM_YZJ_ENABLE = "isyunzhijiaenable";
    public static final String PARAM_YZJ_URL = "yzjurl";
    public static final String PARAM_IS_AUTO_SYNC = "isautosync";
    public static final String PARAM_IS_AUTO_CLEAR_SYNC_TASK = "isautoclearsynctask";
    public static final String PARAM_KEEP_SYNC_TASK_COUNT = "keepsynctaskcount";
    public static final String EID = "eid";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("PARAMETER");

    public static boolean isTest() {
        return false;
    }

    public static Map<String, Object> getParameterConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        DynamicObject paramObj = ParameterHelper.getParameters(100000L, 0L, SUBSYSTEM_APPLICATION);
        if (paramObj != null) {
            Boolean isEnable = paramObj.getBoolean(PARAM_YZJ_ENABLE);
            config.put(PARAM_YZJ_ENABLE, Boolean.TRUE);
            config.put(PARAM_YZJ_URL, paramObj.getString(PARAM_YZJ_URL));
            config.put(PARAM_IS_AUTO_SYNC, paramObj.getBoolean(PARAM_IS_AUTO_SYNC));
            config.put(PARAM_IS_AUTO_CLEAR_SYNC_TASK, paramObj.getBoolean(PARAM_IS_AUTO_CLEAR_SYNC_TASK));
            config.put(PARAM_KEEP_SYNC_TASK_COUNT, paramObj.getInt(PARAM_KEEP_SYNC_TASK_COUNT));
        }
        if (config.get(EID) == null || StringUtils.isEmpty((String)config.get(EID).toString())) {
            String eid = QueryServiceHelper.queryOne((String)"mem_sys_params", (String)EID, null).getString(EID);
            config.put(EID, eid);
        } else {
            DynamicObject object = QueryServiceHelper.queryOne((String)"mem_sys_params", (String)(TokenType.CLOCK_IN.getValue() + "," + TokenType.READ_MAIL_LIST.getValue() + "," + EID), null);
            String clockIn_Appsecret = object.getString(TokenType.CLOCK_IN.getValue());
            config.put(TokenType.CLOCK_IN.getValue(), clockIn_Appsecret);
            String read_Mail_list_Appsecret = object.getString(TokenType.READ_MAIL_LIST.getValue());
            config.put(TokenType.READ_MAIL_LIST.getValue(), read_Mail_list_Appsecret);
        }
        return config;
    }

    public static HttpClient createHttpClient(boolean isSSL, int connectionTimeout, int readTimeout) throws KeyManagementException, NoSuchAlgorithmException {
        SSLClient client = isSSL ? new SSLClient() : new SystemDefaultHttpClient();
        HttpParams httpParams = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimeout);
        return client;
    }

    /*
     * WARNING - void declaration
     */
    public static String doGet(boolean isSSL, String url, Map<String, String> params, Map<String, String> headers) throws UnsupportedEncodingException, KeyManagementException, NoSuchAlgorithmException {
        if (StringUtils.isEmpty((String)url)) {
            throw new RuntimeException("url is empty ");
        }
        HttpClient httpClient = YzjConfigServiceHelper.createHttpClient(isSSL, 3000, 5000);
        HttpGet httpPost = new HttpGet(url);
        if (params != null && params.size() > 0) {
            StringBuilder tempURL = new StringBuilder(url);
            boolean bl = false;
            if (url.indexOf(63) < 0) {
                tempURL.append('?');
            } else if (!url.endsWith("?")) {
                boolean bl2 = true;
            }
            String key = "";
            for (Map.Entry<String, String> entry : params.entrySet()) {
                boolean bl3;
                if (bl3) {
                    tempURL.append('&');
                } else {
                    bl3 = true;
                }
                key = entry.getKey();
                tempURL.append(key).append('=').append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
            }
            httpPost = new HttpGet(tempURL.toString());
        } else {
            httpPost = new HttpGet(url);
        }
        if (headers != null && headers.size() > 0) {
            for (Map.Entry entry : headers.entrySet()) {
                httpPost.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
            if (!headers.containsKey("Content-type")) {
                httpPost.setHeader("Content-type", "application/json; charset=UTF-8");
            }
        }
        String responseStr = null;
        Object var7_11 = null;
        for (int i = 0; i < 5; ++i) {
            try {
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity entity = httpResponse.getEntity();
                responseStr = EntityUtils.toString((HttpEntity)entity, (String)StandardCharsets.UTF_8.name());
                break;
            }
            catch (Exception e) {
                logger.info(e.getMessage());
                continue;
            }
        }
        if (StringUtils.isEmpty(responseStr)) {
            void var7_13;
            responseStr = "httputils call fail:" + (var7_13 == null ? "" : Integer.valueOf(var7_13.getStatusLine().getStatusCode()));
        }
        return responseStr;
    }

    public static Map<String, Object> tranResponseToMap(String response) throws IOException {
        return (Map)JSONUtils.cast((String)response, HashMap.class, (boolean)true);
    }

    public static String getBaiduResultByAddress(String address) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        StringBuilder url = new StringBuilder();
        url.append("http://api.map.baidu.com/geocoder/v2/?address=");
        url.append(address).append("&output=json&ak=");
        DynamicObject object = QueryServiceHelper.queryOne((String)"mem_sys_params", (String)"baidu_map_secret", null);
        url.append(object.getString("baidu_map_secret"));
        return YzjConfigServiceHelper.doGet(false, url.toString(), null, null);
    }

    public static Map<String, Object> getBaiduResult(String response) throws IOException {
        Map<String, Object> res = YzjConfigServiceHelper.tranResponseToMap(response);
        if (res != null && (Integer)res.get("status") == 0) {
            return (Map)res.get("result");
        }
        return null;
    }

    public static Map<String, Object> getBaiduLocation(String response) throws IOException {
        Map<String, Object> res = YzjConfigServiceHelper.getBaiduResult(response);
        return res == null ? null : (Map)res.get("location");
    }
}

