/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.yzj.impl;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.drp.mem.common.DateUtil;
import kd.drp.mem.yzj.TokenType;
import kd.drp.mem.yzj.impl.YzjService;
import kd.drp.mem.yzj.interfaces.IYzjAttendanceService;
import kd.drp.mem.yzj.model.YzjClockInResponseModel;

public class YzjAttendancePubCloudService
extends YzjService
implements IYzjAttendanceService {
    private static Log logger = LogFactory.getLog(YzjAttendancePubCloudService.class);

    public YzjAttendancePubCloudService(Map<String, Object> sysParams) {
        super(sysParams);
    }

    @Override
    public List<Map<String, Object>> getClockInList(String openIds, Date startDate, Date endDate) {
        return this.getClockInList(openIds, startDate, endDate, 1, 200, null);
    }

    @Override
    public List<Map<String, Object>> getClockInList(String openIds, Date startDate, Date endDate, int start, int limit, String deptIds) {
        if (!this.isEnableYZJ()) {
            logger.warn("\u7cfb\u7edf\u672a\u542f\u7528\u4e91\u4e4b\u5bb6");
            return Collections.EMPTY_LIST;
        }
        if (StringUtils.isEmpty((String)openIds)) {
            return Collections.EMPTY_LIST;
        }
        HashMap<String, String> mpUsers = new HashMap<String, String>();
        mpUsers.put("eid", this.getEid());
        mpUsers.put("workDateFrom", DateUtil.getDatetimeformat().format(startDate));
        mpUsers.put("workDateTo", DateUtil.getDatetimeformat().format(endDate));
        if (!StringUtils.isEmpty((String)deptIds)) {
            mpUsers.put("deptIds", deptIds);
        }
        mpUsers.put("openIds", openIds);
        String sHttpResponse = null;
        try {
            sHttpResponse = this.doPostUrlEncodAPI("/gateway/attendance-data/v1/clockIn/list?accessToken=" + this.getToken(TokenType.CLOCK_IN), this.getHttpRequestHeader(), mpUsers);
            if (StringUtils.isBlank((String)sHttpResponse)) {
                return Collections.EMPTY_LIST;
            }
            Map mpGetCloclIn = (Map)JSONUtils.cast((String)sHttpResponse, HashMap.class, (boolean)true);
            if (mpGetCloclIn == null || mpGetCloclIn.get("data") == null || StringUtils.isEmpty((String)mpGetCloclIn.get("data").toString())) {
                String msg = ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u79fb\u52a8\u7b7e\u5230\u660e\u7ec6\u67e5\u8be2\u5931\u8d25: \u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", (String)"YzjAttendancePubCloudService_0", (String)"drp-mem-common", (Object[])new Object[0]);
                logger.error("@........." + msg);
                return Collections.EMPTY_LIST;
            }
            YzjClockInResponseModel yzjmdl = (YzjClockInResponseModel)JSONUtils.cast((String)sHttpResponse, YzjClockInResponseModel.class, (boolean)true);
            if (!yzjmdl.isSuccess()) {
                return Collections.EMPTY_LIST;
            }
            logger.info("@.........\u4e91\u4e4b\u5bb6\u79fb\u52a8\u7b7e\u5230\u660e\u7ec6\u67e5\u8be2\u6210\u529f\u3002");
            return yzjmdl.getData();
        }
        catch (Exception e) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\uff1a%s \u4e91\u4e4b\u5bb6\u8fd4\u56de\u4fe1\u606f\uff1a%s", (String)"YzjAttendancePubCloudService_1", (String)"drp-mem-common", (Object[])new Object[0]), e.getMessage(), sHttpResponse);
            logger.error("@........." + errorMsg, (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

