/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.basedata;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class BillConfigBatchAddNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener,
CellClickListener {
    Log log = LogFactory.getLog(BillConfigBatchAddNewPlugin.class);
    protected static final String TOOLBARAP = "toolbarap";
    protected static final String BTN_SELECT = "btnselect";
    protected static final String BTN_REMOVE = "btnremove";
    protected static final String BTN_SAVE = "btnsave";
    protected static final String BTN_SAVEANDNEW = "btnsaveandnew";
    protected static final String TREE_EXPENSETYPE = "tree_expensetype";
    protected static final String ROOTNODE_ID = "rootNode_expensetype";
    protected static String SELECTED_EXPENSETY_ENTRY = "selectedexpensetyentry";
    protected static String FIELD_ENTRY = "fieldentry";
    protected static final String PARENTID = "parentid";
    protected static final String ISDISPLAY = "isdisplay";
    protected static final String ISREQUIRED = "isrequired";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeset = e.getChangeSet();
        String entityName = changeset[0].getDataEntity().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        this.addClickListeners(new String[]{BTN_SELECT, BTN_REMOVE});
        EntryGrid grid = (EntryGrid)this.getView().getControl(SELECTED_EXPENSETY_ENTRY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadFieldentry(this.getModel());
        this.buildTree_expensetype(this.getModel());
        this.getView().updateView(FIELD_ENTRY);
        this.setDateMustInputAndShow();
    }

    private void setDateMustInputAndShow() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(FIELD_ENTRY);
        int rowIndex = 0;
        for (DynamicObject row : rows) {
            Object fieldname = row.get("fieldname");
            if (fieldname instanceof DynamicObject) {
                String number = ((DynamicObject)fieldname).getString("number").toLowerCase();
                if ("entrybegindate".equals(number) || "entryenddate".equals(number)) {
                    row.set(ISDISPLAY, (Object)Boolean.TRUE);
                    row.set(ISREQUIRED, (Object)Boolean.TRUE);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{ISDISPLAY});
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{ISREQUIRED});
                } else if ("iteminfomodel".equals(number) || "itemclass".equals(number) || "itembrands".equals(number) || "assistunit".equals(number)) {
                    row.set(ISREQUIRED, (Object)Boolean.FALSE);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{ISREQUIRED});
                }
            }
            ++rowIndex;
        }
        this.getView().updateView(FIELD_ENTRY);
    }

    protected void buildTree_expensetype(IDataModel model) {
        TreeNode rootNode = new TreeNode("", ROOTNODE_ID, ResManager.loadKDString((String)"\u8d39\u7528\u7c7b\u578b", (String)"BillConfigBatchAddNewPlugin_0", (String)"drp-mem-formplugin", (Object[])new Object[0]), true);
        rootNode.setIsOpened(true);
        TreeView tree_expensetypeView = (TreeView)this.getControl(TREE_EXPENSETYPE);
        tree_expensetypeView.setMulti(true);
        tree_expensetypeView.addNode(rootNode);
        this.addNodes_expensetype(tree_expensetypeView, rootNode);
    }

    protected void addNodes_expensetype(TreeView treeVew, TreeNode rootNode) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        StringBuilder selector = new StringBuilder();
        selector.append("id,");
        selector.append("number,");
        selector.append("longnumber,");
        selector.append("name,");
        selector.append("parent,");
        selector.append("parent.id");
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
        nodeMap.put(ROOTNODE_ID, rootNode);
        DynamicObject[] documents = BusinessDataServiceHelper.load((String)"mem_expensetype", (String)selector.toString(), (QFilter[])new QFilter[]{filter}, (String)" longnumber asc,level asc");
        if (documents != null && documents.length != 0) {
            for (int i = 0; i < documents.length; ++i) {
                DynamicObject info = documents[i];
                String parengId = info.getString("parent.id");
                String id = info.getString("id");
                String name = info.getString("name");
                String longNumber = info.getString("longnumber");
                if (parengId == null) {
                    parengId = ROOTNODE_ID;
                }
                TreeNode newNode = new TreeNode(parengId, id, name);
                newNode.setLongNumber(longNumber);
                newNode.setData((Object)info);
                newNode.setIsOpened(true);
                TreeNode parentNode = (TreeNode)nodeMap.get(parengId);
                parentNode.addChild(newNode);
                nodeMap.put(id, newNode);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String eventKey = evt.getItemKey();
        if (BTN_SAVE.equals(eventKey)) {
            this.btnSave_click(evt);
        }
        if (BTN_SAVEANDNEW.equals(eventKey)) {
            this.btnSaveAndNew_click(evt);
        }
    }

    public void click(EventObject evt) {
        String eventKey = ((Control)evt.getSource()).getKey();
        if (BTN_SELECT.equals(eventKey)) {
            this.btnSelect_click(evt);
        }
        if (BTN_REMOVE.equals(eventKey)) {
            this.btnRemove_click(evt);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    protected void selectedExpensetyEntry_click(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        if (rowIndex == -1) {
            return;
        }
        if (rowIndex >= 0) {
            boolean isSelected = this.rowIsSelected(SELECTED_EXPENSETY_ENTRY, rowIndex);
            DynamicObject curRow = this.getModel().getEntryRowEntity(SELECTED_EXPENSETY_ENTRY, rowIndex);
            String curRowNumber = curRow.getString("expensetypenumber");
            List<Integer> selectRowList = this.getSelectedRowIndexList(SELECTED_EXPENSETY_ENTRY);
            int rowCount = this.getModel().getEntryRowCount(SELECTED_EXPENSETY_ENTRY);
            EntryGrid entry = (EntryGrid)this.getView().getControl(SELECTED_EXPENSETY_ENTRY);
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject dynObj = this.getModel().getEntryRowEntity(SELECTED_EXPENSETY_ENTRY, i);
                String number = dynObj.getString("expensetypenumber");
                if (!number.startsWith(curRowNumber)) continue;
                if (isSelected) {
                    if (selectRowList.contains(i)) continue;
                    selectRowList.add(i);
                    continue;
                }
                selectRowList.remove(i);
            }
            int[] selectRows = Arrays.stream(selectRowList.toArray(new Integer[0])).mapToInt(Integer::valueOf).toArray();
            entry.selectRows(selectRows, rowIndex);
        }
    }

    protected List<Integer> getSelectedRowIndexList(String entryName) {
        ArrayList<Integer> selectRowList = new ArrayList<Integer>();
        EntryGrid list = (EntryGrid)this.getView().getControl(entryName);
        int[] rowIndexs = list.getSelectRows();
        if (rowIndexs != null) {
            for (int i = 0; i < rowIndexs.length; ++i) {
                selectRowList.add(rowIndexs[i]);
            }
        }
        return selectRowList;
    }

    protected boolean rowIsSelected(String entryName, int rowIndex) {
        EntryGrid list = (EntryGrid)this.getView().getControl(entryName);
        int[] rowIndexs = list.getSelectRows();
        if (rowIndexs != null) {
            for (int i = 0; i < rowIndexs.length; ++i) {
                if (rowIndex != rowIndexs[i]) continue;
                return true;
            }
        }
        return false;
    }

    protected void btnSaveAndNew_click(ItemClickEvent evt) {
        this.storeBill();
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BillConfigBatchAddNewPlugin_1", (String)"drp-mem-formplugin", (Object[])new Object[0]));
        this.getModel().deleteEntryData(SELECTED_EXPENSETY_ENTRY);
        int rowCount = this.getModel().getEntryRowCount(FIELD_ENTRY);
        for (int i = rowCount - 1; i >= 0; --i) {
            DynamicObject row = this.getModel().getEntryRowEntity(FIELD_ENTRY, i);
            row.set(ISDISPLAY, (Object)Boolean.FALSE);
            row.set(ISREQUIRED, (Object)Boolean.FALSE);
        }
        this.getView().updateView(FIELD_ENTRY);
    }

    private void btnSave_click(ItemClickEvent evt) {
        this.storeBill();
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"BillConfigBatchAddNewPlugin_1", (String)"drp-mem-formplugin", (Object[])new Object[0]));
        this.getView().close();
    }

    private void storeBill() {
        int rowCount = this.getModel().getEntryRowCount(SELECTED_EXPENSETY_ENTRY);
        if (rowCount == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d39\u7528\u7c7b\u578b\u3002", (String)"BillConfigBatchAddNewPlugin_2", (String)"drp-mem-formplugin", (Object[])new Object[0]));
        }
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            DynamicObject row = this.getModel().getEntryRowEntity(SELECTED_EXPENSETY_ENTRY, rowIndex);
            String expensetypeId = row.getString("expensetypeid");
            String expensetypeName = row.getString("expensetypename");
            boolean isleaf = row.getBoolean("isleaf");
            if (!isleaf || expensetypeId == null) continue;
            DynamicObject billConfigInfo = BusinessDataServiceHelper.newDynamicObject((String)"mem_billconfig");
            DynamicObject expensetypeInfo = BusinessDataServiceHelper.newDynamicObject((String)"mem_expensetype");
            expensetypeInfo.set("id", (Object)expensetypeId);
            expensetypeInfo.set("number", (Object)row.getString("expensetypenumber"));
            expensetypeInfo.set("name", (Object)expensetypeName);
            billConfigInfo.set("expensetype", (Object)expensetypeInfo);
            billConfigInfo.set("easnumber", row.get("easnumber"));
            billConfigInfo.set("costexecute", (Object)row.getBoolean("costexecute"));
            billConfigInfo.set("enabled", (Object)"1");
            this.storeEntry(billConfigInfo);
            billList.add(billConfigInfo);
        }
        this.invokeOperation(billList.toArray(new DynamicObject[0]), "save");
    }

    public OperationResult invokeOperation(DynamicObject[] objs, String operation) throws KDBizException {
        if (objs == null || objs.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25", (String)"BillConfigBatchAddNewPlugin_3", (String)"drp-mem-formplugin", (Object[])new Object[0]));
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)operation, (String)objs[0].getDataEntityType().getName(), (DynamicObject[])objs, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            List validResultList = result.getValidateResult().getValidateErrors();
            for (ValidateResult validation : validResultList) {
                validation.getAllErrorInfo().forEach(info -> sb.append(info.getMessage()).append(','));
            }
            if (sb.length() == 0) {
                throw new KDBizException(result.getMessage());
            }
            throw new KDBizException(MessageFormat.format("{0} - {1}", result.getMessage(), sb));
        }
        return result;
    }

    protected void storeEntry(DynamicObject billConfigInfo) {
        DynamicObjectCollection entrys = (DynamicObjectCollection)billConfigInfo.get("mem_billconfigentrys");
        int rowCount = this.getModel().getEntryRowCount(FIELD_ENTRY);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject row = this.getModel().getEntryRowEntity(FIELD_ENTRY, i);
            DynamicObject selectInfo = (DynamicObject)row.get("fieldname");
            if (selectInfo == null) continue;
            DynamicObject entry = entrys.addNew();
            entry.set("fieldname", (Object)selectInfo);
            entry.set(ISDISPLAY, (Object)row.getBoolean(ISDISPLAY));
            entry.set(ISREQUIRED, (Object)row.getBoolean(ISREQUIRED));
            entry.setParent((Object)billConfigInfo);
        }
    }

    protected void btnSelect_click(EventObject evt) {
        TreeView tree_expensetypeView = (TreeView)this.getControl(TREE_EXPENSETYPE);
        List selectNodeIds = tree_expensetypeView.getTreeState().getSelectedNodeId();
        if (selectNodeIds == null || selectNodeIds.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u8d39\u7528\u7c7b\u578b!", (String)"BillConfigBatchAddNewPlugin_4", (String)"drp-mem-formplugin", (Object[])new Object[0]));
        }
        selectNodeIds.removeIf(id -> id.equals(ROOTNODE_ID));
        ArrayList<Long> result = new ArrayList<Long>(selectNodeIds.size());
        for (int i = 0; i < selectNodeIds.size(); ++i) {
            result.add(Long.parseLong((String)selectNodeIds.get(i)));
        }
        int rowCount = this.getModel().getEntryRowCount(SELECTED_EXPENSETY_ENTRY);
        HashMap<String, DynamicObject> oldRowMap = new HashMap<String, DynamicObject>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject row = this.getModel().getEntryRowEntity(SELECTED_EXPENSETY_ENTRY, i);
            String id2 = row.getString("expensetypeid");
            if (id2 != null && !result.contains(Long.parseLong(id2))) {
                result.add(Long.parseLong(id2));
            }
            oldRowMap.put(id2, row);
        }
        this.getModel().deleteEntryData(SELECTED_EXPENSETY_ENTRY);
        QFilter[] filters = new QFilter[2];
        filters[0] = new QFilter("id", "in", result);
        StringBuilder selector = new StringBuilder();
        selector.append("id,");
        selector.append("number,");
        selector.append("longnumber,");
        selector.append("name,");
        selector.append("parent,");
        selector.append("parent.id,");
        selector.append("isleaf");
        DynamicObject[] documents = BusinessDataServiceHelper.load((String)"mem_expensetype", (String)selector.toString(), (QFilter[])filters, (String)" longnumber asc");
        if (documents != null && documents.length != 0) {
            for (int i = 0; i < documents.length; ++i) {
                DynamicObject expensetype = documents[i];
                String longNumber = expensetype.getString("longnumber");
                if (longNumber != null) {
                    longNumber = longNumber.replace('!', '.');
                }
                int newRowIndex = this.getModel().createNewEntryRow(SELECTED_EXPENSETY_ENTRY);
                this.getModel().setValue("expensetypeid", expensetype.getPkValue(), newRowIndex);
                this.getModel().setValue("expensetypename", expensetype.get("name"), newRowIndex);
                this.getModel().setValue(PARENTID, expensetype.get("parent.id"), newRowIndex);
                this.getModel().setValue("isleaf", expensetype.get("isleaf"), newRowIndex);
                this.getModel().setValue("expensetypenumber", (Object)longNumber, newRowIndex);
                if (!oldRowMap.containsKey(expensetype.getPkValue().toString())) continue;
                DynamicObject oldRow = (DynamicObject)oldRowMap.get(expensetype.getPkValue().toString());
                this.getModel().setValue("costexecute", oldRow.get("costexecute"), newRowIndex);
            }
        }
    }

    protected void btnRemove_click(EventObject evt) {
        EntryGrid list = (EntryGrid)this.getView().getControl(SELECTED_EXPENSETY_ENTRY);
        int[] rowIndexs = list.getSelectRows();
        if (rowIndexs == null || rowIndexs.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u7684\u884c!", (String)"BillConfigBatchAddNewPlugin_5", (String)"drp-mem-formplugin", (Object[])new Object[0]));
        }
        for (int i = rowIndexs.length - 1; i >= 0; --i) {
            int rowIndex = rowIndexs[i];
            this.getModel().deleteEntryRow(SELECTED_EXPENSETY_ENTRY, rowIndex);
        }
        this.getView().updateView(SELECTED_EXPENSETY_ENTRY);
    }

    private void loadFieldentry(IDataModel model) {
        QFilter filter = new QFilter("enabled", "=", (Object)"1");
        StringBuilder selector = new StringBuilder();
        selector.append("id,");
        selector.append("number,");
        selector.append("name");
        DynamicObject[] documents = BusinessDataServiceHelper.load((String)"mem_fieldname", (String)selector.toString(), (QFilter[])new QFilter[]{filter}, (String)" sequence asc");
        if (documents != null && documents.length != 0) {
            for (int i = 0; i < documents.length; ++i) {
                DynamicObject fieldNameInfo = documents[i];
                if (fieldNameInfo == null) continue;
                int newRowIndex = model.createNewEntryRow(FIELD_ENTRY);
                DynamicObject row = model.getEntryRowEntity(FIELD_ENTRY, newRowIndex);
                row.set("fieldname", (Object)fieldNameInfo);
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void cellClick(CellClickEvent evt) {
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

