/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mem.common.MEMFilterUtil;

public class BillConfigEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String MEM_BILLCONFIGENTRYS = "mem_billconfigentrys";
    protected static String FIELD_ENTRY = "mem_billconfigentrys";
    protected static final String ISDISPLAY = "isdisplay";
    protected static final String ISREQUIRED = "isrequired";

    private void setBillStatus() {
        QFilter[] filter;
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        } else if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT && QueryServiceHelper.exists((String)"mem_market_cost_apply", (QFilter[])(filter = MEMFilterUtil.getQFilter((String)"expensetype", (Object)((DynamicObject)this.getModel().getValue("expensetype")).getPkValue())))) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadEntry(this.getModel());
        Label label = (Label)this.getControl("title");
        if (label != null) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String title = formShowParameter.getCaption();
            if (StringUtils.isNotBlank((CharSequence)title)) {
                title = formShowParameter.getFormConfig().getCaption().toString();
            }
            label.setText(formShowParameter.getCaption());
        }
        this.setBillStatus();
        this.getView().updateView(MEM_BILLCONFIGENTRYS);
        this.setDateMustInputAndShow();
    }

    private void setDateMustInputAndShow() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(FIELD_ENTRY);
        int rowIndex = 0;
        for (DynamicObject row : rows) {
            Object fieldname = row.get("fieldname");
            if (fieldname instanceof DynamicObject) {
                String number = ((DynamicObject)fieldname).getString("number").toLowerCase();
                if ("entrybegindate".equals(number) || "entryenddate".equals(number)) {
                    row.set(ISDISPLAY, (Object)Boolean.TRUE);
                    row.set(ISREQUIRED, (Object)Boolean.TRUE);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{ISDISPLAY});
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{ISREQUIRED});
                } else if ("iteminfomodel".equals(number) || "itemclass".equals(number) || "itembrands".equals(number) || "assistunit".equals(number)) {
                    row.set(ISREQUIRED, (Object)Boolean.FALSE);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{ISREQUIRED});
                }
            }
            ++rowIndex;
        }
        this.getView().updateView(FIELD_ENTRY);
    }

    private void loadEntry(IDataModel model) {
        QFilter filter = new QFilter("enabled", "=", (Object)"1");
        StringBuilder selector = new StringBuilder();
        selector.append("id,");
        selector.append("number,");
        selector.append("name");
        DynamicObject[] documents = BusinessDataServiceHelper.load((String)"mem_fieldname", (String)selector.toString(), (QFilter[])new QFilter[]{filter}, (String)" sequence asc");
        if (documents != null && documents.length != 0) {
            int i;
            ArrayList<String> hadFieldNameList = new ArrayList<String>();
            int rowCount = model.getEntryRowCount(MEM_BILLCONFIGENTRYS);
            for (i = rowCount - 1; i >= 0; --i) {
                DynamicObject row = model.getEntryRowEntity(MEM_BILLCONFIGENTRYS, i);
                DynamicObject fieldNameInfo = (DynamicObject)row.get("fieldname");
                if (fieldNameInfo != null) {
                    hadFieldNameList.add(fieldNameInfo.getString("number"));
                    continue;
                }
                model.deleteEntryRow(MEM_BILLCONFIGENTRYS, i);
            }
            for (i = 0; i < documents.length; ++i) {
                DynamicObject fieldNameInfo = documents[i];
                if (fieldNameInfo == null || hadFieldNameList.contains(fieldNameInfo.getString("number"))) continue;
                int newRowIndex = model.createNewEntryRow(MEM_BILLCONFIGENTRYS);
                DynamicObject row = model.getEntryRowEntity(MEM_BILLCONFIGENTRYS, newRowIndex);
                row.set("fieldname", (Object)fieldNameInfo);
            }
        }
    }
}

