/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.basedata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.util.UserUtil;

public class MEMListPlugin
extends AbstractListPlugin {
    private List<Object> ownerIds;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.afterPreOpenForm(e);
    }

    protected IListView getListView() {
        IFormView formview = this.getView();
        IListView listview = (IListView)formview;
        return listview;
    }

    protected IListModel getListModel() {
        return this.getListView().getListModel();
    }

    public void afterPreOpenForm(PreOpenFormEventArgs e) {
    }

    public boolean isLookup() {
        boolean isLookup = false;
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            isLookup = listShowParameter.isLookUp();
        }
        return isLookup;
    }

    protected boolean getOperationResult(AfterDoOperationEventArgs e) {
        OperationResult result = e.getOperationResult();
        return result == null || result.isSuccess();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("default".equals(e.getOperateKey()) || "undefault".equals(e.getOperateKey())) {
            ((BillList)this.getControl("billlistap")).refresh();
        }
    }

    protected List<ComboItem> getOwnerComboItem() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        List<Object> ownerIDs = this.getOwnerIDs();
        QFilter f = new QFilter("id", "in", ownerIDs);
        DynamicObjectCollection owners = QueryServiceHelper.query((String)"mdr_customer", (String)"id,name", (QFilter[])f.toArray());
        ComboItem item = null;
        for (DynamicObject owner : owners) {
            item = new ComboItem();
            item.setId(String.valueOf(owner.get("id")));
            item.setValue(String.valueOf(owner.get("id")));
            item.setCaption(new LocaleString(owner.getString("name")));
            comboItems.add(item);
        }
        return comboItems;
    }

    protected List<ComboItem> getCustomerGroupComboItem() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        List<Object> ownerIDs = this.getOwnerIDs();
        QFilter f = new QFilter("owner", "in", ownerIDs);
        DynamicObjectCollection customerGroups = QueryServiceHelper.query((String)"mdr_customer_group", (String)"id,name", (QFilter[])f.toArray());
        ComboItem item = null;
        for (DynamicObject customerGroup : customerGroups) {
            item = new ComboItem();
            item.setId(String.valueOf(customerGroup.get("id")));
            item.setValue(String.valueOf(customerGroup.get("id")));
            item.setCaption(new LocaleString(customerGroup.getString("name")));
            if (comboItems.contains(item)) continue;
            comboItems.add(item);
        }
        return comboItems;
    }

    protected List<ComboItem> getItemClassComboItem() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        QFilter f = new QFilter("1", "=", (Object)"1");
        DynamicObjectCollection itemClasses = QueryServiceHelper.query((String)"mdr_item_class", (String)"id,name", (QFilter[])f.toArray());
        ComboItem item = null;
        for (DynamicObject itemClass : itemClasses) {
            item = new ComboItem();
            item.setId(String.valueOf(itemClass.get("id")));
            item.setValue(String.valueOf(itemClass.get("id")));
            item.setCaption(new LocaleString(itemClass.getString("name")));
            if (comboItems.contains(item)) continue;
            comboItems.add(item);
        }
        return comboItems;
    }

    protected List<Object> getOwnerIDs() {
        ArrayList<Object> idList = null;
        if (this.ownerIds == null) {
            this.ownerIds = UserUtil.getOwnerIDs();
            idList = new ArrayList<Object>();
            idList.addAll(this.ownerIds);
        }
        return idList;
    }

    protected void initOwnerFilterComboItem(FilterContainerInitArgs e, String ownerFilterkey) {
        if (this.isLookup()) {
            return;
        }
        List columns = e.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn column : columns) {
            if (!ownerFilterkey.equals(column.getFieldName())) continue;
            CommonFilterColumn col = (CommonFilterColumn)column;
            List<ComboItem> comboItems = this.getOwnerComboItem();
            if (comboItems.size() > 0) {
                col.setDefaultValue(UserUtil.getDefaultOwnerID().toString());
            }
            col.setComboItems(comboItems);
        }
    }

    protected Map<String, QFilter> filter2Map(List<QFilter> fs) {
        HashMap<String, QFilter> fsMap = new HashMap<String, QFilter>(fs.size());
        for (QFilter f : fs) {
            fsMap.put(f.getProperty(), f);
        }
        return fsMap;
    }

    protected Object[] getSelectIds() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] ids = selectedRows.getPrimaryKeyValues();
        return ids;
    }

    protected void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }
}

