/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.basedata;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.MapControl;
import kd.bos.ext.form.control.events.MapSelectEvent;
import kd.bos.ext.form.control.events.MapSelectListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.drp.mem.common.MEMFilterUtil;
import kd.drp.mem.formplugin.basedata.MEMFormPlugin;

public class ShopManageEditPlugin
extends MEMFormPlugin
implements BeforeF7SelectListener,
ClickListener,
MapSelectListener {
    protected static final String LAT = "lat";
    protected static final String LNG = "lng";
    protected static final String LATITUDE = "latitude";
    protected static final String LONGITUDE = "longitude";
    protected static final String POINT = "point";
    protected static final String ADDRESS = "address";
    protected static final String CITY = "city";
    protected static final String DISTRICT = "district";
    protected static final String PROVINCE = "province";
    protected static final String ORIGIN = "origin";
    protected static final String SHOP_AREA = "shopArea";
    protected static final String AREA = "area";
    private static String CHANNELGROUP = "channelgroup";
    protected static final String CHANNEL = "channel";
    private static String REGION = "region";
    protected static final String BTN_LOCATE = "btnlocate";
    protected static final String SHOP_MAP = "shopmap";
    protected static final String DETAIL_ADDRESS = "detailAddress";
    protected static final String SELECT_ADDRESS = "selectAddress";
    protected static final String SHOPREGION = "shopregion";

    public void beforeBindData(EventObject eventobject) {
        super.beforeBindData(eventobject);
    }

    public void registerListener(EventObject eventobject) {
        super.registerListener(eventobject);
        this.addF7Listener(this, CHANNEL);
        this.addClickListeners(new String[]{BTN_LOCATE});
        MapControl map = (MapControl)this.getView().getControl(SHOP_MAP);
        map.addSelectListener((MapSelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel dataModel = this.getModel();
        if ("shoptype".equals(propertyName)) {
            this.shoptype_changeed(dataModel);
            this.shopArea_changeed();
        }
        if (SHOPREGION.equals(propertyName)) {
            Object citynumber = this.setAreacodeText(e.getChangeSet()[0].getNewValue().toString());
            this.getModel().setValue("citynumber", citynumber);
        }
    }

    private Object setAreacodeText(String id) {
        QFilter qfliter = new QFilter("id", "=", (Object)Long.parseLong(id));
        DynamicObject admindivision = BusinessDataServiceHelper.loadSingle((String)"bd_admindivision", (String)"parent,citynumber,parent.id,parent.number,number,iscity", (QFilter[])qfliter.toArray());
        while (admindivision != null) {
            if (admindivision.getBoolean("iscity")) {
                return admindivision.getString("citynumber");
            }
            if ((admindivision = admindivision.getDynamicObject("parent")) == null) continue;
            admindivision = BusinessDataServiceHelper.loadSingle((String)"bd_admindivision", (String)"parent,citynumber,parent.id,parent.number,number,iscity", (QFilter[])MEMFilterUtil.getPKQFilter((Object)admindivision.getPkValue()));
        }
        return null;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        Button btn;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && BTN_LOCATE.equals((btn = (Button)source).getKey())) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(DETAIL_ADDRESS, this.getValue(ADDRESS));
            proxy.invokeControlMethod(SHOP_MAP, SELECT_ADDRESS, new Object[]{map});
        }
    }

    protected void shoptype_changeed(IDataModel dataModel) {
        DynamicObject shopInfo = (DynamicObject)dataModel.getValue("shoptype");
        if (shopInfo != null) {
            this.getPageCache().put(SHOP_AREA, shopInfo.get("arearange").toString());
            StringBuilder selector = new StringBuilder();
            selector.append("id,");
            selector.append("number,");
            selector.append("name,");
            selector.append("channeltype,");
            selector.append("channeltype.id,");
            selector.append("channeltype.number,");
            selector.append("channeltype.name");
            DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)shopInfo.getPkValue(), (String)shopInfo.getDataEntityType().getName(), (String)selector.toString());
            if (info != null) {
                DynamicObject channeltype = (DynamicObject)info.get("channeltype");
                this.getModel().setValue("channeltype", (Object)channeltype);
            }
        }
    }

    protected void shopArea_changeed() {
        this.getModel().setValue(AREA, (Object)this.getPageCache().get(SHOP_AREA));
    }

    protected void channel_changeed(IDataModel dataModel) {
        DynamicObject channelInfo = (DynamicObject)dataModel.getValue(CHANNEL);
        if (channelInfo != null) {
            QFilter[] filter = MEMFilterUtil.getPKQFilter((Object)channelInfo.getPkValue());
            StringBuilder selector = new StringBuilder();
            selector.append("id,");
            selector.append("number,");
            selector.append("name,");
            selector.append("customergroup,");
            selector.append("customergroup.id,");
            selector.append("customergroup.number,");
            selector.append("customergroup.name");
            DynamicObject[] documents = BusinessDataServiceHelper.load((String)channelInfo.getDataEntityType().getName(), (String)selector.toString(), (QFilter[])filter);
            if (documents != null && documents.length != 0) {
                DynamicObject info = documents[0];
                DynamicObject customergroup = info.getDynamicObject("customergroup");
                this.getModel().setValue(CHANNELGROUP, (Object)customergroup);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "channel": {
                this.setChannelFilter(e);
            }
        }
    }

    protected void setChannelFilter(BeforeF7SelectEvent e) {
        HashSet<Object> innerorgs = new HashSet<Object>();
        QFilter filter = new QFilter("isinnerorg", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection innerorgCustomerCollection = QueryServiceHelper.query((String)"mdr_customer", (String)"id", (QFilter[])filter.toArray());
        for (DynamicObject innerorgCustomer : innerorgCustomerCollection) {
            innerorgs.add(innerorgCustomer.get("id"));
        }
        filter = new QFilter("id", "in", innerorgs);
        this.setF7Filter(CHANNEL, filter);
        if (e != null) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
        }
    }

    public void select(MapSelectEvent evt) {
        Map point = evt.getPoint();
        if (point.get(ORIGIN) == null || StringUtils.isEmpty((String)point.get(ORIGIN).toString())) {
            Object province = point.get(PROVINCE);
            StringBuilder detailAddress = new StringBuilder();
            detailAddress.append(point.get(ADDRESS));
            String pcd = province.toString();
            if (point.get(DISTRICT) != null && point.get(DISTRICT).toString().length() > 0 && detailAddress.indexOf(pcd = pcd.indexOf(24066) < 0 ? pcd + point.get(CITY) + point.get(DISTRICT) : pcd + point.get(DISTRICT)) < 0) {
                detailAddress.insert(0, point.get(DISTRICT));
            }
            if (detailAddress.indexOf(province + "" + point.get(CITY)) < 0) {
                detailAddress.insert(0, point.get(CITY));
            }
            if (pcd.indexOf(24066) < 0 && detailAddress.indexOf(province + "" + point.get(CITY)) < 0) {
                detailAddress.insert(0, point.get(CITY));
            }
            if (detailAddress.indexOf(province.toString()) < 0) {
                detailAddress.insert(0, province);
            }
            this.setValue(ADDRESS, detailAddress.toString());
        }
        Map point2 = (Map)point.get(POINT);
        this.setValue(LONGITUDE, point2.get(LNG));
        this.setValue(LATITUDE, point2.get(LAT));
    }
}

