/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.cost;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.MobileBaseShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.util.CacheUtil;
import kd.drp.mem.common.DateUtil;
import kd.drp.mem.common.MEMUtil;
import kd.drp.mem.formplugin.basedata.MEMBillFormMobPlugin;

public class CostApplyDetailMobFormPlugin
extends MEMBillFormMobPlugin
implements MobileSearchTextChangeListener,
RowClickEventListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String LBVIEW = "lbview";
    protected static final String SEARCH = "search";
    protected String pkCacheId = "";
    protected String cacheId = "";
    protected Map<String, Object> entryIdMap = new HashMap<String, Object>(16);

    public void initialize() {
        super.initialize();
        this.cacheId = this.getModel().getDataEntityType().getName() + "_entry_" + this.getView().getPageId();
        this.pkCacheId = this.getModel().getDataEntityType().getName() + "_PK_" + this.getView().getPageId();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (CacheUtil.get((String)this.pkCacheId, Object.class) == null) {
            CacheUtil.put((String)this.pkCacheId, (Object)this.getModel().getDataEntity().getPkValue());
        }
        this.loadHead();
        this.loadEntry();
    }

    private void loadHead() {
        BigDecimal bd;
        Date enddate;
        DynamicObject costType;
        IDataModel model = this.getModel();
        DynamicObject cus = (DynamicObject)model.getValue("customer");
        if (cus != null) {
            ((Label)this.getControl("lb_customer")).setText(cus.getString("name"));
        }
        if ((costType = (DynamicObject)model.getValue("expensetype")) != null) {
            ((Label)this.getControl("lb_expensetype")).setText(costType.getString("name"));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date begindate = (Date)model.getValue("begindate");
        if (begindate != null) {
            ((Label)this.getControl("lb_begindate")).setText(sdf.format(begindate));
        }
        if ((enddate = (Date)model.getValue("enddate")) != null) {
            ((Label)this.getControl("lb_enddate")).setText(sdf.format(enddate));
        }
        ((Label)this.getControl("lb_billno")).setText(model.getValue("billno").toString());
        Date billdate = (Date)model.getValue("billdate");
        if (billdate != null) {
            ((Label)this.getControl("lb_billdate")).setText(sdf.format(billdate));
        }
        if ((bd = (BigDecimal)model.getValue("totalamount")) != null) {
            bd = bd.setScale(2, RoundingMode.HALF_UP);
            ((Label)this.getControl("lb_totalamount")).setText("\uffe5" + bd);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{LBVIEW});
        MobileSearch serach = (MobileSearch)this.getView().getControl(SEARCH);
        serach.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        CardEntry cardE = (CardEntry)this.getView().getControl(ENTRYENTITY);
        cardE.addRowClickListener((RowClickEventListener)this);
    }

    public void click(MobileSearchTextChangeEvent e) {
        this.loadEntry();
    }

    protected void loadEntry() {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(ENTRYENTITY);
        model.getDataEntity(true);
        DynamicObject[] datas = this.getApplyEntryData();
        if (datas != null && datas.length != 0) {
            this.entryIdMap = new HashMap<String, Object>(datas.length);
            model.batchCreateNewEntryRow(ENTRYENTITY, datas.length);
            for (int i = 0; i < datas.length; ++i) {
                DynamicObject data = datas[i];
                int rowIndex = i;
                model.setValue("id", data.get("id"), rowIndex);
                DynamicObject shop = data.getDynamicObject("shop");
                if (shop != null) {
                    model.setValue("shop", (Object)data.getDynamicObject("shop"), rowIndex);
                    this.setLabelText("lb_shopname", i, data.getDynamicObject("shop").getString("name"));
                } else {
                    this.setLabelText("lb_shopname", i, ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u95e8\u5e97", (String)"CostApplyDetailMobFormPlugin_0", (String)"drp-mem-formplugin", (Object[])new Object[0]));
                }
                model.setValue("iteminfo", data.get("iteminfo"), rowIndex);
                model.setValue("amount", data.get("amount"), rowIndex);
                this.entryIdMap.put("rowIndex_" + rowIndex, data.getString("id"));
            }
            CacheUtil.put((String)this.cacheId, this.entryIdMap);
        }
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private void setLabelText(String key, int rowIndex, String text) {
        HashMap activeItem = new HashMap();
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        propertiesMap.put("text", text);
        activeItem.put(key, propertiesMap);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).invokeControlMethod(ENTRYENTITY, "setCustomProperties", new Object[]{rowIndex, activeItem});
    }

    protected DynamicObject[] getApplyEntryData() {
        String entityName = "mem_market_costapplyentry";
        String selector = this.getApplyEntrySelector();
        QFilter[] filters = this.getApplyEntryFilter().toArray();
        DynamicObject[] dynColl = BusinessDataServiceHelper.load((String)entityName, (String)selector, (QFilter[])filters, (String)"shop.name asc");
        return dynColl;
    }

    protected String getApplyEntrySelector() {
        StringBuilder selector = new StringBuilder();
        selector.append("id,").append('\n');
        selector.append("isexecuted,").append('\n');
        selector.append("amount,").append('\n');
        selector.append("shop,").append('\n');
        selector.append("shop.id,").append('\n');
        selector.append("shop.name,").append('\n');
        selector.append("shop.address,").append('\n');
        selector.append("iteminfo,").append('\n');
        selector.append("iteminfo.id,").append('\n');
        selector.append("iteminfo.name").append('\n');
        selector.append("iteminfo.title").append('\n');
        return selector.toString();
    }

    protected QFilter getApplyEntryFilter() {
        MobileSearch search = (MobileSearch)this.getView().getControl(SEARCH);
        String searchtxt = search.getText();
        Object billId = null;
        billId = CacheUtil.get((String)this.pkCacheId, Object.class) != null ? CacheUtil.get((String)this.pkCacheId, Object.class) : this.getModel().getDataEntity().getPkValue();
        QFilter filters = new QFilter("bill", "=", billId);
        if (searchtxt != null && searchtxt.trim().length() != 0) {
            String likeValue = "%" + searchtxt.trim() + "%";
            QFilter searchFilter = new QFilter("shop.name", "like", (Object)likeValue);
            if (MEMUtil.isSplitMDEApp()) {
                searchFilter.or("iteminfo.title", "like", (Object)likeValue);
            } else {
                searchFilter.or("iteminfo.name", "like", (Object)likeValue);
            }
            filters.and(searchFilter);
        }
        return filters;
    }

    public void entryRowDoubleClick(RowClickEvent rowclickevent) {
        super.entryRowDoubleClick(rowclickevent);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        CardEntry ce = (CardEntry)this.getView().getControl(ENTRYENTITY);
        int[] rows = ce.getSelectRows();
        if (rows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\uff01", (String)"CostApplyDetailMobFormPlugin_1", (String)"drp-mem-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowIndex = ce.getSelectRows()[0];
        this.entryIdMap = (Map)CacheUtil.get((String)this.cacheId, HashMap.class);
        Object entryId = this.entryIdMap.get("rowIndex_" + rowIndex);
        DynamicObject entry = BusinessDataServiceHelper.loadSingle((Object)entryId, (String)"mem_market_costapplyentry");
        Date date = new Date();
        date = DateUtil.getDayFirst((Date)date);
        Date begin = entry.getDate("entrybegindate");
        Date end = entry.getDate("entryenddate");
        if (begin.compareTo(date) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d3b\u52a8\u65f6\u95f4\u672a\u5230\uff0c\u4e0d\u5141\u8bb8\u6267\u884c", (String)"CostApplyDetailMobFormPlugin_2", (String)"drp-mem-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else if (end.compareTo(date) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d3b\u52a8\u65f6\u95f4\u7ed3\u675f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c", (String)"CostApplyDetailMobFormPlugin_3", (String)"drp-mem-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else if (entry.getDynamicObject("shop") == null) {
            this.openShopChoose(entry.get("bill.customer.id"));
        } else {
            this.openCostExecuteEditMob(null, entryId);
        }
    }

    private void openShopChoose(Object cusId) {
        MobileBillShowParameter param = new MobileBillShowParameter();
        param.getOpenStyle().setShowType(ShowType.Floating);
        param.setCustomParam("customerId", cusId);
        param.setCustomParam("entryId", this.getClickRowPk());
        param.setFormId("mem_shopmanlistmob");
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeShopChoose"));
        this.getView().showForm((FormShowParameter)param);
    }

    protected void openCostExecuteEditMob(Object costExecutId, Object applyEntryId) {
        MobileBaseShowParameter mobparameter = new MobileBaseShowParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        if (costExecutId != null) {
            mobparameter.setPkId(costExecutId);
            mobparameter.setStatus(OperationStatus.VIEW);
        }
        if (applyEntryId != null) {
            customParam.put("applyEntryId", applyEntryId);
            mobparameter.setStatus(OperationStatus.ADDNEW);
        }
        mobparameter.setCustomParams(customParam);
        mobparameter.getOpenStyle().setShowType(ShowType.Floating);
        mobparameter.setFormId("mem_costexecute_editmob");
        this.getView().showForm((FormShowParameter)mobparameter);
    }

    protected Object getCostExecuteId(Object applyEntryId) {
        QFilter f = new QFilter("costapplyentry.id", "=", applyEntryId);
        DynamicObjectCollection rs = QueryServiceHelper.query((String)"mem_marketcostexecute", (String)"id", (QFilter[])f.toArray(), (String)"createtime desc");
        return rs.size() > 0 ? ((DynamicObject)rs.get(0)).get("id") : null;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("closeShopChoose".equals(e.getActionId())) {
            Object shopId = e.getReturnData();
            if (shopId == null) {
                return;
            }
            if (!QueryServiceHelper.exists((String)"mem_shopmanage", (Object)shopId)) {
                return;
            }
            this.saveShop(shopId);
            this.loadEntry();
        }
    }

    private void saveShop(Object shopId) {
        Object entryId = this.getClickRowPk();
        if (entryId != null) {
            DynamicObject entry = BusinessDataServiceHelper.loadSingle((Object)entryId, (String)"mem_market_costapplyentry");
            entry.set("shop", shopId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entry});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u95e8\u5e97\u6307\u5b9a\u6210\u529f\uff01", (String)"CostApplyDetailMobFormPlugin_4", (String)"drp-mem-formplugin", (Object[])new Object[0]));
        }
    }

    private Object getClickRowPk() {
        CardEntry ce = (CardEntry)this.getView().getControl(ENTRYENTITY);
        int[] rows = ce.getSelectRows();
        if (rows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\uff01", (String)"CostApplyDetailMobFormPlugin_1", (String)"drp-mem-formplugin", (Object[])new Object[0]));
            return null;
        }
        int rowIndex = ce.getSelectRows()[0];
        this.entryIdMap = (Map)CacheUtil.get((String)this.cacheId, HashMap.class);
        Object entryId = this.entryIdMap.get("rowIndex_" + rowIndex);
        return entryId;
    }
}

