/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.cost;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mem.common.MEMFilterUtil;

public class CostExecuteDetailFormPlugin
extends AbstractFormPlugin
implements ClickListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initShopExecTreeFlex();
        CardEntry grid = (CardEntry)this.getView().getControl("shopentryentity");
        grid.selectRows(0);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"shopcardentry"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("shopcardentry".equals(key)) {
            this.showForm(this.getModel().getValue("entryid").toString());
        }
    }

    protected void initShopExecTreeFlex() {
        QFilter[] qFilter;
        DynamicObjectCollection costExecCollection;
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("shopentryentity");
        model.getDataEntity(true);
        Set<Object> set = this.getApplyId();
        if (set != null && (costExecCollection = QueryServiceHelper.query((String)"mem_marketcostexecute", (String)"id", (QFilter[])(qFilter = MEMFilterUtil.getQFilter((String)"costapplyentry", (String)"in", set)))).isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6267\u884c\u4fe1\u606f", (String)"CostExecuteDetailFormPlugin_0", (String)"drp-mem-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        QFilter[] qfilter = MEMFilterUtil.getQFilter((String)"id", (String)"in", set);
        DynamicObjectCollection entryInfo = QueryServiceHelper.query((String)"mem_market_costapplyentry", (String)this.getOql().toString(), (QFilter[])qfilter, null);
        if (entryInfo.size() > 0) {
            for (int i = 0; i < entryInfo.size(); ++i) {
                int rowIndex = model.createNewEntryRow("shopentryentity");
                DynamicObject entry = (DynamicObject)entryInfo.get(i);
                this.setShopTreeFlex(entry, rowIndex);
            }
            this.showForm(((DynamicObject)entryInfo.get(0)).getString("id"));
        }
        model.endInit();
        this.getView().updateView("shopentryentity");
    }

    protected Set<Object> getApplyId() {
        Object markCostApplyBillId;
        Object markCostApplyBillEntryId = this.getView().getFormShowParameter().getCustomParam("COST_APPLY_ENTRYID");
        HashSet<Object> set = new HashSet<Object>();
        if (markCostApplyBillEntryId != null) {
            set.add(markCostApplyBillEntryId);
        }
        if (set.isEmpty() && (markCostApplyBillId = this.getView().getFormShowParameter().getCustomParam("COST_APPLY_BILLID")) != null) {
            DynamicObject markCostApplyBill = BusinessDataServiceHelper.loadSingle((String)"mem_market_cost_apply", (String)"id,entryentity.id", (QFilter[])MEMFilterUtil.getQFilter((String)"id", (Object)Long.parseLong(markCostApplyBillId.toString())));
            DynamicObjectCollection entryCollection = markCostApplyBill.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryCollection.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryCollection.get(i);
                set.add(entry.getPkValue());
            }
        }
        return set;
    }

    private Object getOql() {
        StringBuffer oql = new StringBuffer();
        oql.append("id,shop.name,iteminfo.name,amount");
        return oql;
    }

    private void setShopTreeFlex(DynamicObject entry, int rowIndex) {
        this.getModel().setValue("iteminfo", (Object)entry.getString("iteminfo.name"), rowIndex);
        this.getModel().setValue("shop", (Object)entry.getString("shop.name"), rowIndex);
        if (entry.getBigDecimal("amount") != null) {
            this.getModel().setValue("amount", (Object)entry.getBigDecimal("amount").setScale(2, 0), rowIndex);
        }
        this.getModel().setValue("entryid", (Object)entry.getString("id"), rowIndex);
    }

    private void showForm(String entryid) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey("executeinfoflex");
        param.setFormId("mem_costexecute_list");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("COST_APPLY_ENTRYID", entryid);
        param.setCustomParams(params);
        this.getView().showForm(param);
    }
}

